/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript;

import java.util.Set;
import org.alfresco.model.WCMModel;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.mozilla.javascript.Scriptable;
import org.springframework.extensions.surf.util.ParameterCheck;

public class AVMNode
extends ScriptNode {
    private String path;
    private int version;
    private boolean deleted;
    private AVMNodeDescriptor avmRef;
    private QName type;

    public AVMNode(NodeRef nodeRef, ServiceRegistry services) {
        this(nodeRef, services, null);
    }

    public AVMNode(NodeRef nodeRef, ServiceRegistry services, Scriptable scope) {
        super(nodeRef, services, scope);
        Pair<Integer, String> versionPath = AVMNodeConverter.ToAVMVersionPath(nodeRef);
        this.init((String)versionPath.getSecond(), (Integer)versionPath.getFirst());
    }

    public AVMNode(String path, int version, ServiceRegistry services, Scriptable scope) {
        super(AVMNodeConverter.ToNodeRef(version, path), services, scope);
        this.init(path, version);
    }

    private void init(String path, int version) {
        this.path = path;
        this.version = version;
        AVMNodeDescriptor descriptor = this.services.getAVMService().lookup(version, path, true);
        if (descriptor == null) {
            throw new IllegalArgumentException("Invalid node specified: " + this.nodeRef.toString());
        }
        this.avmRef = descriptor;
        this.deleted = descriptor.isDeleted();
    }

    @Override
    public ScriptNode newInstance(NodeRef nodeRef, ServiceRegistry services, Scriptable scope) {
        return new AVMNode(nodeRef, services, scope);
    }

    public ScriptNode newInstance(String path, int version, ServiceRegistry services, Scriptable scope) {
        return new AVMNode(AVMNodeConverter.ToNodeRef(version, path), services, scope);
    }

    public String getPath() {
        return this.path;
    }

    public int getVersion() {
        return this.version;
    }

    public String getParentPath() {
        return AVMNodeConverter.SplitBase(this.path)[0];
    }

    @Override
    public String getType() {
        if (this.type == null) {
            this.type = !this.deleted ? this.services.getNodeService().getType(this.nodeRef) : (this.avmRef.isDeletedDirectory() ? WCMModel.TYPE_AVM_FOLDER : WCMModel.TYPE_AVM_CONTENT);
        }
        return this.type.toString();
    }

    public boolean isDirectory() {
        return this.avmRef.isDirectory() || this.avmRef.isDeletedDirectory();
    }

    public boolean isFile() {
        return this.avmRef.isFile() || this.avmRef.isDeletedFile();
    }

    @Override
    public String getName() {
        return this.avmRef.getName();
    }

    @Override
    public boolean getIsLocked() {
        String lockOwner = this.services.getAVMLockingService().getLockOwner(this.getWebProject(), this.path.substring(this.path.indexOf("/")));
        return lockOwner != null;
    }

    public boolean isLockOwner() {
        String lockOwner = this.services.getAVMLockingService().getLockOwner(this.getWebProject(), this.path.substring(this.path.indexOf("/")));
        if (lockOwner != null) {
            return lockOwner.equals(this.services.getAuthenticationService().getCurrentUserName());
        }
        return true;
    }

    public boolean hasLockAccess() {
        return this.services.getAVMLockingService().hasAccess(this.getWebProject(), this.path, this.services.getAuthenticationService().getCurrentUserName());
    }

    @Override
    public ScriptNode copy(ScriptNode destination) {
        ParameterCheck.mandatory((String)"Destination Node", (Object)destination);
        return this.getCrossRepositoryCopyHelper().copy(this, destination, this.getName());
    }

    public ScriptNode copy(String destination) {
        ParameterCheck.mandatoryString((String)"Destination Path", (String)destination);
        this.services.getAVMService().copy(this.version, this.path, destination, this.getName());
        return this.newInstance(AVMNodeConverter.ToNodeRef(-1, AVMNodeConverter.ExtendAVMPath(destination, this.getName())), this.services, this.scope);
    }

    @Override
    public boolean move(ScriptNode destination) {
        ParameterCheck.mandatory((String)"Destination Node", (Object)destination);
        boolean success = false;
        if (destination instanceof AVMNode) {
            success = this.move(((AVMNode)destination).getPath());
        }
        return success;
    }

    public boolean move(String destination) {
        ParameterCheck.mandatoryString((String)"Destination Path", (String)destination);
        boolean success = false;
        if (destination != null && destination.length() != 0) {
            AVMNode parent = (AVMNode)this.getParent();
            this.services.getAVMService().rename(parent.getPath(), this.getName(), destination, this.getName());
            this.reset(AVMNodeConverter.ExtendAVMPath(destination, this.getName()));
            success = true;
        }
        return success;
    }

    public boolean rename(String name) {
        ParameterCheck.mandatoryString((String)"Destination name", (String)name);
        boolean success = false;
        if (name != null && name.length() != 0) {
            String parentPath = ((AVMNode)this.getParent()).getPath();
            this.services.getAVMService().rename(parentPath, this.getName(), parentPath, name);
            this.reset(AVMNodeConverter.ExtendAVMPath(parentPath, name));
            success = true;
        }
        return success;
    }

    @Override
    public Set<QName> getAspectsSet() {
        if (this.aspects == null) {
            this.aspects = this.services.getAVMService().getAspects(this.version, this.path);
        }
        return this.aspects;
    }

    private void reset(String path) {
        super.reset();
        this.path = path;
        this.nodeRef = AVMNodeConverter.ToNodeRef(this.version, path);
        this.id = this.nodeRef.getId();
        AVMNodeDescriptor descriptor = this.services.getAVMService().lookup(this.version, path, true);
        if (descriptor == null) {
            throw new IllegalArgumentException("Invalid node specified: " + this.nodeRef.toString());
        }
        this.avmRef = descriptor;
        this.deleted = descriptor.isDeleted();
    }

    private String getWebProject() {
        String webProject = this.path.substring(0, this.path.indexOf(58));
        int index = webProject.indexOf("--");
        if (index != -1) {
            webProject = webProject.substring(0, index);
        }
        return webProject;
    }

    @Override
    public String toString() {
        if (this.services.getAVMService().lookup(this.version, this.path) != null) {
            return "AVM Path: " + this.getPath() + "\nNode Type: " + this.getType() + "\nNode Properties: " + this.getProperties().size() + "\nNode Aspects: " + this.getAspectsSet().toString();
        }
        return "Node no longer exists: " + this.nodeRef;
    }
}

