/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript;

import java.io.Serializable;
import java.util.Date;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.jscript.AVMNode;
import org.alfresco.repo.jscript.ValueConverter;
import org.alfresco.repo.template.AVM;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMStoreDescriptor;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class AVMScriptStore
implements Serializable {
    private ServiceRegistry services;
    private AVMStoreDescriptor descriptor;
    private Scriptable scope;

    public AVMScriptStore(ServiceRegistry services, AVMStoreDescriptor store, Scriptable scope) {
        this.descriptor = store;
        this.services = services;
        this.scope = scope;
    }

    public String getName() {
        return this.descriptor.getName();
    }

    public String getId() {
        return this.descriptor.getName();
    }

    public String getCreator() {
        return this.descriptor.getCreator();
    }

    public Serializable getCreatedDate() {
        return new ValueConverter().convertValueForScript(this.services, this.scope, null, new Date(this.descriptor.getCreateDate()));
    }

    public AVMNode lookupRoot() {
        AVMNode rootNode = null;
        String rootPath = this.descriptor.getName() + ':' + AVM.getWebappsFolderPath();
        AVMNodeDescriptor nodeDesc = this.services.getAVMService().lookup(-1, rootPath);
        if (nodeDesc != null) {
            rootNode = new AVMNode(AVMNodeConverter.ToNodeRef(-1, rootPath), this.services, this.scope);
        }
        return rootNode;
    }

    public AVMNode lookupNode(String path) {
        AVMNode node = null;
        if (path != null && path.length() != 0) {
            if (path.charAt(0) != '/') {
                path = '/' + path;
            }
            path = this.descriptor.getName() + ':' + AVM.getWebappsFolderPath() + path;
            AVMNodeDescriptor nodeDesc = this.services.getAVMService().lookup(-1, path);
            if (nodeDesc != null) {
                node = new AVMNode(path, -1, this.services, this.scope);
            }
        }
        return node;
    }

    public Scriptable luceneSearch(String query) {
        Object[] nodes = null;
        ResultSet results = null;
        try {
            results = this.services.getSearchService().query(new StoreRef("avm", this.descriptor.getName()), "lucene", query);
            if (results.length() != 0) {
                nodes = new Object[results.length()];
                for (int i = 0; i < results.length(); ++i) {
                    ResultSetRow row = results.getRow(i);
                    nodes[i] = new AVMNode(row.getNodeRef(), this.services, this.scope);
                }
            }
        }
        catch (Throwable err) {
            throw new AlfrescoRuntimeException("Failed to execute search: " + query, err);
        }
        finally {
            if (results != null) {
                results.close();
            }
        }
        if (nodes != null) {
            return Context.getCurrentContext().newArray(this.scope, nodes);
        }
        return Context.getCurrentContext().newArray(this.scope, 0);
    }
}

