/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript;

import java.util.HashMap;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.jscript.ClasspathScriptLocation;
import org.alfresco.repo.jscript.ScriptBehaviour;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseSpringTest;

public class ScriptBehaviourTest
extends BaseSpringTest {
    private ServiceRegistry serviceRegistry;
    private NodeService nodeService;
    private PolicyComponent policyComponent;
    private StoreRef storeRef;
    private NodeRef folderNodeRef;

    @Override
    protected String[] getConfigLocations() {
        return new String[]{"classpath:org/alfresco/repo/jscript/test-context.xml"};
    }

    protected void onSetUpInTransaction() throws Exception {
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.policyComponent = (PolicyComponent)this.applicationContext.getBean("policyComponent");
        this.serviceRegistry = (ServiceRegistry)this.applicationContext.getBean("ServiceRegistry");
        AuthenticationComponent authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        this.storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        NodeRef rootNodeRef = this.nodeService.getRootNode(this.storeRef);
        HashMap<QName, String> props = new HashMap<QName, String>(1);
        props.put(ContentModel.PROP_NAME, "TestFolder");
        ChildAssociationRef childAssocRef = this.nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}TestFolder"), ContentModel.TYPE_FOLDER, props);
        this.folderNodeRef = childAssocRef.getChildRef();
    }

    public void test1EnableDisableBehaviour() {
        ClasspathScriptLocation location = new ClasspathScriptLocation("org/alfresco/repo/jscript/test_onCreateNode_cmContent.js");
        ScriptBehaviour behaviour = new ScriptBehaviour(this.serviceRegistry, location);
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onCreateNode"), ContentModel.TYPE_CONTENT, (Behaviour)behaviour);
        behaviour.disable();
        HashMap<QName, String> props = new HashMap<QName, String>(1);
        props.put(ContentModel.PROP_NAME, "myDoc.txt");
        ChildAssociationRef childAssoc = this.nodeService.createNode(this.folderNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"myDoc.txt"), ContentModel.TYPE_CONTENT, props);
        ScriptBehaviourTest.assertFalse((boolean)this.nodeService.hasAspect(childAssoc.getChildRef(), ContentModel.ASPECT_TITLED));
        behaviour.enable();
        HashMap<QName, String> props2 = new HashMap<QName, String>(1);
        props2.put(ContentModel.PROP_NAME, "myDoc1.txt");
        ChildAssociationRef childAssoc2 = this.nodeService.createNode(this.folderNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"myDoc1.txt"), ContentModel.TYPE_CONTENT, props2);
        ScriptBehaviourTest.assertTrue((boolean)this.nodeService.hasAspect(childAssoc2.getChildRef(), ContentModel.ASPECT_TITLED));
    }

    public void test2ClasspathLocationBehaviour() {
        ClasspathScriptLocation location = new ClasspathScriptLocation("org/alfresco/repo/jscript/test_onCreateNode_cmContent.js");
        ScriptBehaviour behaviour = new ScriptBehaviour(this.serviceRegistry, location);
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onCreateNode"), ContentModel.TYPE_CONTENT, (Behaviour)behaviour);
        HashMap<QName, String> props = new HashMap<QName, String>(1);
        props.put(ContentModel.PROP_NAME, "myDoc.txt");
        ChildAssociationRef childAssoc = this.nodeService.createNode(this.folderNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"myDoc.txt"), ContentModel.TYPE_CONTENT, props);
        ScriptBehaviourTest.assertTrue((boolean)this.nodeService.hasAspect(childAssoc.getChildRef(), ContentModel.ASPECT_TITLED));
    }

    public void test3SpringConfiguredBehaviour() {
        this.nodeService.addAspect(this.folderNodeRef, ContentModel.ASPECT_COUNTABLE, null);
        ScriptBehaviourTest.assertTrue((boolean)this.nodeService.hasAspect(this.folderNodeRef, ContentModel.ASPECT_TITLED));
        HashMap<QName, String> props = new HashMap<QName, String>(1);
        props.put(ContentModel.PROP_NAME, "myDoc.txt");
        ChildAssociationRef childAssoc = this.nodeService.createNode(this.folderNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"myDoc.txt"), ContentModel.TYPE_CONTENT, props);
        HashMap<QName, String> props2 = new HashMap<QName, String>(1);
        props2.put(ContentModel.PROP_NAME, "folder2");
        ChildAssociationRef childAssoc2 = this.nodeService.createNode(this.folderNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"folder2"), ContentModel.TYPE_FOLDER, props2);
        this.nodeService.addChild(childAssoc2.getChildRef(), childAssoc.getChildRef(), ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"linked"));
        ScriptBehaviourTest.assertTrue((boolean)this.nodeService.hasAspect(childAssoc.getChildRef(), ContentModel.ASPECT_VERSIONABLE));
    }
}

