/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.management.subsystems;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import org.alfresco.repo.management.subsystems.AbstractPropertyBackedBean;
import org.alfresco.repo.management.subsystems.ChildApplicationContextFactory;
import org.alfresco.repo.management.subsystems.ChildApplicationContextManager;
import org.alfresco.repo.management.subsystems.PropertyBackedBeanState;
import org.springframework.context.ApplicationContext;

public class DefaultChildApplicationContextManager
extends AbstractPropertyBackedBean
implements ChildApplicationContextManager {
    private static final String ORDER_PROPERTY = "chain";
    private String defaultTypeName;
    private String defaultChain;

    public DefaultChildApplicationContextManager() {
        this.setInstancePath(Collections.singletonList("manager"));
    }

    public void setDefaultTypeName(String defaultTypeName) {
        this.defaultTypeName = defaultTypeName;
    }

    public void setDefaultChain(String defaultChain) {
        this.defaultChain = defaultChain;
    }

    @Override
    public String getDescription(String name) {
        return "Comma separated list of name:type pairs";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy(boolean permanent) {
        if (this.getState(false) != null) {
            boolean hadWriteLock = this.lock.isWriteLockedByCurrentThread();
            if (!hadWriteLock) {
                this.lock.readLock().unlock();
                this.lock.writeLock().lock();
            }
            try {
                ApplicationContextManagerState state = (ApplicationContextManagerState)this.getState(false);
                if (state != null) {
                    for (String id : state.getInstanceIds()) {
                        ChildApplicationContextFactory factory = state.getApplicationContextFactory(id);
                        factory.lock.writeLock().lock();
                        try {
                            factory.destroy(permanent);
                        }
                        finally {
                            factory.lock.writeLock().unlock();
                        }
                    }
                }
                super.destroy(permanent);
            }
            finally {
                if (!hadWriteLock) {
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                }
            }
        } else {
            super.destroy(permanent);
        }
    }

    @Override
    protected PropertyBackedBeanState createInitialState() throws IOException {
        return new ApplicationContextManagerState(this.defaultChain, this.defaultTypeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getInstanceIds() {
        this.lock.readLock().lock();
        try {
            Collection<String> collection = ((ApplicationContextManagerState)this.getState(true)).getInstanceIds();
            return collection;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplicationContext getApplicationContext(String id) {
        this.lock.readLock().lock();
        try {
            ApplicationContext applicationContext = ((ApplicationContextManagerState)this.getState(true)).getApplicationContext(id);
            return applicationContext;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected class ApplicationContextManagerState
    implements PropertyBackedBeanState {
        private List<String> instanceIds = new ArrayList<String>(10);
        private Map<String, ChildApplicationContextFactory> childApplicationContexts = new TreeMap<String, ChildApplicationContextFactory>();
        private String defaultTypeName;

        protected ApplicationContextManagerState(String defaultChain, String defaultTypeName) {
            if (defaultChain != null && defaultChain.length() > 0) {
                if (defaultTypeName == null) {
                    this.updateOrder(defaultChain, "default");
                    this.defaultTypeName = this.childApplicationContexts.get(this.instanceIds.get(0)).getTypeName();
                } else {
                    this.defaultTypeName = defaultTypeName;
                    this.updateOrder(defaultChain, defaultTypeName);
                }
            } else if (defaultTypeName == null) {
                this.defaultTypeName = "default";
            }
        }

        @Override
        public String getProperty(String name) {
            if (!name.equals(DefaultChildApplicationContextManager.ORDER_PROPERTY)) {
                return null;
            }
            return this.getOrderString();
        }

        @Override
        public Set<String> getPropertyNames() {
            return Collections.singleton(DefaultChildApplicationContextManager.ORDER_PROPERTY);
        }

        @Override
        public void setProperty(String name, String value) {
            if (!name.equals(DefaultChildApplicationContextManager.ORDER_PROPERTY)) {
                throw new IllegalStateException("Illegal attempt to write to property \"" + name + "\"");
            }
            this.updateOrder(value, this.defaultTypeName);
        }

        @Override
        public void start() {
            for (String instance : this.getInstanceIds()) {
                this.getApplicationContext(instance);
            }
        }

        @Override
        public void stop() {
        }

        public Collection<String> getInstanceIds() {
            return Collections.unmodifiableList(this.instanceIds);
        }

        public ApplicationContext getApplicationContext(String id) {
            ChildApplicationContextFactory child = this.childApplicationContexts.get(id);
            return child == null ? null : child.getApplicationContext();
        }

        protected ChildApplicationContextFactory getApplicationContextFactory(String id) {
            return this.childApplicationContexts.get(id);
        }

        private String getOrderString() {
            StringBuilder orderString = new StringBuilder(100);
            for (String id : this.instanceIds) {
                if (orderString.length() > 0) {
                    orderString.append(",");
                }
                orderString.append(id).append(':').append(this.childApplicationContexts.get(id).getTypeName());
            }
            return orderString.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateOrder(String orderString, String defaultTypeName) {
            try {
                StringTokenizer tkn = new StringTokenizer(orderString, ", \t\n\r\f");
                ArrayList<String> newInstanceIds = new ArrayList<String>(tkn.countTokens());
                while (tkn.hasMoreTokens()) {
                    String instance = tkn.nextToken();
                    int sepIndex = instance.indexOf(58);
                    String id = sepIndex == -1 ? instance : instance.substring(0, sepIndex);
                    String typeName = sepIndex == -1 || sepIndex + 1 >= instance.length() ? defaultTypeName : instance.substring(sepIndex + 1);
                    newInstanceIds.add(id);
                    ChildApplicationContextFactory factory = this.childApplicationContexts.get(id);
                    if (factory != null && !factory.getTypeName().equals(typeName)) {
                        factory.lock.writeLock().lock();
                        try {
                            factory.destroy(true);
                        }
                        finally {
                            factory.lock.writeLock().unlock();
                        }
                        factory = null;
                    }
                    if (factory != null) continue;
                    ArrayList<String> childId = new ArrayList<String>(2);
                    childId.add("managed");
                    childId.add(id);
                    this.childApplicationContexts.put(id, new ChildApplicationContextFactory(DefaultChildApplicationContextManager.this.getParent(), DefaultChildApplicationContextManager.this.getRegistry(), DefaultChildApplicationContextManager.this.getPropertyDefaults(), DefaultChildApplicationContextManager.this.getCategory(), typeName, childId));
                }
                TreeSet<String> idsToRemove = new TreeSet<String>(this.childApplicationContexts.keySet());
                idsToRemove.removeAll(newInstanceIds);
                for (String id : idsToRemove) {
                    ChildApplicationContextFactory factory = this.childApplicationContexts.remove(id);
                    factory.lock.writeLock().lock();
                    try {
                        factory.destroy(true);
                    }
                    finally {
                        factory.lock.writeLock().unlock();
                    }
                }
                this.instanceIds = newInstanceIds;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

