/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.module.tool;

import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.alfresco.repo.module.ModuleDetailsImpl;
import org.alfresco.repo.module.tool.LogOutput;
import org.alfresco.repo.module.tool.ModuleManagementToolException;
import org.alfresco.repo.module.tool.WarHelper;
import org.alfresco.service.cmr.module.ModuleDependency;
import org.alfresco.service.cmr.module.ModuleDetails;
import org.alfresco.util.VersionNumber;

public class WarHelperImpl
implements WarHelper {
    public static final String VERSION_PROPERTIES = "/WEB-INF/classes/alfresco/version.properties";
    private LogOutput log = null;

    public WarHelperImpl(LogOutput log) {
        this.log = log;
    }

    @Override
    public void checkCompatibleVersion(TFile war, ModuleDetails installingModuleDetails) {
        TFile propsFile = new TFile(war + VERSION_PROPERTIES);
        if (propsFile != null && propsFile.exists()) {
            Properties warVers = this.loadProperties(propsFile);
            VersionNumber warVersion = new VersionNumber(warVers.getProperty("version.major") + "." + warVers.getProperty("version.minor") + "." + warVers.getProperty("version.revision"));
            if (warVersion.compareTo(installingModuleDetails.getRepoVersionMin()) == -1) {
                throw new ModuleManagementToolException("The module (" + installingModuleDetails.getTitle() + ") must be installed on a repo version greater than " + installingModuleDetails.getRepoVersionMin());
            }
            if (warVersion.compareTo(installingModuleDetails.getRepoVersionMax()) == 1) {
                throw new ModuleManagementToolException("The module (" + installingModuleDetails.getTitle() + ") cannot be installed on a repo version greater than " + installingModuleDetails.getRepoVersionMax());
            }
        } else {
            this.log.info("No valid version found, is this a share war?");
        }
    }

    @Override
    public void checkCompatibleEdition(TFile war, ModuleDetails installingModuleDetails) {
        List<String> installableEditions = installingModuleDetails.getEditions();
        if (installableEditions != null && installableEditions.size() > 0) {
            TFile propsFile = new TFile(war + VERSION_PROPERTIES);
            if (propsFile != null && propsFile.exists()) {
                Properties warVers = this.loadProperties(propsFile);
                String warEdition = warVers.getProperty("version.edition");
                for (String edition : installableEditions) {
                    if (!warEdition.equalsIgnoreCase(edition)) continue;
                    return;
                }
                throw new ModuleManagementToolException("The module (" + installingModuleDetails.getTitle() + ") can only be installed in one of the following editions" + installableEditions);
            }
            this.log.info("No valid editions found, is this a share war?");
        }
    }

    @Override
    public void checkModuleDependencies(TFile war, ModuleDetails installingModuleDetails) {
        List<ModuleDependency> installingModuleDependencies = installingModuleDetails.getDependencies();
        ArrayList<ModuleDependency> missingDependencies = new ArrayList<ModuleDependency>(0);
        for (ModuleDependency dependency : installingModuleDependencies) {
            String dependencyId;
            ModuleDetails dependencyModuleDetails;
            if (dependency.isValidDependency(dependencyModuleDetails = this.getModuleDetails(war, dependencyId = dependency.getDependencyId()))) continue;
            missingDependencies.add(dependency);
        }
        if (missingDependencies.size() > 0) {
            throw new ModuleManagementToolException("The following modules must first be installed: " + missingDependencies);
        }
    }

    @Override
    public ModuleDetails getModuleDetailsOrAlias(TFile war, ModuleDetails installingModuleDetails) {
        ModuleDetails installedModuleDetails = this.getModuleDetails(war, installingModuleDetails.getId());
        if (installedModuleDetails == null) {
            List<String> installingAliases = installingModuleDetails.getAliases();
            for (String installingAlias : installingAliases) {
                ModuleDetails installedAliasModuleDetails = this.getModuleDetails(war, installingAlias);
                if (installedAliasModuleDetails == null) continue;
                installedModuleDetails = installedAliasModuleDetails;
                break;
            }
        }
        return installedModuleDetails;
    }

    protected ModuleDetails getModuleDetails(TFile war, String moduleId) {
        ModuleDetailsImpl moduleDets = null;
        TFile theFile = this.getModuleDetailsFile(war, moduleId);
        if (theFile != null && theFile.exists()) {
            moduleDets = new ModuleDetailsImpl(this.loadProperties(theFile));
        }
        return moduleDets;
    }

    private Properties loadProperties(TFile propertiesFile) {
        Properties result = null;
        InputStream is = null;
        try {
            if (propertiesFile.exists()) {
                is = new TFileInputStream((File)propertiesFile);
                result = new Properties();
                result.load(is);
            }
        }
        catch (IOException exception) {
            throw new ModuleManagementToolException("Unable to load properties from the war file; " + propertiesFile.getPath(), exception);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable e) {}
            }
        }
        return result;
    }

    private TFile getModuleDetailsFile(TFile war, String moduleId) {
        return new TFile(war.getAbsolutePath() + "/WEB-INF/classes/alfresco/module" + "/" + moduleId + "/module.properties");
    }
}

