/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.domain.node.Node;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.node.NodeEntity;
import org.alfresco.repo.domain.node.NodeVersionKey;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.domain.query.CannedQueryDAO;
import org.alfresco.repo.node.MLPropertyInterceptor;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.node.db.NodeHierarchyWalker;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.Policy;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.DuplicateChildNodeNameException;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mockito.Mockito;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.surf.util.I18NUtil;

public class NodeServiceTest
extends TestCase {
    public static final String NAMESPACE = "http://www.alfresco.org/test/BaseNodeServiceTest";
    public static final String TEST_PREFIX = "test";
    public static final QName TYPE_QNAME_TEST = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"multiprop");
    public static final QName PROP_QNAME_NAME = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"name");
    public static final QName ASSOC_QNAME_CHILDREN = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"child");
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private static Log logger = LogFactory.getLog(NodeServiceTest.class);
    protected ServiceRegistry serviceRegistry;
    protected NodeService nodeService;
    protected NodeDAO nodeDAO;
    private TransactionService txnService;
    private PolicyComponent policyComponent;
    private CannedQueryDAO cannedQueryDAO;
    private SimpleCache<Serializable, Serializable> nodesCache;
    private SimpleCache<Serializable, Serializable> propsCache;
    private SimpleCache<Serializable, Serializable> aspectsCache;
    protected NodeRef rootNodeRef;
    private static final QName PROP_RESIDUAL = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)GUID.generate());

    protected void setUp() throws Exception {
        I18NUtil.setLocale(null);
        this.serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.nodeService = this.serviceRegistry.getNodeService();
        this.nodeDAO = (NodeDAO)ctx.getBean("nodeDAO");
        this.txnService = this.serviceRegistry.getTransactionService();
        this.policyComponent = (PolicyComponent)ctx.getBean("policyComponent");
        this.cannedQueryDAO = (CannedQueryDAO)ctx.getBean("cannedQueryDAO");
        this.nodesCache = (SimpleCache)ctx.getBean("node.nodesSharedCache");
        this.propsCache = (SimpleCache)ctx.getBean("node.propertiesSharedCache");
        this.aspectsCache = (SimpleCache)ctx.getBean("node.aspectsSharedCache");
        this.nodesCache.clear();
        this.propsCache.clear();
        this.aspectsCache.clear();
        AuthenticationUtil.setRunAsUserSystem();
        RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> createStoreWork = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() {
                StoreRef storeRef = NodeServiceTest.this.nodeService.createStore("workspace", "Test_" + System.nanoTime());
                return NodeServiceTest.this.nodeService.getRootNode(storeRef);
            }
        };
        this.rootNodeRef = this.txnService.getRetryingTransactionHelper().doInTransaction(createStoreWork);
    }

    protected void tearDown() {
        AuthenticationUtil.clearCurrentSecurityContext();
        I18NUtil.setLocale(null);
    }

    public void testSetUp() throws Exception {
        NodeServiceTest.assertNotNull((Object)this.rootNodeRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLocaleSupport() throws Exception {
        Locale locale = (Locale)this.nodeService.getProperty(this.rootNodeRef, ContentModel.PROP_LOCALE);
        NodeServiceTest.assertNotNull((String)"Locale property must occur on every node", (Object)locale);
        NodeServiceTest.assertEquals((String)"Expected default locale on the root node", (Object)I18NUtil.getLocale(), (Object)locale);
        NodeServiceTest.assertTrue((String)"Every node must have sys:localized", (boolean)this.nodeService.hasAspect(this.rootNodeRef, ContentModel.ASPECT_LOCALIZED));
        I18NUtil.setLocale((Locale)Locale.CANADA_FRENCH);
        NodeRef nodeRef1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)this.getName()), ContentModel.TYPE_CONTAINER, Collections.singletonMap(ContentModel.PROP_LOCALE, Locale.GERMAN)).getChildRef();
        NodeServiceTest.assertTrue((String)"Every node must have sys:localized", (boolean)this.nodeService.hasAspect(nodeRef1, ContentModel.ASPECT_LOCALIZED));
        NodeServiceTest.assertEquals((String)"Didn't set the explicit locale during create. ", (Object)Locale.GERMAN, (Object)this.nodeService.getProperty(nodeRef1, ContentModel.PROP_LOCALE));
        NodeRef nodeRef2 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)this.getName()), ContentModel.TYPE_CONTAINER).getChildRef();
        NodeServiceTest.assertTrue((String)"Every node must have sys:localized", (boolean)this.nodeService.hasAspect(nodeRef2, ContentModel.ASPECT_LOCALIZED));
        NodeServiceTest.assertEquals((String)"Didn't set the locale during create. ", (Object)Locale.CANADA_FRENCH, (Object)this.nodeService.getProperty(nodeRef2, ContentModel.PROP_LOCALE));
        I18NUtil.setLocale((Locale)Locale.CHINESE);
        this.nodeService.setProperty(nodeRef2, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"Chinese description"));
        I18NUtil.setLocale((Locale)Locale.FRENCH);
        this.nodeService.setProperty(nodeRef2, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"French description"));
        boolean wasMLAware = MLPropertyInterceptor.setMLAware(true);
        try {
            MLText checkDescription = (MLText)this.nodeService.getProperty(nodeRef2, ContentModel.PROP_DESCRIPTION);
            NodeServiceTest.assertEquals((String)"Chinese description", (String)checkDescription.getValue(Locale.CHINESE));
            NodeServiceTest.assertEquals((String)"French description", (String)checkDescription.getValue(Locale.FRENCH));
        }
        finally {
            MLPropertyInterceptor.setMLAware(wasMLAware);
        }
        NodeServiceTest.assertEquals((String)"Node modification should not affect node locale. ", (Object)Locale.CANADA_FRENCH, (Object)this.nodeService.getProperty(nodeRef2, ContentModel.PROP_LOCALE));
        this.nodeService.setProperty(nodeRef2, ContentModel.PROP_LOCALE, (Serializable)Locale.ITALY);
        NodeServiceTest.assertEquals((String)"Node locale must be settable. ", (Object)Locale.ITALY, (Object)this.nodeService.getProperty(nodeRef2, ContentModel.PROP_LOCALE));
        NodeServiceTest.assertEquals((String)"Canada-French must be closest to French. ", (Object)"French description", (Object)this.nodeService.getProperty(nodeRef2, ContentModel.PROP_DESCRIPTION));
        this.nodeService.setProperty(nodeRef2, ContentModel.PROP_LOCALE, null);
        NodeServiceTest.assertEquals((String)"Node locale set to 'null' does nothing. ", (Object)Locale.ITALY, (Object)this.nodeService.getProperty(nodeRef2, ContentModel.PROP_LOCALE));
        this.nodeService.removeProperty(nodeRef2, ContentModel.PROP_LOCALE);
        NodeServiceTest.assertEquals((String)"Node locale removal does nothing. ", (Object)Locale.ITALY, (Object)this.nodeService.getProperty(nodeRef2, ContentModel.PROP_LOCALE));
        Map props = this.nodeService.getProperties(nodeRef2);
        props.put(ContentModel.PROP_LOCALE, Locale.GERMAN);
        this.nodeService.setProperties(nodeRef2, props);
        NodeServiceTest.assertEquals((String)"Node locale not set in setProperties(). ", (Object)Locale.GERMAN, (Object)this.nodeService.getProperty(nodeRef2, ContentModel.PROP_LOCALE));
    }

    private void buildNodeHierarchy(final NodeRef workspaceRootNodeRef, final NodeRef[] liveNodeRefs) {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> setupCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                HashMap<QName, String> props = new HashMap<QName, String>(3);
                props.put(ContentModel.PROP_NAME, "depth-0-" + GUID.generate());
                liveNodeRefs[0] = NodeServiceTest.this.nodeService.createNode(workspaceRootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)NodeServiceTest.NAMESPACE, (String)"depth-0"), ContentModel.TYPE_FOLDER, props).getChildRef();
                for (int i = 1; i < liveNodeRefs.length; ++i) {
                    props.put(ContentModel.PROP_NAME, "depth-" + i);
                    liveNodeRefs[i] = NodeServiceTest.this.nodeService.createNode(liveNodeRefs[i - 1], ContentModel.ASSOC_CONTAINS, QName.createQName((String)NodeServiceTest.NAMESPACE, (String)("depth-" + i)), ContentModel.TYPE_FOLDER, props).getChildRef();
                }
                return null;
            }
        };
        this.txnService.getRetryingTransactionHelper().doInTransaction(setupCallback);
    }

    public void testRootAspect() throws Exception {
        NodeRef workspaceRootNodeRef = this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        NodeRef[] nodes = new NodeRef[6];
        this.buildNodeHierarchy(workspaceRootNodeRef, nodes);
        Set allRootNodes = this.nodeService.getAllRootNodes(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        int initialNumRootNodes = allRootNodes.size();
        this.nodeService.addAspect(nodes[1], ContentModel.ASPECT_ROOT, null);
        this.nodeService.addAspect(nodes[3], ContentModel.ASPECT_ROOT, null);
        this.nodeService.addAspect(nodes[4], ContentModel.ASPECT_ROOT, null);
        allRootNodes = this.nodeService.getAllRootNodes(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        NodeServiceTest.assertEquals((String)"", (int)3, (int)(allRootNodes.size() - initialNumRootNodes));
        List paths = this.nodeService.getPaths(nodes[5], false);
        NodeServiceTest.assertEquals((String)"", (int)4, (int)paths.size());
        this.nodeService.removeAspect(nodes[3], ContentModel.ASPECT_ROOT);
        allRootNodes = this.nodeService.getAllRootNodes(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        NodeServiceTest.assertEquals((String)"", (int)2, (int)(allRootNodes.size() - initialNumRootNodes));
        paths = this.nodeService.getPaths(nodes[5], false);
        for (Path path : paths) {
            System.out.println("Path = " + path.toString());
        }
        NodeServiceTest.assertEquals((String)"", (int)3, (int)paths.size());
    }

    public void testConcurrentArchive() throws Exception {
        NodeRef workspaceRootNodeRef = this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        NodeRef[] nodesPrimer = new NodeRef[1];
        this.buildNodeHierarchy(workspaceRootNodeRef, nodesPrimer);
        final NodeRef[] nodesOne = new NodeRef[10];
        this.buildNodeHierarchy(workspaceRootNodeRef, nodesOne);
        final NodeRef[] nodesTwo = new NodeRef[10];
        this.buildNodeHierarchy(workspaceRootNodeRef, nodesTwo);
        this.nodeService.deleteNode(nodesPrimer[0]);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> outerCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                NodeServiceTest.this.nodeService.deleteNode(nodesOne[0]);
                RetryingTransactionHelper.RetryingTransactionCallback<Void> innerCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                    @Override
                    public Void execute() throws Throwable {
                        NodeServiceTest.this.nodeService.deleteNode(nodesTwo[0]);
                        return null;
                    }
                };
                NodeServiceTest.this.txnService.getRetryingTransactionHelper().doInTransaction(innerCallback, false, true);
                return null;
            }
        };
        this.txnService.getRetryingTransactionHelper().doInTransaction(outerCallback, false, true);
    }

    public void testArchiveAndRestore() {
        NodeRef.Status archivedStatus;
        NodeRef.Status liveStatus;
        NodeRef[] liveNodeRefs = new NodeRef[10];
        NodeRef[] archivedNodeRefs = new NodeRef[10];
        NodeRef workspaceRootNodeRef = this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        NodeRef archiveRootNodeRef = this.nodeService.getRootNode(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE);
        this.buildNodeHierarchy(workspaceRootNodeRef, liveNodeRefs);
        Long txnIdCreate = null;
        for (int i = 0; i < liveNodeRefs.length; ++i) {
            StoreRef archivedStoreRef = archiveRootNodeRef.getStoreRef();
            archivedNodeRefs[i] = new NodeRef(archivedStoreRef, liveNodeRefs[i].getId());
            liveStatus = this.nodeService.getNodeStatus(liveNodeRefs[i]);
            archivedStatus = this.nodeService.getNodeStatus(archivedNodeRefs[i]);
            NodeServiceTest.assertNotNull((String)("'Live' node " + i + " status does not exist."), (Object)liveStatus);
            NodeServiceTest.assertFalse((String)("'Live' node " + i + " should be node be deleted"), (boolean)liveStatus.isDeleted());
            NodeServiceTest.assertNull((String)("'Archived' node " + i + " should not (yet) exist."), (Object)archivedStatus);
            if (txnIdCreate == null) {
                txnIdCreate = liveStatus.getDbTxnId();
                continue;
            }
            NodeServiceTest.assertEquals((String)"DB TXN ID should have been the same for the hierarchy. ", (Object)txnIdCreate, (Object)liveStatus.getDbTxnId());
        }
        this.nodeService.deleteNode(liveNodeRefs[0]);
        Long txnIdDelete = null;
        for (int i = 0; i < liveNodeRefs.length; ++i) {
            liveStatus = this.nodeService.getNodeStatus(liveNodeRefs[i]);
            archivedStatus = this.nodeService.getNodeStatus(archivedNodeRefs[i]);
            NodeServiceTest.assertNotNull((String)("'Live' node " + i + " status does not exist."), (Object)liveStatus);
            NodeServiceTest.assertTrue((String)("'Live' node " + i + " should be deleted (ghost entries)"), (boolean)liveStatus.isDeleted());
            NodeServiceTest.assertNotNull((String)("'Archived' node " + i + " does not exist."), (Object)archivedStatus);
            NodeServiceTest.assertFalse((String)("'Archived' node " + i + " should be undeleted"), (boolean)archivedStatus.isDeleted());
            if (txnIdDelete == null) {
                txnIdDelete = liveStatus.getDbTxnId();
            } else {
                NodeServiceTest.assertEquals((String)"DB TXN ID should have been the same for the deleted (ghost) nodes. ", (Object)txnIdDelete, (Object)liveStatus.getDbTxnId());
            }
            NodeServiceTest.assertEquals((String)"DB TXN ID should be the same for deletes across the hierarchy", (Object)txnIdDelete, (Object)archivedStatus.getDbTxnId());
        }
        this.nodeService.restoreNode(archivedNodeRefs[0], workspaceRootNodeRef, null, null);
        Long txnIdRestore = null;
        for (int i = 0; i < liveNodeRefs.length; ++i) {
            NodeRef.Status liveStatus2 = this.nodeService.getNodeStatus(liveNodeRefs[i]);
            StoreRef archivedStoreRef = archiveRootNodeRef.getStoreRef();
            archivedNodeRefs[i] = new NodeRef(archivedStoreRef, liveNodeRefs[i].getId());
            NodeRef.Status archivedStatus2 = this.nodeService.getNodeStatus(archivedNodeRefs[i]);
            NodeServiceTest.assertNotNull((String)("'Live' node " + i + " status does not exist."), (Object)liveStatus2);
            NodeServiceTest.assertFalse((String)("'Live' node " + i + " should not be deleted"), (boolean)liveStatus2.isDeleted());
            NodeServiceTest.assertNotNull((String)("'Archived' node " + i + " does not exist."), (Object)archivedStatus2);
            NodeServiceTest.assertTrue((String)("'Archived' node " + i + " should be deleted (ghost entry)"), (boolean)archivedStatus2.isDeleted());
            if (txnIdRestore == null) {
                txnIdRestore = liveStatus2.getDbTxnId();
            } else {
                NodeServiceTest.assertEquals((String)"DB TXN ID should have been the same for the restored nodes. ", (Object)txnIdRestore, (Object)liveStatus2.getDbTxnId());
            }
            NodeServiceTest.assertEquals((String)"DB TXN ID should be the same for the ex-archived (now-ghost) nodes. ", (Object)txnIdRestore, (Object)archivedStatus2.getDbTxnId());
        }
    }

    public void testGetAssocById() {
        AssociationRef assocRef = this.nodeService.getAssoc(Long.valueOf(Long.MAX_VALUE));
        NodeServiceTest.assertNull((String)"Should get null for missing ID of association. ", (Object)assocRef);
    }

    public void testDuplicateChildNodeName() {
        final NodeRef[] liveNodeRefs = new NodeRef[3];
        NodeRef workspaceRootNodeRef = this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        this.buildNodeHierarchy(workspaceRootNodeRef, liveNodeRefs);
        final String lastName = (String)((Object)this.nodeService.getProperty(liveNodeRefs[2], ContentModel.PROP_NAME));
        RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> newNodeCallback = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                HashMap<QName, String> props = new HashMap<QName, String>(3);
                props.put(ContentModel.PROP_NAME, lastName);
                return NodeServiceTest.this.nodeService.createNode(liveNodeRefs[1], ContentModel.ASSOC_CONTAINS, QName.createQName((String)NodeServiceTest.NAMESPACE, (String)"duplicate"), ContentModel.TYPE_FOLDER, props).getChildRef();
            }
        };
        try {
            this.txnService.getRetryingTransactionHelper().doInTransaction(newNodeCallback);
            NodeServiceTest.fail((String)"Duplicate child node name not detected.");
        }
        catch (DuplicateChildNodeNameException e) {
            // empty catch block
        }
    }

    public void testGetChildren_Limited() {
        List childAssocRefs;
        int i;
        NodeRef[] liveNodeRefs = new NodeRef[10];
        NodeRef workspaceRootNodeRef = this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        this.buildNodeHierarchy(workspaceRootNodeRef, liveNodeRefs);
        for (i = 2; i < liveNodeRefs.length; ++i) {
            this.nodeService.addChild(liveNodeRefs[0], liveNodeRefs[i], ContentModel.ASSOC_CONTAINS, QName.createQName((String)NAMESPACE, (String)"secondary"));
        }
        for (i = 1; i < liveNodeRefs.length; ++i) {
            childAssocRefs = this.nodeService.getChildAssocs(liveNodeRefs[0], null, null, i, true);
            NodeServiceTest.assertEquals((String)"Expected exact number of child assocs", (int)i, (int)childAssocRefs.size());
        }
        for (i = 1; i < liveNodeRefs.length; ++i) {
            childAssocRefs = this.nodeService.getChildAssocs(liveNodeRefs[0], null, null, i, false);
            NodeServiceTest.assertEquals((String)"Expected exact number of child assocs", (int)i, (int)childAssocRefs.size());
        }
    }

    public void testCaches_DeleteNode() {
        NodeRef[] liveNodeRefs = new NodeRef[10];
        NodeRef workspaceRootNodeRef = this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        this.buildNodeHierarchy(workspaceRootNodeRef, liveNodeRefs);
        this.nodeService.addAspect(liveNodeRefs[3], ContentModel.ASPECT_TEMPORARY, null);
        HashMap<QName, String> props = new HashMap<QName, String>(3);
        props.put(ContentModel.PROP_NAME, "Secondary");
        NodeRef secondaryNodeRef = this.nodeService.createNode(liveNodeRefs[2], ContentModel.ASSOC_CONTAINS, QName.createQName((String)NAMESPACE, (String)"secondary"), ContentModel.TYPE_FOLDER, props).getChildRef();
        this.nodeService.addChild(liveNodeRefs[3], secondaryNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)NAMESPACE, (String)"secondary"));
        this.nodeService.addChild(liveNodeRefs[4], secondaryNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)NAMESPACE, (String)"secondary"));
        List parentAssocsPre = this.nodeService.getParentAssocs(secondaryNodeRef);
        NodeServiceTest.assertEquals((String)"Incorrect number of parent assocs", (int)3, (int)parentAssocsPre.size());
        this.nodeService.deleteNode(liveNodeRefs[3]);
        List parentAssocsPost = this.nodeService.getParentAssocs(secondaryNodeRef);
        NodeServiceTest.assertEquals((String)"Incorrect number of parent assocs", (int)1, (int)parentAssocsPost.size());
    }

    public void testCaches_RenameNode() {
        NodeRef[] nodeRefs = new NodeRef[2];
        NodeRef workspaceRootNodeRef = this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        this.buildNodeHierarchy(workspaceRootNodeRef, nodeRefs);
        String name = (String)((Object)this.nodeService.getProperty(nodeRefs[1], ContentModel.PROP_NAME));
        NodeRef nodeRefCheck = this.nodeService.getChildByName(nodeRefs[0], ContentModel.ASSOC_CONTAINS, name);
        NodeServiceTest.assertNotNull((String)"Did not find node by name", (Object)nodeRefCheck);
        NodeServiceTest.assertEquals((String)"Node found was not correct", (Object)nodeRefs[1], (Object)nodeRefCheck);
        this.nodeService.setProperty(nodeRefs[1], ContentModel.PROP_NAME, (Serializable)((Object)"New Name"));
        nodeRefCheck = this.nodeService.getChildByName(nodeRefs[0], ContentModel.ASSOC_CONTAINS, name);
        NodeServiceTest.assertNull((String)"Should not have found anything", (Object)nodeRefCheck);
        NodeRef newChildNodeRef = this.nodeService.createNode(nodeRefs[0], ContentModel.ASSOC_CONTAINS, QName.createQName((String)NAMESPACE, (String)name), ContentModel.TYPE_FOLDER, Collections.singletonMap(ContentModel.PROP_NAME, name)).getChildRef();
        nodeRefCheck = this.nodeService.getChildByName(nodeRefs[0], ContentModel.ASSOC_CONTAINS, name);
        NodeServiceTest.assertNotNull((String)"Did not find node by name", (Object)nodeRefCheck);
        NodeServiceTest.assertEquals((String)"Node found was not correct", (Object)newChildNodeRef, (Object)nodeRefCheck);
    }

    private Object findCacheValue(SimpleCache<Serializable, Serializable> cache, Serializable key) {
        Collection keys = cache.getKeys();
        for (Serializable keyInCache : keys) {
            String keyStr;
            String keyInCacheStr = keyInCache.toString();
            if (!keyInCacheStr.endsWith(keyStr = key.toString())) continue;
            Object value = cache.get(keyInCache);
            return value;
        }
        return null;
    }

    public void testCaches_ImmutableNodeCaches() throws Exception {
        NodeRef[] nodeRefs = new NodeRef[2];
        final NodeRef workspaceRootNodeRef = this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        this.buildNodeHierarchy(workspaceRootNodeRef, nodeRefs);
        final NodeRef nodeRef = nodeRefs[1];
        Long nodeId = (Long)this.findCacheValue(this.nodesCache, (Serializable)nodeRef);
        NodeServiceTest.assertNotNull((String)"Node not found in cache", (Object)nodeId);
        Node nodeOne = (Node)this.findCacheValue(this.nodesCache, nodeId);
        NodeServiceTest.assertNotNull((String)"Node not found in cache", (Object)nodeOne);
        NodeVersionKey nodeKeyOne = nodeOne.getNodeVersionKey();
        Map nodePropsOne = (Map)this.findCacheValue(this.propsCache, nodeKeyOne);
        Set nodeAspectsOne = (Set)this.findCacheValue(this.aspectsCache, nodeKeyOne);
        NodeServiceTest.assertEquals((String)"The node version is incorrect", (Object)1L, (Object)nodeKeyOne.getVersion());
        NodeServiceTest.assertNotNull((String)"No cache entry for properties", (Object)nodePropsOne);
        NodeServiceTest.assertNotNull((String)"No cache entry for aspects", (Object)nodeAspectsOne);
        NodeServiceTest.assertEquals((String)"Property count incorrect", (int)1, (int)nodePropsOne.size());
        NodeServiceTest.assertNotNull((String)"Expected a cm:name property", nodePropsOne.get(ContentModel.PROP_NAME));
        NodeServiceTest.assertEquals((String)"Aspect count incorrect", (int)1, (int)nodeAspectsOne.size());
        NodeServiceTest.assertTrue((String)"Expected a cm:auditable aspect", (boolean)nodeAspectsOne.contains(ContentModel.ASPECT_AUDITABLE));
        this.nodeService.setProperty(nodeRef, PROP_RESIDUAL, (Serializable)((Object)GUID.generate()));
        Map nodePropsOneCheck = (Map)this.findCacheValue(this.propsCache, nodeKeyOne);
        Set nodeAspectsOneCheck = (Set)this.findCacheValue(this.aspectsCache, nodeKeyOne);
        NodeServiceTest.assertTrue((String)"Previous cache entries must be left alone", (nodePropsOneCheck == nodePropsOne ? 1 : 0) != 0);
        NodeServiceTest.assertTrue((String)"Previous cache entries must be left alone", (nodeAspectsOneCheck == nodeAspectsOne ? 1 : 0) != 0);
        Node nodeTwo = (Node)this.findCacheValue(this.nodesCache, nodeId);
        NodeServiceTest.assertNotNull((String)"Node not found in cache", (Object)nodeTwo);
        NodeVersionKey nodeKeyTwo = nodeTwo.getNodeVersionKey();
        Map nodePropsTwo = (Map)this.findCacheValue(this.propsCache, nodeKeyTwo);
        Set nodeAspectsTwo = (Set)this.findCacheValue(this.aspectsCache, nodeKeyTwo);
        NodeServiceTest.assertEquals((String)"The node version is incorrect", (Object)2L, (Object)nodeKeyTwo.getVersion());
        NodeServiceTest.assertNotNull((String)"No cache entry for properties", (Object)nodePropsTwo);
        NodeServiceTest.assertNotNull((String)"No cache entry for aspects", (Object)nodeAspectsTwo);
        NodeServiceTest.assertTrue((String)"Properties must have moved on", (nodePropsTwo != nodePropsOne ? 1 : 0) != 0);
        NodeServiceTest.assertEquals((String)"Property count incorrect", (int)2, (int)nodePropsTwo.size());
        NodeServiceTest.assertNotNull((String)"Expected a cm:name property", nodePropsTwo.get(ContentModel.PROP_NAME));
        NodeServiceTest.assertNotNull((String)"Expected a residual property", nodePropsTwo.get(PROP_RESIDUAL));
        NodeServiceTest.assertTrue((String)"Aspects must be carried", (nodeAspectsTwo == nodeAspectsOne ? 1 : 0) != 0);
        this.nodeService.removeProperty(nodeRef, PROP_RESIDUAL);
        Map nodePropsTwoCheck = (Map)this.findCacheValue(this.propsCache, nodeKeyTwo);
        Set nodeAspectsTwoCheck = (Set)this.findCacheValue(this.aspectsCache, nodeKeyTwo);
        NodeServiceTest.assertTrue((String)"Previous cache entries must be left alone", (nodePropsTwoCheck == nodePropsTwo ? 1 : 0) != 0);
        NodeServiceTest.assertTrue((String)"Previous cache entries must be left alone", (nodeAspectsTwoCheck == nodeAspectsTwo ? 1 : 0) != 0);
        Node nodeThree = (Node)this.findCacheValue(this.nodesCache, nodeId);
        NodeServiceTest.assertNotNull((String)"Node not found in cache", (Object)nodeThree);
        NodeVersionKey nodeKeyThree = nodeThree.getNodeVersionKey();
        Map nodePropsThree = (Map)this.findCacheValue(this.propsCache, nodeKeyThree);
        Set nodeAspectsThree = (Set)this.findCacheValue(this.aspectsCache, nodeKeyThree);
        NodeServiceTest.assertEquals((String)"The node version is incorrect", (Object)3L, (Object)nodeKeyThree.getVersion());
        NodeServiceTest.assertNotNull((String)"No cache entry for properties", (Object)nodePropsThree);
        NodeServiceTest.assertNotNull((String)"No cache entry for aspects", (Object)nodeAspectsThree);
        NodeServiceTest.assertTrue((String)"Properties must have moved on", (nodePropsThree != nodePropsTwo ? 1 : 0) != 0);
        NodeServiceTest.assertEquals((String)"Property count incorrect", (int)1, (int)nodePropsThree.size());
        NodeServiceTest.assertNotNull((String)"Expected a cm:name property", nodePropsThree.get(ContentModel.PROP_NAME));
        NodeServiceTest.assertNull((String)"Expected no residual property", nodePropsThree.get(PROP_RESIDUAL));
        NodeServiceTest.assertTrue((String)"Aspects must be carried", (nodeAspectsThree == nodeAspectsTwo ? 1 : 0) != 0);
        this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_TITLED, null);
        Map nodePropsThreeCheck = (Map)this.findCacheValue(this.propsCache, nodeKeyThree);
        Set nodeAspectsThreeCheck = (Set)this.findCacheValue(this.aspectsCache, nodeKeyThree);
        NodeServiceTest.assertTrue((String)"Previous cache entries must be left alone", (nodePropsThreeCheck == nodePropsThree ? 1 : 0) != 0);
        NodeServiceTest.assertTrue((String)"Previous cache entries must be left alone", (nodeAspectsThreeCheck == nodeAspectsThree ? 1 : 0) != 0);
        Node nodeFour = (Node)this.findCacheValue(this.nodesCache, nodeId);
        NodeServiceTest.assertNotNull((String)"Node not found in cache", (Object)nodeFour);
        NodeVersionKey nodeKeyFour = nodeFour.getNodeVersionKey();
        Map nodePropsFour = (Map)this.findCacheValue(this.propsCache, nodeKeyFour);
        Set nodeAspectsFour = (Set)this.findCacheValue(this.aspectsCache, nodeKeyFour);
        NodeServiceTest.assertEquals((String)"The node version is incorrect", (Object)4L, (Object)nodeKeyFour.getVersion());
        NodeServiceTest.assertNotNull((String)"No cache entry for properties", (Object)nodePropsFour);
        NodeServiceTest.assertNotNull((String)"No cache entry for aspects", (Object)nodeAspectsFour);
        NodeServiceTest.assertTrue((String)"Properties must be carried", (nodePropsFour == nodePropsThree ? 1 : 0) != 0);
        NodeServiceTest.assertTrue((String)"Aspects must have moved on", (nodeAspectsFour != nodeAspectsThree ? 1 : 0) != 0);
        NodeServiceTest.assertTrue((String)"Expected cm:titled aspect", (boolean)nodeAspectsFour.contains(ContentModel.ASPECT_TITLED));
        this.nodeService.removeAspect(nodeRef, ContentModel.ASPECT_TITLED);
        Map nodePropsFourCheck = (Map)this.findCacheValue(this.propsCache, nodeKeyFour);
        Set nodeAspectsFourCheck = (Set)this.findCacheValue(this.aspectsCache, nodeKeyFour);
        NodeServiceTest.assertTrue((String)"Previous cache entries must be left alone", (nodePropsFourCheck == nodePropsFour ? 1 : 0) != 0);
        NodeServiceTest.assertTrue((String)"Previous cache entries must be left alone", (nodeAspectsFourCheck == nodeAspectsFour ? 1 : 0) != 0);
        Node nodeFive = (Node)this.findCacheValue(this.nodesCache, nodeId);
        NodeServiceTest.assertNotNull((String)"Node not found in cache", (Object)nodeFive);
        NodeVersionKey nodeKeyFive = nodeFive.getNodeVersionKey();
        Map nodePropsFive = (Map)this.findCacheValue(this.propsCache, nodeKeyFive);
        Set nodeAspectsFive = (Set)this.findCacheValue(this.aspectsCache, nodeKeyFive);
        NodeServiceTest.assertEquals((String)"The node version is incorrect", (Object)5L, (Object)nodeKeyFive.getVersion());
        NodeServiceTest.assertNotNull((String)"No cache entry for properties", (Object)nodePropsFive);
        NodeServiceTest.assertNotNull((String)"No cache entry for aspects", (Object)nodeAspectsFive);
        NodeServiceTest.assertTrue((String)"Properties must be carried", (nodePropsFive == nodePropsFour ? 1 : 0) != 0);
        NodeServiceTest.assertTrue((String)"Aspects must have moved on", (nodeAspectsFive != nodeAspectsFour ? 1 : 0) != 0);
        NodeServiceTest.assertFalse((String)"Expected no cm:titled aspect ", (boolean)nodeAspectsFive.contains(ContentModel.ASPECT_TITLED));
        RetryingTransactionHelper.RetryingTransactionCallback<Void> nodeSixWork = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                HashMap<QName, String> props = new HashMap<QName, String>();
                props.put(ContentModel.PROP_TITLE, "some title");
                NodeServiceTest.this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_TITLED, props);
                NodeServiceTest.this.nodeService.setProperty(nodeRef, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"Some description"));
                NodeServiceTest.this.nodeService.addChild(Collections.singletonList(workspaceRootNodeRef), nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)NodeServiceTest.TEST_PREFIX, (String)"secondary"));
                return null;
            }
        };
        this.txnService.getRetryingTransactionHelper().doInTransaction(nodeSixWork);
        Map nodePropsFiveCheck = (Map)this.findCacheValue(this.propsCache, nodeKeyFive);
        Set nodeAspectsFiveCheck = (Set)this.findCacheValue(this.aspectsCache, nodeKeyFive);
        NodeServiceTest.assertTrue((String)"Previous cache entries must be left alone", (nodePropsFiveCheck == nodePropsFive ? 1 : 0) != 0);
        NodeServiceTest.assertTrue((String)"Previous cache entries must be left alone", (nodeAspectsFiveCheck == nodeAspectsFive ? 1 : 0) != 0);
        Node nodeSix = (Node)this.findCacheValue(this.nodesCache, nodeId);
        NodeServiceTest.assertNotNull((String)"Node not found in cache", (Object)nodeSix);
        NodeVersionKey nodeKeySix = nodeSix.getNodeVersionKey();
        Map nodePropsSix = (Map)this.findCacheValue(this.propsCache, nodeKeySix);
        Set nodeAspectsSix = (Set)this.findCacheValue(this.aspectsCache, nodeKeySix);
        NodeServiceTest.assertEquals((String)"The node version is incorrect", (Object)6L, (Object)nodeKeySix.getVersion());
        NodeServiceTest.assertNotNull((String)"No cache entry for properties", (Object)nodePropsSix);
        NodeServiceTest.assertNotNull((String)"No cache entry for aspects", (Object)nodeAspectsSix);
        NodeServiceTest.assertTrue((String)"Properties must have moved on", (nodePropsSix != nodePropsFive ? 1 : 0) != 0);
        NodeServiceTest.assertEquals((String)"Property count incorrect", (int)3, (int)nodePropsSix.size());
        NodeServiceTest.assertNotNull((String)"Expected a cm:name property", nodePropsSix.get(ContentModel.PROP_NAME));
        NodeServiceTest.assertNotNull((String)"Expected a cm:title property", nodePropsSix.get(ContentModel.PROP_TITLE));
        NodeServiceTest.assertNotNull((String)"Expected a cm:description property", nodePropsSix.get(ContentModel.PROP_DESCRIPTION));
        NodeServiceTest.assertTrue((String)"Aspects must have moved on", (nodeAspectsSix != nodeAspectsFive ? 1 : 0) != 0);
        NodeServiceTest.assertTrue((String)"Expected cm:titled aspect ", (boolean)nodeAspectsSix.contains(ContentModel.ASPECT_TITLED));
        RetryingTransactionHelper.RetryingTransactionCallback<Void> nodeSevenWork = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                NodeServiceTest.this.nodeService.removeAspect(nodeRef, ContentModel.ASPECT_TITLED);
                NodeServiceTest.this.nodeService.removeChild(workspaceRootNodeRef, nodeRef);
                return null;
            }
        };
        this.txnService.getRetryingTransactionHelper().doInTransaction(nodeSevenWork);
        Map nodePropsSixCheck = (Map)this.findCacheValue(this.propsCache, nodeKeySix);
        Set nodeAspectsSixCheck = (Set)this.findCacheValue(this.aspectsCache, nodeKeySix);
        NodeServiceTest.assertTrue((String)"Previous cache entries must be left alone", (nodePropsSixCheck == nodePropsSix ? 1 : 0) != 0);
        NodeServiceTest.assertTrue((String)"Previous cache entries must be left alone", (nodeAspectsSixCheck == nodeAspectsSix ? 1 : 0) != 0);
        Node nodeSeven = (Node)this.findCacheValue(this.nodesCache, nodeId);
        NodeServiceTest.assertNotNull((String)"Node not found in cache", (Object)nodeSeven);
        NodeVersionKey nodeKeySeven = nodeSeven.getNodeVersionKey();
        Map nodePropsSeven = (Map)this.findCacheValue(this.propsCache, nodeKeySeven);
        Set nodeAspectsSeven = (Set)this.findCacheValue(this.aspectsCache, nodeKeySeven);
        NodeServiceTest.assertEquals((String)"The node version is incorrect", (Object)7L, (Object)nodeKeySeven.getVersion());
        NodeServiceTest.assertNotNull((String)"No cache entry for properties", (Object)nodePropsSeven);
        NodeServiceTest.assertNotNull((String)"No cache entry for aspects", (Object)nodeAspectsSeven);
        NodeServiceTest.assertTrue((String)"Properties must have moved on", (nodePropsSeven != nodePropsSix ? 1 : 0) != 0);
        NodeServiceTest.assertEquals((String)"Property count incorrect", (int)1, (int)nodePropsSeven.size());
        NodeServiceTest.assertNotNull((String)"Expected a cm:name property", nodePropsSeven.get(ContentModel.PROP_NAME));
        NodeServiceTest.assertTrue((String)"Aspects must have moved on", (nodeAspectsSeven != nodeAspectsSix ? 1 : 0) != 0);
        NodeServiceTest.assertFalse((String)"Expected no cm:titled aspect ", (boolean)nodeAspectsSeven.contains(ContentModel.ASPECT_TITLED));
        RetryingTransactionHelper.RetryingTransactionCallback<Void> nodeEightWork = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                BehaviourFilter behaviourFilter = (BehaviourFilter)ctx.getBean("policyBehaviourFilter");
                behaviourFilter.disableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
                NodeServiceTest.this.nodeService.setProperty(nodeRef, ContentModel.PROP_MODIFIER, (Serializable)((Object)"Fred"));
                return null;
            }
        };
        this.txnService.getRetryingTransactionHelper().doInTransaction(nodeEightWork);
        Map nodePropsSevenCheck = (Map)this.findCacheValue(this.propsCache, nodeKeySeven);
        Set nodeAspectsSevenCheck = (Set)this.findCacheValue(this.aspectsCache, nodeKeySeven);
        NodeServiceTest.assertTrue((String)"Previous cache entries must be left alone", (nodePropsSevenCheck == nodePropsSeven ? 1 : 0) != 0);
        NodeServiceTest.assertTrue((String)"Previous cache entries must be left alone", (nodeAspectsSevenCheck == nodeAspectsSeven ? 1 : 0) != 0);
        Node nodeEight = (Node)this.findCacheValue(this.nodesCache, nodeId);
        NodeServiceTest.assertNotNull((String)"Node not found in cache", (Object)nodeEight);
        NodeVersionKey nodeKeyEight = nodeEight.getNodeVersionKey();
        Map nodePropsEight = (Map)this.findCacheValue(this.propsCache, nodeKeyEight);
        Set nodeAspectsEight = (Set)this.findCacheValue(this.aspectsCache, nodeKeyEight);
        NodeServiceTest.assertEquals((String)"The node version is incorrect", (Object)8L, (Object)nodeKeyEight.getVersion());
        NodeServiceTest.assertNotNull((String)"No cache entry for properties", (Object)nodePropsEight);
        NodeServiceTest.assertNotNull((String)"No cache entry for aspects", (Object)nodeAspectsEight);
        NodeServiceTest.assertEquals((String)"Expected change to cm:modifier", (String)"Fred", (String)nodeEight.getAuditableProperties().getAuditModifier());
        NodeServiceTest.assertTrue((String)"Properties must be carried", (nodePropsEight == nodePropsSeven ? 1 : 0) != 0);
        NodeServiceTest.assertTrue((String)"Aspects be carried", (nodeAspectsEight == nodeAspectsSeven ? 1 : 0) != 0);
    }

    public void testCreateNodePolicies() {
        NodeServicePolicies.OnCreateNodePolicy onCreateNodePolicy = this.createClassPolicy(NodeServicePolicies.OnCreateNodePolicy.class, NodeServicePolicies.OnCreateNodePolicy.QNAME, ContentModel.TYPE_CONTENT);
        NodeServicePolicies.BeforeCreateNodePolicy beforeCreateNodePolicy = this.createClassPolicy(NodeServicePolicies.BeforeCreateNodePolicy.class, NodeServicePolicies.BeforeCreateNodePolicy.QNAME, ContentModel.TYPE_CONTENT);
        NodeServicePolicies.OnCreateChildAssociationPolicy onCreateChildAssociationPolicy = this.createAssocPolicy(NodeServicePolicies.OnCreateChildAssociationPolicy.class, NodeServicePolicies.OnCreateChildAssociationPolicy.QNAME, ContentModel.TYPE_STOREROOT);
        NodeServicePolicies.OnUpdatePropertiesPolicy onUpdatePropertiesPolicy = this.createClassPolicy(NodeServicePolicies.OnUpdatePropertiesPolicy.class, NodeServicePolicies.OnUpdatePropertiesPolicy.QNAME, ContentModel.TYPE_CONTENT);
        NodeRef newNodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTENT, PropertyMap.EMPTY_MAP).getChildRef();
        Map propsAfter = this.nodeService.getProperties(newNodeRef);
        ChildAssociationRef childAssocRef = this.nodeService.getPrimaryParent(newNodeRef);
        ((NodeServicePolicies.BeforeCreateNodePolicy)Mockito.verify((Object)beforeCreateNodePolicy)).beforeCreateNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTENT);
        ((NodeServicePolicies.OnCreateNodePolicy)Mockito.verify((Object)onCreateNodePolicy)).onCreateNode(childAssocRef);
        ((NodeServicePolicies.OnCreateChildAssociationPolicy)Mockito.verify((Object)onCreateChildAssociationPolicy)).onCreateChildAssociation(childAssocRef, true);
        ((NodeServicePolicies.OnUpdatePropertiesPolicy)Mockito.verify((Object)onUpdatePropertiesPolicy)).onUpdateProperties(newNodeRef, PropertyMap.EMPTY_MAP, propsAfter);
    }

    public void testSetNodeTypePolicies() {
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTENT, new HashMap(0)).getChildRef();
        NodeServicePolicies.BeforeUpdateNodePolicy beforeUpdatePolicy = this.createClassPolicy(NodeServicePolicies.BeforeUpdateNodePolicy.class, NodeServicePolicies.BeforeUpdateNodePolicy.QNAME, ContentModel.TYPE_CONTENT);
        NodeServicePolicies.OnUpdateNodePolicy onUpdatePolicy = this.createClassPolicy(NodeServicePolicies.OnUpdateNodePolicy.class, NodeServicePolicies.OnUpdateNodePolicy.QNAME, ContentModel.TYPE_FOLDER);
        NodeServicePolicies.BeforeSetNodeTypePolicy beforeSetNodeTypePolicy = this.createClassPolicy(NodeServicePolicies.BeforeSetNodeTypePolicy.class, NodeServicePolicies.BeforeSetNodeTypePolicy.QNAME, ContentModel.TYPE_CONTENT);
        NodeServicePolicies.OnSetNodeTypePolicy onSetNodeTypePolicy = this.createClassPolicy(NodeServicePolicies.OnSetNodeTypePolicy.class, NodeServicePolicies.OnSetNodeTypePolicy.QNAME, ContentModel.TYPE_FOLDER);
        this.nodeService.setType(nodeRef, ContentModel.TYPE_FOLDER);
        ((NodeServicePolicies.BeforeUpdateNodePolicy)Mockito.verify((Object)beforeUpdatePolicy)).beforeUpdateNode(nodeRef);
        ((NodeServicePolicies.OnUpdateNodePolicy)Mockito.verify((Object)onUpdatePolicy)).onUpdateNode(nodeRef);
        ((NodeServicePolicies.BeforeSetNodeTypePolicy)Mockito.verify((Object)beforeSetNodeTypePolicy)).beforeSetNodeType(nodeRef, ContentModel.TYPE_CONTENT, ContentModel.TYPE_FOLDER);
        ((NodeServicePolicies.OnSetNodeTypePolicy)Mockito.verify((Object)onSetNodeTypePolicy)).onSetNodeType(nodeRef, ContentModel.TYPE_CONTENT, ContentModel.TYPE_FOLDER);
    }

    private <T extends Policy> T createClassPolicy(Class<T> policyInterface, QName policyQName, QName triggerOnClass) {
        Policy policy = (Policy)Mockito.mock(policyInterface);
        this.policyComponent.bindClassBehaviour(policyQName, triggerOnClass, (Behaviour)new JavaBehaviour(policy, policyQName.getLocalName()));
        return (T)policy;
    }

    private <T extends Policy> T createAssocPolicy(Class<T> policyInterface, QName policyQName, QName triggerOnClass) {
        Policy policy = (Policy)Mockito.mock(policyInterface);
        this.policyComponent.bindAssociationBehaviour(policyQName, triggerOnClass, (Behaviour)new JavaBehaviour(policy, policyQName.getLocalName()));
        return (T)policy;
    }

    public void testConcurrentLinkToDeletedNode() throws Throwable {
        QNameDAO qnameDAO = (QNameDAO)ctx.getBean("qnameDAO");
        Long deletedTypeQNameId = (Long)qnameDAO.getOrCreateQName(ContentModel.TYPE_DELETED).getFirst();
        NodeEntity params = new NodeEntity();
        params.setId(0L);
        params.setTypeQNameId(deletedTypeQNameId);
        List<Long> attachedToDeletedIdsBefore = this.getChildNodesWithDeletedParentNode(params, 0);
        logger.debug((Object)("Found child nodes with deleted parent node (before): " + attachedToDeletedIdsBefore));
        List<Long> orphanedNodeIdsBefore = this.getChildNodesWithNoParentNode(params, 0);
        logger.debug((Object)("Found child nodes without parent (before): " + orphanedNodeIdsBefore));
        final NodeRef[] nodeRefs = new NodeRef[10];
        NodeRef workspaceRootNodeRef = this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        this.buildNodeHierarchy(workspaceRootNodeRef, nodeRefs);
        final RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> createChildCallback = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                String randomName = NodeServiceTest.this.getName() + "-" + GUID.generate();
                QName randomQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)randomName);
                HashMap<QName, String> props = new HashMap<QName, String>();
                props.put(ContentModel.PROP_NAME, randomName);
                int random = new Random().nextInt(10);
                return NodeServiceTest.this.nodeService.createNode(nodeRefs[random], ContentModel.ASSOC_CONTAINS, randomQName, ContentModel.TYPE_CONTAINER, props).getChildRef();
            }
        };
        final Runnable[] runnables = new Runnable[20];
        final List<NodeRef> nodesAtRisk = Collections.synchronizedList(new ArrayList(100));
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (int i = 0; i < runnables.length; ++i) {
            runnables[i] = new Runnable(){

                @Override
                public synchronized void run() {
                    AuthenticationUtil.setRunAsUserSystem();
                    try {
                        this.wait(1000L);
                        for (int i = 0; i < 200; ++i) {
                            NodeRef nodeRef = (NodeRef)NodeServiceTest.this.txnService.getRetryingTransactionHelper().doInTransaction(createChildCallback);
                            nodesAtRisk.add(nodeRef);
                            this.wait(1L);
                        }
                    }
                    catch (Throwable e) {
                        logger.debug((Object)"Got exception adding child node: ", e);
                    }
                }
            };
            Thread thread = new Thread(runnables[i]);
            threads.add(thread);
            thread.start();
        }
        RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> deleteWithNestedCallback = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NodeRef execute() throws Throwable {
                for (int i = 0; i < runnables.length; ++i) {
                    Object object = runnables[i];
                    synchronized (object) {
                        runnables[i].notify();
                    }
                    object = this;
                    synchronized (object) {
                        try {
                            this.wait(10L);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        continue;
                    }
                }
                NodeServiceTest.this.nodeService.deleteNode(nodeRefs[0]);
                return null;
            }
        };
        this.txnService.getRetryingTransactionHelper().doInTransaction(deleteWithNestedCallback);
        for (Thread t : threads) {
            t.join();
        }
        logger.info((Object)"All threads should have finished");
        List<Long> attachedToDeletedIdsAfter = this.getChildNodesWithDeletedParentNode(params, attachedToDeletedIdsBefore.size());
        logger.debug((Object)("Found child nodes with deleted parent node (after): " + attachedToDeletedIdsAfter));
        List<Long> orphanedNodeIdsAfter = this.getChildNodesWithNoParentNode(params, orphanedNodeIdsBefore.size());
        logger.debug((Object)("Found child nodes without parent (after): " + attachedToDeletedIdsAfter));
        if (attachedToDeletedIdsAfter.isEmpty() && orphanedNodeIdsAfter.isEmpty()) {
            return;
        }
        for (final NodeRef nodeRef : nodesAtRisk) {
            this.txnService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                @Override
                public Void execute() throws Throwable {
                    if (NodeServiceTest.this.nodeService.exists(nodeRef)) {
                        NodeServiceTest.this.nodeService.getPath(nodeRef);
                    }
                    return null;
                }
            });
        }
        List<Long> attachedToDeletedIdsCleaned = this.getChildNodesWithDeletedParentNode(params, attachedToDeletedIdsBefore.size());
        logger.debug((Object)("Found child nodes with deleted parent node (cleaned): " + attachedToDeletedIdsAfter));
        List<Long> orphanedNodeIdsCleaned = this.getChildNodesWithNoParentNode(params, orphanedNodeIdsBefore.size());
        logger.debug((Object)("Found child nodes without parent (cleaned): " + attachedToDeletedIdsAfter));
        NodeServiceTest.assertTrue((String)("Expected full cleanup of nodes referencing deleted nodes: " + attachedToDeletedIdsCleaned), (boolean)attachedToDeletedIdsCleaned.isEmpty());
        NodeServiceTest.assertTrue((String)("Expected full cleanup of nodes referencing without parents: " + orphanedNodeIdsCleaned), (boolean)orphanedNodeIdsCleaned.isEmpty());
        List<NodeRef> lostAndFoundNodeRefs = this.getLostAndFoundNodes();
        NodeServiceTest.assertFalse((boolean)lostAndFoundNodeRefs.isEmpty());
        HashSet<Long> lostAndFoundNodeIds = new HashSet<Long>(lostAndFoundNodeRefs.size());
        for (NodeRef nodeRef : lostAndFoundNodeRefs) {
            lostAndFoundNodeIds.add((Long)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NODE_DBID));
        }
        NodeServiceTest.assertTrue((String)"Nodes linked to deleted parent nodes not handled.", (boolean)lostAndFoundNodeIds.containsAll(attachedToDeletedIdsAfter));
        NodeServiceTest.assertTrue((String)"Orphaned nodes not all handled.", (boolean)lostAndFoundNodeIds.containsAll(orphanedNodeIdsAfter));
        NodeServiceTest.fail((String)"We allowed orphaned nodes or nodes with deleted parents.");
    }

    public void testForceNonRootNodeWithNoParentNode() throws Throwable {
        QNameDAO qnameDAO = (QNameDAO)ctx.getBean("qnameDAO");
        Long deletedTypeQNameId = (Long)qnameDAO.getOrCreateQName(ContentModel.TYPE_DELETED).getFirst();
        NodeEntity params = new NodeEntity();
        params.setId(0L);
        params.setTypeQNameId(deletedTypeQNameId);
        List<Long> ids = this.getChildNodesWithNoParentNode(params, 0);
        logger.debug((Object)("Found child nodes with deleted parent node (before): " + ids));
        int idsToSkip = ids.size();
        NodeRef[] nodeRefs = new NodeRef[10];
        NodeRef workspaceRootNodeRef = this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        this.buildNodeHierarchy(workspaceRootNodeRef, nodeRefs);
        int cnt = 5;
        ArrayList<NodeRef> childNodeRefs = new ArrayList<NodeRef>(cnt);
        final NodeDAO nodeDAO = (NodeDAO)ctx.getBean("nodeDAO");
        for (int i = 0; i < cnt; ++i) {
            String randomName = this.getName() + "-" + System.nanoTime();
            QName randomQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)randomName);
            HashMap<QName, String> props = new HashMap<QName, String>();
            props.put(ContentModel.PROP_NAME, randomName);
            int random = new Random().nextInt(10);
            NodeRef parentNodeRef = nodeRefs[random];
            NodeRef childNodeRef = this.nodeService.createNode(parentNodeRef, ContentModel.ASSOC_CONTAINS, randomQName, ContentModel.TYPE_THUMBNAIL, props).getChildRef();
            childNodeRefs.add(childNodeRef);
            final Long childNodeId = (Long)this.nodeService.getProperty(childNodeRef, ContentModel.PROP_NODE_DBID);
            this.txnService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                @Override
                public Void execute() throws Throwable {
                    Pair<Long, ChildAssociationRef> assocPair = nodeDAO.getPrimaryParentAssoc(childNodeId);
                    nodeDAO.deleteChildAssoc((Long)assocPair.getFirst());
                    return null;
                }
            });
        }
        List<Long> childNodeIds = this.getChildNodesWithNoParentNode(params, idsToSkip);
        NodeServiceTest.assertFalse((boolean)childNodeIds.isEmpty());
        logger.debug((Object)("Found child nodes with deleted parent node (after): " + childNodeIds));
        for (final NodeRef nodeRef : childNodeRefs) {
            this.txnService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                @Override
                public Void execute() throws Throwable {
                    if (NodeServiceTest.this.nodeService.exists(nodeRef)) {
                        NodeServiceTest.this.nodeService.getPath(nodeRef);
                    }
                    return null;
                }
            });
        }
        ids = this.getChildNodesWithNoParentNode(params, idsToSkip);
        NodeServiceTest.assertTrue((String)("The following child nodes have no parent node: " + ids), (boolean)ids.isEmpty());
        List<NodeRef> lostAndFoundNodeRefs = this.getLostAndFoundNodes();
        NodeServiceTest.assertFalse((boolean)lostAndFoundNodeRefs.isEmpty());
        ArrayList<Long> lostAndFoundNodeIds = new ArrayList<Long>(lostAndFoundNodeRefs.size());
        for (NodeRef nodeRef : lostAndFoundNodeRefs) {
            lostAndFoundNodeIds.add((Long)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NODE_DBID));
        }
        for (Long childNodeId : childNodeIds) {
            NodeServiceTest.assertTrue((String)("Not found: " + childNodeId), (boolean)lostAndFoundNodeIds.contains(childNodeId));
        }
    }

    private List<Long> getChildNodesWithDeletedParentNode(NodeEntity params, int idsToSkip) {
        return this.cannedQueryDAO.executeQuery("alfresco.query.test", "select_NodeServiceTest_testConcurrentLinkToDeletedNode_GetChildNodesWithDeletedParentNodeCannedQuery", params, idsToSkip, Integer.MAX_VALUE);
    }

    private List<Long> getChildNodesWithNoParentNode(NodeEntity params, int idsToSkip) {
        return this.cannedQueryDAO.executeQuery("alfresco.query.test", "select_NodeServiceTest_testForceNonRootNodeWithNoParentNode_GetChildNodesWithNoParentNodeCannedQuery", params, idsToSkip, Integer.MAX_VALUE);
    }

    private List<NodeRef> getLostAndFoundNodes() {
        HashSet<QName> childNodeTypeQNames = new HashSet<QName>(1);
        childNodeTypeQNames.add(ContentModel.TYPE_LOST_AND_FOUND);
        List childAssocRefs = this.nodeService.getChildAssocs(this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE), childNodeTypeQNames);
        List<NodeRef> lostNodeRefs = null;
        if (childAssocRefs.size() > 0) {
            List lostNodeChildAssocRefs = this.nodeService.getChildAssocs(((ChildAssociationRef)childAssocRefs.get(0)).getChildRef());
            lostNodeRefs = new ArrayList<NodeRef>(lostNodeChildAssocRefs.size());
            for (ChildAssociationRef lostNodeChildAssocRef : lostNodeChildAssocRefs) {
                lostNodeRefs.add(lostNodeChildAssocRef.getChildRef());
            }
        } else {
            lostNodeRefs = Collections.emptyList();
        }
        return lostNodeRefs;
    }

    public void testNodeHierarchyWalker() throws Exception {
        NodeRef workspaceRootNodeRef = this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        NodeRef[] nodes = new NodeRef[6];
        this.buildNodeHierarchy(workspaceRootNodeRef, nodes);
        Pair<Long, NodeRef> parentNodePair = this.nodeDAO.getNodePair(nodes[0]);
        Pair<Long, ChildAssociationRef> parentAssocPair = this.nodeDAO.getPrimaryParentAssoc((Long)parentNodePair.getFirst());
        this.nodeService.addAspect(nodes[1], ContentModel.ASPECT_COPIEDFROM, null);
        this.nodeService.createAssociation(nodes[1], nodes[0], ContentModel.ASSOC_ORIGINAL);
        this.nodeService.addChild(nodes[0], nodes[2], ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org", (String)"testNodeHierarchyWalker"));
        NodeHierarchyWalker walker = new NodeHierarchyWalker(this.nodeDAO);
        walker.walkHierarchy(parentNodePair, parentAssocPair);
        List<NodeHierarchyWalker.VisitedNode> nodesLeafFirst = walker.getNodes(true);
        NodeServiceTest.assertEquals((String)"Unexpected number of nodes visited", (int)6, (int)nodesLeafFirst.size());
        NodeServiceTest.assertEquals((String)"Incorrect order ", (Object)nodesLeafFirst.get((int)0).nodeRef, (Object)nodes[5]);
        NodeServiceTest.assertEquals((String)"Incorrect order ", (Object)nodesLeafFirst.get((int)5).nodeRef, (Object)nodes[0]);
        List<NodeHierarchyWalker.VisitedNode> nodesParentFirst = walker.getNodes(false);
        NodeServiceTest.assertEquals((String)"Unexpected number of nodes visited", (int)6, (int)nodesParentFirst.size());
        NodeServiceTest.assertEquals((String)"Incorrect order ", (Object)nodesParentFirst.get((int)0).nodeRef, (Object)nodes[0]);
        NodeServiceTest.assertEquals((String)"Incorrect order ", (Object)nodesParentFirst.get((int)5).nodeRef, (Object)nodes[5]);
        NodeServiceTest.assertEquals((Object)workspaceRootNodeRef, (Object)((ChildAssociationRef)nodesParentFirst.get((int)0).primaryParentAssocPair.getSecond()).getParentRef());
        NodeServiceTest.assertEquals((Object)nodes[0], (Object)((ChildAssociationRef)nodesParentFirst.get((int)1).primaryParentAssocPair.getSecond()).getParentRef());
        NodeServiceTest.assertEquals((Object)nodes[4], (Object)((ChildAssociationRef)nodesParentFirst.get((int)5).primaryParentAssocPair.getSecond()).getParentRef());
        NodeServiceTest.assertEquals((int)0, (int)nodesParentFirst.get((int)0).secondaryParentAssocs.size());
        NodeServiceTest.assertEquals((Object)nodes[0], (Object)((ChildAssociationRef)nodesParentFirst.get((int)2).secondaryParentAssocs.get(0).getSecond()).getParentRef());
        NodeServiceTest.assertEquals((int)0, (int)nodesParentFirst.get((int)1).secondaryParentAssocs.size());
        NodeServiceTest.assertEquals((int)1, (int)nodesParentFirst.get((int)2).secondaryParentAssocs.size());
        NodeServiceTest.assertEquals((int)0, (int)nodesParentFirst.get((int)3).secondaryParentAssocs.size());
        NodeServiceTest.assertEquals((int)1, (int)nodesParentFirst.get((int)0).secondaryChildAssocs.size());
        NodeServiceTest.assertEquals((Object)nodes[2], (Object)((ChildAssociationRef)nodesParentFirst.get((int)0).secondaryChildAssocs.get(0).getSecond()).getChildRef());
        NodeServiceTest.assertEquals((int)0, (int)nodesParentFirst.get((int)1).secondaryChildAssocs.size());
        NodeServiceTest.assertEquals((int)0, (int)nodesParentFirst.get((int)0).targetAssocs.size());
        NodeServiceTest.assertEquals((int)1, (int)nodesParentFirst.get((int)1).targetAssocs.size());
        NodeServiceTest.assertEquals((Object)nodes[0], (Object)((AssociationRef)nodesParentFirst.get((int)1).targetAssocs.get(0).getSecond()).getTargetRef());
        NodeServiceTest.assertEquals((int)1, (int)nodesParentFirst.get((int)0).sourceAssocs.size());
        NodeServiceTest.assertEquals((Object)nodes[1], (Object)((AssociationRef)nodesParentFirst.get((int)0).sourceAssocs.get(0).getSecond()).getSourceRef());
        NodeServiceTest.assertEquals((int)0, (int)nodesParentFirst.get((int)1).sourceAssocs.size());
    }
}

