/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.policy;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.TransactionalResourceHelper;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.ParameterCheck;

public class BehaviourFilterImpl
implements BehaviourFilter {
    private static final String KEY_FILTER_COUNT = "BehaviourFilterImpl.filterCount";
    private static final String KEY_GLOBAL_FILTERS = "BehaviourFilterImpl.globalFilters";
    private static final String KEY_CLASS_FILTERS = "BehaviourFilterImpl.classFilters";
    private static final String KEY_INSTANCE_CLASS_FILTERS = "BehaviourFilterImpl.instanceClassFilters";
    private static final String KEY_INSTANCE_FILTERS = "BehaviourFilterImpl.instanceFilters";
    private static final Log logger = LogFactory.getLog(BehaviourFilterImpl.class);
    private DictionaryService dictionaryService;
    private TenantService tenantService;

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    @Override
    @Deprecated
    public void enableBehaviours(NodeRef nodeRef) {
        this.enableBehaviour(nodeRef);
    }

    @Override
    @Deprecated
    public void disableAllBehaviours() {
        this.disableBehaviour();
    }

    @Override
    @Deprecated
    public void enableAllBehaviours() {
        this.enableBehaviour();
    }

    @Override
    public void disableBehaviour() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Behaviour: DISABLE (" + AlfrescoTransactionSupport.getTransactionId() + "): ALL"));
        }
        TransactionalResourceHelper.incrementCount(KEY_FILTER_COUNT);
        TransactionalResourceHelper.incrementCount(KEY_GLOBAL_FILTERS);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("   Now: " + TransactionalResourceHelper.getCount(KEY_GLOBAL_FILTERS)));
        }
    }

    @Override
    public void disableBehaviour(QName className) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Behaviour: DISABLE (" + AlfrescoTransactionSupport.getTransactionId() + "): " + className));
        }
        ParameterCheck.mandatory((String)"className", (Object)className);
        TransactionalResourceHelper.incrementCount(KEY_FILTER_COUNT);
        Map<QName, MutableInt> classFilters = TransactionalResourceHelper.getMap(KEY_CLASS_FILTERS);
        MutableInt filter = (MutableInt)classFilters.get(className);
        if (filter == null) {
            filter = new MutableInt(1);
            classFilters.put(className, filter);
        } else {
            filter.increment();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("   Now: " + filter));
        }
    }

    @Override
    public void disableBehaviour(NodeRef nodeRef, QName className) {
        MutableInt filter;
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        ParameterCheck.mandatory((String)"className", (Object)className);
        nodeRef = this.tenantService.getName(nodeRef);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Behaviour: DISABLE (" + AlfrescoTransactionSupport.getTransactionId() + "): " + nodeRef + "/" + className));
        }
        nodeRef = this.tenantService.getName(nodeRef);
        TransactionalResourceHelper.incrementCount(KEY_FILTER_COUNT);
        Map instanceClassFilters = TransactionalResourceHelper.getMap(KEY_INSTANCE_CLASS_FILTERS);
        HashMap<QName, MutableInt> classFilters = (HashMap<QName, MutableInt>)instanceClassFilters.get(nodeRef);
        if (classFilters == null) {
            classFilters = new HashMap<QName, MutableInt>(3);
            instanceClassFilters.put(nodeRef, classFilters);
        }
        if ((filter = (MutableInt)classFilters.get(className)) == null) {
            filter = new MutableInt(0);
            classFilters.put(className, filter);
        }
        filter.increment();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("   Now: " + filter));
        }
    }

    @Override
    public void disableBehaviour(NodeRef nodeRef) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Behaviour: DISABLE (" + AlfrescoTransactionSupport.getTransactionId() + "): " + nodeRef + "/ALL:"));
        }
        nodeRef = this.tenantService.getName(nodeRef);
        TransactionalResourceHelper.incrementCount(KEY_FILTER_COUNT);
        Map<NodeRef, MutableInt> instanceFilters = TransactionalResourceHelper.getMap(KEY_INSTANCE_FILTERS);
        MutableInt filter = (MutableInt)instanceFilters.get(nodeRef);
        if (filter == null) {
            filter = new MutableInt(0);
            instanceFilters.put(nodeRef, filter);
        }
        filter.increment();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("   Now:" + filter));
        }
    }

    @Override
    public void enableBehaviour() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Behaviour: ENABLE (" + AlfrescoTransactionSupport.getTransactionId() + "): ALL"));
        }
        TransactionalResourceHelper.decrementCount(KEY_FILTER_COUNT, false);
        TransactionalResourceHelper.decrementCount(KEY_GLOBAL_FILTERS, false);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("   Now: " + TransactionalResourceHelper.getCount(KEY_GLOBAL_FILTERS)));
        }
    }

    @Override
    public void enableBehaviour(QName className) {
        ParameterCheck.mandatory((String)"className", (Object)className);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Behaviour: ENABLE (" + AlfrescoTransactionSupport.getTransactionId() + "): " + className));
        }
        TransactionalResourceHelper.decrementCount(KEY_FILTER_COUNT, false);
        if (!TransactionalResourceHelper.isResourcePresent(KEY_CLASS_FILTERS)) {
            return;
        }
        Map classFilters = TransactionalResourceHelper.getMap(KEY_CLASS_FILTERS);
        MutableInt filter = (MutableInt)classFilters.get(className);
        if (filter == null) {
            return;
        }
        if (filter.intValue() > 0) {
            filter.decrement();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("   Now: " + filter));
        }
    }

    @Override
    public void enableBehaviour(NodeRef nodeRef, QName className) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        ParameterCheck.mandatory((String)"className", (Object)className);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Behaviour: ENABLE (" + AlfrescoTransactionSupport.getTransactionId() + "): " + nodeRef + "/" + className));
        }
        TransactionalResourceHelper.decrementCount(KEY_FILTER_COUNT, false);
        if (!TransactionalResourceHelper.isResourcePresent(KEY_INSTANCE_CLASS_FILTERS)) {
            return;
        }
        nodeRef = this.tenantService.getName(nodeRef);
        Map instanceClassFilters = TransactionalResourceHelper.getMap(KEY_INSTANCE_CLASS_FILTERS);
        Map classFilters = (Map)instanceClassFilters.get(nodeRef);
        if (classFilters == null) {
            return;
        }
        MutableInt filter = (MutableInt)classFilters.get(className);
        if (filter == null) {
            return;
        }
        if (filter.intValue() > 0) {
            filter.decrement();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("   Now: " + filter));
        }
    }

    @Override
    public void enableBehaviour(NodeRef nodeRef) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Behaviour: ENABLE (" + AlfrescoTransactionSupport.getTransactionId() + "): " + nodeRef + "/ALL"));
        }
        TransactionalResourceHelper.decrementCount(KEY_FILTER_COUNT, false);
        if (!TransactionalResourceHelper.isResourcePresent(KEY_INSTANCE_FILTERS)) {
            return;
        }
        nodeRef = this.tenantService.getName(nodeRef);
        Map instanceFilters = TransactionalResourceHelper.getMap(KEY_INSTANCE_FILTERS);
        MutableInt filter = (MutableInt)instanceFilters.get(nodeRef);
        if (filter == null) {
            return;
        }
        if (filter.intValue() > 0) {
            filter.decrement();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("   Now:" + filter));
        }
    }

    @Override
    public boolean isEnabled() {
        return TransactionalResourceHelper.getCount(KEY_GLOBAL_FILTERS) <= 0;
    }

    @Override
    public boolean isEnabled(QName className) {
        ParameterCheck.mandatory((String)"className", (Object)className);
        if (!this.isEnabled()) {
            return false;
        }
        if (!TransactionalResourceHelper.isResourcePresent(KEY_CLASS_FILTERS)) {
            return true;
        }
        Map classFilters = TransactionalResourceHelper.getMap(KEY_CLASS_FILTERS);
        MutableInt classFilter = (MutableInt)classFilters.get(className);
        return classFilter == null || classFilter.intValue() <= 0;
    }

    @Override
    public boolean isEnabled(NodeRef nodeRef, QName className) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        ParameterCheck.mandatory((String)"className", (Object)className);
        if (!this.isEnabled(className) || !this.isEnabled(nodeRef)) {
            return false;
        }
        if (!TransactionalResourceHelper.isResourcePresent(KEY_INSTANCE_CLASS_FILTERS)) {
            return true;
        }
        nodeRef = this.tenantService.getName(nodeRef);
        Map instanceClassFilters = TransactionalResourceHelper.getMap(KEY_INSTANCE_CLASS_FILTERS);
        Map classFilters = (Map)instanceClassFilters.get(nodeRef);
        if (classFilters == null) {
            return true;
        }
        for (QName classCheck : classFilters.keySet()) {
            MutableInt filter;
            if (!this.dictionaryService.isSubClass(className, classCheck) || (filter = (MutableInt)classFilters.get(className)) == null || filter.intValue() <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEnabled(NodeRef nodeRef) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        if (!this.isEnabled()) {
            return false;
        }
        if (!TransactionalResourceHelper.isResourcePresent(KEY_INSTANCE_FILTERS)) {
            return true;
        }
        nodeRef = this.tenantService.getName(nodeRef);
        Map instanceFilters = TransactionalResourceHelper.getMap(KEY_INSTANCE_FILTERS);
        MutableInt filter = (MutableInt)instanceFilters.get(nodeRef);
        return filter == null || filter.intValue() <= 0;
    }

    @Override
    public boolean isActivated() {
        return TransactionalResourceHelper.getCount(KEY_FILTER_COUNT) > 0;
    }
}

