/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.policy;

import org.alfresco.repo.policy.BehaviourBinding;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;

class ClassBehaviourBinding
implements BehaviourBinding {
    private DictionaryService dictionary;
    private QName classQName;
    private NodeRef nodeRef;

    ClassBehaviourBinding(DictionaryService dictionary, NodeRef nodeRef, QName classQName) {
        this.dictionary = dictionary;
        this.nodeRef = nodeRef;
        this.classQName = classQName;
    }

    ClassBehaviourBinding(DictionaryService dictionary, QName classQName) {
        this(dictionary, null, classQName);
    }

    DictionaryService getDictionary() {
        return this.dictionary;
    }

    @Override
    public BehaviourBinding generaliseBinding() {
        ClassBehaviourBinding generalisedBinding = null;
        ClassDefinition classDefinition = this.dictionary.getClass(this.classQName);
        if (classDefinition == null) {
            return null;
        }
        QName parentClassName = classDefinition.getParentName();
        if (parentClassName != null) {
            generalisedBinding = new ClassBehaviourBinding(this.dictionary, parentClassName);
        }
        return generalisedBinding;
    }

    public NodeRef getNodeRef() {
        return this.nodeRef;
    }

    public QName getClassQName() {
        return this.classQName;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ClassBehaviourBinding)) {
            return false;
        }
        return this.classQName.equals((Object)((ClassBehaviourBinding)obj).classQName);
    }

    public int hashCode() {
        return this.classQName.hashCode();
    }

    public String toString() {
        return "ClassBinding[class=" + this.classQName + "]";
    }
}

