/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.publishing;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.node.NodeUtils;
import org.alfresco.repo.publishing.AbstractChannelType;
import org.alfresco.repo.publishing.ChannelHelper;
import org.alfresco.repo.publishing.PublishingEventHelper;
import org.alfresco.repo.publishing.PublishingModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.publishing.NodeSnapshot;
import org.alfresco.service.cmr.publishing.PublishingEvent;
import org.alfresco.service.cmr.publishing.PublishingPackageEntry;
import org.alfresco.service.cmr.publishing.channels.Channel;
import org.alfresco.service.cmr.publishing.channels.ChannelType;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.GUID;
import org.alfresco.util.ParameterCheck;

public class ChannelImpl
implements Channel {
    private static final String PERMISSIONS_ERR_ACCESS_DENIED = "permissions.err_access_denied";
    private final NodeRef nodeRef;
    private final AbstractChannelType channelType;
    private final String name;
    private final ChannelHelper channelHelper;
    private final NodeService nodeService;
    private final DictionaryService dictionaryService;
    private final PublishingEventHelper eventHelper;

    public ChannelImpl(ServiceRegistry serviceRegistry, AbstractChannelType channelType, NodeRef nodeRef, String name, ChannelHelper channelHelper, PublishingEventHelper eventHelper) {
        this.nodeRef = nodeRef;
        this.channelType = channelType;
        this.name = name;
        this.channelHelper = channelHelper;
        this.nodeService = serviceRegistry.getNodeService();
        this.dictionaryService = serviceRegistry.getDictionaryService();
        this.eventHelper = eventHelper;
    }

    @Override
    public String getId() {
        return this.nodeRef.toString();
    }

    @Override
    public ChannelType getChannelType() {
        return this.channelType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public NodeRef getNodeRef() {
        return this.nodeRef;
    }

    @Override
    public Map<QName, Serializable> getProperties() {
        return this.channelHelper.getChannelProperties(this.nodeRef);
    }

    public void publishEvent(PublishingEvent event) {
        NodeRef eventNode = this.eventHelper.getPublishingEventNode(event.getId());
        for (PublishingPackageEntry entry : event.getPackage().getEntries()) {
            if (entry.isPublish()) {
                this.publishEntry(entry, eventNode);
                continue;
            }
            this.unpublishEntry(entry);
        }
    }

    public void unpublishEntry(final PublishingPackageEntry entry) {
        final NodeRef channelNode = this.getNodeRef();
        if (this.channelHelper.hasPublishPermissions(channelNode)) {
            AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

                public NodeRef doWork() throws Exception {
                    NodeRef unpublishedNode = ChannelImpl.this.channelHelper.mapSourceToEnvironment(entry.getNodeRef(), channelNode);
                    if (NodeUtils.exists(unpublishedNode, ChannelImpl.this.nodeService)) {
                        ChannelImpl.this.unpublish(unpublishedNode);
                        ChannelImpl.this.nodeService.addAspect(unpublishedNode, ContentModel.ASPECT_TEMPORARY, null);
                        ChannelImpl.this.nodeService.deleteNode(unpublishedNode);
                    }
                    return unpublishedNode;
                }
            });
        }
    }

    public NodeRef publishEntry(final PublishingPackageEntry entry, final NodeRef eventNode) {
        if (!this.channelHelper.hasPublishPermissions(this.getNodeRef())) {
            throw new AccessDeniedException(PERMISSIONS_ERR_ACCESS_DENIED);
        }
        NodeRef publishedNode = (NodeRef)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                NodeRef publishedNode = ChannelImpl.this.channelHelper.mapSourceToEnvironment(entry.getNodeRef(), ChannelImpl.this.getNodeRef());
                if (publishedNode == null) {
                    publishedNode = ChannelImpl.this.publishNewNode(ChannelImpl.this.getNodeRef(), entry.getSnapshot());
                } else {
                    ChannelImpl.this.updatePublishedNode(publishedNode, entry);
                }
                ChannelImpl.this.eventHelper.linkToLastEvent(publishedNode, eventNode);
                ChannelImpl.this.publish(publishedNode);
                return publishedNode;
            }
        });
        return publishedNode;
    }

    private NodeRef publishNewNode(NodeRef channel, NodeSnapshot snapshot) {
        ParameterCheck.mandatory((String)"channel", (Object)channel);
        ParameterCheck.mandatory((String)"snapshot", (Object)snapshot);
        NodeRef publishedNode = this.createPublishedNode(channel, snapshot);
        this.addAspects(publishedNode, snapshot.getAspects());
        NodeRef source = snapshot.getNodeRef();
        this.channelHelper.createMapping(source, publishedNode);
        return publishedNode;
    }

    private void updatePublishedNode(NodeRef publishedNode, PublishingPackageEntry entry) {
        NodeSnapshot snapshot = entry.getSnapshot();
        Set<QName> newAspects = snapshot.getAspects();
        this.removeUnwantedAspects(publishedNode, newAspects);
        Map<QName, Serializable> snapshotProps = snapshot.getProperties();
        this.removeUnwantedProperties(publishedNode, snapshotProps);
        HashMap<QName, Serializable> newProps = new HashMap<QName, Serializable>(snapshotProps);
        newProps.remove(ContentModel.PROP_NODE_UUID);
        this.nodeService.setProperties(publishedNode, snapshotProps);
        this.addAspects(publishedNode, newAspects);
        List assocs = this.nodeService.getChildAssocs(publishedNode, (QNamePattern)PublishingModel.ASSOC_LAST_PUBLISHING_EVENT, RegexQNamePattern.MATCH_ALL);
        for (ChildAssociationRef assoc : assocs) {
            this.nodeService.removeChildAssociation(assoc);
        }
    }

    private void removeUnwantedProperties(NodeRef publishedNode, Map<QName, Serializable> snapshotProps) {
        Map publishProps = this.nodeService.getProperties(publishedNode);
        HashSet propsToRemove = new HashSet(publishProps.keySet());
        propsToRemove.removeAll(snapshotProps.keySet());
        snapshotProps.put(PublishingModel.PROP_ASSET_ID, this.nodeService.getProperty(publishedNode, PublishingModel.PROP_ASSET_ID));
        snapshotProps.put(PublishingModel.PROP_ASSET_URL, this.nodeService.getProperty(publishedNode, PublishingModel.PROP_ASSET_URL));
        for (QName propertyToRemove : propsToRemove) {
            this.nodeService.removeProperty(publishedNode, propertyToRemove);
        }
    }

    private void removeUnwantedAspects(NodeRef publishedNode, Set<QName> newAspects) {
        Set aspectsToRemove = this.nodeService.getAspects(publishedNode);
        aspectsToRemove.removeAll(newAspects);
        aspectsToRemove.remove(PublishingModel.ASPECT_PUBLISHED);
        aspectsToRemove.remove(PublishingModel.ASPECT_ASSET);
        for (QName publishedAssetAspect : this.dictionaryService.getSubAspects(PublishingModel.ASPECT_ASSET, true)) {
            aspectsToRemove.remove(publishedAssetAspect);
        }
        for (QName aspectToRemove : aspectsToRemove) {
            this.nodeService.removeAspect(publishedNode, aspectToRemove);
        }
    }

    private void addAspects(NodeRef publishedNode, Collection<QName> aspects) {
        Set currentAspects = this.nodeService.getAspects(publishedNode);
        for (QName aspect : aspects) {
            if (currentAspects.contains(aspect)) continue;
            this.nodeService.addAspect(publishedNode, aspect, null);
        }
    }

    private NodeRef createPublishedNode(NodeRef root, NodeSnapshot snapshot) {
        QName type = snapshot.getType();
        Map<QName, Serializable> actualProps = this.getPropertiesToPublish(snapshot);
        String name = (String)((Object)actualProps.get(ContentModel.PROP_NAME));
        if (name == null) {
            name = GUID.generate();
        }
        QName assocName = QName.createQName((String)"http://www.alfresco.org/model/publishing/1.0", (String)name);
        ChildAssociationRef publishedAssoc = this.nodeService.createNode(root, PublishingModel.ASSOC_PUBLISHED_NODES, assocName, type, actualProps);
        NodeRef publishedNode = publishedAssoc.getChildRef();
        return publishedNode;
    }

    private Map<QName, Serializable> getPropertiesToPublish(NodeSnapshot snapshot) {
        Map<QName, Serializable> properties = snapshot.getProperties();
        HashMap<QName, Serializable> actualProps = new HashMap<QName, Serializable>(properties);
        actualProps.remove(ContentModel.PROP_NODE_UUID);
        return actualProps;
    }

    private void publish(NodeRef nodeToPublish) {
        if (this.channelHelper.canPublish(nodeToPublish, this.channelType)) {
            this.channelHelper.addPublishedAspect(nodeToPublish, this.nodeRef);
            this.channelType.publish(nodeToPublish, this.getProperties());
        }
    }

    private void unpublish(NodeRef nodeToUnpublish) {
        if (this.channelType.canUnpublish()) {
            this.channelType.unpublish(nodeToUnpublish, this.getProperties());
        }
    }

    @Override
    public void sendStatusUpdate(String status, String nodeUrl) {
        if (this.channelType.canPublishStatusUpdates()) {
            int urlLength = nodeUrl == null ? 0 : nodeUrl.length();
            int maxLength = this.channelType.getMaximumStatusLength() - urlLength;
            if (maxLength > 0) {
                int endpoint = Math.min(maxLength, status.length());
                status = status.substring(0, endpoint);
            }
            String msg = nodeUrl == null ? status : status + nodeUrl;
            this.channelType.sendStatusUpdate(this, msg);
        }
    }

    @Override
    public String getUrl(NodeRef publishedNode) {
        NodeRef mappedNode = this.channelHelper.mapSourceToEnvironment(publishedNode, this.nodeRef);
        return this.channelType.getNodeUrl(mappedNode);
    }

    @Override
    public boolean isAuthorised() {
        return this.channelHelper.isChannelAuthorised(this.nodeRef);
    }

    @Override
    public boolean canPublish() {
        return this.channelType.canPublish() && this.isAuthorised() && this.channelHelper.hasPublishPermissions(this.nodeRef);
    }

    @Override
    public boolean canUnpublish() {
        return this.channelType.canPublish() && this.isAuthorised() && this.channelHelper.hasPublishPermissions(this.nodeRef);
    }

    @Override
    public boolean canPublishStatusUpdates() {
        return this.channelType.canPublish() && this.isAuthorised() && this.channelHelper.hasPublishPermissions(this.nodeRef);
    }
}

