/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.publishing;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.node.NodeUtils;
import org.alfresco.repo.publishing.ChannelHelper;
import org.alfresco.repo.publishing.NodeSnapshotSerializer;
import org.alfresco.repo.publishing.NodeSnapshotTransferImpl;
import org.alfresco.repo.publishing.PublishingDetailsImpl;
import org.alfresco.repo.publishing.PublishingEventImpl;
import org.alfresco.repo.publishing.PublishingModel;
import org.alfresco.repo.publishing.PublishingPackageEntryImpl;
import org.alfresco.repo.publishing.PublishingPackageImpl;
import org.alfresco.repo.publishing.StatusUpdateImpl;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.transfer.manifest.TransferManifestNodeFactory;
import org.alfresco.repo.transfer.manifest.TransferManifestNormalNode;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.cmr.publishing.NodeSnapshot;
import org.alfresco.service.cmr.publishing.PublishingDetails;
import org.alfresco.service.cmr.publishing.PublishingEvent;
import org.alfresco.service.cmr.publishing.PublishingEventFilter;
import org.alfresco.service.cmr.publishing.PublishingPackage;
import org.alfresco.service.cmr.publishing.PublishingPackageEntry;
import org.alfresco.service.cmr.publishing.Status;
import org.alfresco.service.cmr.publishing.StatusUpdate;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.transfer.TransferDefinition;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.GUID;
import org.alfresco.util.collections.CollectionUtils;
import org.alfresco.util.collections.Filter;
import org.alfresco.util.collections.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PublishingEventHelper {
    private static final Log log = LogFactory.getLog(PublishingEventHelper.class);
    public static final String WORKFLOW_DEFINITION_NAME = "publishWebContent";
    private NodeService nodeService;
    private ContentService contentService;
    private VersionService versionService;
    private WorkflowService workflowService;
    private NodeSnapshotSerializer serializer;
    private PermissionService permissionService;
    private TransferManifestNodeFactory transferManifestNodeFactory;
    private List<QName> excludedAspects = new ArrayList<QName>();
    private String workflowEngineId;
    private TransferDefinition excludedAspectsTransferDefinition;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setTransferManifestNodeFactory(TransferManifestNodeFactory transferManifestNodeFactory) {
        this.transferManifestNodeFactory = transferManifestNodeFactory;
    }

    public void setVersionService(VersionService versionService) {
        this.versionService = versionService;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    public void setWorkflowEngineId(String workflowEngineId) {
        this.workflowEngineId = workflowEngineId;
    }

    public void setSerializer(NodeSnapshotSerializer serializer) {
        this.serializer = serializer;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public PublishingEvent getPublishingEvent(NodeRef eventNode) throws AlfrescoRuntimeException {
        if (eventNode == null) {
            return null;
        }
        Map props = this.nodeService.getProperties(eventNode);
        String statusStr = (String)props.get(PublishingModel.PROP_PUBLISHING_EVENT_STATUS);
        Status status = Status.valueOf(statusStr);
        String channel = (String)props.get(PublishingModel.PROP_PUBLISHING_EVENT_CHANNEL);
        Date createdTime = (Date)props.get(ContentModel.PROP_CREATED);
        String creator = (String)props.get(ContentModel.PROP_CREATOR);
        Date modifiedTime = (Date)props.get(ContentModel.PROP_MODIFIED);
        String modifier = (String)props.get(ContentModel.PROP_MODIFIER);
        String comment = (String)props.get(PublishingModel.PROP_PUBLISHING_EVENT_COMMENT);
        Calendar scheduledTime = this.getScheduledTime(props);
        PublishingPackage publishingPackage = this.getPublishingPackage(eventNode, channel);
        StatusUpdate statusUpdate = this.buildStatusUpdate(props);
        return new PublishingEventImpl(eventNode.toString(), status, channel, publishingPackage, createdTime, creator, modifiedTime, modifier, scheduledTime, comment, statusUpdate);
    }

    private StatusUpdate buildStatusUpdate(Map<QName, Serializable> props) {
        String message = (String)((Object)props.get(PublishingModel.PROP_STATUS_UPDATE_MESSAGE));
        Collection channelNames = (Collection)((Object)props.get(PublishingModel.PROP_STATUS_UPDATE_CHANNEL_NAMES));
        if (channelNames == null || channelNames.isEmpty()) {
            return null;
        }
        String nodeId = (String)((Object)props.get(PublishingModel.PROP_STATUS_UPDATE_NODE_REF));
        NodeRef nodeToLinkTo = nodeId == null ? null : new NodeRef(nodeId);
        return new StatusUpdateImpl(message, nodeToLinkTo, channelNames);
    }

    public List<PublishingEvent> getPublishingEvents(List<NodeRef> eventNodes) {
        return CollectionUtils.transform(eventNodes, (Function)new Function<NodeRef, PublishingEvent>(){

            public PublishingEvent apply(NodeRef eventNode) {
                return PublishingEventHelper.this.getPublishingEvent(eventNode);
            }
        });
    }

    public NodeRef createNode(NodeRef queueNode, PublishingDetails details) throws Exception {
        this.checkChannelAccess(details.getPublishChannelId());
        Set<String> statusChannelIds = details.getStatusUpdateChannels();
        if (!CollectionUtils.isEmpty(statusChannelIds)) {
            for (String statusChannelId : statusChannelIds) {
                this.checkChannelAccess(statusChannelId);
            }
        }
        String name = GUID.generate();
        Map<QName, Serializable> props = this.buildPublishingEventProperties(details, name);
        ChildAssociationRef newAssoc = this.nodeService.createNode(queueNode, PublishingModel.ASSOC_PUBLISHING_EVENT, QName.createQName((String)"http://www.alfresco.org/model/publishing/1.0", (String)name), PublishingModel.TYPE_PUBLISHING_EVENT, props);
        NodeRef eventNode = newAssoc.getChildRef();
        this.serializePublishNodes(eventNode, details);
        return eventNode;
    }

    private void checkChannelAccess(String channelId) {
        NodeRef channelNode = new NodeRef(channelId);
        AccessStatus accessStatus = this.permissionService.hasPermission(channelNode, "AddChildren");
        if (AccessStatus.ALLOWED != accessStatus) {
            throw new AccessDeniedException("You do not have access to channel: " + channelId);
        }
    }

    private Map<QName, Serializable> buildPublishingEventProperties(PublishingDetails details, String name) {
        Calendar schedule = details.getSchedule();
        if (schedule == null) {
            schedule = Calendar.getInstance();
        }
        HashMap<QName, Serializable> props = new HashMap<QName, Serializable>();
        props.put(ContentModel.PROP_NAME, (Serializable)((Object)name));
        props.put(PublishingModel.PROP_PUBLISHING_EVENT_STATUS, (Serializable)((Object)Status.IN_PROGRESS.name()));
        props.put(PublishingModel.PROP_PUBLISHING_EVENT_TIME, schedule.getTime());
        props.put(PublishingModel.PROP_PUBLISHING_EVENT_TIME_ZONE, (Serializable)((Object)schedule.getTimeZone().getID()));
        props.put(PublishingModel.PROP_PUBLISHING_EVENT_CHANNEL, (Serializable)((Object)details.getPublishChannelId()));
        props.put(PublishingModel.PROP_PUBLISHING_EVENT_STATUS, (Serializable)((Object)"SCHEDULED"));
        String comment = details.getComment();
        if (comment != null) {
            props.put(PublishingModel.PROP_PUBLISHING_EVENT_COMMENT, (Serializable)((Object)comment));
        }
        List<String> publshStrings = this.mapNodesToStrings(details.getNodesToPublish());
        props.put(PublishingModel.PROP_PUBLISHING_EVENT_NODES_TO_PUBLISH, (Serializable)((Object)publshStrings));
        List<String> unpublshStrings = this.mapNodesToStrings(details.getNodesToUnpublish());
        props.put(PublishingModel.PROP_PUBLISHING_EVENT_NODES_TO_UNPUBLISH, (Serializable)((Object)unpublshStrings));
        String message = details.getStatusMessage();
        Set<String> statusChannels = details.getStatusUpdateChannels();
        if (message != null && !CollectionUtils.isEmpty(statusChannels)) {
            props.put(PublishingModel.PROP_STATUS_UPDATE_MESSAGE, (Serializable)((Object)message));
            NodeRef statusNode = details.getNodeToLinkTo();
            if (statusNode != null) {
                props.put(PublishingModel.PROP_STATUS_UPDATE_NODE_REF, (Serializable)((Object)statusNode.toString()));
            }
            props.put(PublishingModel.PROP_STATUS_UPDATE_CHANNEL_NAMES, (Serializable)((Object)statusChannels));
        }
        return props;
    }

    private List<String> mapNodesToStrings(Collection<NodeRef> nodes) {
        return CollectionUtils.toListOfStrings(nodes);
    }

    public List<NodeRef> findPublishingEventNodes(NodeRef queue, PublishingEventFilter filter) {
        Set<NodeRef> publishedNodes = filter.getPublishedNodes();
        List<NodeRef> eventNodes = !CollectionUtils.isEmpty(publishedNodes) ? this.getEventNodesForPublishedNodes(queue, publishedNodes) : this.getAllPublishingEventNodes(queue);
        Set<String> ids = filter.getIds();
        if (!CollectionUtils.isEmpty(ids)) {
            eventNodes = this.filterEventNodesById(eventNodes, ids);
        }
        return eventNodes;
    }

    private List<NodeRef> filterEventNodesById(Collection<NodeRef> eventNodes, final Collection<String> ids) {
        return CollectionUtils.filter(eventNodes, (Function)new Filter<NodeRef>(){

            public Boolean apply(NodeRef node) {
                return ids.contains(node.toString());
            }
        });
    }

    private List<NodeRef> getAllPublishingEventNodes(NodeRef queue) {
        List assocs = this.nodeService.getChildAssocs(queue, (QNamePattern)PublishingModel.ASSOC_PUBLISHING_EVENT, RegexQNamePattern.MATCH_ALL);
        return CollectionUtils.transform((Collection)assocs, NodeUtils.toChildRef());
    }

    public List<NodeRef> getEventNodesForPublishedNodes(NodeRef queue, NodeRef ... publishedNodes) {
        return this.getEventNodesForPublishedNodes(queue, Arrays.asList(publishedNodes));
    }

    public List<NodeRef> getEventNodesForPublishedNodes(NodeRef queue, Collection<NodeRef> publishedNodes) {
        return this.getEventNodesForNodeProperty(queue, PublishingModel.PROP_PUBLISHING_EVENT_NODES_TO_PUBLISH, publishedNodes);
    }

    public List<NodeRef> getEventNodesForUnpublishedNodes(NodeRef queue, Collection<NodeRef> unpublishedNodes) {
        return this.getEventNodesForNodeProperty(queue, PublishingModel.PROP_PUBLISHING_EVENT_NODES_TO_PUBLISH, unpublishedNodes);
    }

    public List<NodeRef> getEventNodesForPublishedNode(NodeRef queue, NodeRef publishedNode) {
        Function<NodeRef, List<NodeRef>> transformer = this.eventNodeForNodePropertyFinder(queue, PublishingModel.PROP_PUBLISHING_EVENT_NODES_TO_PUBLISH);
        return (List)transformer.apply((Object)publishedNode);
    }

    public List<NodeRef> getEventNodesForUnpublishedNode(NodeRef queue, NodeRef unpublishedNode) {
        Function<NodeRef, List<NodeRef>> transformer = this.eventNodeForNodePropertyFinder(queue, PublishingModel.PROP_PUBLISHING_EVENT_NODES_TO_UNPUBLISH);
        return (List)transformer.apply((Object)unpublishedNode);
    }

    private List<NodeRef> getEventNodesForNodeProperty(NodeRef queue, QName propertyKey, Collection<NodeRef> publishedNodes) {
        Function<NodeRef, List<NodeRef>> transformer = this.eventNodeForNodePropertyFinder(queue, propertyKey);
        return CollectionUtils.transformFlat(publishedNodes, transformer);
    }

    private Function<NodeRef, List<NodeRef>> eventNodeForNodePropertyFinder(final NodeRef queue, final QName propertyKey) {
        return new Function<NodeRef, List<NodeRef>>(){

            public List<NodeRef> apply(NodeRef publishedNode) {
                String nodeString = publishedNode.toString();
                List assocs = PublishingEventHelper.this.nodeService.getChildAssocsByPropertyValue(queue, propertyKey, (Serializable)((Object)nodeString));
                return CollectionUtils.transform((Collection)assocs, NodeUtils.toChildRef());
            }
        };
    }

    public List<PublishingEvent> findPublishingEvents(NodeRef queue, PublishingEventFilter filter) {
        List<NodeRef> eventNodes = this.findPublishingEventNodes(queue, filter);
        return this.getPublishingEvents(eventNodes);
    }

    public PublishingEvent getPublishingEvent(String id) {
        NodeRef eventNode = this.getPublishingEventNode(id);
        return this.getPublishingEvent(eventNode);
    }

    public NodeRef getPublishingEventNode(String id) {
        NodeRef eventNode;
        if (id != null && NodeRef.isNodeRef((String)id) && this.nodeService.exists(eventNode = new NodeRef(id)) && PublishingModel.TYPE_PUBLISHING_EVENT.equals((Object)this.nodeService.getType(eventNode))) {
            return eventNode;
        }
        return null;
    }

    public String startPublishingWorkflow(NodeRef eventNode, Calendar scheduledTime) {
        HashMap<QName, Serializable> parameters = new HashMap<QName, Serializable>();
        parameters.put(PublishingModel.PROP_WF_PUBLISHING_EVENT, (Serializable)eventNode);
        parameters.put(WorkflowModel.ASSOC_PACKAGE, (Serializable)this.workflowService.createPackage(null));
        parameters.put(PublishingModel.PROP_WF_SCHEDULED_PUBLISH_DATE, scheduledTime);
        WorkflowPath path = this.workflowService.startWorkflow(this.getPublshingWorkflowDefinitionId(), parameters);
        String instanceId = path.getInstance().getId();
        this.nodeService.setProperty(eventNode, PublishingModel.PROP_PUBLISHING_EVENT_WORKFLOW_ID, (Serializable)((Object)instanceId));
        WorkflowTask startTask = this.workflowService.getStartTask(instanceId);
        this.workflowService.endTask(startTask.getId(), null);
        return instanceId;
    }

    private String getPublshingWorkflowDefinitionId() {
        String definitionName = this.workflowEngineId + "$" + WORKFLOW_DEFINITION_NAME;
        WorkflowDefinition definition = this.workflowService.getDefinitionByName(definitionName);
        if (definition == null) {
            String msg = "The Web publishing workflow definition does not exist! Definition name: " + definitionName;
            throw new AlfrescoRuntimeException(msg);
        }
        return definition.getId();
    }

    public Calendar getScheduledTime(NodeRef eventNode) {
        if (eventNode == null) {
            return null;
        }
        return this.getScheduledTime(this.nodeService.getProperties(eventNode));
    }

    public Calendar getScheduledTime(Map<QName, Serializable> eventProperties) {
        Date time = (Date)eventProperties.get(PublishingModel.PROP_PUBLISHING_EVENT_TIME);
        String timezone = (String)((Object)eventProperties.get(PublishingModel.PROP_PUBLISHING_EVENT_TIME_ZONE));
        Calendar scheduledTime = Calendar.getInstance();
        scheduledTime.setTime(time);
        scheduledTime.setTimeZone(TimeZone.getTimeZone(timezone));
        return scheduledTime;
    }

    private void serializePublishNodes(NodeRef eventNode, PublishingDetails details) throws Exception {
        try {
            NodeRef channelNode = new NodeRef(details.getPublishChannelId());
            List<NodeSnapshot> snapshots = this.createPublishSnapshots(details.getNodesToPublish());
            snapshots.addAll(this.createUnpublishSnapshots(details.getNodesToUnpublish(), channelNode));
            ContentWriter contentWriter = this.contentService.getWriter(eventNode, PublishingModel.PROP_PUBLISHING_EVENT_PAYLOAD, true);
            contentWriter.setEncoding("UTF-8");
            OutputStream os = contentWriter.getContentOutputStream();
            this.serializer.serialize(snapshots, os);
            os.flush();
            os.close();
        }
        catch (Exception ex) {
            log.warn((Object)"Failed to serialize publishing package", (Throwable)ex);
            throw ex;
        }
    }

    private List<NodeSnapshot> createUnpublishSnapshots(Set<NodeRef> nodes, final NodeRef channelNode) {
        return CollectionUtils.transform(nodes, (Function)new Function<NodeRef, NodeSnapshot>(){

            public NodeSnapshot apply(NodeRef node) {
                return PublishingEventHelper.this.createUnpublishSnapshot(node, channelNode);
            }
        });
    }

    private PublishingPackage getPublishingPackage(NodeRef eventNode, String channelId) throws AlfrescoRuntimeException {
        Map<NodeRef, PublishingPackageEntry> entries = this.getPublishingPackageEntries(eventNode);
        return new PublishingPackageImpl(entries);
    }

    private List<NodeSnapshot> createPublishSnapshots(final Collection<NodeRef> nodes) {
        return (List)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<List<NodeSnapshot>>(){

            public List<NodeSnapshot> doWork() throws Exception {
                return CollectionUtils.transform((Collection)nodes, (Function)new Function<NodeRef, NodeSnapshot>(){

                    public NodeSnapshot apply(NodeRef node) {
                        return PublishingEventHelper.this.createPublishSnapshot(node);
                    }
                });
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    private NodeSnapshotTransferImpl createPublishSnapshot(NodeRef node) {
        this.versionService.createVersion(node, null);
        TransferManifestNormalNode payload = (TransferManifestNormalNode)this.transferManifestNodeFactory.createTransferManifestNode(node, this.excludedAspectsTransferDefinition);
        NodeSnapshotTransferImpl snapshot = new NodeSnapshotTransferImpl(payload);
        return snapshot;
    }

    private Map<NodeRef, PublishingPackageEntry> getPublishingPackageEntries(NodeRef eventNode) {
        List idsToUnpublish = (List)((Object)this.nodeService.getProperty(eventNode, PublishingModel.PROP_PUBLISHING_EVENT_NODES_TO_UNPUBLISH));
        List<NodeRef> nodesToUnpublish = NodeUtils.toNodeRefs(idsToUnpublish);
        ContentReader contentReader = this.contentService.getReader(eventNode, PublishingModel.PROP_PUBLISHING_EVENT_PAYLOAD);
        InputStream input = contentReader.getContentInputStream();
        try {
            List<NodeSnapshot> snapshots = this.serializer.deserialize(input);
            HashMap<NodeRef, PublishingPackageEntry> entries = new HashMap<NodeRef, PublishingPackageEntry>(snapshots.size());
            for (NodeSnapshot snapshot : snapshots) {
                NodeRef node = snapshot.getNodeRef();
                boolean isPublish = false == nodesToUnpublish.contains(node);
                PublishingPackageEntryImpl entry = new PublishingPackageEntryImpl(isPublish, node, snapshot);
                entries.put(node, entry);
            }
            return entries;
        }
        catch (Exception ex) {
            String msg = "Failed to deserialize publishing package for PublishingEvent: " + eventNode;
            throw new AlfrescoRuntimeException(msg, (Throwable)ex);
        }
    }

    private NodeSnapshot createUnpublishSnapshot(NodeRef source, NodeRef channelNode) {
        NodeRef lastEvent = this.getLastPublishEvent(source, channelNode);
        if (lastEvent == null) {
            String msg = "Cannot create unpublish snapshot as last publishing event does not exist! Source node: " + source + " channelId: " + channelNode;
            throw new AlfrescoRuntimeException(msg);
        }
        Map<NodeRef, PublishingPackageEntry> entries = this.getPublishingPackageEntries(lastEvent);
        PublishingPackageEntry entry = entries.get(source);
        return entry.getSnapshot();
    }

    public NodeRef getLastPublishEvent(NodeRef source, NodeRef channelNode) {
        NodeRef publishedNode = ChannelHelper.mapSourceToEnvironment(source, channelNode, this.nodeService);
        if (publishedNode == null) {
            return null;
        }
        List assocs = this.nodeService.getTargetAssocs(publishedNode, (QNamePattern)PublishingModel.ASSOC_LAST_PUBLISHING_EVENT);
        return NodeUtils.getSingleAssocNode(assocs, true);
    }

    public void cancelEvent(String id) {
        NodeRef eventNode = this.getPublishingEventNode(id);
        if (eventNode != null) {
            Map eventProps = this.nodeService.getProperties(eventNode);
            String status = (String)eventProps.get(PublishingModel.PROP_PUBLISHING_EVENT_STATUS);
            if ("SCHEDULED".equals(status)) {
                String processId = (String)eventProps.get(PublishingModel.PROP_PUBLISHING_EVENT_WORKFLOW_ID);
                if (processId != null) {
                    this.workflowService.cancelWorkflow(processId);
                }
                this.nodeService.deleteNode(eventNode);
            } else if ("IN_PROGRESS".equals(status)) {
                this.nodeService.setProperty(eventNode, PublishingModel.PROP_PUBLISHING_EVENT_STATUS, (Serializable)((Object)"CANCEL_REQUESTED"));
            }
        }
    }

    public AssociationRef linkToLastEvent(NodeRef publishedNode, NodeRef eventNode) {
        List assocs = this.nodeService.getTargetAssocs(publishedNode, (QNamePattern)PublishingModel.ASSOC_LAST_PUBLISHING_EVENT);
        if (!CollectionUtils.isEmpty((Collection)assocs)) {
            AssociationRef assoc = (AssociationRef)assocs.get(0);
            this.nodeService.removeAssociation(assoc.getSourceRef(), assoc.getTargetRef(), assoc.getTypeQName());
        }
        return this.nodeService.createAssociation(publishedNode, eventNode, PublishingModel.ASSOC_LAST_PUBLISHING_EVENT);
    }

    public PublishingDetails createPublishingDetails() {
        return new PublishingDetailsImpl();
    }

    public void setExcludedAspects(Collection<String> excludedAspects) {
        this.excludedAspects.clear();
        for (String aspect : excludedAspects) {
            this.excludedAspects.add(QName.createQName((String)aspect));
        }
        this.excludedAspectsTransferDefinition = new TransferDefinition();
        this.excludedAspectsTransferDefinition.setExcludedAspects(this.excludedAspects);
    }
}

