/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.publishing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.publishing.AbstractPublishingIntegrationTest;
import org.alfresco.repo.publishing.NodeSnapshotTransferImpl;
import org.alfresco.repo.publishing.StandardNodeSnapshotSerializer;
import org.alfresco.repo.transfer.manifest.TransferManifestNormalNode;
import org.alfresco.service.cmr.publishing.NodeSnapshot;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.junit.Before;
import org.junit.Test;

public class PublishingPackageSerializerTest
extends AbstractPublishingIntegrationTest {
    @Resource(name="publishingPackageSerializer")
    private StandardNodeSnapshotSerializer serializer;
    private TransferManifestNormalNode normalNode1;

    @Override
    @Before
    public void onSetUp() throws Exception {
        super.onSetUp();
        this.serializer = (StandardNodeSnapshotSerializer)this.getApplicationContext().getBean("publishingPackageSerializer");
        this.normalNode1 = new TransferManifestNormalNode();
        this.normalNode1.setAccessControl(null);
        HashSet<QName> aspects = new HashSet<QName>();
        aspects.add(ContentModel.ASPECT_AUDITABLE);
        aspects.add(ContentModel.ASPECT_TITLED);
        this.normalNode1.setAspects(aspects);
        ArrayList<ChildAssociationRef> childAssocs = new ArrayList<ChildAssociationRef>();
        this.normalNode1.setChildAssocs(childAssocs);
        String guid = GUID.generate();
        NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, guid);
        this.normalNode1.setNodeRef(nodeRef);
        ChildAssociationRef primaryParentAssoc = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "MY_PARENT_NODEREF"), QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"localname"), nodeRef, true, -1);
        ArrayList<ChildAssociationRef> parentAssocs = new ArrayList<ChildAssociationRef>();
        parentAssocs.add(primaryParentAssoc);
        this.normalNode1.setParentAssocs(parentAssocs);
        Path path = new Path();
        path.append((Path.Element)new Path.ChildAssocElement(primaryParentAssoc));
        this.normalNode1.setParentPath(path);
        this.normalNode1.setPrimaryParentAssoc(primaryParentAssoc);
        HashMap<QName, Serializable> props = new HashMap<QName, Serializable>();
        props.put(ContentModel.PROP_NAME, (Serializable)((Object)guid));
        this.normalNode1.setProperties(props);
        ArrayList<AssociationRef> sourceAssocs = new ArrayList<AssociationRef>();
        sourceAssocs.add(new AssociationRef(nodeRef, ContentModel.ASSOC_ATTACHMENTS, nodeRef));
        sourceAssocs.add(new AssociationRef(nodeRef, ContentModel.ASSOC_REFERENCES, nodeRef));
        this.normalNode1.setSourceAssocs(sourceAssocs);
        ArrayList<AssociationRef> targetAssocs = new ArrayList<AssociationRef>();
        targetAssocs.add(new AssociationRef(nodeRef, ContentModel.ASSOC_ATTACHMENTS, nodeRef));
        targetAssocs.add(new AssociationRef(nodeRef, ContentModel.ASSOC_REFERENCES, nodeRef));
        this.normalNode1.setTargetAssocs(targetAssocs);
        this.normalNode1.setType(ContentModel.TYPE_CONTENT);
        this.normalNode1.setAncestorType(ContentModel.TYPE_CONTENT);
        this.normalNode1.setUuid(guid);
    }

    @Test
    public void testSerializer() throws Exception {
        NodeSnapshotTransferImpl transferSnapshot = new NodeSnapshotTransferImpl(this.normalNode1);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.serializer.serialize(Collections.singleton(transferSnapshot), os);
        os.close();
        byte[] output = os.toByteArray();
        ByteArrayInputStream is = new ByteArrayInputStream(output);
        List<NodeSnapshot> snapshots = this.serializer.deserialize(is);
        PublishingPackageSerializerTest.assertEquals((int)1, (int)snapshots.size());
        NodeSnapshot snapshot = snapshots.get(0);
        PublishingPackageSerializerTest.assertEquals((Object)this.normalNode1.getNodeRef(), (Object)snapshot.getNodeRef());
        PublishingPackageSerializerTest.assertEquals((Object)this.normalNode1.getType(), (Object)snapshot.getType());
        PublishingPackageSerializerTest.assertEquals(this.normalNode1.getAspects(), snapshot.getAspects());
        PublishingPackageSerializerTest.assertEquals(this.normalNode1.getProperties(), snapshot.getProperties());
    }
}

