/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition;

import freemarker.ext.dom.NodeModel;
import freemarker.template.SimpleDate;
import freemarker.template.SimpleHash;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.rendition.RenditionLocation;
import org.alfresco.repo.rendition.RenditionLocationImpl;
import org.alfresco.repo.rendition.RenditionLocationResolver;
import org.alfresco.repo.rendition.executer.AbstractRenderingEngine;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.template.TemplateNode;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileFolderUtil;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.rendition.RenditionDefinition;
import org.alfresco.service.cmr.rendition.RenditionServiceException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.TemplateException;
import org.alfresco.util.FreeMarkerUtil;
import org.alfresco.util.XMLUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class StandardRenditionLocationResolverImpl
implements RenditionLocationResolver {
    private static final Log log = LogFactory.getLog(StandardRenditionLocationResolverImpl.class);
    private ServiceRegistry serviceRegistry;
    private Repository repositoryHelper;
    private String companyHomePath = "/app:company_home";

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setCompanyHomePath(String companyHomePath) {
        this.companyHomePath = companyHomePath;
    }

    public void setRepositoryHelper(Repository repositoryHelper) {
        this.repositoryHelper = repositoryHelper;
    }

    @Override
    public RenditionLocation getRenditionLocation(NodeRef sourceNode, RenditionDefinition definition, NodeRef tempRenditionLocation) {
        NodeRef companyHome;
        String path;
        NodeRef destination = AbstractRenderingEngine.getCheckedParam("rendition-destination-node", NodeRef.class, definition);
        if (destination != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No need to calculate rendition location, using rendition-destination-node=" + destination));
            }
            RenditionLocationImpl location = this.createNodeLocation(destination);
            return location;
        }
        String pathTemplate = (String)((Object)definition.getParameterValue("destination-path-template"));
        if (pathTemplate != null && (path = this.renderPathTemplate(pathTemplate, sourceNode, tempRenditionLocation, companyHome = this.getCompanyHomeNode(sourceNode.getStoreRef()))) != null) {
            return this.findOrCreateTemplatedPath(sourceNode, path, companyHome);
        }
        return new RenditionLocationImpl(sourceNode, null, null);
    }

    private RenditionLocationImpl createNodeLocation(NodeRef destination) {
        NodeService nodeService = this.serviceRegistry.getNodeService();
        if (!nodeService.exists(destination)) {
            throw new RenditionServiceException("The rendition destination node does not exist! NodeRef: " + destination);
        }
        NodeRef parentRef = nodeService.getPrimaryParent(destination).getParentRef();
        String destinationCmName = (String)((Object)nodeService.getProperty(destination, ContentModel.PROP_NAME));
        RenditionLocationImpl location = new RenditionLocationImpl(parentRef, destination, destinationCmName);
        return location;
    }

    private RenditionLocationImpl findOrCreateTemplatedPath(NodeRef sourceNode, String path, NodeRef companyHome) {
        String fileName;
        if (log.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("FindOrCreateTemplatedPath for ").append(sourceNode).append(", ").append(path);
            log.debug((Object)msg.toString());
        }
        NodeService nodeService = this.serviceRegistry.getNodeService();
        List<String> pathElements = Arrays.asList(path.split("/"));
        LinkedList<String> folderElements = new LinkedList<String>(pathElements);
        folderElements.removeAll(Arrays.asList(""));
        Serializable companyHomeName = nodeService.getProperty(companyHome, ContentModel.PROP_NAME);
        if (folderElements.getFirst().equals(companyHomeName)) {
            folderElements.removeFirst();
        }
        if ((fileName = folderElements.removeLast()) == null || fileName.length() == 0) {
            StringBuilder msg = new StringBuilder();
            msg.append("The path must include a valid filename! Path: ").append(path);
            if (log.isDebugEnabled()) {
                log.debug((Object)msg.toString());
            }
            throw new RenditionServiceException(msg.toString());
        }
        FileFolderService fileFolderService = this.serviceRegistry.getFileFolderService();
        NodeRef parent = companyHome;
        if (!folderElements.isEmpty()) {
            FileInfo parentInfo = FileFolderUtil.makeFolders(fileFolderService, companyHome, folderElements, ContentModel.TYPE_FOLDER);
            parent = parentInfo.getNodeRef();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("folderElements: " + folderElements));
            log.debug((Object)("parent: " + parent));
            log.debug((Object)("   " + nodeService.getType(parent) + " " + nodeService.getPath(parent)));
            log.debug((Object)("fileName: " + fileName));
        }
        NodeRef child = fileFolderService.searchSimple(parent, fileName);
        if (log.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("RenditionLocation parent=").append(parent).append(", child=").append(child).append(", fileName=").append(fileName);
            log.debug((Object)msg.toString());
            if (child != null) {
                log.debug((Object)("child path = " + nodeService.getPath(child)));
            }
        }
        return new RenditionLocationImpl(parent, child, fileName);
    }

    private String renderPathTemplate(String pathTemplate, NodeRef sourceNode, NodeRef tempRenditionLocation, NodeRef companyHome) {
        String cwd;
        String fullSourceName;
        NodeService nodeService = this.serviceRegistry.getNodeService();
        FileFolderService fileFolderService = this.serviceRegistry.getFileFolderService();
        HashMap<String, Object> root = new HashMap<String, Object>();
        try {
            List<FileInfo> sourcePathInfo = fileFolderService.getNamePath(companyHome, sourceNode);
            FileInfo sourceFileInfo = sourcePathInfo.remove(sourcePathInfo.size() - 1);
            fullSourceName = sourceFileInfo.getName();
            StringBuilder cwdBuilder = new StringBuilder("/");
            for (FileInfo file : sourcePathInfo) {
                cwdBuilder.append(file.getName());
                cwdBuilder.append('/');
            }
            cwd = cwdBuilder.toString();
        }
        catch (FileNotFoundException e) {
            log.warn((Object)("Failed to resolve path to source node: " + sourceNode + ". Default to Company Home"));
            fullSourceName = nodeService.getPrimaryParent(sourceNode).getQName().getLocalName();
            cwd = "/";
        }
        String trimmedSourceName = fullSourceName;
        String sourceExtension = "";
        int extensionIndex = fullSourceName.lastIndexOf(46);
        if (extensionIndex != -1) {
            trimmedSourceName = extensionIndex == 0 ? "" : fullSourceName.substring(0, extensionIndex);
            sourceExtension = extensionIndex == fullSourceName.length() - 1 ? "" : fullSourceName.substring(extensionIndex + 1);
        }
        root.put("name", trimmedSourceName);
        root.put("extension", sourceExtension);
        root.put("date", new SimpleDate(new Date(), 3));
        root.put("cwd", cwd);
        TemplateNode companyHomeNode = new TemplateNode(companyHome, this.serviceRegistry, null);
        root.put("companyHome", companyHomeNode);
        root.put("companyhome", companyHomeNode);
        root.put("sourceNode", new TemplateNode(sourceNode, this.serviceRegistry, null));
        root.put("sourceContentType", nodeService.getType(sourceNode).getLocalName());
        root.put("renditionContentType", nodeService.getType(tempRenditionLocation).getLocalName());
        NodeRef person = this.serviceRegistry.getPersonService().getPerson(AuthenticationUtil.getFullyAuthenticatedUser());
        root.put("person", new TemplateNode(person, this.serviceRegistry, null));
        if (this.sourceNodeIsXml(sourceNode)) {
            try {
                Document xml = XMLUtil.parse(sourceNode, this.serviceRegistry.getContentService());
                pathTemplate = FreeMarkerUtil.buildNamespaceDeclaration(xml) + pathTemplate;
                root.put("xml", NodeModel.wrap((Node)xml));
            }
            catch (Exception ex) {
                log.warn((Object)("Failed to parse XML content into path template model: Node = " + sourceNode));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Path template model: " + root));
        }
        String result = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Processing " + pathTemplate + " using source node " + cwd + fullSourceName));
            }
            result = this.serviceRegistry.getTemplateService().processTemplateString("freemarker", pathTemplate, new SimpleHash(root));
        }
        catch (TemplateException te) {
            log.error((Object)("Error while trying to process rendition path template: " + pathTemplate));
            log.error((Object)te.getMessage(), (Throwable)((Object)te));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("processed pattern " + pathTemplate + " as " + result));
        }
        return result;
    }

    private NodeRef getCompanyHomeNode(StoreRef store) {
        return this.repositoryHelper.getCompanyHome();
    }

    protected boolean sourceNodeIsXml(NodeRef sourceNode) {
        boolean result = false;
        ContentReader reader = this.serviceRegistry.getContentService().getReader(sourceNode, ContentModel.PROP_CONTENT);
        if (reader != null && reader.exists()) {
            result = reader.getContentData().getMimetype().equals("text/xml");
        }
        return result;
    }
}

