/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition.executer;

import com.sun.star.lang.NullPointerException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.model.RenditionModel;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.repo.content.MimetypeMap;
import org.alfresco.repo.nodelocator.NodeLocator;
import org.alfresco.repo.nodelocator.SelfNodeLocator;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.rendition.RenderingEngineDefinitionImpl;
import org.alfresco.repo.rendition.RenditionDefinitionImpl;
import org.alfresco.repo.rendition.RenditionLocation;
import org.alfresco.repo.rendition.RenditionLocationResolver;
import org.alfresco.repo.rendition.RenditionNodeManager;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionDefinition;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.rendition.RenderCallback;
import org.alfresco.service.cmr.rendition.RenditionDefinition;
import org.alfresco.service.cmr.rendition.RenditionService;
import org.alfresco.service.cmr.rendition.RenditionServiceException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.NamespaceException;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public abstract class AbstractRenderingEngine
extends ActionExecuterAbstractBase {
    private static Log logger = LogFactory.getLog(AbstractRenderingEngine.class);
    protected static final String CONTENT_READER_NOT_FOUND_MESSAGE = "Cannot find Content Reader for document. Operation can't be performed";
    private static final String DEFAULT_RUN_AS_NAME = AuthenticationUtil.getSystemUserName();
    private static final QName DEFAULT_DEFAULT_RENDITION_NODE_TYPE = ContentModel.TYPE_CONTENT;
    private static final QName DEFAULT_DEFAULT_RENDITION_CONTENT_PROP = ContentModel.PROP_CONTENT;
    private static final String DEFAULT_MIMETYPE = "text/plain";
    private static final String DEFAULT_ENCODING = "UTF-8";
    private QName defaultRenditionNodeType = DEFAULT_DEFAULT_RENDITION_NODE_TYPE;
    private QName defaultRenditionContentProp = DEFAULT_DEFAULT_RENDITION_CONTENT_PROP;
    private static final QName DEFAULT_CONTENT_PROPERTY = ContentModel.TYPE_CONTENT;
    protected ContentService contentService;
    protected MimetypeMap mimetypeMap;
    public static final String PARAM_PLACEHOLDER_RESOURCE_PATH = "placeHolderResourcePath";
    public static final String PARAM_SOURCE_CONTENT_PROPERTY = "sourceContentProperty";
    public static final String PARAM_TARGET_CONTENT_PROPERTY = "targetContentProperty";
    public static final String PARAM_UPDATE_RENDITIONS_ON_ANY_PROPERTY_CHANGE = "update-renditions-on-any-property-change";
    public static final String PARAM_RUN_AS = "runAs";
    public static final String PARAM_MIME_TYPE = "mime-type";
    public static final String PARAM_ENCODING = "encoding";
    private static final NodeLocator defaultNodeLocator = new SelfNodeLocator();
    private RenditionLocationResolver renditionLocationResolver;
    protected NodeService nodeService;
    private RenditionService renditionService;
    private BehaviourFilter behaviourFilter;
    private final NodeLocator temporaryParentNodeLocator;
    private final QName temporaryRenditionLinkType;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setRenditionService(RenditionService renditionService) {
        this.renditionService = renditionService;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void setRenditionLocationResolver(RenditionLocationResolver renditionLocationResolver) {
        this.renditionLocationResolver = renditionLocationResolver;
    }

    public AbstractRenderingEngine(NodeLocator temporaryParentNodeLocator, QName temporaryRenditionLinkType) {
        this.publicAction = false;
        this.temporaryParentNodeLocator = temporaryParentNodeLocator != null ? temporaryParentNodeLocator : defaultNodeLocator;
        this.temporaryRenditionLinkType = temporaryRenditionLinkType != null ? temporaryRenditionLinkType : RenditionModel.ASSOC_RENDITION;
    }

    public AbstractRenderingEngine() {
        this(null, null);
    }

    public void setDefaultRenditionNodeType(String type) {
        QName qname;
        try {
            qname = QName.createQName((String)type);
        }
        catch (NamespaceException nx) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)"Error when setting default rendition node type: ", (Throwable)nx);
            }
            throw nx;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Using default rendition node type: " + qname));
        }
        this.defaultRenditionNodeType = qname;
    }

    protected QName getDefaultRenditionNodeType() {
        return this.defaultRenditionNodeType;
    }

    protected String getTargetMimeType(RenderingContext context) {
        return context.getParamWithDefault(PARAM_MIME_TYPE, DEFAULT_MIMETYPE);
    }

    protected String getTargetEncoding(RenderingContext context) {
        return context.getParamWithDefault(PARAM_ENCODING, DEFAULT_ENCODING);
    }

    public void setDefaultRenditionContentProp(String prop) {
        QName qname;
        try {
            qname = QName.createQName((String)prop);
        }
        catch (NamespaceException nx) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)"Error when setting default rendition content property: ", (Throwable)nx);
            }
            throw nx;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Using default rendition content property: " + qname));
        }
        this.defaultRenditionContentProp = qname;
    }

    protected QName getDefaultRenditionContentProp() {
        return this.defaultRenditionContentProp;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setMimetypeMap(MimetypeMap mimetypeMap) {
        this.mimetypeMap = mimetypeMap;
    }

    @Override
    protected ActionDefinition createActionDefinition(String definitionName) {
        return new RenderingEngineDefinitionImpl(definitionName);
    }

    @Override
    protected void executeImpl(Action action, NodeRef sourceNode) {
        this.executeImpl((RenditionDefinition)action, sourceNode);
    }

    protected void executeImpl(final RenditionDefinition renditionDef, final NodeRef sourceNode) {
        if (this.nodeService.exists(sourceNode)) {
            Serializable runAsParam;
            if (logger.isDebugEnabled()) {
                StringBuilder msg = new StringBuilder();
                msg.append("Rendering node ").append(sourceNode).append(" with rendition definition ").append(renditionDef.getRenditionName());
                msg.append("\n").append("  parameters:").append("\n");
                if (!renditionDef.getParameterValues().isEmpty()) {
                    for (String paramKey : renditionDef.getParameterValues().keySet()) {
                        msg.append("    ").append(paramKey).append("=").append(renditionDef.getParameterValue(paramKey)).append("\n");
                    }
                } else {
                    msg.append("    [None]");
                }
                logger.debug((Object)msg.toString());
            }
            String runAsName = (runAsParam = renditionDef.getParameterValue(PARAM_RUN_AS)) == null ? DEFAULT_RUN_AS_NAME : (String)((Object)runAsParam);
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() throws Exception {
                    ChildAssociationRef result = null;
                    try {
                        boolean isComponentRendition = AbstractRenderingEngine.this.isComponentRendition(renditionDef);
                        if (!isComponentRendition) {
                            AbstractRenderingEngine.this.setTemporaryRenditionProperties(sourceNode, renditionDef);
                        }
                        AbstractRenderingEngine.this.executeRenditionImpl(renditionDef, sourceNode);
                        if (!isComponentRendition) {
                            AbstractRenderingEngine.this.tagSourceNodeAsRenditioned(renditionDef, sourceNode);
                            AbstractRenderingEngine.this.switchToFinalRenditionNode(renditionDef, sourceNode);
                        }
                        result = (ChildAssociationRef)renditionDef.getParameterValue("result");
                    }
                    catch (Throwable t) {
                        AbstractRenderingEngine.this.notifyCallbackOfException(renditionDef, t);
                        AbstractRenderingEngine.this.throwWrappedException(t);
                    }
                    if (result != null) {
                        AbstractRenderingEngine.this.notifyCallbackOfResult(renditionDef, result);
                    }
                    return null;
                }
            }, (String)runAsName);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Rendition has not been created, because the node no longer exitst.  (sourceNode=" + sourceNode + ")"));
        }
    }

    private boolean isComponentRendition(Action action) {
        Serializable s = action.getParameterValue("is-component-rendition");
        boolean result = s == null ? false : (Boolean)s;
        return result;
    }

    protected void executeRenditionImpl(Action action, NodeRef sourceNode) {
        if (logger.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Executing rendering engine; name:").append(this.name).append(", class:").append(this.getClass().getName());
            logger.debug((Object)msg.toString());
        }
        this.checkParameterValues(action);
        RenditionDefinition renditionDefinition = this.checkActionIsRenditionDefinition(action);
        this.checkSourceNodeExists(sourceNode);
        QName targetContentProp = this.getRenditionContentProperty(renditionDefinition);
        RenderingContext context = new RenderingContext(sourceNode, renditionDefinition, targetContentProp);
        this.render(context);
        action.getParameterValues().put("result", (Serializable)context.getChildAssociationRef());
    }

    protected void checkParameterValues(Action action) {
    }

    protected QName getRenditionContentProperty(RenditionDefinition renditionDefinition) {
        return AbstractRenderingEngine.getParamWithDefault(PARAM_TARGET_CONTENT_PROPERTY, this.defaultRenditionContentProp, renditionDefinition);
    }

    protected abstract void render(RenderingContext var1);

    protected void checkSourceNodeExists(NodeRef actionedUponNodeRef) {
        if (!this.nodeService.exists(actionedUponNodeRef)) {
            String msg = "Cannot execute action as node does not exist: " + actionedUponNodeRef;
            logger.warn((Object)msg);
            throw new RenditionServiceException(msg);
        }
    }

    protected RenditionDefinition checkActionIsRenditionDefinition(Action action) {
        if (action instanceof RenditionDefinition) {
            return (RenditionDefinition)action;
        }
        return new RenditionDefinitionImpl(action);
    }

    private QName getRenditionNodeType(RenditionDefinition renditionDefinition) {
        return AbstractRenderingEngine.getParamWithDefault("rendition-nodetype", this.defaultRenditionNodeType, renditionDefinition);
    }

    @Override
    protected final void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.addAll(this.getParameterDefinitions());
    }

    @Override
    protected String getParamDisplayLabel(String paramName) {
        String commonPropertiesPrefix = "baseRenderingAction";
        String message = I18NUtil.getMessage((String)("baseRenderingAction." + paramName + "." + "display-label"));
        if (message == null) {
            message = super.getParamDisplayLabel(paramName);
        }
        return message;
    }

    protected Collection<ParameterDefinition> getParameterDefinitions() {
        ArrayList<ParameterDefinition> paramList = new ArrayList<ParameterDefinition>();
        paramList.add(new ParameterDefinitionImpl("renderingActionName", DataTypeDefinition.QNAME, true, this.getParamDisplayLabel("renderingActionName")));
        paramList.add(new ParameterDefinitionImpl(PARAM_RUN_AS, DataTypeDefinition.TEXT, false, this.getParamDisplayLabel(PARAM_RUN_AS)));
        paramList.add(new ParameterDefinitionImpl(PARAM_UPDATE_RENDITIONS_ON_ANY_PROPERTY_CHANGE, DataTypeDefinition.BOOLEAN, false, this.getParamDisplayLabel(PARAM_UPDATE_RENDITIONS_ON_ANY_PROPERTY_CHANGE)));
        paramList.add(new ParameterDefinitionImpl("rendition-nodetype", DataTypeDefinition.QNAME, false, this.getParamDisplayLabel("rendition-nodetype")));
        paramList.add(new ParameterDefinitionImpl(PARAM_PLACEHOLDER_RESOURCE_PATH, DataTypeDefinition.TEXT, false, this.getParamDisplayLabel(PARAM_PLACEHOLDER_RESOURCE_PATH)));
        paramList.add(new ParameterDefinitionImpl(PARAM_SOURCE_CONTENT_PROPERTY, DataTypeDefinition.QNAME, false, this.getParamDisplayLabel(PARAM_SOURCE_CONTENT_PROPERTY)));
        paramList.add(new ParameterDefinitionImpl(PARAM_TARGET_CONTENT_PROPERTY, DataTypeDefinition.QNAME, false, this.getParamDisplayLabel(PARAM_TARGET_CONTENT_PROPERTY)));
        paramList.add(new ParameterDefinitionImpl("destination-path-template", DataTypeDefinition.TEXT, false, this.getParamDisplayLabel("destination-path-template")));
        paramList.add(new ParameterDefinitionImpl("orphan-existing-rendition", DataTypeDefinition.BOOLEAN, false, this.getParamDisplayLabel("orphan-existing-rendition")));
        paramList.add(new ParameterDefinitionImpl("result", DataTypeDefinition.CHILD_ASSOC_REF, false, this.getParamDisplayLabel("result")));
        paramList.add(new ParameterDefinitionImpl("is-component-rendition", DataTypeDefinition.BOOLEAN, false, this.getParamDisplayLabel("is-component-rendition")));
        return paramList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChildAssociationRef createRenditionNodeAssoc(NodeRef sourceNode, RenditionDefinition renditionDefinition) {
        QName renditionName = renditionDefinition.getRenditionName();
        HashMap<QName, Object> nodeProps = new HashMap<QName, Object>();
        nodeProps.put(ContentModel.PROP_NAME, renditionName.getLocalName());
        nodeProps.put(ContentModel.PROP_CONTENT_PROPERTY_NAME, this.getRenditionContentProp(renditionDefinition));
        QName assocName = QName.createQName((String)"http://www.alfresco.org/model/rendition/1.0", (String)GUID.generate());
        NodeRef parentNode = renditionDefinition.getRenditionParent();
        QName assocType = renditionDefinition.getRenditionAssociationType();
        QName nodeType = this.getRenditionNodeType(renditionDefinition);
        this.behaviourFilter.disableBehaviour(parentNode, ContentModel.ASPECT_AUDITABLE);
        ChildAssociationRef childAssoc = null;
        try {
            childAssoc = this.nodeService.createNode(parentNode, assocType, assocName, nodeType, nodeProps);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Created node " + childAssoc + " as child of " + parentNode + " with assoc-type " + assocType));
            }
        }
        finally {
            this.behaviourFilter.enableBehaviour(parentNode, ContentModel.ASPECT_AUDITABLE);
        }
        return childAssoc;
    }

    private Serializable getRenditionContentProp(RenditionDefinition renditionDefinition) {
        return (Serializable)AbstractRenderingEngine.getParamWithDefault(PARAM_TARGET_CONTENT_PROPERTY, this.getDefaultRenditionContentProp(), renditionDefinition);
    }

    public static <T> T getCheckedParam(String paramName, Class<T> clazz, RenditionDefinition definition) {
        Serializable value = definition.getParameterValue(paramName);
        if (value == null) {
            return null;
        }
        if (clazz == null) {
            throw new RenditionServiceException("The class must not be null!", (Throwable)new NullPointerException());
        }
        Class<T> valueClass = value.getClass();
        if (!valueClass.isAssignableFrom(clazz)) {
            throw new RenditionServiceException("The parameter: " + paramName + " must be of type: " + clazz.getName() + "but was of type: " + valueClass.getName());
        }
        return (T)value;
    }

    public static <T> T getParamWithDefault(String paramName, T defaultValue, RenditionDefinition definition) {
        if (defaultValue == null) {
            throw new RenditionServiceException("The defaultValue cannot be null!", (Throwable)new NullPointerException());
        }
        Class<?> clazz = defaultValue.getClass();
        Object result = AbstractRenderingEngine.getCheckedParam(paramName, clazz, definition);
        if (result == null) {
            result = defaultValue;
        }
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tagSourceNodeAsRenditioned(RenditionDefinition renditionDef, NodeRef actionedUponNodeRef) {
        if (!this.nodeService.hasAspect(actionedUponNodeRef, RenditionModel.ASPECT_RENDITIONED)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Applying " + RenditionModel.ASPECT_RENDITIONED + " to " + actionedUponNodeRef));
            }
            this.behaviourFilter.disableBehaviour(actionedUponNodeRef, ContentModel.ASPECT_AUDITABLE);
            try {
                this.nodeService.addAspect(actionedUponNodeRef, RenditionModel.ASPECT_RENDITIONED, null);
            }
            finally {
                this.behaviourFilter.enableBehaviour(actionedUponNodeRef, ContentModel.ASPECT_AUDITABLE);
            }
        }
    }

    protected void switchToFinalRenditionNode(RenditionDefinition renditionDef, NodeRef actionedUponNodeRef) {
        ChildAssociationRef tempRendAssoc = (ChildAssociationRef)renditionDef.getParameterValue("result");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Switching temporary rendition: " + tempRendAssoc));
        }
        ChildAssociationRef result = this.createOrUpdateRendition(actionedUponNodeRef, tempRendAssoc, renditionDef);
        renditionDef.setParameterValue("result", (Serializable)result);
    }

    protected void notifyCallbackOfException(RenditionDefinition renditionDefinition, Throwable t) {
        RenderCallback callback;
        if (renditionDefinition != null && (callback = renditionDefinition.getCallback()) != null) {
            callback.handleFailedRendition(t);
        }
    }

    protected void throwWrappedException(Throwable t) {
        if (t instanceof AlfrescoRuntimeException) {
            throw (AlfrescoRuntimeException)t;
        }
        throw new RenditionServiceException(t.getMessage(), t);
    }

    protected void notifyCallbackOfResult(RenditionDefinition renditionDefinition, ChildAssociationRef result) {
        RenderCallback callback;
        if (renditionDefinition != null && (callback = renditionDefinition.getCallback()) != null) {
            callback.handleSuccessfulRendition(result);
        }
    }

    private void setTemporaryRenditionProperties(NodeRef sourceNode, RenditionDefinition definition) {
        NodeRef parent = this.temporaryParentNodeLocator.getNode(sourceNode, definition.getParameterValues());
        definition.setRenditionParent(parent);
        definition.setRenditionAssociationType(this.temporaryRenditionLinkType);
        if (logger.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Temporary rendition will have parent=").append(parent).append(" and assoc-type=").append(this.temporaryRenditionLinkType);
            logger.debug((Object)msg.toString());
        }
    }

    private ChildAssociationRef createOrUpdateRendition(NodeRef sourceNode, ChildAssociationRef tempRendition, RenditionDefinition renditionDefinition) {
        NodeRef tempRenditionNode = tempRendition.getChildRef();
        RenditionLocation renditionLocation = this.resolveRenditionLocation(sourceNode, renditionDefinition, tempRenditionNode);
        QName renditionQName = renditionDefinition.getRenditionName();
        RenditionNodeManager renditionNodeManager = new RenditionNodeManager(sourceNode, tempRenditionNode, renditionLocation, renditionDefinition, this.nodeService, this.renditionService, this.behaviourFilter);
        ChildAssociationRef renditionNode = renditionNodeManager.findOrCreateRenditionNode();
        String renditionName = this.getRenditionName(tempRenditionNode, renditionLocation, renditionDefinition);
        this.nodeService.setProperty(renditionNode.getChildRef(), ContentModel.PROP_NAME, (Serializable)((Object)renditionName));
        this.nodeService.removeChildAssociation(tempRendition);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Removed temporary child-association " + tempRendition));
        }
        this.manageRenditionAspects(sourceNode, renditionNode);
        ChildAssociationRef renditionAssoc = this.renditionService.getRenditionByName(sourceNode, renditionQName);
        if (renditionAssoc == null) {
            String msg = "A rendition of name: " + renditionQName + " should have been created for source node: " + sourceNode;
            throw new RenditionServiceException(msg);
        }
        return renditionAssoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void manageRenditionAspects(NodeRef sourceNode, ChildAssociationRef renditionParentAssoc) {
        NodeRef renditionNode = renditionParentAssoc.getChildRef();
        NodeRef primaryParent = renditionParentAssoc.getParentRef();
        if (primaryParent.equals((Object)sourceNode)) {
            this.behaviourFilter.disableBehaviour(renditionNode, ContentModel.ASPECT_AUDITABLE);
            try {
                this.nodeService.addAspect(renditionNode, RenditionModel.ASPECT_HIDDEN_RENDITION, null);
                this.nodeService.removeAspect(renditionNode, RenditionModel.ASPECT_VISIBLE_RENDITION);
            }
            finally {
                this.behaviourFilter.enableBehaviour(renditionNode, ContentModel.ASPECT_AUDITABLE);
            }
        }
        this.behaviourFilter.disableBehaviour(renditionNode, ContentModel.ASPECT_AUDITABLE);
        try {
            this.nodeService.addAspect(renditionNode, RenditionModel.ASPECT_VISIBLE_RENDITION, null);
            this.nodeService.removeAspect(renditionNode, RenditionModel.ASPECT_HIDDEN_RENDITION);
        }
        finally {
            this.behaviourFilter.enableBehaviour(renditionNode, ContentModel.ASPECT_AUDITABLE);
        }
    }

    private String getRenditionName(NodeRef tempRenditionNode, RenditionLocation location, RenditionDefinition renditionDefinition) {
        String locName = location.getChildName();
        if (locName != null && locName.length() > 0) {
            return locName;
        }
        Serializable tempName = this.nodeService.getProperty(tempRenditionNode, ContentModel.PROP_NAME);
        if (tempName != null) {
            return (String)((Object)tempName);
        }
        return renditionDefinition.getRenditionName().getLocalName();
    }

    protected RenditionLocation resolveRenditionLocation(NodeRef sourceNode, RenditionDefinition definition, NodeRef tempRendition) {
        return this.renditionLocationResolver.getRenditionLocation(sourceNode, definition, tempRendition);
    }

    protected class RenderingContext {
        private final NodeRef sourceNode;
        private final RenditionDefinition definition;
        private final QName renditionContentProperty;
        private ChildAssociationRef caNodeRef;

        public RenderingContext(NodeRef sourceNode, RenditionDefinition definition, QName renditionContentProperty) {
            this.sourceNode = sourceNode;
            this.definition = definition;
            this.renditionContentProperty = renditionContentProperty;
        }

        public NodeRef getSourceNode() {
            return this.sourceNode;
        }

        public synchronized ChildAssociationRef getChildAssociationRef() {
            if (this.caNodeRef == null) {
                this.caNodeRef = AbstractRenderingEngine.this.createRenditionNodeAssoc(this.sourceNode, this.definition);
            }
            return this.caNodeRef;
        }

        public NodeRef getDestinationNode() {
            return this.getChildAssociationRef().getChildRef();
        }

        public RenditionDefinition getDefinition() {
            return this.definition;
        }

        public <T> T getCheckedParam(String paramName, Class<T> clazz) {
            return AbstractRenderingEngine.getCheckedParam(paramName, clazz, this.definition);
        }

        public <T> T getParamWithDefault(String paramName, T defaultValue) {
            return AbstractRenderingEngine.getParamWithDefault(paramName, defaultValue, this.definition);
        }

        public ContentReader makeContentReader() {
            QName srcContentProp = this.getParamWithDefault(AbstractRenderingEngine.PARAM_SOURCE_CONTENT_PROPERTY, DEFAULT_CONTENT_PROPERTY);
            ContentReader contentReader = AbstractRenderingEngine.this.contentService.getReader(this.sourceNode, srcContentProp);
            if (contentReader == null || !contentReader.exists()) {
                throw new RenditionServiceException(AbstractRenderingEngine.CONTENT_READER_NOT_FOUND_MESSAGE);
            }
            return contentReader;
        }

        public ContentWriter makeContentWriter() {
            ContentWriter contentWriter = AbstractRenderingEngine.this.contentService.getWriter(this.getDestinationNode(), this.renditionContentProperty, true);
            String mimetype = AbstractRenderingEngine.this.getTargetMimeType(this);
            contentWriter.setMimetype(mimetype);
            String encoding = AbstractRenderingEngine.this.getTargetEncoding(this);
            contentWriter.setEncoding(encoding);
            return contentWriter;
        }

        public int getIntegerParam(String key, int defaultValue) {
            Serializable serializable = this.definition.getParameterValue(key);
            if (serializable == null) {
                return defaultValue;
            }
            Number number = (Number)serializable;
            return number.intValue();
        }
    }
}

