/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rule;

import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.copy.CopyBehaviourCallback;
import org.alfresco.repo.copy.CopyDetails;
import org.alfresco.repo.copy.CopyServicePolicies;
import org.alfresco.repo.copy.DefaultCopyBehaviourCallback;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.rule.RuleModel;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RulesAspect
implements CopyServicePolicies.OnCopyNodePolicy,
CopyServicePolicies.OnCopyCompletePolicy,
NodeServicePolicies.OnAddAspectPolicy,
NodeServicePolicies.BeforeDeleteChildAssociationPolicy {
    private PolicyComponent policyComponent;
    private BehaviourFilter behaviourFilter;
    private RuleService ruleService;
    private NodeService nodeService;
    private static Log logger = LogFactory.getLog(RulesAspect.class);

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"policyComponent", (Object)this.policyComponent);
        PropertyCheck.mandatory((Object)this, (String)"behaviourFilter", (Object)this.behaviourFilter);
        PropertyCheck.mandatory((Object)this, (String)"ruleService", (Object)this.ruleService);
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        this.policyComponent.bindClassBehaviour(CopyServicePolicies.OnCopyNodePolicy.QNAME, RuleModel.ASPECT_RULES, (Behaviour)new JavaBehaviour(this, "getCopyCallback"));
        this.policyComponent.bindClassBehaviour(CopyServicePolicies.OnCopyCompletePolicy.QNAME, RuleModel.ASPECT_RULES, (Behaviour)new JavaBehaviour(this, "onCopyComplete"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnAddAspectPolicy.QNAME, RuleModel.ASPECT_RULES, (Behaviour)new JavaBehaviour(this, "onAddAspect"));
        this.policyComponent.bindAssociationBehaviour(NodeServicePolicies.BeforeDeleteChildAssociationPolicy.QNAME, RuleModel.ASPECT_RULES, RuleModel.ASSOC_RULE_FOLDER, new JavaBehaviour(this, "beforeDeleteChildAssociation"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAddAspect(NodeRef nodeRef, QName aspectTypeQName) {
        this.ruleService.disableRules(nodeRef);
        try {
            int count = this.nodeService.getChildAssocs(nodeRef, (QNamePattern)RuleModel.ASSOC_RULE_FOLDER, (QNamePattern)RuleModel.ASSOC_RULE_FOLDER).size();
            if (count == 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("rules folder does not exist: create new rules folder for: " + nodeRef));
                }
                this.nodeService.createNode(nodeRef, RuleModel.ASSOC_RULE_FOLDER, RuleModel.ASSOC_RULE_FOLDER, ContentModel.TYPE_SYSTEM_FOLDER);
            }
        }
        finally {
            this.ruleService.enableRules(nodeRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeDeleteChildAssociation(ChildAssociationRef childAssocRef) {
        NodeRef nodeRef = childAssocRef.getParentRef();
        this.ruleService.disableRules(nodeRef);
        try {
            this.nodeService.removeAspect(nodeRef, RuleModel.ASPECT_RULES);
        }
        finally {
            this.ruleService.enableRules(nodeRef);
        }
    }

    @Override
    public CopyBehaviourCallback getCopyCallback(QName classRef, CopyDetails copyDetails) {
        return new RulesAspectCopyBehaviourCallback(this.behaviourFilter);
    }

    @Override
    public void onCopyComplete(QName classRef, NodeRef sourceNodeRef, NodeRef destinationRef, boolean copyToNewNode, Map<NodeRef, NodeRef> copyMap) {
        this.behaviourFilter.enableBehaviour(destinationRef, RuleModel.ASPECT_RULES);
    }

    private class RulesAspectCopyBehaviourCallback
    extends DefaultCopyBehaviourCallback {
        private final BehaviourFilter behaviourFilter;

        private RulesAspectCopyBehaviourCallback(BehaviourFilter behaviourFilter) {
            this.behaviourFilter = behaviourFilter;
        }

        @Override
        public boolean getMustCopy(QName classQName, CopyDetails copyDetails) {
            NodeRef targetNodeRef = copyDetails.getTargetNodeRef();
            this.behaviourFilter.disableBehaviour(targetNodeRef, RuleModel.ASPECT_RULES);
            return true;
        }

        @Override
        public CopyBehaviourCallback.ChildAssocCopyAction getChildAssociationCopyAction(QName classQName, CopyDetails copyDetails, CopyBehaviourCallback.CopyChildAssociationDetails childAssocCopyDetails) {
            ChildAssociationRef childAssocRef = childAssocCopyDetails.getChildAssocRef();
            if (childAssocRef.getTypeQName().equals((Object)RuleModel.ASSOC_RULE_FOLDER)) {
                return CopyBehaviourCallback.ChildAssocCopyAction.COPY_CHILD;
            }
            super.throwExceptionForUnexpectedBehaviour(copyDetails, childAssocCopyDetails.toString());
            return null;
        }

        @Override
        public CopyBehaviourCallback.ChildAssocRecurseAction getChildAssociationRecurseAction(QName classQName, CopyDetails copyDetails, CopyBehaviourCallback.CopyChildAssociationDetails childAssocCopyDetails) {
            ChildAssociationRef childAssocRef = childAssocCopyDetails.getChildAssocRef();
            if (childAssocRef.getTypeQName().equals((Object)RuleModel.ASSOC_RULE_FOLDER)) {
                return CopyBehaviourCallback.ChildAssocRecurseAction.FORCE_RECURSE;
            }
            super.throwExceptionForUnexpectedBehaviour(copyDetails, childAssocCopyDetails.toString());
            return null;
        }
    }
}

