/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import org.alfresco.repo.search.CannedQueryDef;
import org.alfresco.repo.search.MLAnalysisMode;
import org.alfresco.repo.search.QueryRegisterComponent;
import org.alfresco.repo.search.SearcherException;
import org.alfresco.repo.search.impl.NodeSearcher;
import org.alfresco.repo.search.impl.lucene.AbstractLuceneBase;
import org.alfresco.repo.search.impl.lucene.ClosingIndexSearcher;
import org.alfresco.repo.search.impl.lucene.LuceneConfig;
import org.alfresco.repo.search.impl.lucene.LuceneIndexException;
import org.alfresco.repo.search.impl.lucene.LuceneIndexer;
import org.alfresco.repo.search.impl.lucene.LuceneQueryLanguageSPI;
import org.alfresco.repo.search.impl.lucene.LuceneQueryParser;
import org.alfresco.repo.search.impl.lucene.LuceneSearcher;
import org.alfresco.repo.search.impl.lucene.QueryParameterisationException;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.XPathException;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.search.QueryParameter;
import org.alfresco.service.cmr.search.QueryParameterDefinition;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ISO9075;
import org.alfresco.util.Pair;
import org.alfresco.util.SearchLanguageConversion;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;

public class ADMLuceneSearcherImpl
extends AbstractLuceneBase
implements LuceneSearcher {
    static Log s_logger = LogFactory.getLog(ADMLuceneSearcherImpl.class);
    private NamespacePrefixResolver namespacePrefixResolver;
    private NodeService nodeService;
    private TenantService tenantService;
    private QueryRegisterComponent queryRegister;
    private LuceneIndexer indexer;
    private Map<String, LuceneQueryLanguageSPI> queryLanguages;

    public static ADMLuceneSearcherImpl getSearcher(StoreRef storeRef, LuceneIndexer indexer, LuceneConfig config) {
        ADMLuceneSearcherImpl searcher = new ADMLuceneSearcherImpl();
        searcher.setLuceneConfig(config);
        try {
            searcher.initialise(storeRef, indexer == null ? null : indexer.getDeltaId());
            searcher.indexer = indexer;
        }
        catch (LuceneIndexException e) {
            throw new SearcherException((Throwable)((Object)e));
        }
        return searcher;
    }

    public static ADMLuceneSearcherImpl getSearcher(StoreRef storeRef, LuceneConfig config) {
        return ADMLuceneSearcherImpl.getSearcher(storeRef, null, config);
    }

    public static ADMLuceneSearcherImpl getNodeSearcher() {
        return new ADMLuceneSearcherImpl();
    }

    @Override
    public void setNamespacePrefixResolver(NamespacePrefixResolver namespacePrefixResolver) {
        this.namespacePrefixResolver = namespacePrefixResolver;
    }

    public NamespacePrefixResolver getNamespacePrefixResolver() {
        return this.namespacePrefixResolver;
    }

    public NodeService getNodeService() {
        return this.nodeService;
    }

    public TenantService getTenantService() {
        return this.tenantService;
    }

    public QueryRegisterComponent getQueryRegister() {
        return this.queryRegister;
    }

    @Override
    public boolean indexExists() {
        return true;
    }

    @Override
    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setQueryRegister(QueryRegisterComponent queryRegister) {
        this.queryRegister = queryRegister;
    }

    public void setQueryLanguages(Map<String, LuceneQueryLanguageSPI> queryLanguages) {
        this.queryLanguages = queryLanguages;
    }

    public ResultSet query(StoreRef store, String language, String queryString, QueryParameterDefinition[] queryParameterDefinitions) throws SearcherException {
        store = this.tenantService.getName(store);
        SearchParameters sp = new SearchParameters();
        sp.addStore(store);
        sp.setLanguage(language);
        sp.setQuery(queryString);
        if (queryParameterDefinitions != null) {
            for (QueryParameterDefinition qpd : queryParameterDefinitions) {
                sp.addQueryParameterDefinition(qpd);
            }
        }
        sp.excludeDataInTheCurrentTransaction(true);
        return this.query(sp);
    }

    public ResultSet query(SearchParameters searchParameters) {
        String parameterisedQueryString;
        if (searchParameters.getStores().size() != 1) {
            throw new IllegalStateException("Only one store can be searched at present");
        }
        ArrayList stores = searchParameters.getStores();
        stores.set(0, this.tenantService.getName((StoreRef)searchParameters.getStores().get(0)));
        if (searchParameters.getQueryParameterDefinitions().size() > 0) {
            HashMap<QName, QueryParameterDefinition> map = new HashMap<QName, QueryParameterDefinition>();
            for (QueryParameterDefinition qpd : searchParameters.getQueryParameterDefinitions()) {
                map.put(qpd.getQName(), qpd);
            }
            parameterisedQueryString = this.parameterise(searchParameters.getQuery(), map, null, this.namespacePrefixResolver);
        } else {
            parameterisedQueryString = searchParameters.getQuery();
        }
        searchParameters.setQuery(parameterisedQueryString);
        LuceneQueryLanguageSPI language = this.queryLanguages.get(searchParameters.getLanguage().toLowerCase());
        if (language != null) {
            return language.executeQuery(searchParameters, this);
        }
        throw new SearcherException("Unknown query language: " + searchParameters.getLanguage());
    }

    protected String findSortField(SearchParameters searchParameters, ClosingIndexSearcher searcher, String field, Locale sortLocale) {
        MLAnalysisMode analysisMode = this.getLuceneConfig().getDefaultMLSearchAnalysisMode();
        HashSet<String> allowableLocales = new HashSet<String>();
        for (Locale l : MLAnalysisMode.getLocales((MLAnalysisMode)analysisMode, (Locale)sortLocale, (boolean)false)) {
            allowableLocales.add(l.toString());
        }
        String sortField = field;
        for (Object current : searcher.getReader().getFieldNames(IndexReader.FieldOption.INDEXED)) {
            String fieldLocale;
            String currentString = (String)current;
            if (!currentString.startsWith(field) || !currentString.endsWith(".sort") || !allowableLocales.contains(fieldLocale = currentString.substring(field.length() + 1, currentString.length() - 5))) continue;
            if (fieldLocale.equals(sortLocale.toString())) {
                sortField = currentString;
                break;
            }
            if (sortLocale.toString().startsWith(fieldLocale)) {
                if (!sortField.equals(field) && currentString.length() >= sortField.length()) continue;
                sortField = currentString;
                continue;
            }
            if (!fieldLocale.startsWith(sortLocale.toString()) || !sortField.equals(field) && currentString.length() >= sortField.length()) continue;
            sortField = currentString;
        }
        return sortField;
    }

    public ResultSet query(StoreRef store, String language, String query) {
        return this.query(store, language, query, null);
    }

    public ResultSet query(StoreRef store, QName queryId, QueryParameter[] queryParameters) {
        CannedQueryDef definition = this.queryRegister.getQueryDefinition(queryId);
        this.checkParameters(definition, queryParameters);
        String queryString = this.parameterise(definition.getQuery(), definition.getQueryParameterMap(), queryParameters, definition.getNamespacePrefixResolver());
        return this.query(store, definition.getLanguage(), queryString, null);
    }

    private void checkParameters(CannedQueryDef definition, QueryParameter[] queryParameters) throws QueryParameterisationException {
        ArrayList<QName> missing = new ArrayList<QName>();
        HashSet<QName> parameterQNameSet = new HashSet<QName>();
        if (queryParameters != null) {
            for (QueryParameter parameter : queryParameters) {
                parameterQNameSet.add(parameter.getQName());
            }
        }
        for (QueryParameterDefinition parameterDefinition : definition.getQueryParameterDefs()) {
            if (parameterDefinition.hasDefaultValue() || parameterQNameSet.contains(parameterDefinition.getQName())) continue;
            missing.add(parameterDefinition.getQName());
        }
        if (missing.size() > 0) {
            StringBuilder buffer = new StringBuilder(128);
            buffer.append("The query is missing values for the following parameters: ");
            for (QName qName : missing) {
                buffer.append(qName);
                buffer.append(", ");
            }
            buffer.delete(buffer.length() - 1, buffer.length() - 1);
            buffer.delete(buffer.length() - 1, buffer.length() - 1);
            throw new QueryParameterisationException(buffer.toString());
        }
    }

    private String parameterise(String unparameterised, Map<QName, QueryParameterDefinition> map, QueryParameter[] queryParameters, NamespacePrefixResolver nspr) throws QueryParameterisationException {
        HashMap<QName, ArrayList<Serializable>> valueMap = new HashMap<QName, ArrayList<Serializable>>();
        if (queryParameters != null) {
            for (QueryParameter parameter : queryParameters) {
                ArrayList<Serializable> list = (ArrayList<Serializable>)valueMap.get(parameter.getQName());
                if (list == null) {
                    list = new ArrayList<Serializable>();
                    valueMap.put(parameter.getQName(), list);
                }
                list.add(parameter.getValue());
            }
        }
        HashMap iteratorMap = new HashMap();
        ArrayList<QName> missing = new ArrayList<QName>(1);
        StringBuilder buffer = new StringBuilder(unparameterised);
        int index = 0;
        while ((index = buffer.indexOf("${", index)) != -1) {
            int endIndex = buffer.indexOf("}", index);
            String qNameString = buffer.substring(index + 2, endIndex);
            QName key = QName.createQName((String)qNameString, (NamespacePrefixResolver)nspr);
            QueryParameterDefinition parameterDefinition = map.get(key);
            if (parameterDefinition == null) {
                missing.add(key);
                buffer.replace(index, endIndex + 1, "");
                continue;
            }
            ListIterator it = (ListIterator)iteratorMap.get(key);
            if (it == null || !it.hasNext()) {
                List list = (List)valueMap.get(key);
                if (list != null && list.size() > 0) {
                    it = list.listIterator();
                }
                if (it != null) {
                    iteratorMap.put(key, it);
                }
            }
            String value = it == null ? parameterDefinition.getDefault() : (String)DefaultTypeConverter.INSTANCE.convert(String.class, it.next());
            buffer.replace(index, endIndex + 1, value);
        }
        if (missing.size() > 0) {
            StringBuilder error = new StringBuilder();
            error.append("The query uses the following parameters which are not defined: ");
            for (QName qName : missing) {
                error.append(qName);
                error.append(", ");
            }
            error.delete(error.length() - 1, error.length() - 1);
            error.delete(error.length() - 1, error.length() - 1);
            throw new QueryParameterisationException(error.toString());
        }
        return buffer.toString();
    }

    public List<NodeRef> selectNodes(NodeRef contextNodeRef, String xpath, QueryParameterDefinition[] parameters, NamespacePrefixResolver namespacePrefixResolver, boolean followAllParentLinks, String language) throws InvalidNodeRefException, XPathException {
        NodeSearcher nodeSearcher = new NodeSearcher(this.nodeService, this.getDictionaryService(), this);
        return nodeSearcher.selectNodes(contextNodeRef, xpath, parameters, namespacePrefixResolver, followAllParentLinks, language);
    }

    public List<Serializable> selectProperties(NodeRef contextNodeRef, String xpath, QueryParameterDefinition[] parameters, NamespacePrefixResolver namespacePrefixResolver, boolean followAllParentLinks, String language) throws InvalidNodeRefException, XPathException {
        NodeSearcher nodeSearcher = new NodeSearcher(this.nodeService, this.getDictionaryService(), this);
        return nodeSearcher.selectProperties(contextNodeRef, xpath, parameters, namespacePrefixResolver, followAllParentLinks, language);
    }

    public boolean contains(NodeRef nodeRef, QName propertyQName, String googleLikePattern) {
        return this.contains(nodeRef, propertyQName, googleLikePattern, SearchParameters.Operator.OR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(NodeRef nodeRef, QName propertyQName, String googleLikePattern, SearchParameters.Operator defaultOperator) {
        ResultSet resultSet = null;
        try {
            boolean answer;
            StringBuilder sb = new StringBuilder();
            sb.append("+ID:\"").append(nodeRef.toString()).append("\" +(TEXT:(").append(googleLikePattern.toLowerCase()).append(") ");
            if (propertyQName != null) {
                sb.append(" OR @").append(LuceneQueryParser.escape((String)QName.createQName((String)propertyQName.getNamespaceURI(), (String)ISO9075.encode((String)propertyQName.getLocalName())).toString()));
                sb.append(":(").append(googleLikePattern.toLowerCase()).append(")");
            } else {
                for (QName key : this.nodeService.getProperties(nodeRef).keySet()) {
                    sb.append(" OR @").append(LuceneQueryParser.escape((String)QName.createQName((String)key.getNamespaceURI(), (String)ISO9075.encode((String)key.getLocalName())).toString()));
                    sb.append(":(").append(googleLikePattern.toLowerCase()).append(")");
                }
            }
            sb.append(")");
            SearchParameters sp = new SearchParameters();
            sp.setLanguage("lucene");
            sp.setQuery(sb.toString());
            sp.setDefaultOperator(defaultOperator);
            sp.addStore(nodeRef.getStoreRef());
            resultSet = this.query(sp);
            boolean bl = answer = resultSet.length() > 0;
            return bl;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean like(NodeRef nodeRef, QName propertyQName, String sqlLikePattern, boolean includeFTS) {
        if (propertyQName == null) {
            throw new IllegalArgumentException("Property QName is mandatory for the like expression");
        }
        StringBuilder sb = new StringBuilder(sqlLikePattern.length() * 3);
        if (includeFTS) {
            String pattern = SearchLanguageConversion.convertXPathLikeToLucene((String)sqlLikePattern.toLowerCase());
            sb = new StringBuilder();
            sb.append("+ID:\"").append(nodeRef.toString()).append("\" +(");
            if (includeFTS) {
                sb.append("TEXT:(").append(pattern).append(") ");
            }
            if (propertyQName != null) {
                sb.append(" @").append(LuceneQueryParser.escape((String)QName.createQName((String)propertyQName.getNamespaceURI(), (String)ISO9075.encode((String)propertyQName.getLocalName())).toString())).append(":(").append(pattern).append(")");
            }
            sb.append(")");
            ResultSet resultSet = null;
            try {
                boolean answer;
                resultSet = this.query(nodeRef.getStoreRef(), "lucene", sb.toString());
                boolean bl = answer = resultSet.length() > 0;
                return bl;
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        String pattern = SearchLanguageConversion.convertXPathLikeToRegex((String)sqlLikePattern.toLowerCase());
        Serializable property = this.nodeService.getProperty(nodeRef, propertyQName);
        if (property == null) {
            return false;
        }
        String propertyString = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, propertyQName));
        return propertyString.toLowerCase().matches(pattern);
    }

    public List<NodeRef> selectNodes(NodeRef contextNodeRef, String xpath, QueryParameterDefinition[] parameters, NamespacePrefixResolver namespacePrefixResolver, boolean followAllParentLinks) throws InvalidNodeRefException, XPathException {
        return this.selectNodes(contextNodeRef, xpath, parameters, namespacePrefixResolver, followAllParentLinks, "xpath");
    }

    public List<Serializable> selectProperties(NodeRef contextNodeRef, String xpath, QueryParameterDefinition[] parameters, NamespacePrefixResolver namespacePrefixResolver, boolean followAllParentLinks) throws InvalidNodeRefException, XPathException {
        return this.selectProperties(contextNodeRef, xpath, parameters, namespacePrefixResolver, followAllParentLinks, "xpath");
    }

    String expandAttributeFieldName(String field) {
        String fieldName = field;
        if (field.charAt(1) != '{') {
            int colonPosition = field.indexOf(58);
            fieldName = colonPosition == -1 ? "@{" + this.namespacePrefixResolver.getNamespaceURI("") + "}" + field.substring(1) : "@{" + this.namespacePrefixResolver.getNamespaceURI(field.substring(1, colonPosition)) + "}" + field.substring(colonPosition + 1);
        }
        return fieldName;
    }

    @Override
    public List<Pair<String, Integer>> getTopTerms(String field, int count) {
        ClosingIndexSearcher searcher = null;
        try {
            LinkedList<Pair<String, Integer>> answer = new LinkedList<Pair<String, Integer>>();
            searcher = this.getSearcher(this.indexer);
            IndexReader reader = searcher.getIndexReader();
            TermEnum terms = reader.terms(new Term(field, ""));
            block9: do {
                Pair test;
                ListIterator<Pair> it;
                Term term;
                if ((term = terms.term()) == null) continue;
                if (!term.field().equals(field)) break;
                int freq = terms.docFreq();
                Pair pair = new Pair((Object)term.text(), (Object)freq);
                if (answer.size() < count) {
                    if (answer.size() == 0) {
                        answer.add((Pair<String, Integer>)pair);
                        continue;
                    }
                    if (((Integer)answer.get(answer.size() - 1).getSecond()).compareTo((Integer)pair.getSecond()) >= 0) {
                        answer.add((Pair<String, Integer>)pair);
                        continue;
                    }
                    it = answer.listIterator();
                    while (it.hasNext()) {
                        test = (Pair)it.next();
                        if (((Integer)test.getSecond()).compareTo((Integer)pair.getSecond()) >= 0) continue;
                        it.previous();
                        it.add(pair);
                        continue block9;
                    }
                } else {
                    if (((Integer)answer.get(count - 1).getSecond()).compareTo((Integer)pair.getSecond()) >= 0) continue;
                    it = answer.listIterator();
                    while (it.hasNext()) {
                        test = (Pair)it.next();
                        if (((Integer)test.getSecond()).compareTo((Integer)pair.getSecond()) >= 0) continue;
                        it.previous();
                        it.add(pair);
                        break;
                    }
                    answer.removeLast();
                }
            } while (terms.next());
            terms.close();
            LinkedList<Pair<String, Integer>> linkedList = answer;
            return linkedList;
        }
        catch (IOException e) {
            throw new SearcherException(e);
        }
        finally {
            if (searcher != null) {
                try {
                    searcher.close();
                }
                catch (IOException e) {
                    throw new SearcherException(e);
                }
            }
        }
    }

    @Override
    public ClosingIndexSearcher getClosingIndexSearcher() {
        return this.getSearcher(this.indexer);
    }
}

