/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.management.subsystems.ChildApplicationContextFactory;
import org.alfresco.repo.search.impl.lucene.LuceneIndexerAndSearcher;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

public class ALF947Test
extends TestCase {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private NodeService nodeService;
    private LuceneIndexerAndSearcher indexerAndSearcher;
    private TransactionService transactionService;
    private AuthenticationComponent authenticationComponent;
    private CopyService copyService;
    private FileFolderService fileFolderService;
    private UserTransaction testTX;
    private StoreRef storeRef = null;
    private NodeRef folder1;
    private NodeRef folder2;
    private NodeRef folder3;
    private NodeRef folder4;
    private NodeRef folder5;
    private NodeRef folder6;
    private NodeRef folder7;
    private NodeRef file1;
    private NodeRef file2;
    private NodeRef file3;
    private NodeRef file4;

    public void setUp() throws Exception {
        this.nodeService = (NodeService)ctx.getBean("dbNodeService");
        ChildApplicationContextFactory luceneSubSystem = (ChildApplicationContextFactory)ctx.getBean("lucene");
        this.indexerAndSearcher = (LuceneIndexerAndSearcher)luceneSubSystem.getApplicationContext().getBean("search.admLuceneIndexerAndSearcherFactory");
        this.authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.transactionService = (TransactionService)ctx.getBean("transactionComponent");
        this.copyService = (CopyService)ctx.getBean("CopyService");
        this.fileFolderService = (FileFolderService)ctx.getBean("FileFolderService");
    }

    protected void tearDown() throws Exception {
        if (this.testTX.getStatus() == 0) {
            this.testTX.rollback();
        }
        AuthenticationUtil.clearCurrentSecurityContext();
        super.tearDown();
    }

    private void buildBigTree(NodeRef rootNodeRef) {
        HashMap<QName, String> properties = new HashMap<QName, String>();
        properties.put(ContentModel.PROP_NAME, "folder1");
        QName assoc1Name = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"root_p_f1");
        this.folder1 = this.nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, assoc1Name, ContentModel.TYPE_FOLDER, properties).getChildRef();
        properties.put(ContentModel.PROP_NAME, "folder2");
        QName assoc2Name = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"root_p_f2");
        this.folder2 = this.nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, assoc2Name, ContentModel.TYPE_FOLDER, properties).getChildRef();
        properties.put(ContentModel.PROP_NAME, "folder3");
        QName assoc3Name = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"root_p_f3");
        this.folder3 = this.nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, assoc3Name, ContentModel.TYPE_FOLDER, properties).getChildRef();
        properties.put(ContentModel.PROP_NAME, "folder4");
        QName assoc4Name = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"f1_p_f4");
        this.folder4 = this.nodeService.createNode(this.folder1, ContentModel.ASSOC_CONTAINS, assoc4Name, ContentModel.TYPE_FOLDER, properties).getChildRef();
        properties.put(ContentModel.PROP_NAME, "folder5");
        QName assoc5Name = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"f4_p_f5");
        this.folder5 = this.nodeService.createNode(this.folder4, ContentModel.ASSOC_CONTAINS, assoc5Name, ContentModel.TYPE_FOLDER, properties).getChildRef();
        properties.put(ContentModel.PROP_NAME, "folder6");
        QName assoc6Name = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"f5_p_f6");
        this.folder6 = this.nodeService.createNode(this.folder5, ContentModel.ASSOC_CONTAINS, assoc6Name, ContentModel.TYPE_FOLDER, properties).getChildRef();
        properties.put(ContentModel.PROP_NAME, "file1");
        QName assoc8Name = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"f1_p_file1");
        this.file1 = this.nodeService.createNode(this.folder1, ContentModel.ASSOC_CONTAINS, assoc8Name, ContentModel.TYPE_CONTENT, properties).getChildRef();
        properties.put(ContentModel.PROP_NAME, "file2");
        QName assoc9Name = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"f4_p_file2");
        this.file2 = this.nodeService.createNode(this.folder4, ContentModel.ASSOC_CONTAINS, assoc8Name, ContentModel.TYPE_CONTENT, properties).getChildRef();
        properties.put(ContentModel.PROP_NAME, "file3");
        QName assoc10Name = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"f5_p_file3");
        this.file3 = this.nodeService.createNode(this.folder5, ContentModel.ASSOC_CONTAINS, assoc9Name, ContentModel.TYPE_CONTENT, properties).getChildRef();
        properties.put(ContentModel.PROP_NAME, "file4");
        QName assoc11Name = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"f3_p_file4");
        this.file4 = this.nodeService.createNode(this.folder3, ContentModel.ASSOC_CONTAINS, assoc10Name, ContentModel.TYPE_CONTENT, properties).getChildRef();
        this.nodeService.addChild(Arrays.asList(this.folder1, this.folder4, this.folder5, this.folder6), this.file4, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"stuff"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testALF947_1() throws Exception {
        StoreRef storeRef = null;
        NodeRef rootNodeRef = null;
        String queryString = null;
        SearchService searchService = null;
        ResultSet results = null;
        try {
            this.testTX = this.transactionService.getUserTransaction();
            this.testTX.begin();
            this.authenticationComponent.setSystemUserAsCurrentUser();
            storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
            rootNodeRef = this.nodeService.getRootNode(storeRef);
            this.buildBigTree(rootNodeRef);
            searchService = this.indexerAndSearcher.getSearcher(storeRef, true);
            queryString = "@cm\\:name:n4";
            results = searchService.query(storeRef, "lucene", queryString);
            results.close();
            this.nodeService.moveNode(this.folder1, this.folder2, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{namespace}test"));
            queryString = "PATH:\"//*\"";
            results = searchService.query(storeRef, "lucene", queryString);
            for (ResultSetRow row : results) {
                NodeRef nodeRef = row.getNodeRef();
                System.out.println("Node ref = " + nodeRef);
                Map nodeProperties = this.nodeService.getProperties(nodeRef);
                for (QName propName : nodeProperties.keySet()) {
                    System.out.println("Property " + propName + "=" + nodeProperties.get(propName));
                }
            }
            System.out.println("===================");
            results.close();
            ALF947Test.assertEquals((int)10, (int)results.length());
            List parents = this.nodeService.getParentAssocs(this.file4);
            ALF947Test.assertEquals((int)5, (int)parents.size());
        }
        finally {
            if (null != storeRef) {
                // empty if block
            }
            if (null != this.testTX) {
                this.testTX.commit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testALF947_2() throws Exception {
        StoreRef storeRef = null;
        NodeRef rootNodeRef = null;
        String queryString = null;
        SearchService searchService = null;
        ResultSet results = null;
        try {
            this.testTX = this.transactionService.getUserTransaction();
            this.testTX.begin();
            this.authenticationComponent.setSystemUserAsCurrentUser();
            storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
            rootNodeRef = this.nodeService.getRootNode(storeRef);
            this.buildBigTree(rootNodeRef);
            searchService = this.indexerAndSearcher.getSearcher(storeRef, true);
            queryString = "@cm\\:name:n4";
            results = searchService.query(storeRef, "lucene", queryString);
            results.close();
            this.nodeService.moveNode(this.folder1, this.folder2, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"cm", (String)"n2_p_n1"));
        }
        finally {
            if (null != storeRef) {
                // empty if block
            }
            if (null != this.testTX) {
                this.testTX.commit();
            }
        }
        try {
            this.testTX = this.transactionService.getUserTransaction();
            this.testTX.begin();
            this.authenticationComponent.setSystemUserAsCurrentUser();
            queryString = "PATH:\"//*\"";
            searchService = this.indexerAndSearcher.getSearcher(storeRef, true);
            results = searchService.query(storeRef, "lucene", queryString);
            for (ResultSetRow row : results) {
                NodeRef nodeRef = row.getNodeRef();
                System.out.println("Node ref = " + nodeRef);
                Map nodeProperties = this.nodeService.getProperties(nodeRef);
                for (QName propName : nodeProperties.keySet()) {
                    System.out.println("Property " + propName + "=" + nodeProperties.get(propName));
                }
            }
            System.out.println("===================");
            results.close();
            ALF947Test.assertEquals((int)10, (int)results.length());
            List parents = this.nodeService.getParentAssocs(this.file4);
            ALF947Test.assertEquals((int)5, (int)parents.size());
        }
        finally {
            if (null != storeRef) {
                // empty if block
            }
            if (null != this.testTX) {
                this.testTX.commit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testALF947_3() throws Exception {
        NodeRef rootNodeRef = null;
        String queryString = null;
        SearchService searchService = null;
        ResultSet results = null;
        try {
            this.testTX = this.transactionService.getUserTransaction();
            this.testTX.begin();
            this.authenticationComponent.setSystemUserAsCurrentUser();
            this.storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
            rootNodeRef = this.nodeService.getRootNode(this.storeRef);
            this.buildBigTree(rootNodeRef);
            NodeRef newNode = this.copyService.copyAndRename(this.folder1, this.folder2, ContentModel.ASSOC_CONTAINS, null, true);
            searchService = this.indexerAndSearcher.getSearcher(this.storeRef, true);
            queryString = "PATH:\"//*\"";
            results = searchService.query(this.storeRef, "lucene", queryString);
            results.close();
            FileInfo fileInfo = this.fileFolderService.rename(newNode, "folder7");
        }
        finally {
            if (null != this.storeRef) {
                // empty if block
            }
            if (null != this.testTX) {
                this.testTX.commit();
            }
        }
        try {
            this.testTX = this.transactionService.getUserTransaction();
            this.testTX.begin();
            this.authenticationComponent.setSystemUserAsCurrentUser();
            queryString = "PATH:\"//*\"";
            searchService = this.indexerAndSearcher.getSearcher(this.storeRef, true);
            results = searchService.query(this.storeRef, "lucene", queryString);
            for (ResultSetRow row : results) {
                NodeRef nodeRef = row.getNodeRef();
                System.out.println("Node ref = " + nodeRef);
                Map nodeProperties = this.nodeService.getProperties(nodeRef);
                for (QName propName : nodeProperties.keySet()) {
                    System.out.println("Property " + propName + "=" + nodeProperties.get(propName));
                }
            }
            System.out.println("===================");
            results.close();
            ALF947Test.assertEquals((int)17, (int)results.length());
            List parents = this.nodeService.getParentAssocs(this.file4);
            ALF947Test.assertEquals((int)9, (int)parents.size());
        }
        finally {
            if (null != this.storeRef) {
                // empty if block
            }
            if (null != this.testTX) {
                this.testTX.commit();
            }
        }
    }
}

