/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.error.AlfrescoRuntimeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.OpenBitSet;

public class FilterIndexReaderByStringId
extends FilterIndexReader {
    private static Log s_logger = LogFactory.getLog(FilterIndexReaderByStringId.class);
    private OpenBitSet deletedDocuments;
    private final Set<String> deletions;
    private final Set<String> containerDeletions;
    private final boolean deleteNodesOnly;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final String id;

    public FilterIndexReaderByStringId(String id, IndexReader reader, Set<String> deletions, Set<String> containerDeletions, boolean deleteNodesOnly) {
        super(reader);
        reader.incRef();
        this.id = id;
        this.deletions = deletions;
        this.containerDeletions = containerDeletions;
        this.deleteNodesOnly = deleteNodesOnly;
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Applying deletions FOR " + id + " (the index ito which these are applied is the previous one ...)"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenBitSet getDeletedDocuments() {
        this.lock.readLock().lock();
        try {
            if (this.deletedDocuments != null) {
                OpenBitSet openBitSet = this.deletedDocuments;
                return openBitSet;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            TermDocs td;
            if (this.deletedDocuments != null) {
                OpenBitSet openBitSet = this.deletedDocuments;
                return openBitSet;
            }
            this.deletedDocuments = new OpenBitSet((long)this.in.maxDoc());
            IndexSearcher searcher = new IndexSearcher(this.in);
            for (String stringRef : this.deletions) {
                if (!this.deleteNodesOnly || this.containerDeletions.contains(stringRef)) {
                    td = this.in.termDocs(new Term("ID", stringRef));
                    while (td.next()) {
                        this.deletedDocuments.set((long)td.doc());
                    }
                    td.close();
                    continue;
                }
                TermQuery query = new TermQuery(new Term("ID", stringRef));
                Hits hits = searcher.search((Query)query);
                if (hits.length() <= 0) continue;
                for (int i = 0; i < hits.length(); ++i) {
                    Document doc = hits.doc(i);
                    Field path = doc.getField("PATH");
                    if (path != null && path.stringValue().length() != 0) continue;
                    this.deletedDocuments.set((long)hits.id(i));
                }
            }
            for (String stringRef : this.containerDeletions) {
                td = this.in.termDocs(new Term("ANCESTOR", stringRef));
                while (td.next()) {
                    this.deletedDocuments.set((long)td.doc());
                }
                td.close();
            }
            OpenBitSet openBitSet = this.deletedDocuments;
            return openBitSet;
        }
        catch (IOException e) {
            s_logger.error((Object)("Error initialising " + this.id), (Throwable)e);
            throw new AlfrescoRuntimeException("Failed to find deleted documents to filter", (Throwable)e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected void doClose() throws IOException {
        this.in.decRef();
    }

    public int numDocs() {
        return super.numDocs() - (int)this.getDeletedDocuments().cardinality();
    }

    public TermDocs termDocs() throws IOException {
        return new FilterTermDocs(this.id, super.termDocs());
    }

    public TermPositions termPositions() throws IOException {
        return new FilterTermPositions(this.id, super.termPositions());
    }

    public class FilterTermPositions
    extends FilterTermDocs
    implements TermPositions {
        TermPositions tp;

        public FilterTermPositions(String id, TermPositions in) {
            super(id, (TermDocs)in);
            this.tp = in;
        }

        public int nextPosition() throws IOException {
            return this.tp.nextPosition();
        }

        public byte[] getPayload(byte[] data, int offset) throws IOException {
            return this.tp.getPayload(data, offset);
        }

        public int getPayloadLength() {
            return this.tp.getPayloadLength();
        }

        public boolean isPayloadAvailable() {
            return this.tp.isPayloadAvailable();
        }
    }

    public class FilterTermDocs
    implements TermDocs {
        protected TermDocs in;
        String id;

        public FilterTermDocs(String id, TermDocs in) {
            this.in = in;
        }

        public void seek(Term term) throws IOException {
            this.in.seek(term);
        }

        public void seek(TermEnum termEnum) throws IOException {
            this.in.seek(termEnum);
        }

        public int doc() {
            return this.in.doc();
        }

        public int freq() {
            return this.in.freq();
        }

        public boolean next() throws IOException {
            try {
                if (!this.in.next()) {
                    return false;
                }
                OpenBitSet deletedDocuments = FilterIndexReaderByStringId.this.getDeletedDocuments();
                while (deletedDocuments.get(this.in.doc())) {
                    if (this.in.next()) continue;
                    return false;
                }
                return true;
            }
            catch (IOException ioe) {
                s_logger.error((Object)("Error reading docs for " + this.id));
                throw ioe;
            }
        }

        public int read(int[] docs, int[] freqs) throws IOException {
            int[] innerDocs = new int[docs.length];
            int[] innerFreq = new int[docs.length];
            int count = this.in.read(innerDocs, innerFreq);
            if (count == 0) {
                return 0;
            }
            OpenBitSet deletedDocuments = FilterIndexReaderByStringId.this.getDeletedDocuments();
            while (this.allDeleted(innerDocs, count, deletedDocuments)) {
                count = this.in.read(innerDocs, innerFreq);
                if (count != 0) continue;
                return 0;
            }
            int insertPosition = 0;
            for (int i = 0; i < count; ++i) {
                if (deletedDocuments.get(innerDocs[i])) continue;
                docs[insertPosition] = innerDocs[i];
                freqs[insertPosition] = innerFreq[i];
                ++insertPosition;
            }
            return insertPosition;
        }

        private boolean allDeleted(int[] docs, int fillSize, OpenBitSet deletedDocuments) {
            for (int i = 0; i < fillSize; ++i) {
                if (deletedDocuments.get(docs[i])) continue;
                return false;
            }
            return true;
        }

        public boolean skipTo(int i) throws IOException {
            if (!this.in.skipTo(i)) {
                return false;
            }
            OpenBitSet deletedDocuments = FilterIndexReaderByStringId.this.getDeletedDocuments();
            while (deletedDocuments.get(this.in.doc())) {
                if (this.in.next()) continue;
                return false;
            }
            return true;
        }

        public void close() throws IOException {
            this.in.close();
        }
    }
}

