/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr;

import java.util.concurrent.atomic.AtomicBoolean;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.repo.solr.SOLRAdminClient;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.springframework.beans.factory.InitializingBean;

public class SolrBackupClient
implements InitializingBean {
    private static final Log logger = LogFactory.getLog(SolrBackupClient.class);
    private QName lock;
    private JobLockService jobLockService;
    private String remoteBackupLocation;
    private int numberToKeep;
    private String core;
    private SOLRAdminClient solrAdminClient;

    public void setSolrAdminClient(SOLRAdminClient solrAdminClient) {
        this.solrAdminClient = solrAdminClient;
    }

    public void setCore(String core) {
        this.core = core;
    }

    public void setJobLockService(JobLockService jobLockService) {
        this.jobLockService = jobLockService;
    }

    public void setRemoteBackupLocation(String remoteBackupLocation) {
        this.remoteBackupLocation = remoteBackupLocation;
    }

    public void setNumberToKeep(int numberToKeep) {
        this.numberToKeep = numberToKeep;
    }

    public void execute() {
        String lockToken = this.getLock(60000L);
        if (lockToken == null) {
            // empty if block
        }
        final AtomicBoolean running = new AtomicBoolean(true);
        this.jobLockService.refreshLock(lockToken, this.lock, 30000L, new JobLockService.JobLockRefreshCallback(){

            @Override
            public boolean isActive() {
                return running.get();
            }

            @Override
            public void lockReleased() {
                running.set(false);
            }
        });
        try {
            this.executeImpl(running);
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            running.set(false);
            this.jobLockService.releaseLock(lockToken, this.lock);
        }
    }

    private void executeImpl(AtomicBoolean running) {
        if ((this.remoteBackupLocation == null || this.remoteBackupLocation.length() == 0) && logger.isInfoEnabled()) {
            logger.info((Object)("Back up of SOLR core skipped - no remote backup localtion set for: " + this.core));
        }
        try {
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("qt", new String[]{"/" + this.core + "/replication"});
            params.set("command", new String[]{"backup"});
            params.set("location", new String[]{this.remoteBackupLocation});
            params.set("numberToKeep", this.numberToKeep);
            QueryResponse response = this.solrAdminClient.query(params);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Back up of SOLR core completed: " + this.core));
            }
        }
        catch (SolrServerException e) {
            throw new AlfrescoRuntimeException("Backup for core " + this.core + " failed .... ", (Throwable)e);
        }
    }

    private String getLock(long time) {
        try {
            return this.jobLockService.getLock(this.lock, time);
        }
        catch (LockAcquisitionException e) {
            return null;
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.lock = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)("SolrBackupClient-" + this.core));
    }
}

