/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authority.script;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.repo.security.authority.script.Authority;
import org.alfresco.repo.security.authority.script.ScriptUser;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.util.ModelUtil;
import org.alfresco.util.ScriptPagingDetails;
import org.mozilla.javascript.Scriptable;

public class ScriptGroup
implements Authority,
Serializable {
    private static final long serialVersionUID = 6073732221341647273L;
    private transient ServiceRegistry serviceRegistry;
    private transient AuthorityService authorityService;
    private Authority.ScriptAuthorityType authorityType = Authority.ScriptAuthorityType.GROUP;
    private String shortName;
    private String fullName;
    private String displayName;
    private Set<String> childAuthorityNames;
    private NodeRef groupNodeRef;
    private Scriptable scope;
    private ScriptUser[] childUsers;
    private ScriptGroup[] childGroups;
    private ScriptGroup[] parentCache;

    public ScriptGroup(String fullName, ServiceRegistry serviceRegistry, Scriptable scope) {
        this(fullName, serviceRegistry, serviceRegistry.getAuthorityService(), scope);
    }

    public ScriptGroup(String fullName, AuthorityService authorityService) {
        this(fullName, null, authorityService, null);
    }

    private ScriptGroup(String fullName, ServiceRegistry serviceRegistry, AuthorityService authorityService, Scriptable scope) {
        this.authorityService = authorityService;
        this.serviceRegistry = serviceRegistry;
        this.fullName = fullName;
        this.scope = scope;
        this.shortName = authorityService.getShortName(fullName);
        this.displayName = authorityService.getAuthorityDisplayName(fullName);
    }

    public void deleteGroup() {
        this.authorityService.deleteAuthority(this.fullName);
    }

    public void setAuthorityType(Authority.ScriptAuthorityType authorityType) {
        this.authorityType = authorityType;
    }

    @Override
    public Authority.ScriptAuthorityType getAuthorityType() {
        return this.authorityType;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    public void setDisplayName(String displayName) {
        if (this.displayName != null && !this.displayName.equals(displayName)) {
            this.authorityService.setAuthorityDisplayName(this.fullName, displayName);
        }
        this.displayName = displayName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public ScriptUser[] getAllUsers() {
        Set<String> children = this.authorityService.getContainedAuthorities(AuthorityType.USER, this.fullName, false);
        LinkedHashSet<ScriptUser> users = new LinkedHashSet<ScriptUser>();
        for (String authority : children) {
            ScriptUser user = new ScriptUser(authority, null, this.serviceRegistry, this.scope);
            users.add(user);
        }
        return users.toArray(new ScriptUser[users.size()]);
    }

    public ScriptGroup[] getAllGroups() {
        Set<String> children = this.authorityService.getContainedAuthorities(AuthorityType.GROUP, this.fullName, false);
        LinkedHashSet<ScriptGroup> groups = new LinkedHashSet<ScriptGroup>();
        for (String authority : children) {
            ScriptGroup group = new ScriptGroup(authority, this.serviceRegistry, this.authorityService, this.scope);
            groups.add(group);
        }
        return groups.toArray(new ScriptGroup[groups.size()]);
    }

    private Set<String> getChildAuthorityNames() {
        if (this.childAuthorityNames == null) {
            this.childAuthorityNames = this.authorityService.getContainedAuthorities(null, this.fullName, true);
        }
        return this.childAuthorityNames;
    }

    private Set<String> getChildNamesOfType(AuthorityType type) {
        Set<String> authorities = this.getChildAuthorityNames();
        TreeSet<String> result = new TreeSet<String>();
        for (String authority : authorities) {
            if (AuthorityType.getAuthorityType((String)authority) != type) continue;
            result.add(authority);
        }
        return result;
    }

    public ScriptUser[] getChildUsers() {
        return this.getChildUsers(new ScriptPagingDetails(), null);
    }

    public ScriptUser[] getChildUsers(ScriptPagingDetails paging, String sortBy) {
        if (this.childUsers == null) {
            Set<String> children = this.getChildNamesOfType(AuthorityType.USER);
            LinkedHashSet<ScriptUser> users = new LinkedHashSet<ScriptUser>();
            for (String authority : children) {
                ScriptUser user = new ScriptUser(authority, null, this.serviceRegistry, this.scope);
                users.add(user);
            }
            this.childUsers = users.toArray(new ScriptUser[users.size()]);
        }
        return (ScriptUser[])this.makePagedAuthority(paging, sortBy, this.childUsers);
    }

    public ScriptGroup[] getChildGroups() {
        return this.getChildGroups(new ScriptPagingDetails(), null);
    }

    public ScriptGroup[] getChildGroups(int maxItems, int skipCount) {
        return this.getChildGroups(new ScriptPagingDetails(maxItems, skipCount), null);
    }

    public ScriptGroup[] getChildGroups(ScriptPagingDetails paging, String sortBy) {
        if (this.childGroups == null) {
            Set<String> children = this.getChildNamesOfType(AuthorityType.GROUP);
            Set<ScriptGroup> groups = this.makeScriptGroups(children);
            this.childGroups = groups.toArray(new ScriptGroup[groups.size()]);
        }
        return (ScriptGroup[])this.makePagedAuthority(paging, sortBy, this.childGroups);
    }

    public Authority[] getChildAuthorities() {
        return this.getChildAuthorities(new ScriptPagingDetails(), null);
    }

    public Authority[] getChildAuthorities(ScriptPagingDetails paging, String sortBy) {
        ScriptGroup[] groups = this.getChildGroups();
        ScriptUser[] users = this.getChildUsers();
        Authority[] ret = new Authority[groups.length + users.length];
        System.arraycopy(groups, 0, ret, 0, groups.length);
        System.arraycopy(users, 0, ret, groups.length, users.length);
        return this.makePagedAuthority(paging, sortBy, ret);
    }

    public ScriptGroup[] getParentGroups() {
        return this.getParentGroups(new ScriptPagingDetails(), null);
    }

    public ScriptGroup[] getParentGroups(int maxItems, int skipCount) {
        return this.getParentGroups(new ScriptPagingDetails(maxItems, skipCount), null);
    }

    public ScriptGroup[] getParentGroups(ScriptPagingDetails paging, String sortBy) {
        if (this.parentCache == null) {
            Set<String> parents = this.authorityService.getContainingAuthorities(AuthorityType.GROUP, this.fullName, true);
            Set<ScriptGroup> groups = this.makeScriptGroups(parents);
            this.parentCache = groups.toArray(new ScriptGroup[groups.size()]);
        }
        return (ScriptGroup[])this.makePagedAuthority(paging, sortBy, this.parentCache);
    }

    private <T extends Authority> T[] makePagedAuthority(ScriptPagingDetails paging, String sortBy, T[] groups) {
        Arrays.sort(groups, new Authority.AuthorityComparator(sortBy));
        int maxItems = paging.getMaxItems();
        int skipCount = paging.getSkipCount();
        paging.setTotalItems(groups.length);
        return (Authority[])ModelUtil.page(groups, maxItems, skipCount);
    }

    private Set<ScriptGroup> makeScriptGroups(Set<String> parents) {
        ArrayList<String> sortedParents = new ArrayList<String>(parents);
        Collections.sort(sortedParents);
        LinkedHashSet<ScriptGroup> groups = new LinkedHashSet<ScriptGroup>();
        for (String authority : sortedParents) {
            ScriptGroup group = new ScriptGroup(authority, this.serviceRegistry, this.authorityService, this.scope);
            groups.add(group);
        }
        return groups;
    }

    public ScriptGroup[] getAllParentGroups() {
        return this.getAllParentGroups(new ScriptPagingDetails(), null);
    }

    public ScriptGroup[] getAllParentGroups(int maxItems, int skipCount) {
        return this.getAllParentGroups(new ScriptPagingDetails(maxItems, skipCount), null);
    }

    public ScriptGroup[] getAllParentGroups(ScriptPagingDetails paging, String sortBy) {
        Set<String> parents = this.authorityService.getContainingAuthorities(AuthorityType.GROUP, this.fullName, false);
        return ScriptGroup.makeScriptGroups(parents, paging, sortBy, this.serviceRegistry, this.scope);
    }

    public int getUserCount() {
        return this.getChildNamesOfType(AuthorityType.USER).size();
    }

    public int getGroupCount() {
        return this.getChildNamesOfType(AuthorityType.GROUP).size();
    }

    public ScriptGroup createGroup(String newShortName, String newDisplayName) {
        String authorityName = this.authorityService.createAuthority(AuthorityType.GROUP, newShortName, newDisplayName, this.authorityService.getDefaultZones());
        this.authorityService.addAuthority(this.fullName, authorityName);
        ScriptGroup childGroup = new ScriptGroup(authorityName, this.serviceRegistry, this.authorityService, this.scope);
        this.clearCaches();
        return childGroup;
    }

    public void removeGroup(String newShortName) {
        String fullAuthorityName = this.authorityService.getName(AuthorityType.GROUP, newShortName);
        this.authorityService.removeAuthority(this.fullName, fullAuthorityName);
        this.clearCaches();
    }

    public void removeUser(String newShortName) {
        String fullAuthorityName = this.authorityService.getName(AuthorityType.USER, newShortName);
        this.authorityService.removeAuthority(this.fullName, fullAuthorityName);
        this.clearCaches();
    }

    public void addAuthority(String fullAuthorityName) {
        this.authorityService.addAuthority(this.fullName, fullAuthorityName);
        this.clearCaches();
    }

    public void removeAuthority(String fullAuthorityName) {
        this.authorityService.removeAuthority(this.fullName, fullAuthorityName);
        this.clearCaches();
    }

    public NodeRef getGroupNodeRef() {
        if (this.groupNodeRef == null) {
            this.groupNodeRef = this.authorityService.getAuthorityNodeRef(this.fullName);
        }
        return this.groupNodeRef;
    }

    public ScriptNode getGroupNode() {
        return new ScriptNode(this.getGroupNodeRef(), this.serviceRegistry, this.scope);
    }

    private void clearCaches() {
        this.childUsers = null;
        this.childGroups = null;
        this.childAuthorityNames = null;
    }

    public static ScriptGroup[] makeScriptGroups(Collection<String> authorities, ScriptPagingDetails paging, ServiceRegistry serviceRegistry, Scriptable scope) {
        return ScriptGroup.makeScriptGroups(authorities, paging, null, serviceRegistry, scope);
    }

    public static ScriptGroup[] makeScriptGroups(Collection<String> authorities, ScriptPagingDetails paging, String sortBy, ServiceRegistry serviceRegistry, Scriptable scope) {
        ArrayList<String> authList = new ArrayList<String>(authorities);
        final HashMap<String, ScriptGroup> scriptGroupCache = new HashMap<String, ScriptGroup>();
        if ("shortName".equals(sortBy) || "displayName".equals(sortBy)) {
            for (String authority : authorities) {
                scriptGroupCache.put(authority, new ScriptGroup(authority, serviceRegistry, scope));
            }
            final Authority.AuthorityComparator c2 = new Authority.AuthorityComparator(sortBy);
            Collections.sort(authList, new Comparator<String>(){

                @Override
                public int compare(String g1, String g2) {
                    ScriptGroup sg1 = (ScriptGroup)scriptGroupCache.get(g1);
                    ScriptGroup sg2 = (ScriptGroup)scriptGroupCache.get(g2);
                    return c2.compare(sg1, sg2);
                }
            });
        } else {
            Collections.sort(authList, new Comparator<String>(){

                @Override
                public int compare(String g1, String g2) {
                    return g1.toLowerCase().compareTo(g2.toLowerCase());
                }
            });
        }
        List<String> paged = ModelUtil.page(authList, paging);
        ScriptGroup[] groups = new ScriptGroup[paged.size()];
        for (int i = 0; i < groups.length; ++i) {
            String authority = paged.get(i);
            ScriptGroup group = scriptGroupCache.containsKey(authority) ? (ScriptGroup)scriptGroupCache.get(authority) : new ScriptGroup(authority, serviceRegistry, scope);
            groups[i] = group;
        }
        return groups;
    }

    public static ScriptGroup[] makeScriptGroups(PagingResults<String> pagedGroups, ScriptPagingDetails paging, ServiceRegistry serviceRegistry, Scriptable scope) {
        paging.setTotalItems(pagedGroups);
        List groupNames = pagedGroups.getPage();
        ScriptGroup[] groups = new ScriptGroup[groupNames.size()];
        for (int i = 0; i < groups.length; ++i) {
            groups[i] = new ScriptGroup((String)groupNames.get(i), serviceRegistry, scope);
        }
        return groups;
    }
}

