/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.permissions.AccessControlListDAO;
import org.alfresco.repo.domain.permissions.AclDAO;
import org.alfresco.repo.search.IndexerAndSearcher;
import org.alfresco.repo.search.impl.lucene.ADMLuceneIndexer;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.MutableAuthenticationDao;
import org.alfresco.repo.security.authority.AuthorityDAO;
import org.alfresco.repo.security.permissions.PermissionServiceSPI;
import org.alfresco.repo.security.permissions.impl.ModelDAO;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.OwnableService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.wcm.webproject.WebProjectService;
import org.springframework.context.ApplicationContext;
import org.springframework.orm.hibernate3.LocalSessionFactoryBean;

public class AbstractReadPermissionTest
extends TestCase {
    protected static ApplicationContext applicationContext = ApplicationContextHelper.getApplicationContext();
    protected static final String ROLE_AUTHENTICATED = "ROLE_AUTHENTICATED";
    protected NodeService nodeService;
    protected DictionaryService dictionaryService;
    protected PermissionServiceSPI permissionService;
    protected MutableAuthenticationService authenticationService;
    protected MutableAuthenticationDao authenticationDAO;
    protected LocalSessionFactoryBean sessionFactory;
    protected NodeRef rootNodeRef;
    protected NamespacePrefixResolver namespacePrefixResolver;
    protected ServiceRegistry serviceRegistry;
    protected NodeRef systemNodeRef;
    protected AuthenticationComponent authenticationComponent;
    protected ModelDAO permissionModelDAO;
    protected PersonService personService;
    protected AuthorityService authorityService;
    protected AuthorityDAO authorityDAO;
    protected NodeDAO nodeDAO;
    protected AclDAO aclDaoComponent;
    protected ADMLuceneIndexer admLuceneIndexer;
    protected RetryingTransactionHelper retryingTransactionHelper;
    protected TransactionService transactionService;
    protected AccessControlListDAO accessControlListDao;
    protected FileFolderService fileFolderService;
    protected OwnableService ownableService;
    protected UserTransaction testTX;
    protected AVMService fService;
    protected IndexerAndSearcher fIndexerAndSearcher;
    protected WebProjectService wpService;
    protected boolean logToFile = false;
    protected String[] webAuthorities = new String[]{"Web1", "Web2", "Web3", "Web4", "Web5"};
    protected String[] authorities = new String[]{"Dynamic", "1000", "1001", "Y", "Z", "X", "10_1", "avm", "100", "10", "1", "01", "001", "0001"};
    protected String AVMStore = "main" + System.currentTimeMillis();
    final int WEB_COUNT = 100;
    protected final String TEST_RUN = "" + System.currentTimeMillis();
    protected final String TEST_WEBPROJ_DNS = "testWP-" + this.TEST_RUN;
    protected final String TEST_WEBPROJ_NAME = "testSandbox Web Project Display Name - " + this.TEST_RUN;
    protected final String TEST_WEBPROJ_TITLE = "This is my title";
    protected final String TEST_WEBPROJ_DESCRIPTION = "This is my description";
    protected final String TEST_WEBPROJ_DEFAULT_WEBAPP = "ROOT";
    protected final boolean TEST_WEBPROJ_USE_AS_TEMPLATE = true;
    protected final boolean TEST_WEBPROJ_DONT_USE_AS_TEMPLATE = false;
    protected int COUNT = 10;
    protected Counter c01 = new Counter();
    protected Counter c001 = new Counter();
    protected Counter c0001 = new Counter();

    private Map<QName, Serializable> createPersonProperties(String userName) {
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        properties.put(ContentModel.PROP_USERNAME, (Serializable)((Object)userName));
        return properties;
    }

    protected void createAuthentication(String name) {
        if (this.authenticationDAO.userExists(name)) {
            this.authenticationService.deleteAuthentication(name);
        }
        this.authenticationService.createAuthentication(name, name.toCharArray());
        if (this.personService.personExists(name)) {
            this.personService.deletePerson(name);
        }
        this.personService.createPerson(this.createPersonProperties(name));
    }

    protected void createGroup(String name) {
        this.authorityService.createAuthority(AuthorityType.GROUP, name);
    }

    protected void runAs(String userName) {
        this.authenticationService.authenticate(userName, userName.toCharArray());
        AbstractReadPermissionTest.assertNotNull((Object)this.authenticationService.getCurrentUserName());
    }

    protected NodeRef[] build1000Nodes(String authority, int returnNodes, boolean inherit) {
        return this.build1000Nodes(authority, "Read", returnNodes, inherit);
    }

    protected NodeRef[] buildOwnedNodes(final String authority, final int returnNodes) {
        this.runAs("admin");
        final NodeRef[] nodes = new NodeRef[returnNodes];
        RetryingTransactionHelper.RetryingTransactionCallback<Void> cb = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                int i = 0;
                int k = returnNodes > 0 ? 1000 / returnNodes : 0;
                String namePrefix = "simple" + System.currentTimeMillis();
                NodeRef folder = AbstractReadPermissionTest.this.fileFolderService.create(AbstractReadPermissionTest.this.rootNodeRef, namePrefix, ContentModel.TYPE_FOLDER).getNodeRef();
                NodeRef folder_1000 = AbstractReadPermissionTest.this.fileFolderService.create(folder, namePrefix + "-1000-", ContentModel.TYPE_FOLDER).getNodeRef();
                AbstractReadPermissionTest.this.permissionService.setInheritParentPermissions(folder_1000, false);
                AbstractReadPermissionTest.this.permissionService.setPermission(folder_1000, authority, "Read", true);
                for (int j = 0; j < 1000; ++j) {
                    NodeRef file = AbstractReadPermissionTest.this.fileFolderService.create(folder_1000, namePrefix + "-1000-" + j, ContentModel.TYPE_CONTENT).getNodeRef();
                    AbstractReadPermissionTest.this.ownableService.setOwner(file, authority);
                    if (returnNodes <= 0 || j % k != 0) continue;
                    nodes[i++] = file;
                }
                return null;
            }
        };
        this.retryingTransactionHelper.doInTransaction(cb, false, false);
        return nodes;
    }

    protected void buildNodes(final String user, final String permission, final int n, final boolean inherit) {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> cb = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                String namePrefix = "simple" + System.currentTimeMillis();
                NodeRef folder = AbstractReadPermissionTest.this.fileFolderService.create(AbstractReadPermissionTest.this.rootNodeRef, namePrefix, ContentModel.TYPE_FOLDER).getNodeRef();
                NodeRef folder_n = AbstractReadPermissionTest.this.fileFolderService.create(folder, namePrefix + "-n", ContentModel.TYPE_FOLDER).getNodeRef();
                AbstractReadPermissionTest.this.permissionService.setInheritParentPermissions(folder_n, false);
                AbstractReadPermissionTest.this.permissionService.setPermission(folder_n, user, "Read", true);
                for (int j = 0; j < n; ++j) {
                    NodeRef file = AbstractReadPermissionTest.this.fileFolderService.create(folder_n, namePrefix + "-n-" + j, ContentModel.TYPE_CONTENT).getNodeRef();
                    if (inherit) continue;
                    AbstractReadPermissionTest.this.permissionService.setInheritParentPermissions(file, false);
                    if (permission == null) continue;
                    AbstractReadPermissionTest.this.permissionService.setPermission(file, user, permission, true);
                }
                return null;
            }
        };
        this.retryingTransactionHelper.doInTransaction(cb, false, false);
    }

    protected NodeRef[] build1000Nodes(final String authority, final String permission, final int returnNodes, final boolean inherit) {
        this.runAs("admin");
        final NodeRef[] nodes = new NodeRef[returnNodes];
        RetryingTransactionHelper.RetryingTransactionCallback<Void> cb = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                int i = 0;
                int k = returnNodes > 0 ? 1000 / returnNodes : 0;
                String namePrefix = "simple" + System.currentTimeMillis();
                NodeRef folder = AbstractReadPermissionTest.this.fileFolderService.create(AbstractReadPermissionTest.this.rootNodeRef, namePrefix, ContentModel.TYPE_FOLDER).getNodeRef();
                NodeRef folder_1000 = AbstractReadPermissionTest.this.fileFolderService.create(folder, namePrefix + "-1000-", ContentModel.TYPE_FOLDER).getNodeRef();
                AbstractReadPermissionTest.this.permissionService.setInheritParentPermissions(folder_1000, false);
                AbstractReadPermissionTest.this.permissionService.setPermission(folder_1000, authority, permission, true);
                for (int j = 0; j < 1000; ++j) {
                    NodeRef file = AbstractReadPermissionTest.this.fileFolderService.create(folder_1000, namePrefix + "-1000-" + j, ContentModel.TYPE_CONTENT).getNodeRef();
                    if (!inherit) {
                        AbstractReadPermissionTest.this.permissionService.setInheritParentPermissions(file, false);
                        AbstractReadPermissionTest.this.permissionService.setPermission(file, authority, permission, true);
                    }
                    if (returnNodes <= 0 || j % k != 0) continue;
                    nodes[i++] = file;
                }
                return null;
            }
        };
        this.retryingTransactionHelper.doInTransaction(cb, false, false);
        return nodes;
    }

    protected NodeRef[] build1000Nodes(String authority, String permission, boolean inherit) {
        return this.build1000Nodes(authority, permission, 0, inherit);
    }

    protected void build1000NodesReadDenied(final String authority) {
        this.runAs("admin");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> cb = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                String name = "simple" + System.currentTimeMillis();
                NodeRef folder = AbstractReadPermissionTest.this.fileFolderService.create(AbstractReadPermissionTest.this.rootNodeRef, name, ContentModel.TYPE_FOLDER).getNodeRef();
                NodeRef folder_1001 = AbstractReadPermissionTest.this.fileFolderService.create(folder, name + "-1001", ContentModel.TYPE_FOLDER).getNodeRef();
                AbstractReadPermissionTest.this.permissionService.setPermission(folder_1001, authority, "Read", true);
                AbstractReadPermissionTest.this.permissionService.setInheritParentPermissions(folder_1001, false);
                for (int j = 0; j < 1000; ++j) {
                    NodeRef file = AbstractReadPermissionTest.this.fileFolderService.create(folder_1001, name + "-1001-" + j, ContentModel.TYPE_CONTENT).getNodeRef();
                    AbstractReadPermissionTest.this.permissionService.setInheritParentPermissions(file, false);
                    AbstractReadPermissionTest.this.permissionService.setPermission(file, authority, "Read", false);
                }
                return null;
            }
        };
        this.retryingTransactionHelper.doInTransaction(cb, false, false);
    }

    protected void buildNodes() {
        final Random random = new Random(42L);
        this.runAs("admin");
        this.permissionService.setPermission(this.rootNodeRef, "GROUP_EVERYONE", "Read", true);
        int ii = 0;
        while (ii < this.COUNT) {
            final String namePrefix = "name" + System.currentTimeMillis() + "-";
            final int i = ii++;
            System.out.println("Loop " + i);
            RetryingTransactionHelper.RetryingTransactionCallback<Void> cb = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                @Override
                public Void execute() throws Throwable {
                    NodeRef rf;
                    NodeRef file;
                    NodeRef folder = AbstractReadPermissionTest.this.fileFolderService.create(AbstractReadPermissionTest.this.rootNodeRef, namePrefix + i, ContentModel.TYPE_FOLDER).getNodeRef();
                    NodeRef folder_1000 = AbstractReadPermissionTest.this.fileFolderService.create(folder, namePrefix + "1000-" + i, ContentModel.TYPE_FOLDER).getNodeRef();
                    AbstractReadPermissionTest.this.permissionService.setPermission(folder_1000, "1000", "Read", true);
                    AbstractReadPermissionTest.this.permissionService.setInheritParentPermissions(folder_1000, false);
                    for (int j = 0; j < 1000; ++j) {
                        NodeRef file2 = AbstractReadPermissionTest.this.fileFolderService.create(folder_1000, namePrefix + "1000-" + i + "-" + j, ContentModel.TYPE_CONTENT).getNodeRef();
                    }
                    NodeRef folder_100 = AbstractReadPermissionTest.this.fileFolderService.create(folder, namePrefix + "100-" + i, ContentModel.TYPE_FOLDER).getNodeRef();
                    AbstractReadPermissionTest.this.permissionService.setPermission(folder_100, "100", "Read", true);
                    AbstractReadPermissionTest.this.permissionService.setInheritParentPermissions(folder_100, false);
                    for (int j = 0; j < 100; ++j) {
                        NodeRef file3 = AbstractReadPermissionTest.this.fileFolderService.create(folder_100, namePrefix + "100-" + i + "-" + j, ContentModel.TYPE_CONTENT).getNodeRef();
                    }
                    NodeRef folder_10 = AbstractReadPermissionTest.this.fileFolderService.create(folder, namePrefix + "10-" + i, ContentModel.TYPE_FOLDER).getNodeRef();
                    AbstractReadPermissionTest.this.permissionService.setPermission(folder_10, "10", "Read", true);
                    AbstractReadPermissionTest.this.permissionService.setInheritParentPermissions(folder_10, false);
                    for (int j = 0; j < 10; ++j) {
                        NodeRef file4 = AbstractReadPermissionTest.this.fileFolderService.create(folder_10, namePrefix + "10-" + i + "-" + j, ContentModel.TYPE_CONTENT).getNodeRef();
                    }
                    NodeRef folder_10_1 = AbstractReadPermissionTest.this.fileFolderService.create(folder, namePrefix + "10_1-" + i, ContentModel.TYPE_FOLDER).getNodeRef();
                    AbstractReadPermissionTest.this.permissionService.setPermission(folder_10_1, "GROUP_X", "Read", true);
                    AbstractReadPermissionTest.this.permissionService.setInheritParentPermissions(folder_10_1, false);
                    for (int j = 0; j < 10; ++j) {
                        file = AbstractReadPermissionTest.this.fileFolderService.create(folder_10_1, "namePrefix + 10_1-" + i + "-" + j, ContentModel.TYPE_CONTENT).getNodeRef();
                    }
                    NodeRef folder_1 = AbstractReadPermissionTest.this.fileFolderService.create(folder, namePrefix + "1" + i, ContentModel.TYPE_FOLDER).getNodeRef();
                    AbstractReadPermissionTest.this.permissionService.setPermission(folder_1, "1", "Read", true);
                    AbstractReadPermissionTest.this.permissionService.setInheritParentPermissions(folder_1, false);
                    file = AbstractReadPermissionTest.this.fileFolderService.create(folder_1, namePrefix + "1-1-1", ContentModel.TYPE_CONTENT).getNodeRef();
                    double rn = random.nextDouble();
                    if (rn < 0.1) {
                        rf = AbstractReadPermissionTest.this.fileFolderService.create(folder, namePrefix + "0.1", ContentModel.TYPE_CONTENT).getNodeRef();
                        AbstractReadPermissionTest.this.c01.increment();
                    }
                    if (rn < 0.01) {
                        rf = AbstractReadPermissionTest.this.fileFolderService.create(folder, namePrefix + "0.01", ContentModel.TYPE_CONTENT).getNodeRef();
                        AbstractReadPermissionTest.this.c001.increment();
                    }
                    if (rn < 0.001) {
                        rf = AbstractReadPermissionTest.this.fileFolderService.create(folder, namePrefix + "0.001", ContentModel.TYPE_CONTENT).getNodeRef();
                        AbstractReadPermissionTest.this.c0001.increment();
                    }
                    return null;
                }
            };
            this.retryingTransactionHelper.doInTransaction(cb, false, false);
        }
    }

    protected void setupBasicTree(final String authority) throws Exception {
        this.runAs("admin");
        final String[] dirs = new String[]{"a", "a/b", "a/b/c", "a/b/c/d", "e", "e/f", "e/f/g", "e/f/g/h", "x", "x/y"};
        for (int j = 0; j < dirs.length; ++j) {
            String file;
            String dir;
            String path = dirs[j];
            int k = path.lastIndexOf(47);
            if (k == -1) {
                dir = "";
                file = path;
            } else {
                dir = path.substring(0, k);
                file = path.substring(k + 1);
            }
            this.fService.createDirectory(this.AVMStore + ":/" + dir, file);
        }
        AVMNodeDescriptor nodeDesc = this.fService.lookup(-1, this.AVMStore + ":/");
        NodeRef nodeRef = AVMNodeConverter.ToNodeRef(-1, nodeDesc.getPath());
        RetryingTransactionHelper.RetryingTransactionCallback<Void> cb = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                for (int i = 0; i < 100; ++i) {
                    if (i % 100 == 0) {
                        System.out.println("Loop " + i);
                    }
                    int j = i % AbstractReadPermissionTest.this.webAuthorities.length;
                    String dir = AbstractReadPermissionTest.this.AVMStore + ":/" + dirs[i % 10];
                    String file = "foo" + i;
                    String path = dir + "/" + file;
                    AbstractReadPermissionTest.this.fService.createFile(dir, file).close();
                    ContentWriter writer = AbstractReadPermissionTest.this.fService.getContentWriter(path, true);
                    writer.setEncoding("UTF-8");
                    writer.setMimetype("text/plain");
                    writer.putContent("I am main");
                    NodeRef nodeRef = AVMNodeConverter.ToNodeRef(-1, path);
                    AbstractReadPermissionTest.this.permissionService.setPermission(nodeRef, authority, "Read", true);
                    AbstractReadPermissionTest.this.permissionService.setInheritParentPermissions(nodeRef, false);
                }
                return null;
            }
        };
        this.retryingTransactionHelper.doInTransaction(cb, false, false);
        this.fService.createSnapshot(this.AVMStore, null, null);
    }

    protected void deleteAuthentication(String name) {
        if (this.authenticationDAO.userExists(name)) {
            this.authenticationService.deleteAuthentication(name);
        }
        if (this.personService.personExists(name)) {
            this.personService.deletePerson(name);
        }
    }

    public void setUp() throws Exception {
        if (AlfrescoTransactionSupport.getTransactionReadState() != AlfrescoTransactionSupport.TxnReadState.TXN_NONE) {
            throw new AlfrescoRuntimeException("A previous tests did not clean up transaction: " + AlfrescoTransactionSupport.getTransactionId());
        }
        this.nodeService = (NodeService)applicationContext.getBean("nodeService");
        this.dictionaryService = (DictionaryService)applicationContext.getBean(ServiceRegistry.DICTIONARY_SERVICE.getLocalName());
        this.permissionService = (PermissionServiceSPI)applicationContext.getBean("permissionService");
        this.namespacePrefixResolver = (NamespacePrefixResolver)applicationContext.getBean(ServiceRegistry.NAMESPACE_SERVICE.getLocalName());
        this.authenticationService = (MutableAuthenticationService)applicationContext.getBean("authenticationService");
        this.authenticationComponent = (AuthenticationComponent)applicationContext.getBean("authenticationComponent");
        this.serviceRegistry = (ServiceRegistry)applicationContext.getBean("ServiceRegistry");
        this.permissionModelDAO = (ModelDAO)applicationContext.getBean("permissionsModelDAO");
        this.personService = (PersonService)applicationContext.getBean("personService");
        this.authorityService = (AuthorityService)applicationContext.getBean("authorityService");
        this.authorityDAO = (AuthorityDAO)applicationContext.getBean("authorityDAO");
        this.accessControlListDao = (AccessControlListDAO)applicationContext.getBean("admNodeACLDAO");
        this.fileFolderService = (FileFolderService)applicationContext.getBean("fileFolderService");
        this.authenticationComponent.setCurrentUser(this.authenticationComponent.getSystemUserName());
        this.authenticationDAO = (MutableAuthenticationDao)applicationContext.getBean("authenticationDao");
        this.nodeDAO = (NodeDAO)applicationContext.getBean("nodeDAO");
        this.aclDaoComponent = (AclDAO)applicationContext.getBean("aclDAO");
        this.retryingTransactionHelper = (RetryingTransactionHelper)applicationContext.getBean("retryingTransactionHelper");
        this.transactionService = (TransactionService)applicationContext.getBean("transactionComponent");
        this.ownableService = (OwnableService)applicationContext.getBean("ownableService");
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        StoreRef storeRef = this.nodeService.createStore("workspace", "Test_" + System.nanoTime());
        this.rootNodeRef = this.nodeService.getRootNode(storeRef);
        if (this.authenticationDAO.userExists("andy")) {
            this.authenticationService.deleteAuthentication("andy");
        }
        this.authenticationService.createAuthentication("andy", "andy".toCharArray());
        if (this.authenticationDAO.userExists("lemur")) {
            this.authenticationService.deleteAuthentication("lemur");
        }
        this.authenticationService.createAuthentication("lemur", "lemur".toCharArray());
        if (this.authenticationDAO.userExists(AuthenticationUtil.getAdminUserName())) {
            this.authenticationService.deleteAuthentication(AuthenticationUtil.getAdminUserName());
        }
        this.authenticationService.createAuthentication(AuthenticationUtil.getAdminUserName(), "admin".toCharArray());
        this.fService = (AVMService)applicationContext.getBean("AVMService");
        this.fIndexerAndSearcher = (IndexerAndSearcher)applicationContext.getBean("indexerAndSearcherFactory");
        this.wpService = (WebProjectService)applicationContext.getBean("WebProjectService");
        if (this.fService.getStore(this.AVMStore) != null) {
            this.fService.purgeStore(this.AVMStore);
        }
        this.fService.createStore(this.AVMStore);
        for (String authority : this.authorities) {
            this.createAuthentication(authority);
        }
        for (String authority : this.webAuthorities) {
            this.createAuthentication(authority);
        }
        this.createGroup("X");
        this.authorityService.addAuthority(this.authorityService.getName(AuthorityType.GROUP, "X"), "10_1");
        this.authenticationComponent.clearCurrentSecurityContext();
    }

    protected void tearDown() throws Exception {
        try {
            this.testTX.rollback();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        AuthenticationUtil.clearCurrentSecurityContext();
        super.tearDown();
    }

    protected class Counter {
        int i = 0;

        protected Counter() {
        }

        void increment() {
            ++this.i;
        }

        int count() {
            return this.i;
        }
    }
}

