/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.template;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.template.TemplateContent;
import org.alfresco.repo.template.TemplateNode;
import org.alfresco.repo.template.TemplateNodeRef;
import org.alfresco.repo.template.TemplateProperties;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.FileTypeImageSize;
import org.alfresco.service.cmr.repository.NoTransformerException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.TemplateImageResolver;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.service.cmr.webdav.WebDavService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.ISO9075;
import org.springframework.extensions.surf.util.URLEncoder;

public abstract class BaseContentNode
implements TemplateContent {
    protected static final String CONTENT_GET_URL = "/d/d/{0}/{1}/{2}/{3}";
    protected static final String CONTENT_GET_PROP_URL = "/d/d/{0}/{1}/{2}/{3}?property={4}";
    protected static final String CONTENT_DOWNLOAD_URL = "/d/a/{0}/{1}/{2}/{3}";
    protected static final String CONTENT_DOWNLOAD_PROP_URL = "/d/a/{0}/{1}/{2}/{3}?property={4}";
    protected static final String CONTENT_SERVICE_GET_URL = "/api/node/content/{0}/{1}/{2}/{3}";
    protected static final String CONTENT_SERVICE_GET_PROP_URL = "/api/node/content;{4}/{0}/{1}/{2}/{3}";
    protected static final String FOLDER_BROWSE_URL = "/n/browse/{0}/{1}/{2}";
    protected static final String NAMESPACE_BEGIN = "{";
    protected List<TemplateProperties> children = null;
    protected ServiceRegistry services = null;
    protected TemplateImageResolver imageResolver = null;
    protected Set<QName> aspects = null;
    private String displayPath = null;
    private Boolean isDocument = null;
    private Boolean isContainer = null;
    private Boolean isLinkToDocument = null;
    private Boolean isLinkToContainer = null;
    private Boolean hasChildren = null;
    private String siteName;
    private boolean siteNameResolved = false;

    public boolean getIsContainer() {
        if (this.isContainer == null) {
            DictionaryService dd = this.services.getDictionaryService();
            this.isContainer = dd.isSubClass(this.getType(), ContentModel.TYPE_FOLDER) && !dd.isSubClass(this.getType(), ContentModel.TYPE_SYSTEM_FOLDER);
        }
        return this.isContainer;
    }

    public boolean getIsDocument() {
        if (this.isDocument == null) {
            DictionaryService dd = this.services.getDictionaryService();
            this.isDocument = dd.isSubClass(this.getType(), ContentModel.TYPE_CONTENT);
        }
        return this.isDocument;
    }

    public boolean getIsLinkToContainer() {
        if (this.isLinkToContainer == null) {
            DictionaryService dd = this.services.getDictionaryService();
            this.isLinkToContainer = dd.isSubClass(this.getType(), ApplicationModel.TYPE_FOLDERLINK);
        }
        return this.isLinkToContainer;
    }

    public boolean getIsLinkToDocument() {
        if (this.isLinkToDocument == null) {
            DictionaryService dd = this.services.getDictionaryService();
            this.isLinkToDocument = dd.isSubClass(this.getType(), ApplicationModel.TYPE_FILELINK);
        }
        return this.isLinkToDocument;
    }

    public String toString() {
        if (this.services.getNodeService().exists(this.getNodeRef())) {
            return "Node Type: " + this.getType() + "\tNode Ref: " + this.getNodeRef().toString();
        }
        return "Node no longer exists: " + this.getNodeRef();
    }

    public String getQnamePath() {
        return this.services.getNodeService().getPath(this.getNodeRef()).toPrefixString((NamespacePrefixResolver)this.services.getNamespaceService());
    }

    public String getIcon16() {
        if (this.imageResolver != null) {
            if (this.getIsDocument()) {
                return this.imageResolver.resolveImagePathForName(this.getName(), FileTypeImageSize.Small);
            }
            String icon = (String)((Object)this.getProperties().get("app:icon"));
            if (icon != null) {
                return "/images/icons/" + icon + "-16.gif";
            }
            return "/images/icons/space-icon-default-16.gif";
        }
        return "/images/filetypes/_default.gif";
    }

    public String getIcon32() {
        if (this.imageResolver != null) {
            if (this.getIsDocument()) {
                return this.imageResolver.resolveImagePathForName(this.getName(), FileTypeImageSize.Medium);
            }
            String icon = (String)((Object)this.getProperties().get("app:icon"));
            if (icon != null) {
                return "/images/icons/" + icon + ".gif";
            }
            return "/images/icons/space-icon-default.gif";
        }
        return "/images/filetypes32/_default.gif";
    }

    public String getIcon64() {
        if (this.imageResolver != null) {
            if (this.getIsDocument()) {
                return this.imageResolver.resolveImagePathForName(this.getName(), FileTypeImageSize.Large);
            }
            String icon = (String)((Object)this.getProperties().get("app:icon"));
            if (icon != null) {
                return "/images/icons/" + icon + "-64.png";
            }
            return "/images/icons/space-icon-default-64.png";
        }
        return "/images/filetypes64/_default.gif";
    }

    public String getDisplayPath() {
        if (this.displayPath == null) {
            this.displayPath = this.services.getNodeService().getPath(this.getNodeRef()).toDisplayPath(this.services.getNodeService(), this.services.getPermissionService());
        }
        return this.displayPath;
    }

    @Override
    public List<TemplateProperties> getChildren() {
        if (this.children == null) {
            List childRefs = this.services.getNodeService().getChildAssocs(this.getNodeRef());
            this.children = new ArrayList<TemplateProperties>(childRefs.size());
            for (ChildAssociationRef ref : childRefs) {
                TemplateNode child = new TemplateNode(ref.getChildRef(), this.services, this.imageResolver);
                this.children.add(child);
            }
            this.hasChildren = childRefs.size() != 0;
        }
        return this.children;
    }

    public boolean getHasChildren() {
        if (this.hasChildren == null) {
            this.hasChildren = !this.services.getNodeService().getChildAssocs(this.getNodeRef(), RegexQNamePattern.MATCH_ALL, RegexQNamePattern.MATCH_ALL, false).isEmpty();
        }
        return this.hasChildren;
    }

    @Override
    public Set<QName> getAspects() {
        if (this.aspects == null) {
            this.aspects = this.services.getNodeService().getAspects(this.getNodeRef());
        }
        return this.aspects;
    }

    @Override
    public boolean hasAspect(String aspect) {
        if (this.aspects == null) {
            this.getAspects();
        }
        if (aspect.startsWith(NAMESPACE_BEGIN)) {
            return this.aspects.contains(QName.createQName((String)aspect));
        }
        boolean found = false;
        for (QName qname : this.aspects) {
            if (!qname.toPrefixString((NamespacePrefixResolver)this.services.getNamespaceService()).equals(aspect)) continue;
            found = true;
            break;
        }
        return found;
    }

    @Override
    public String getContent() {
        TemplateContentData content = (TemplateContentData)this.getProperties().get(ContentModel.PROP_CONTENT);
        return content != null ? content.getContent() : "";
    }

    @Override
    public String getUrl() {
        if (this.getIsDocument()) {
            TemplateContentData content = (TemplateContentData)this.getProperties().get(ContentModel.PROP_CONTENT);
            return content != null ? content.getUrl() : "";
        }
        return MessageFormat.format(FOLDER_BROWSE_URL, this.getNodeRef().getStoreRef().getProtocol(), this.getNodeRef().getStoreRef().getIdentifier(), this.getNodeRef().getId());
    }

    @Override
    public String getDownloadUrl() {
        if (this.getIsDocument()) {
            TemplateContentData content = (TemplateContentData)this.getProperties().get(ContentModel.PROP_CONTENT);
            return content != null ? content.getDownloadUrl() : "";
        }
        return "";
    }

    public String getServiceUrl() {
        if (this.getIsDocument()) {
            TemplateContentData content = (TemplateContentData)this.getProperties().get(ContentModel.PROP_CONTENT);
            return content != null ? content.getServiceUrl() : "";
        }
        return "";
    }

    public String getWebdavUrl() {
        WebDavService webDavService = this.services.getWebDavService();
        return webDavService.getWebdavUrl(this.getNodeRef());
    }

    @Override
    public String getMimetype() {
        TemplateContentData content = (TemplateContentData)this.getProperties().get(ContentModel.PROP_CONTENT);
        return content != null ? content.getMimetype() : null;
    }

    public String getDisplayMimetype() {
        TemplateContentData content = (TemplateContentData)this.getProperties().get(ContentModel.PROP_CONTENT);
        return content != null ? content.getDisplayMimetype() : null;
    }

    public String getEncoding() {
        TemplateContentData content = (TemplateContentData)this.getProperties().get(ContentModel.PROP_CONTENT);
        return content != null ? content.getEncoding() : null;
    }

    @Override
    public long getSize() {
        TemplateContentData content = (TemplateContentData)this.getProperties().get(ContentModel.PROP_CONTENT);
        return content != null ? content.getSize() : 0L;
    }

    public boolean isTemplateContent(Object o) {
        return o instanceof TemplateContentData;
    }

    public boolean isTemplateNodeRef(Object o) {
        return o instanceof TemplateNodeRef;
    }

    public String getSiteShortName() {
        if (!this.siteNameResolved) {
            this.siteNameResolved = true;
            Path path = this.services.getNodeService().getPath(this.getNodeRef());
            for (int i = 0; i < path.size(); ++i) {
                if (!"st:sites".equals(path.get(i).getPrefixedString((NamespacePrefixResolver)this.services.getNamespaceService()))) continue;
                if (i + 1 >= path.size()) break;
                Path.Element siteName = path.get(i + 1);
                this.siteName = ISO9075.decode((String)siteName.getPrefixedString((NamespacePrefixResolver)this.services.getNamespaceService()).substring(3));
                break;
            }
        }
        return this.siteName;
    }

    public class TemplateContentData
    implements Serializable {
        private ContentData contentData;
        private QName property;

        public TemplateContentData(ContentData contentData, QName property) {
            this.contentData = contentData;
            this.property = property;
        }

        public String getContent() {
            ContentService contentService = BaseContentNode.this.services.getContentService();
            ContentReader reader = contentService.getReader(BaseContentNode.this.getNodeRef(), this.property);
            return reader != null && reader.exists() ? reader.getContentString() : "";
        }

        public String getContentMaxLength(int length) {
            ContentService contentService = BaseContentNode.this.services.getContentService();
            ContentReader reader = contentService.getReader(BaseContentNode.this.getNodeRef(), this.property);
            return reader != null && reader.exists() ? reader.getContentString(length) : "";
        }

        public String getContentAsText(int length) {
            String result = null;
            if ("text/plain".equals(this.getMimetype())) {
                result = this.getContentMaxLength(length);
            } else {
                NodeRef nodeRef;
                ContentService contentService = BaseContentNode.this.services.getContentService();
                ContentReader reader = contentService.getReader(nodeRef = BaseContentNode.this.getNodeRef(), this.property);
                if (reader == null) {
                    return "";
                }
                ContentWriter writer = contentService.getTempWriter();
                writer.setMimetype("text/plain");
                writer.setEncoding(reader.getEncoding());
                TransformationOptions options = new TransformationOptions();
                options.setSourceNodeRef(nodeRef);
                try {
                    contentService.transform(reader, writer, options);
                    ContentReader resultReader = writer.getReader();
                    if (resultReader != null && reader.exists()) {
                        result = length != -1 ? resultReader.getContentString(length) : resultReader.getContentString();
                    }
                }
                catch (NoTransformerException e) {
                    // empty catch block
                }
            }
            return result;
        }

        public String getUrl() {
            if (ContentModel.PROP_CONTENT.equals((Object)this.property)) {
                return this.buildUrl(BaseContentNode.CONTENT_GET_URL);
            }
            return this.buildPropUrl(BaseContentNode.CONTENT_GET_PROP_URL);
        }

        public String getDownloadUrl() {
            if (ContentModel.PROP_CONTENT.equals((Object)this.property)) {
                return this.buildUrl(BaseContentNode.CONTENT_DOWNLOAD_URL);
            }
            return this.buildPropUrl(BaseContentNode.CONTENT_DOWNLOAD_PROP_URL);
        }

        public String getServiceUrl() {
            if (ContentModel.PROP_CONTENT.equals((Object)this.property)) {
                return this.buildUrl(BaseContentNode.CONTENT_SERVICE_GET_URL);
            }
            return this.buildPropUrl(BaseContentNode.CONTENT_SERVICE_GET_PROP_URL);
        }

        private String buildUrl(String format) {
            return MessageFormat.format(format, BaseContentNode.this.getNodeRef().getStoreRef().getProtocol(), BaseContentNode.this.getNodeRef().getStoreRef().getIdentifier(), BaseContentNode.this.getNodeRef().getId(), URLEncoder.encode((String)BaseContentNode.this.getName()));
        }

        private String buildPropUrl(String pformat) {
            return MessageFormat.format(pformat, BaseContentNode.this.getNodeRef().getStoreRef().getProtocol(), BaseContentNode.this.getNodeRef().getStoreRef().getIdentifier(), BaseContentNode.this.getNodeRef().getId(), URLEncoder.encode((String)BaseContentNode.this.getName()), URLEncoder.encode((String)this.property.toString()));
        }

        public long getSize() {
            return this.contentData.getSize();
        }

        public String getMimetype() {
            return this.contentData.getMimetype();
        }

        public String getDisplayMimetype() {
            return (String)BaseContentNode.this.services.getMimetypeService().getDisplaysByMimetype().get(this.getMimetype());
        }

        public String getEncoding() {
            return this.contentData.getEncoding();
        }
    }
}

