/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.thumbnail;

import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.ContentServicePolicies;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockStatus;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.thumbnail.FailedThumbnailInfo;
import org.alfresco.service.cmr.thumbnail.ThumbnailService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FailedThumbnailSourceAspect
implements NodeServicePolicies.OnDeleteNodePolicy,
ContentServicePolicies.OnContentUpdatePolicy {
    private static final Log log = LogFactory.getLog(FailedThumbnailSourceAspect.class);
    private BehaviourFilter behaviourFilter;
    private NodeService nodeService;
    private PolicyComponent policyComponent;
    private LockService lockService;
    private ThumbnailService thumbnailService;

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setThumbnailService(ThumbnailService thumbnailService) {
        this.thumbnailService = thumbnailService;
    }

    public void setLockService(LockService lockService) {
        this.lockService = lockService;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnDeleteNodePolicy.QNAME, ContentModel.TYPE_FAILED_THUMBNAIL, (Behaviour)new JavaBehaviour(this, "onDeleteNode", Behaviour.NotificationFrequency.EVERY_EVENT));
        this.policyComponent.bindClassBehaviour(ContentServicePolicies.OnContentUpdatePolicy.QNAME, ContentModel.ASPECT_FAILED_THUMBNAIL_SOURCE, (Behaviour)new JavaBehaviour(this, "onContentUpdate", Behaviour.NotificationFrequency.TRANSACTION_COMMIT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDeleteNode(ChildAssociationRef childAssocRef, boolean isNodeArchived) {
        Map<String, FailedThumbnailInfo> failures = this.thumbnailService.getFailedThumbnails(childAssocRef.getParentRef());
        if (failures.isEmpty()) {
            if (log.isDebugEnabled()) {
                StringBuilder msg = new StringBuilder();
                msg.append("No remaining failedThumbnail children of ").append(childAssocRef.getParentRef()).append(" therefore removing aspect ").append(ContentModel.ASPECT_FAILED_THUMBNAIL_SOURCE);
                log.debug((Object)msg.toString());
            }
            this.behaviourFilter.disableBehaviour(childAssocRef.getParentRef(), ContentModel.ASPECT_AUDITABLE);
            try {
                this.nodeService.removeAspect(childAssocRef.getParentRef(), ContentModel.ASPECT_FAILED_THUMBNAIL_SOURCE);
            }
            finally {
                this.behaviourFilter.enableBehaviour(childAssocRef.getParentRef(), ContentModel.ASPECT_AUDITABLE);
            }
        }
    }

    @Override
    public void onContentUpdate(final NodeRef nodeRef, boolean newContent) {
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() {
                if (FailedThumbnailSourceAspect.this.nodeService.exists(nodeRef) && FailedThumbnailSourceAspect.this.lockService.getLockStatus(nodeRef) != LockStatus.LOCKED) {
                    FailedThumbnailSourceAspect.this.deleteFailedThumbnailChildren(nodeRef);
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteFailedThumbnailChildren(NodeRef nodeRef) {
        Map<String, FailedThumbnailInfo> failedThumbnails = this.thumbnailService.getFailedThumbnails(nodeRef);
        this.behaviourFilter.disableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Deleting " + failedThumbnails.size() + " " + ContentModel.TYPE_FAILED_THUMBNAIL + " nodes"));
            }
            for (Map.Entry<String, FailedThumbnailInfo> entry : failedThumbnails.entrySet()) {
                FailedThumbnailInfo info = entry.getValue();
                this.nodeService.deleteNode(info.getFailedThumbnailNode());
            }
        }
        finally {
            this.behaviourFilter.enableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
        }
    }
}

