/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.thumbnail;

import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.ContentServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.thumbnail.ThumbnailDefinition;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.thumbnail.ThumbnailService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class SimpleThumbnailer
extends TransactionListenerAdapter
implements ContentServicePolicies.OnContentUpdatePolicy,
InitializingBean {
    private static final Log logger = LogFactory.getLog(SimpleThumbnailer.class);
    private static final String KEY_POST_TXN_NODES_TO_THUMBNAIL = "SimpleThumbnailer.KEY_POST_TXN_NODES_TO_THUMBNAIL";
    private PolicyComponent policyComponent;
    private NodeService nodeService;
    private TransactionService transactionService;
    private ThumbnailService thumbnailService;

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setThumbnailService(ThumbnailService thumbnailService) {
        this.thumbnailService = thumbnailService;
    }

    public void afterPropertiesSet() {
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onContentUpdate"), this, (Behaviour)new JavaBehaviour(this, "onContentUpdate"));
    }

    @Override
    public void onContentUpdate(NodeRef nodeRef, boolean newContent) {
        if (!this.nodeService.getType(nodeRef).equals((Object)ContentModel.TYPE_THUMBNAIL) && this.nodeService.getProperty(nodeRef, ContentModel.PROP_CONTENT) != null) {
            AlfrescoTransactionSupport.bindListener(this);
            this.getPostTxnNodesToThumbnail().add(nodeRef);
        }
    }

    @Override
    public void afterCommit() {
        for (final NodeRef nodeRef : this.getPostTxnNodesToThumbnail()) {
            Serializable value;
            ContentData contentData;
            if (!this.nodeService.exists(nodeRef) || (contentData = (ContentData)DefaultTypeConverter.INSTANCE.convert(ContentData.class, (Object)(value = this.nodeService.getProperty(nodeRef, ContentModel.PROP_CONTENT)))) == null) continue;
            List<ThumbnailDefinition> thumbnailDefinitions = this.thumbnailService.getThumbnailRegistry().getThumbnailDefinitions(contentData.getMimetype(), contentData.getSize());
            for (final ThumbnailDefinition thumbnailDefinition : thumbnailDefinitions) {
                final NodeRef existingThumbnail = this.thumbnailService.getThumbnailByName(nodeRef, ContentModel.PROP_CONTENT, thumbnailDefinition.getName());
                try {
                    this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                        @Override
                        public Object execute() throws Throwable {
                            if (existingThumbnail == null) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("Creating thumbnail \"" + thumbnailDefinition.getName() + "\" for node " + nodeRef.getId()));
                                }
                                SimpleThumbnailer.this.thumbnailService.createThumbnail(nodeRef, ContentModel.PROP_CONTENT, thumbnailDefinition.getMimetype(), thumbnailDefinition.getTransformationOptions(), thumbnailDefinition.getName());
                            } else {
                                logger.debug((Object)("Updating thumbnail \"" + thumbnailDefinition.getName() + "\" for node " + nodeRef.getId()));
                                SimpleThumbnailer.this.thumbnailService.updateThumbnail(existingThumbnail, thumbnailDefinition.getTransformationOptions());
                            }
                            return null;
                        }
                    }, false, true);
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to generate thumbnail \"" + thumbnailDefinition.getName() + "\" for node " + nodeRef.getId()), (Throwable)e);
                }
            }
        }
    }

    private Set<NodeRef> getPostTxnNodesToThumbnail() {
        LinkedHashSet nodesToThumbnail = (LinkedHashSet)AlfrescoTransactionSupport.getResource(KEY_POST_TXN_NODES_TO_THUMBNAIL);
        if (nodesToThumbnail == null) {
            nodesToThumbnail = new LinkedHashSet(11);
            AlfrescoTransactionSupport.bindResource(KEY_POST_TXN_NODES_TO_THUMBNAIL, nodesToThumbnail);
        }
        return nodesToThumbnail;
    }
}

