/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.thumbnail;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.content.transform.TransformerDebug;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.Tenant;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.thumbnail.ThumbnailDefinition;
import org.alfresco.repo.thumbnail.ThumbnailRenditionConvertor;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.rendition.RenditionDefinition;
import org.alfresco.service.cmr.rendition.RenditionService;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.service.cmr.thumbnail.ThumbnailException;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public class ThumbnailRegistry
implements ApplicationContextAware,
ApplicationListener<ApplicationContextEvent> {
    private static Log logger = LogFactory.getLog(ThumbnailRegistry.class);
    private ContentService contentService;
    private TransactionService transactionService;
    private RenditionService renditionService;
    private TenantAdminService tenantAdminService;
    private Map<String, ThumbnailDefinition> thumbnailDefinitions = new HashMap<String, ThumbnailDefinition>();
    private Map<String, List<ThumbnailDefinitionLimits>> mimetypeMap = new HashMap<String, List<ThumbnailDefinitionLimits>>(17);
    private ThumbnailRenditionConvertor thumbnailRenditionConvertor;
    private RegistryLifecycle lifecycle = new RegistryLifecycle();

    public void setThumbnailRenditionConvertor(ThumbnailRenditionConvertor thumbnailRenditionConvertor) {
        this.thumbnailRenditionConvertor = thumbnailRenditionConvertor;
    }

    public ThumbnailRenditionConvertor getThumbnailRenditionConvertor() {
        return this.thumbnailRenditionConvertor;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setRenditionService(RenditionService renditionService) {
        this.renditionService = renditionService;
    }

    public void setTenantAdminService(TenantAdminService tenantAdminService) {
        this.tenantAdminService = tenantAdminService;
    }

    public void setThumbnailDefinitions(List<ThumbnailDefinition> thumbnailDefinitions) {
        for (ThumbnailDefinition td : thumbnailDefinitions) {
            String thumbnailName = td.getName();
            if (thumbnailName == null) {
                throw new ThumbnailException("When adding a thumbnail details object make sure the name is set.");
            }
            this.thumbnailDefinitions.put(thumbnailName, td);
        }
    }

    public void initThumbnailDefinitions() {
        RetryingTransactionHelper transactionHelper = this.transactionService.getRetryingTransactionHelper();
        transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                for (String thumbnailDefName : ThumbnailRegistry.this.thumbnailDefinitions.keySet()) {
                    ThumbnailDefinition thumbnailDefinition = (ThumbnailDefinition)ThumbnailRegistry.this.thumbnailDefinitions.get(thumbnailDefName);
                    RenditionDefinition renditionDef = ThumbnailRegistry.this.thumbnailRenditionConvertor.convert(thumbnailDefinition, null);
                    ThumbnailRegistry.this.renditionService.saveRenditionDefinition(renditionDef);
                }
                return null;
            }
        });
    }

    public List<ThumbnailDefinition> getThumbnailDefinitions() {
        return new ArrayList<ThumbnailDefinition>(this.thumbnailDefinitions.values());
    }

    public List<ThumbnailDefinition> getThumbnailDefinitions(String mimetype) {
        return this.getThumbnailDefinitions(mimetype, -1L);
    }

    public List<ThumbnailDefinition> getThumbnailDefinitions(String mimetype, long sourceSize) {
        long maxSourceSizeBytes;
        List<ThumbnailDefinitionLimits> thumbnailDefinitionsLimitsForMimetype = this.mimetypeMap.get(mimetype);
        if (thumbnailDefinitionsLimitsForMimetype == null) {
            boolean foundAtLeastOneTransformer = false;
            thumbnailDefinitionsLimitsForMimetype = new ArrayList<ThumbnailDefinitionLimits>(7);
            for (ThumbnailDefinition thumbnailDefinition : this.thumbnailDefinitions.values()) {
                maxSourceSizeBytes = this.getMaxSourceSizeBytes(mimetype, thumbnailDefinition);
                if (maxSourceSizeBytes == 0L) continue;
                thumbnailDefinitionsLimitsForMimetype.add(new ThumbnailDefinitionLimits(thumbnailDefinition, maxSourceSizeBytes));
                foundAtLeastOneTransformer = true;
            }
            if (foundAtLeastOneTransformer) {
                this.mimetypeMap.put(mimetype, thumbnailDefinitionsLimitsForMimetype);
            }
        }
        ArrayList<ThumbnailDefinition> result = new ArrayList<ThumbnailDefinition>(thumbnailDefinitionsLimitsForMimetype.size());
        for (ThumbnailDefinitionLimits thumbnailDefinitionLimits : thumbnailDefinitionsLimitsForMimetype) {
            maxSourceSizeBytes = thumbnailDefinitionLimits.getMaxSourceSizeBytes();
            if (sourceSize > 0L && maxSourceSizeBytes >= 0L && maxSourceSizeBytes < sourceSize) continue;
            result.add(thumbnailDefinitionLimits.getThumbnailDefinition());
        }
        return result;
    }

    @Deprecated
    public List<ThumbnailDefinition> getThumnailDefintions(String mimetype) {
        return this.getThumbnailDefinitions(mimetype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isThumbnailDefinitionAvailable(String sourceUrl, String sourceMimetype, long sourceSize, NodeRef sourceNodeRef, ThumbnailDefinition thumbnailDefinition) {
        TransformationOptions options = thumbnailDefinition.getTransformationOptions().deepCopy();
        options.setSourceNodeRef(sourceNodeRef);
        boolean orig = TransformerDebug.setDebugOutput(false);
        try {
            boolean bl = this.contentService.getTransformer(sourceUrl, sourceMimetype, sourceSize, thumbnailDefinition.getMimetype(), options) != null;
            return bl;
        }
        finally {
            TransformerDebug.setDebugOutput(orig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaxSourceSizeBytes(String sourceMimetype, ThumbnailDefinition thumbnailDefinition) {
        boolean orig = TransformerDebug.setDebugOutput(false);
        try {
            long l = this.contentService.getMaxSourceSizeBytes(sourceMimetype, thumbnailDefinition.getMimetype(), thumbnailDefinition.getTransformationOptions());
            return l;
        }
        finally {
            TransformerDebug.setDebugOutput(orig);
        }
    }

    public void addThumbnailDefinition(ThumbnailDefinition thumbnailDetails) {
        String thumbnailName = thumbnailDetails.getName();
        if (thumbnailName == null) {
            throw new ThumbnailException("When adding a thumbnail details object make sure the name is set.");
        }
        this.thumbnailDefinitions.put(thumbnailName, thumbnailDetails);
    }

    public ThumbnailDefinition getThumbnailDefinition(String thumbnailName) {
        return this.thumbnailDefinitions.get(thumbnailName);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.lifecycle.setApplicationContext(applicationContext);
    }

    public void onApplicationEvent(ApplicationContextEvent event) {
        this.lifecycle.onApplicationEvent((ApplicationEvent)event);
    }

    private class ThumbnailDefinitionLimits {
        private ThumbnailDefinition thumbnailDefinition;
        private long maxSourceSizeBytes;

        public ThumbnailDefinitionLimits(ThumbnailDefinition thumbnailDefinition, long maxSourceSizeBytes) {
            this.thumbnailDefinition = thumbnailDefinition;
            this.maxSourceSizeBytes = maxSourceSizeBytes;
        }

        public ThumbnailDefinition getThumbnailDefinition() {
            return this.thumbnailDefinition;
        }

        public long getMaxSourceSizeBytes() {
            return this.maxSourceSizeBytes;
        }
    }

    private class RegistryLifecycle
    extends AbstractLifecycleBean {
        private RegistryLifecycle() {
        }

        protected void onBootstrap(ApplicationEvent event) {
            long start = System.currentTimeMillis();
            if (ThumbnailRegistry.this.transactionService.isReadOnly()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"TransactionService is in read-only mode. Therefore no thumbnail definitions have been initialised.");
                }
                return;
            }
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                public Object doWork() throws Exception {
                    ThumbnailRegistry.this.initThumbnailDefinitions();
                    return null;
                }
            }, (String)AuthenticationUtil.getSystemUserName());
            if (ThumbnailRegistry.this.tenantAdminService.isEnabled()) {
                List<Tenant> tenants = ThumbnailRegistry.this.tenantAdminService.getAllTenants();
                for (Tenant tenant : tenants) {
                    AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                        public Object doWork() throws Exception {
                            ThumbnailRegistry.this.initThumbnailDefinitions();
                            return null;
                        }
                    }, (String)ThumbnailRegistry.this.tenantAdminService.getDomainUser(AuthenticationUtil.getSystemUserName(), tenant.getTenantDomain()));
                }
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Init'ed thumbnail defs in " + (System.currentTimeMillis() - start) + " ms"));
            }
        }

        protected void onShutdown(ApplicationEvent event) {
        }
    }
}

