/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.thumbnail;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.transform.magick.ImageResizeOptions;
import org.alfresco.repo.content.transform.magick.ImageTransformationOptions;
import org.alfresco.repo.content.transform.swf.SWFTransformationOptions;
import org.alfresco.repo.thumbnail.ThumbnailDefinition;
import org.alfresco.service.cmr.rendition.RenditionDefinition;
import org.alfresco.service.cmr.rendition.RenditionService;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.service.cmr.thumbnail.ThumbnailParentAssociationDetails;
import org.alfresco.service.namespace.QName;

public class ThumbnailRenditionConvertor {
    private RenditionService renditionService;

    public void setRenditionService(RenditionService renditionService) {
        this.renditionService = renditionService;
    }

    public RenditionDefinition convert(ThumbnailDefinition thumbnailDefinition, ThumbnailParentAssociationDetails assocDetails) {
        if (thumbnailDefinition == null || thumbnailDefinition.getName() == null || thumbnailDefinition.getName().trim().length() == 0) {
            throw new IllegalArgumentException("Thumbnail Definition and Name must be non-null and non-empty.");
        }
        TransformationOptions transformationOptions = thumbnailDefinition.getTransformationOptions();
        Map<String, Serializable> parameters = this.convert(transformationOptions, assocDetails);
        this.putParameterIfNotNull("mime-type", (Serializable)((Object)thumbnailDefinition.getMimetype()), parameters);
        this.putParameterIfNotNull("placeHolderResourcePath", (Serializable)((Object)thumbnailDefinition.getPlaceHolderResourcePath()), parameters);
        this.putParameterIfNotNull("runAs", (Serializable)((Object)thumbnailDefinition.getRunAs()), parameters);
        QName namespacedRenditionName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)thumbnailDefinition.getName());
        boolean isImageThumbnail = this.isImageBasedRendition(thumbnailDefinition);
        String renderingEngineName = isImageThumbnail ? "imageRenderingEngine" : "reformat";
        RenditionDefinition renditionDef = this.renditionService.createRenditionDefinition(namespacedRenditionName, renderingEngineName);
        for (String paramName : parameters.keySet()) {
            renditionDef.setParameterValue(paramName, parameters.get(paramName));
        }
        return renditionDef;
    }

    private boolean isImageBasedRendition(ThumbnailDefinition thumbnailDefinition) {
        TransformationOptions transformationOptions = thumbnailDefinition.getTransformationOptions();
        return transformationOptions != null && transformationOptions instanceof ImageTransformationOptions;
    }

    public Map<String, Serializable> convert(TransformationOptions transformationOptions, ThumbnailParentAssociationDetails assocDetails) {
        HashMap<String, Serializable> parameters = new HashMap<String, Serializable>();
        parameters.put("rendition-nodetype", (Serializable)ContentModel.TYPE_THUMBNAIL);
        this.putParameterIfNotNull("sourceContentProperty", (Serializable)transformationOptions.getSourceContentProperty(), parameters);
        this.putParameterIfNotNull("targetContentProperty", (Serializable)transformationOptions.getTargetContentProperty(), parameters);
        this.putParameterIfNotNull("rendition-destination-node", (Serializable)transformationOptions.getTargetNodeRef(), parameters);
        this.putParameterIfNotNull("timeoutMs", Long.valueOf(transformationOptions.getTimeoutMs()), parameters);
        this.putParameterIfNotNull("readLimitTimeMs", Long.valueOf(transformationOptions.getReadLimitTimeMs()), parameters);
        this.putParameterIfNotNull("maxSourceSizeKBytes", Long.valueOf(transformationOptions.getMaxSourceSizeKBytes()), parameters);
        this.putParameterIfNotNull("readLimitKBytes", Long.valueOf(transformationOptions.getReadLimitKBytes()), parameters);
        this.putParameterIfNotNull("maxPages", Integer.valueOf(transformationOptions.getMaxPages()), parameters);
        this.putParameterIfNotNull("pageLimit", Integer.valueOf(transformationOptions.getPageLimit()), parameters);
        if (transformationOptions instanceof SWFTransformationOptions) {
            SWFTransformationOptions swfTransformationOptions = (SWFTransformationOptions)transformationOptions;
            this.putParameterIfNotNull("flashVersion", (Serializable)((Object)swfTransformationOptions.getFlashVersion()), parameters);
        } else if (transformationOptions instanceof ImageTransformationOptions) {
            ImageTransformationOptions imTransformationOptions = (ImageTransformationOptions)transformationOptions;
            this.putParameterIfNotNull("commandOptions", (Serializable)((Object)imTransformationOptions.getCommandOptions()), parameters);
            this.putParameterIfNotNull("autoOrientation", Boolean.valueOf(imTransformationOptions.isAutoOrient()), parameters);
            ImageResizeOptions imgResizeOptions = imTransformationOptions.getResizeOptions();
            if (imgResizeOptions != null) {
                int width = imgResizeOptions.getWidth();
                parameters.put("xsize", Integer.valueOf(width));
                int height = imgResizeOptions.getHeight();
                parameters.put("ysize", Integer.valueOf(height));
                boolean maintainAspectRatio = imgResizeOptions.isMaintainAspectRatio();
                parameters.put("maintainAspectRatio", Boolean.valueOf(maintainAspectRatio));
                boolean percentResize = imgResizeOptions.isPercentResize();
                parameters.put("isAbsolute", Boolean.valueOf(percentResize));
                boolean resizeToThumbnail = imgResizeOptions.isResizeToThumbnail();
                parameters.put("resizeToThumbnail", Boolean.valueOf(resizeToThumbnail));
                boolean allowEnlargement = imgResizeOptions.getAllowEnlargement();
                parameters.put("allowEnlargement", Boolean.valueOf(allowEnlargement));
            }
        }
        return parameters;
    }

    private void putParameterIfNotNull(String paramName, Serializable paramValue, Map<String, Serializable> params) {
        if (paramValue != null) {
            params.put(paramName, paramValue);
        }
    }

    public ThumbnailDefinition convert(RenditionDefinition renditionDefinition) {
        ThumbnailDefinition thDefn = new ThumbnailDefinition();
        Map<String, Serializable> params = renditionDefinition.getParameterValues();
        Serializable mimeTypeParam = params.get("mime-type");
        thDefn.setMimetype((String)((Object)mimeTypeParam));
        thDefn.setName(renditionDefinition.getRenditionName().getLocalName());
        Serializable placeHolderResourcePathParam = params.get("placeHolderResourcePath");
        if (placeHolderResourcePathParam != null) {
            thDefn.setPlaceHolderResourcePath((String)((Object)placeHolderResourcePathParam));
        }
        TransformationOptions transformationOptions = null;
        Serializable flashVersion = renditionDefinition.getParameterValue("flashVersion");
        if (flashVersion != null) {
            TransformationOptions swfTranOpts = transformationOptions = new SWFTransformationOptions();
            ((SWFTransformationOptions)swfTranOpts).setFlashVersion((String)((Object)flashVersion));
        } else {
            Serializable allowEnlargement;
            Serializable resizeToThumbnail;
            Serializable maintainAspectRatio;
            Serializable ysize;
            transformationOptions = new ImageTransformationOptions();
            ImageTransformationOptions imgTrOpts = (ImageTransformationOptions)transformationOptions;
            ImageResizeOptions resizeOptions = new ImageResizeOptions();
            Serializable xsize = renditionDefinition.getParameterValue("xsize");
            if (xsize != null) {
                resizeOptions.setWidth(((Long)xsize).intValue());
            }
            if ((ysize = renditionDefinition.getParameterValue("ysize")) != null) {
                resizeOptions.setHeight(((Long)ysize).intValue());
            }
            if ((maintainAspectRatio = renditionDefinition.getParameterValue("maintainAspectRatio")) != null) {
                resizeOptions.setMaintainAspectRatio((Boolean)maintainAspectRatio);
            }
            if ((resizeToThumbnail = renditionDefinition.getParameterValue("resizeToThumbnail")) != null) {
                resizeOptions.setResizeToThumbnail((Boolean)resizeToThumbnail);
            }
            if ((allowEnlargement = renditionDefinition.getParameterValue("allowEnlargement")) != null) {
                resizeOptions.setAllowEnlargement((Boolean)allowEnlargement);
            }
            imgTrOpts.setResizeOptions(resizeOptions);
        }
        thDefn.setTransformationOptions(transformationOptions);
        return thDefn;
    }
}

