/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transaction;

import javax.transaction.RollbackException;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.repo.admin.SysAdminParams;
import org.alfresco.repo.security.authentication.AuthenticationContext;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionServiceImpl;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.ReadOnlyServerException;
import org.alfresco.util.ApplicationContextHelper;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.springframework.context.ApplicationContext;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.TransientDataAccessResourceException;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.transaction.PlatformTransactionManager;

public class TransactionServiceImplTest
extends TestCase {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private PlatformTransactionManager transactionManager;
    private TransactionServiceImpl transactionService;
    private NodeService nodeService;
    private final QName vetoName = QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)"TransactionServiceImplTest");
    private Dialect dialect;

    public void setUp() throws Exception {
        this.transactionManager = (PlatformTransactionManager)ctx.getBean("transactionManager");
        this.transactionService = new TransactionServiceImpl();
        this.transactionService.setTransactionManager(this.transactionManager);
        this.transactionService.setAllowWrite(true, this.vetoName);
        this.transactionService.setAuthenticationContext((AuthenticationContext)ctx.getBean("authenticationContext"));
        this.transactionService.setSysAdminParams((SysAdminParams)ctx.getBean("sysAdminParams"));
        this.nodeService = (NodeService)ctx.getBean("dbNodeService");
        this.dialect = (Dialect)ctx.getBean("dialect");
    }

    public void testPropagatingTxn() throws Exception {
        UserTransaction txnOuter = this.transactionService.getUserTransaction();
        txnOuter.begin();
        String txnIdOuter = AlfrescoTransactionSupport.getTransactionId();
        UserTransaction txnInner = this.transactionService.getUserTransaction();
        txnInner.begin();
        String txnIdInner = AlfrescoTransactionSupport.getTransactionId();
        TransactionServiceImplTest.assertEquals((String)"Txn ID not propagated", (String)txnIdOuter, (String)txnIdInner);
        txnInner.rollback();
        TransactionServiceImplTest.assertEquals((String)"Inner txn not marked rolled back", (int)4, (int)txnInner.getStatus());
        TransactionServiceImplTest.assertEquals((String)"Outer txn not marked for rolled back", (int)1, (int)txnOuter.getStatus());
        try {
            txnOuter.commit();
            TransactionServiceImplTest.fail((String)"Outer txn not marked for rollback");
        }
        catch (RollbackException e) {
            txnOuter.rollback();
        }
    }

    public void testNonPropagatingTxn() throws Exception {
        UserTransaction txnOuter = this.transactionService.getUserTransaction();
        txnOuter.begin();
        String txnIdOuter = AlfrescoTransactionSupport.getTransactionId();
        UserTransaction txnInner = this.transactionService.getNonPropagatingUserTransaction();
        txnInner.begin();
        String txnIdInner = AlfrescoTransactionSupport.getTransactionId();
        TransactionServiceImplTest.assertNotSame((String)"Txn ID not propagated", (Object)txnIdOuter, (Object)txnIdInner);
        txnInner.rollback();
        txnOuter.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadOnlyTxn() throws Exception {
        block28: {
            this.transactionService.setAllowWrite(false, this.vetoName);
            UserTransaction txn = this.transactionService.getUserTransaction();
            txn.begin();
            try {
                this.nodeService.createStore("workspace", this.getName() + "_" + System.currentTimeMillis());
                txn.commit();
                TransactionServiceImplTest.fail((String)"Read-only transaction wasn't detected");
            }
            catch (ReadOnlyServerException e) {
                boolean i = false;
            }
            catch (InvalidDataAccessApiUsageException e) {
                boolean i = false;
            }
            catch (TransientDataAccessResourceException e) {
                boolean i = false;
            }
            catch (IllegalStateException e) {
                boolean i = false;
            }
            catch (UncategorizedSQLException e) {
                if (this.dialect instanceof PostgreSQLDialect) {
                    boolean bl = false;
                    break block28;
                }
                throw e;
            }
            finally {
                this.transactionService.setAllowWrite(true, this.vetoName);
                try {
                    txn.rollback();
                }
                catch (Throwable e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadOnlyVetoTxn() throws Exception {
        QName v1 = QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)"V1");
        QName v2 = QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)"V2");
        QName v3 = QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)"V2");
        try {
            this.transactionService.setAllowWrite(false, v1);
            this.transactionService.setAllowWrite(false, v2);
            TransactionServiceImplTest.assertFalse((String)"v1 AND v2 veto not read only", (boolean)this.transactionService.getAllowWrite());
            this.transactionService.setAllowWrite(true, v2);
            TransactionServiceImplTest.assertFalse((String)"v1 not read only", (boolean)this.transactionService.getAllowWrite());
            this.transactionService.setAllowWrite(true, v1);
            TransactionServiceImplTest.assertTrue((String)"v1 still read only", (boolean)this.transactionService.getAllowWrite());
            this.transactionService.setAllowWrite(true, v3);
            TransactionServiceImplTest.assertTrue((String)"v3 veto", (boolean)this.transactionService.getAllowWrite());
        }
        finally {
            this.transactionService.setAllowWrite(true, v1);
            this.transactionService.setAllowWrite(true, v2);
            this.transactionService.setAllowWrite(true, v3);
        }
    }

    public void testGetRetryingTransactionHelper() {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                return null;
            }
        };
        TransactionServiceImplTest.assertFalse((String)"Retriers must be new instances", (this.transactionService.getRetryingTransactionHelper() == this.transactionService.getRetryingTransactionHelper() ? 1 : 0) != 0);
        this.transactionService.setAllowWrite(true, this.vetoName);
        this.transactionService.getRetryingTransactionHelper().doInTransaction(callback, true);
        this.transactionService.getRetryingTransactionHelper().doInTransaction(callback, false);
        this.transactionService.setAllowWrite(false, this.vetoName);
        this.transactionService.getRetryingTransactionHelper().doInTransaction(callback, true);
        try {
            this.transactionService.getRetryingTransactionHelper().doInTransaction(callback, false);
            TransactionServiceImplTest.fail((String)"Expected AccessDeniedException when starting to write to a read-only transaction service.");
        }
        catch (AccessDeniedException e) {
            // empty catch block
        }
        RetryingTransactionHelper helper = this.transactionService.getRetryingTransactionHelper();
        helper.setForceWritable(true);
        helper.doInTransaction(callback, true);
        helper.doInTransaction(callback, false);
        this.transactionService.setAllowWrite(true, this.vetoName);
    }
}

