/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer.manifest;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.alfresco.repo.transfer.PathHelper;
import org.alfresco.repo.transfer.TransferVersionImpl;
import org.alfresco.repo.transfer.manifest.ManifestAccessControl;
import org.alfresco.repo.transfer.manifest.ManifestPermission;
import org.alfresco.repo.transfer.manifest.TransferManifestDeletedNode;
import org.alfresco.repo.transfer.manifest.TransferManifestHeader;
import org.alfresco.repo.transfer.manifest.TransferManifestNode;
import org.alfresco.repo.transfer.manifest.TransferManifestNormalNode;
import org.alfresco.repo.transfer.manifest.TransferManifestProcessor;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.repository.datatype.TypeConversionException;
import org.alfresco.service.cmr.transfer.TransferException;
import org.alfresco.service.cmr.transfer.TransferVersion;
import org.alfresco.service.namespace.NamespaceException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.surf.util.Base64;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.extensions.surf.util.ISO8601DateFormat;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLTransferManifestReader
extends DefaultHandler
implements ContentHandler,
NamespacePrefixResolver {
    private TransferManifestProcessor processor;
    private static final String MSG_NO_ENCODING = "transfer_service.no_encoding";
    private static final String MSG_UNABLE_DESERIALIZE = "transfer_service.unable_to_deserialise";
    LinkedList<HashMap<String, String>> namespaces = new LinkedList();
    final String TRANSFER_URI = "http://www.alfresco.org/model/transfer/1.0";
    final String XMLNS_URI = "http://www.w3.org/XML/1998/namespace";
    private StringBuffer buffer;
    private Map<String, Object> props = new HashMap<String, Object>();

    public XMLTransferManifestReader(TransferManifestProcessor snapshotProcessor) {
        this.processor = snapshotProcessor;
        HashMap<String, String> namespace = new HashMap<String, String>();
        namespace.put("xmlns", "http://www.w3.org/XML/1998/namespace");
        this.namespaces.add(namespace);
    }

    @Override
    public void startDocument() throws SAXException {
        this.processor.startTransferManifest();
    }

    @Override
    public void endDocument() throws SAXException {
        this.processor.endTransferManifest();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.buffer != null) {
            this.buffer.append(ch, start, length);
        }
    }

    @Override
    public void startElement(String uri, String localName, String prefixName, Attributes atts) throws SAXException {
        String elementName;
        QName elementQName = QName.resolveToQName((NamespacePrefixResolver)this, (String)prefixName);
        HashMap<String, String> namespace = new HashMap<String, String>();
        this.namespaces.addFirst(namespace);
        for (int i = 0; i < atts.getLength(); ++i) {
            QName attributeQName = QName.resolveToQName((NamespacePrefixResolver)this, (String)atts.getQName(i));
            if (!attributeQName.getNamespaceURI().equals("http://www.w3.org/XML/1998/namespace")) continue;
            namespace.put(attributeQName.getLocalName(), atts.getValue(i));
        }
        if (elementQName == null) {
            return;
        }
        if (elementQName.getNamespaceURI().equals("http://www.alfresco.org/model/transfer/1.0")) {
            // empty if block
        }
        if (!(elementName = elementQName.getLocalName()).equals("transferManifest")) {
            TransferManifestNode node;
            if (elementName.equals("transferManifestHeader")) {
                TransferManifestHeader header = new TransferManifestHeader();
                this.props.put("header", header);
            } else if (elementName.equals("deletedNode")) {
                node = new TransferManifestDeletedNode();
                NodeRef nodeRef = new NodeRef(atts.getValue("", "nodeRef"));
                ((TransferManifestDeletedNode)node).setNodeRef(nodeRef);
                this.props.put("node", node);
            } else if (elementName.equals("node")) {
                node = new TransferManifestNormalNode();
                NodeRef nodeRef = new NodeRef(atts.getValue("", "nodeRef"));
                QName type = QName.createQName((String)atts.getValue("", "nodeType"));
                ((TransferManifestNormalNode)node).setNodeRef(nodeRef);
                ((TransferManifestNormalNode)node).setType(type);
                QName ancestorType = QName.createQName((String)atts.getValue("", "ancestorType"));
                ((TransferManifestNormalNode)node).setAncestorType(ancestorType);
                this.props.put("node", node);
            } else if (elementName.equals("aspects")) {
                node = (TransferManifestNormalNode)this.props.get("node");
                ((TransferManifestNormalNode)node).setAspects(new HashSet<QName>());
            } else if (elementName.equals("aspect")) {
                this.buffer = new StringBuffer();
            } else if (elementName.equals("properties")) {
                node = (TransferManifestNormalNode)this.props.get("node");
                HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
                ((TransferManifestNormalNode)node).setProperties(properties);
                this.props.put("properties", properties);
            } else if (elementName.equals("property")) {
                QName name = QName.createQName((String)atts.getValue("", "name"));
                this.props.put("name", name);
                this.props.remove("values");
                this.props.remove("mlvalues");
            } else if (elementName.equals("createdDate")) {
                this.buffer = new StringBuffer();
            } else if (elementName.equals("nodeCount")) {
                this.buffer = new StringBuffer();
            } else if (elementName.equals("repositoryId")) {
                this.buffer = new StringBuffer();
            } else if (elementName.equals("parentAssocs")) {
                node = (TransferManifestNormalNode)this.props.get("node");
                ArrayList<ChildAssociationRef> parentAssocs = new ArrayList<ChildAssociationRef>();
                ((TransferManifestNormalNode)node).setParentAssocs(parentAssocs);
                this.props.put("parentAssocs", parentAssocs);
            } else if (elementName.equals("childAssocs")) {
                node = (TransferManifestNormalNode)this.props.get("node");
                ((TransferManifestNormalNode)node).setChildAssocs(new ArrayList<ChildAssociationRef>());
            } else if (elementName.equals("childAssoc")) {
                this.buffer = new StringBuffer();
                NodeRef to = new NodeRef(atts.getValue("", "to"));
                QName type = QName.createQName((String)atts.getValue("", "type"));
                Boolean isPrimary = Boolean.parseBoolean(atts.getValue("", "isPrimary"));
                this.props.put("to", to);
                this.props.put("type", type);
                this.props.put("isPrimary", isPrimary);
            } else if (elementName.equals("parentAssoc")) {
                this.buffer = new StringBuffer();
                NodeRef from = new NodeRef(atts.getValue("", "from"));
                QName type = QName.createQName((String)atts.getValue("", "type"));
                Boolean isPrimary = Boolean.parseBoolean(atts.getValue("", "isPrimary"));
                this.props.put("from", from);
                this.props.put("type", type);
                this.props.put("isPrimary", isPrimary);
            } else if (elementName.equals("targetAssocs")) {
                node = (TransferManifestNormalNode)this.props.get("node");
                ArrayList<AssociationRef> assocs = new ArrayList<AssociationRef>();
                ((TransferManifestNormalNode)node).setTargetAssocs(assocs);
                this.props.put("assocs", assocs);
            } else if (elementName.equals("sourceAssocs")) {
                node = (TransferManifestNormalNode)this.props.get("node");
                ArrayList<AssociationRef> assocs = new ArrayList<AssociationRef>();
                ((TransferManifestNormalNode)node).setSourceAssocs(assocs);
                this.props.put("assocs", assocs);
            } else if (elementName.equals("assoc")) {
                NodeRef source = new NodeRef(atts.getValue("", "source"));
                NodeRef target = new NodeRef(atts.getValue("", "target"));
                QName type = QName.createQName((String)atts.getValue("", "type"));
                this.props.put("source", source);
                this.props.put("target", target);
                this.props.put("type", type);
            } else if (elementName.equals("primaryParent")) {
                this.buffer = new StringBuffer();
                ArrayList parentAssocs = new ArrayList();
                this.props.put("parentAssocs", parentAssocs);
            } else if (elementName.equals("values")) {
                ArrayList values = new ArrayList();
                this.props.put("values", values);
            } else if (elementName.equals("value")) {
                this.props.put("className", atts.getValue("", "className"));
                this.buffer = new StringBuffer();
            } else if (!elementName.equals("nullValue")) {
                if (elementName.equals("serializedValue")) {
                    this.props.put("encoding", atts.getValue("", "encoding"));
                    this.buffer = new StringBuffer();
                } else if (elementName.equals("mlvalue")) {
                    MLText mltext = (MLText)this.props.get("mlvalues");
                    if (mltext == null) {
                        mltext = new MLText();
                        this.props.put("mlvalues", mltext);
                    }
                    String strLocale = atts.getValue("", "locale");
                    Locale locale = I18NUtil.parseLocale((String)strLocale);
                    this.props.put("locale", locale);
                    this.buffer = new StringBuffer();
                } else if (elementName.equals("content")) {
                    String contentURL = atts.getValue("", "contentURL");
                    String mimetype = atts.getValue("", "mimetype");
                    String strLocale = atts.getValue("", "locale");
                    Locale locale = I18NUtil.parseLocale((String)strLocale);
                    String encoding = atts.getValue("", "encoding");
                    String sizeStr = atts.getValue("", "size");
                    Long size = Long.valueOf(sizeStr);
                    ContentData contentHeader = new ContentData(contentURL, mimetype, size.longValue(), encoding, locale);
                    this.props.put("contentHeader", contentHeader);
                } else if (elementName.equals("acl")) {
                    String isInherited = atts.getValue("", "isInherited");
                    ManifestAccessControl acl = new ManifestAccessControl();
                    if ("TRUE".equalsIgnoreCase(isInherited)) {
                        acl.setInherited(true);
                    }
                    this.props.put("acl", acl);
                } else if (elementName.equals("version")) {
                    String versionMajor = atts.getValue("", "versionMajor");
                    String versionMinor = atts.getValue("", "versionMinor");
                    String versionRevision = atts.getValue("", "versionRevision");
                    String edition = atts.getValue("", "edition");
                    this.props.put("headerVersion", new TransferVersionImpl(versionMajor, versionMinor, versionRevision, edition));
                } else if (elementName.equals("permission")) {
                    String authority = atts.getValue("", "authority");
                    String permission = atts.getValue("", "permission");
                    String status = atts.getValue("", "status");
                    ManifestPermission perm = new ManifestPermission();
                    perm.setAuthority(authority);
                    perm.setPermission(permission);
                    perm.setStatus(status);
                    this.props.put("permission", perm);
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String prefixName) throws SAXException {
        String elementName;
        this.namespaces.removeFirst();
        QName elementQName = QName.resolveToQName((NamespacePrefixResolver)this, (String)prefixName);
        if (elementQName == null) {
            return;
        }
        if (elementQName.getNamespaceURI().equals("http://www.alfresco.org/model/transfer/1.0")) {
            // empty if block
        }
        if (!(elementName = elementQName.getLocalName()).equals("transferManifest")) {
            if (elementName.equals("transferManifestHeader")) {
                TransferManifestHeader header = (TransferManifestHeader)this.props.get("header");
                this.processor.processTransferManifiestHeader(header);
            } else if (elementName.equals("node")) {
                TransferManifestNormalNode node = (TransferManifestNormalNode)this.props.get("node");
                this.processor.processTransferManifestNode(node);
            } else if (elementName.equals("deletedNode")) {
                TransferManifestDeletedNode node = (TransferManifestDeletedNode)this.props.get("node");
                this.processor.processTransferManifestNode(node);
            } else if (!elementName.equals("aspects")) {
                if (elementName.equals("aspect")) {
                    TransferManifestNormalNode node = (TransferManifestNormalNode)this.props.get("node");
                    node.getAspects().add(QName.createQName((String)this.buffer.toString()));
                    this.buffer = null;
                } else if (!elementName.equals("properties")) {
                    if (elementName.equals("property")) {
                        TransferManifestNormalNode node = (TransferManifestNormalNode)this.props.get("node");
                        QName name = (QName)this.props.get("name");
                        Serializable value = (Serializable)this.props.get("value");
                        node.getProperties().put(name, value);
                    } else if (elementName.equals("createdDate")) {
                        TransferManifestHeader header = (TransferManifestHeader)this.props.get("header");
                        header.setCreatedDate(ISO8601DateFormat.parse((String)this.buffer.toString()));
                        this.buffer = null;
                    } else if (elementName.equals("nodeCount")) {
                        TransferManifestHeader header = (TransferManifestHeader)this.props.get("header");
                        header.setNodeCount(Integer.parseInt(this.buffer.toString()));
                        this.buffer = null;
                    } else if (elementName.equals("sync")) {
                        TransferManifestHeader header = (TransferManifestHeader)this.props.get("header");
                        header.setSync(true);
                    } else if (elementName.equals("readOnly")) {
                        TransferManifestHeader header = (TransferManifestHeader)this.props.get("header");
                        header.setReadOnly(true);
                    } else if (elementName.equals("repositoryId")) {
                        TransferManifestHeader header = (TransferManifestHeader)this.props.get("header");
                        header.setRepositoryId(this.buffer.toString());
                        this.buffer = null;
                    } else if (!elementName.equals("parentAssocs") && !elementName.equals("childAssocs")) {
                        if (elementName.equals("childAssoc")) {
                            String value = this.buffer.toString();
                            QName name = QName.createQName((String)value);
                            NodeRef to = (NodeRef)this.props.get("to");
                            QName type = (QName)this.props.get("type");
                            Boolean isPrimary = (Boolean)this.props.get("isPrimary");
                            TransferManifestNormalNode node = (TransferManifestNormalNode)this.props.get("node");
                            ChildAssociationRef childAssociationRef = new ChildAssociationRef(type, node.getNodeRef(), name, to, isPrimary.booleanValue(), -1);
                            node.getChildAssocs().add(childAssociationRef);
                        } else if (elementName.equals("parentAssoc")) {
                            String value = this.buffer.toString();
                            QName name = QName.createQName((String)value);
                            NodeRef from = (NodeRef)this.props.get("from");
                            QName type = (QName)this.props.get("type");
                            Boolean isPrimary = (Boolean)this.props.get("isPrimary");
                            TransferManifestNode node = (TransferManifestNode)this.props.get("node");
                            List parentAssocs = (List)this.props.get("parentAssocs");
                            ChildAssociationRef childAssociationRef = new ChildAssociationRef(type, from, name, node.getNodeRef(), isPrimary.booleanValue(), -1);
                            parentAssocs.add(childAssociationRef);
                        } else if (!elementName.equals("targetAssocs") && !elementName.equals("sourceAssocs")) {
                            if (elementName.equals("assoc")) {
                                NodeRef source = (NodeRef)this.props.get("source");
                                NodeRef target = (NodeRef)this.props.get("target");
                                QName type = (QName)this.props.get("type");
                                List assocs = (List)this.props.get("assocs");
                                AssociationRef assoc = new AssociationRef(null, source, type, target);
                                assocs.add(assoc);
                                this.props.put("assoc", new AssociationRef(null, source, type, target));
                            } else if (elementName.equals("primaryParent")) {
                                TransferManifestNode node = (TransferManifestNode)this.props.get("node");
                                List parentAssocs = (List)this.props.get("parentAssocs");
                                if (parentAssocs != null) {
                                    assert (parentAssocs.size() == 1);
                                    node.setPrimaryParentAssoc((ChildAssociationRef)parentAssocs.get(0));
                                }
                            } else if (elementName.equals("primaryPath")) {
                                TransferManifestNode node = (TransferManifestNode)this.props.get("node");
                                String value = this.buffer.toString();
                                Path path = PathHelper.stringToPath(value);
                                node.setParentPath(path);
                            } else if (elementName.equals("values")) {
                                this.props.put("value", this.props.get("values"));
                            } else if (elementName.equals("value")) {
                                Collection values = (Collection)this.props.get("values");
                                String className = (String)this.props.get("className");
                                Object value = this.buffer.toString();
                                if (className != null && !className.equals("java.lang.String")) {
                                    try {
                                        value = (Serializable)DefaultTypeConverter.INSTANCE.convert(Class.forName(className), value);
                                    }
                                    catch (TypeConversionException tcf) {
                                    }
                                    catch (ClassNotFoundException cnf) {
                                        // empty catch block
                                    }
                                }
                                if (values != null) {
                                    values.add(value);
                                } else {
                                    this.props.put("value", value);
                                }
                            } else if (elementName.equals("nullValue")) {
                                Collection values = (Collection)this.props.get("values");
                                if (values != null) {
                                    values.add(null);
                                } else {
                                    this.props.put("value", null);
                                }
                            } else if (elementName.equals("serializedValue")) {
                                Collection values = (Collection)this.props.get("values");
                                String encoding = (String)this.props.get("encoding");
                                String strValue = this.buffer.toString();
                                Object value = null;
                                if (encoding.equalsIgnoreCase("base64/ObjectOutputStream")) {
                                    try {
                                        byte[] data = Base64.decode((byte[])strValue.getBytes("UTF-8"));
                                        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));
                                        value = ois.readObject();
                                    }
                                    catch (IOException error) {
                                        throw new TransferException(MSG_UNABLE_DESERIALIZE, error);
                                    }
                                    catch (ClassNotFoundException error) {
                                        throw new TransferException(MSG_UNABLE_DESERIALIZE, error);
                                    }
                                } else {
                                    throw new TransferException(MSG_NO_ENCODING, new Object[]{encoding});
                                }
                                if (values != null) {
                                    values.add((Serializable)value);
                                } else {
                                    this.props.put("value", value);
                                }
                            } else if (elementName.equals("mlvalue")) {
                                MLText mltext = (MLText)this.props.get("mlvalues");
                                Locale locale = (Locale)this.props.get("locale");
                                String value = this.buffer.toString();
                                mltext.addValue(locale, value);
                                this.props.put("value", mltext);
                            } else if (elementName.equals("content")) {
                                ContentData data = (ContentData)this.props.get("contentHeader");
                                this.props.put("value", data);
                            } else if (elementName.equals("version")) {
                                TransferManifestHeader header = (TransferManifestHeader)this.props.get("header");
                                TransferVersion version = (TransferVersion)this.props.get("headerVersion");
                                header.setTransferVersion(version);
                            } else if (elementName.equals("acl")) {
                                TransferManifestNormalNode node = (TransferManifestNormalNode)this.props.get("node");
                                ManifestAccessControl acl = (ManifestAccessControl)this.props.get("acl");
                                node.setAccessControl(acl);
                            } else if (elementName.equals("permission")) {
                                ManifestAccessControl acl = (ManifestAccessControl)this.props.get("acl");
                                ManifestPermission permission = (ManifestPermission)this.props.get("permission");
                                acl.addPermission(permission);
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        HashMap<String, String> namespace = this.namespaces.get(0);
        namespace.put(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        HashMap<String, String> namespace = this.namespaces.get(0);
        namespace.remove(prefix);
    }

    public String getNamespaceURI(String prefix) throws NamespaceException {
        for (HashMap hashMap : this.namespaces) {
            String uri = (String)hashMap.get(prefix);
            if (uri == null) continue;
            return uri;
        }
        return null;
    }

    public Collection<String> getPrefixes(String namespaceURI) throws NamespaceException {
        HashSet<String> prefixes = new HashSet<String>();
        for (HashMap hashMap : this.namespaces) {
            for (Map.Entry entry : hashMap.entrySet()) {
                if (!namespaceURI.equals(entry.getValue())) continue;
                prefixes.add((String)entry.getKey());
            }
        }
        return prefixes;
    }

    public Collection<String> getPrefixes() {
        HashSet<String> prefixes = new HashSet<String>();
        for (HashMap hashMap : this.namespaces) {
            prefixes.addAll(hashMap.keySet());
        }
        return prefixes;
    }

    public Collection<String> getURIs() {
        HashSet<String> uris = new HashSet<String>();
        for (HashMap hashMap : this.namespaces) {
            uris.addAll(hashMap.values());
        }
        return uris;
    }
}

