/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer.requisite;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.alfresco.repo.transfer.requisite.TransferRequsiteProcessor;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.NamespaceException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLTransferRequsiteReader
extends DefaultHandler
implements ContentHandler,
NamespacePrefixResolver {
    private TransferRequsiteProcessor processor;
    LinkedList<HashMap<String, String>> namespaces = new LinkedList();
    final String REQUSITE_URI = "http://www.alfresco.org/model/requsite/1.0";
    final String XMLNS_URI = "http://www.w3.org/XML/1998/namespace";
    private StringBuffer buffer;
    private Map<String, Object> props = new HashMap<String, Object>();

    public XMLTransferRequsiteReader(TransferRequsiteProcessor processor) {
        this.processor = processor;
        HashMap<String, String> namespace = new HashMap<String, String>();
        namespace.put("xmlns", "http://www.w3.org/XML/1998/namespace");
        this.namespaces.add(namespace);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        HashMap<String, String> namespace = this.namespaces.get(0);
        namespace.put(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        HashMap<String, String> namespace = this.namespaces.get(0);
        namespace.remove(prefix);
    }

    public String getNamespaceURI(String prefix) throws NamespaceException {
        for (HashMap hashMap : this.namespaces) {
            String uri = (String)hashMap.get(prefix);
            if (uri == null) continue;
            return uri;
        }
        return null;
    }

    public Collection<String> getPrefixes(String namespaceURI) throws NamespaceException {
        HashSet<String> prefixes = new HashSet<String>();
        for (HashMap hashMap : this.namespaces) {
            for (Map.Entry entry : hashMap.entrySet()) {
                if (!namespaceURI.equals(entry.getValue())) continue;
                prefixes.add((String)entry.getKey());
            }
        }
        return prefixes;
    }

    public Collection<String> getPrefixes() {
        HashSet<String> prefixes = new HashSet<String>();
        for (HashMap hashMap : this.namespaces) {
            prefixes.addAll(hashMap.keySet());
        }
        return prefixes;
    }

    public Collection<String> getURIs() {
        HashSet<String> uris = new HashSet<String>();
        for (HashMap hashMap : this.namespaces) {
            uris.addAll(hashMap.values());
        }
        return uris;
    }

    @Override
    public void startDocument() throws SAXException {
        this.processor.startTransferRequsite();
    }

    @Override
    public void endDocument() throws SAXException {
        this.processor.endTransferRequsite();
    }

    @Override
    public void startElement(String uri, String localName, String prefixName, Attributes atts) throws SAXException {
        String elementName;
        QName elementQName = QName.resolveToQName((NamespacePrefixResolver)this, (String)prefixName);
        HashMap<String, String> namespace = new HashMap<String, String>();
        this.namespaces.addFirst(namespace);
        for (int i = 0; i < atts.getLength(); ++i) {
            QName attributeQName = QName.resolveToQName((NamespacePrefixResolver)this, (String)atts.getQName(i));
            if (!attributeQName.getNamespaceURI().equals("http://www.w3.org/XML/1998/namespace")) continue;
            namespace.put(attributeQName.getLocalName(), atts.getValue(i));
        }
        if (elementQName == null) {
            return;
        }
        if (elementQName.getNamespaceURI().equals("http://www.alfresco.org/model/requsite/1.0")) {
            // empty if block
        }
        if (!(elementName = elementQName.getLocalName()).equals("transferRequsite") && elementName.equals("requiredContent")) {
            NodeRef nodeRef = new NodeRef(atts.getValue("", "nodeRef"));
            QName qname = QName.createQName((String)atts.getValue("", "qname"));
            String name = atts.getValue("", "name");
            this.processor.missingContent(nodeRef, qname, name);
        }
    }

    @Override
    public void endElement(String uri, String localName, String prefixName) throws SAXException {
        this.namespaces.removeFirst();
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }
}

