/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer.script;

import java.util.HashMap;
import java.util.HashSet;
import org.alfresco.repo.jscript.ClasspathScriptLocation;
import org.alfresco.repo.transfer.TransferTargetImpl;
import org.alfresco.repo.transfer.script.ScriptTransferService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.ScriptService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.transfer.TransferDefinition;
import org.alfresco.service.cmr.transfer.TransferException;
import org.alfresco.service.cmr.transfer.TransferService;
import org.alfresco.util.BaseAlfrescoSpringTest;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class ScriptTransferServiceTest
extends BaseAlfrescoSpringTest {
    private ScriptService scriptService;
    private ScriptTransferService scriptTransferService;

    @Override
    protected void onSetUpInTransaction() throws Exception {
        super.onSetUpInTransaction();
        this.scriptService = (ScriptService)this.applicationContext.getBean("ScriptService");
        this.scriptTransferService = (ScriptTransferService)this.applicationContext.getBean("transferServiceScript");
    }

    public void testJSAPI() throws Exception {
        TransferTargetImpl dummyTarget = new TransferTargetImpl();
        dummyTarget.setName("dummyTarget");
        dummyTarget.setNodeRef(new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "4"));
        HashSet<TransferTargetImpl> dummyTargets = new HashSet<TransferTargetImpl>();
        dummyTargets.add(dummyTarget);
        TransferService mockedTransferService = (TransferService)Mockito.mock(TransferService.class);
        this.scriptTransferService.setTransferService(mockedTransferService);
        Mockito.when((Object)mockedTransferService.transfer(Matchers.anyString(), (TransferDefinition)Matchers.isA(TransferDefinition.class))).thenReturn((Object)new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "123"));
        Mockito.when((Object)mockedTransferService.transfer((String)Matchers.eq((Object)"exception"), (TransferDefinition)Matchers.isA(TransferDefinition.class))).thenThrow(new Throwable[]{new TransferException("mocked transfer exception")});
        Mockito.when((Object)mockedTransferService.getTransferTarget(Matchers.anyString())).thenReturn((Object)dummyTarget);
        Mockito.when(mockedTransferService.getTransferTargets(Matchers.anyString())).thenReturn(dummyTargets);
        Mockito.when(mockedTransferService.getTransferTargets()).thenReturn(dummyTargets);
        HashMap<String, Object> model = new HashMap<String, Object>(1);
        ClasspathScriptLocation location = new ClasspathScriptLocation("org/alfresco/repo/transfer/script/test_transferService.js");
        this.scriptService.executeScript(location, model);
    }
}

