/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.usage;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.ibatis.IdsEntity;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.domain.query.CannedQueryDAO;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.usage.RepoUsageComponent;
import org.alfresco.service.cmr.admin.RepoUsage;
import org.alfresco.service.cmr.admin.RepoUsageStatus;
import org.alfresco.service.cmr.attributes.AttributeService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class RepoUsageComponentImpl
implements RepoUsageComponent {
    private static final String QUERY_NS = "alfresco.query.usages";
    private static final String QUERY_SELECT_COUNT_PERSONS_NOT_DISABLED = "select_CountPersonsNotDisabled";
    private static final String QUERY_SELECT_COUNT_DOCUMENTS = "select_CountDocuments";
    private static Log logger = LogFactory.getLog(RepoUsageComponentImpl.class);
    private TransactionService transactionService;
    private AuthorityService authorityService;
    private AttributeService attributeService;
    private DictionaryService dictionaryService;
    private JobLockService jobLockService;
    private CannedQueryDAO cannedQueryDAO;
    private QNameDAO qnameDAO;
    private RepoUsage restrictions;
    private ReentrantReadWriteLock.ReadLock restrictionsReadLock;
    private ReentrantReadWriteLock.WriteLock restrictionsWriteLock;
    private Set<RepoUsageComponent.RestrictionObserver> restrictionObservers = new HashSet<RepoUsageComponent.RestrictionObserver>();

    public RepoUsageComponentImpl() {
        this.restrictions = new RepoUsage(null, null, null, RepoUsage.LicenseMode.UNKNOWN, null, false);
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.restrictionsReadLock = lock.readLock();
        this.restrictionsWriteLock = lock.writeLock();
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setAttributeService(AttributeService attributeService) {
        this.attributeService = attributeService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setJobLockService(JobLockService jobLockService) {
        this.jobLockService = jobLockService;
    }

    public void setCannedQueryDAO(CannedQueryDAO cannedQueryDAO) {
        this.cannedQueryDAO = cannedQueryDAO;
    }

    public void setQnameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
    }

    @Override
    public void observeRestrictions(RepoUsageComponent.RestrictionObserver observer) {
        this.restrictionObservers.add(observer);
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"transactionService", (Object)this.transactionService);
        PropertyCheck.mandatory((Object)this, (String)"authorityService", (Object)this.authorityService);
        PropertyCheck.mandatory((Object)this, (String)"attributeService", (Object)this.attributeService);
        PropertyCheck.mandatory((Object)this, (String)"dictionaryService", (Object)this.dictionaryService);
        PropertyCheck.mandatory((Object)this, (String)"jobLockService", (Object)this.jobLockService);
        PropertyCheck.mandatory((Object)this, (String)"cannedQueryDAO", (Object)this.cannedQueryDAO);
        PropertyCheck.mandatory((Object)this, (String)"qnameDAO", (Object)this.qnameDAO);
    }

    private final void checkTxnState(AlfrescoTransactionSupport.TxnReadState txnStateNeeded) {
        switch (txnStateNeeded) {
            case TXN_READ_WRITE: {
                if (AlfrescoTransactionSupport.getTransactionReadState() == AlfrescoTransactionSupport.TxnReadState.TXN_READ_WRITE) break;
                throw AlfrescoRuntimeException.create((String)"system.usage.err.no_txn_readwrite", (Object[])new Object[0]);
            }
            case TXN_READ_ONLY: {
                if (AlfrescoTransactionSupport.getTransactionReadState() != AlfrescoTransactionSupport.TxnReadState.TXN_NONE) break;
                throw AlfrescoRuntimeException.create((String)"system.usage.err.no_txn", (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRestrictions(RepoUsage restrictions) {
        this.checkTxnState(AlfrescoTransactionSupport.TxnReadState.TXN_NONE);
        this.restrictionsWriteLock.lock();
        try {
            this.restrictions = restrictions;
        }
        finally {
            this.restrictionsWriteLock.unlock();
        }
        for (RepoUsageComponent.RestrictionObserver observer : this.restrictionObservers) {
            observer.onChangeRestriction(restrictions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RepoUsage getRestrictions() {
        this.restrictionsReadLock.lock();
        try {
            RepoUsage repoUsage = this.restrictions;
            return repoUsage;
        }
        finally {
            this.restrictionsReadLock.unlock();
        }
    }

    @Override
    public boolean updateUsage(RepoUsage.UsageType usageType) {
        this.checkTxnState(AlfrescoTransactionSupport.TxnReadState.TXN_READ_WRITE);
        boolean updateUsers = false;
        boolean updateDocuments = false;
        switch (usageType) {
            case USAGE_DOCUMENTS: {
                updateDocuments = true;
                break;
            }
            case USAGE_USERS: {
                updateUsers = true;
                break;
            }
            case USAGE_ALL: {
                updateUsers = true;
                updateDocuments = true;
            }
        }
        if (updateUsers && !this.updateUsers()) {
            return false;
        }
        if (updateDocuments && !this.updateDocuments()) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            RepoUsage usage = this.getUsageImpl();
            logger.debug((Object)("Updated repo usage: " + usage));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateUsers() {
        String lockToken = null;
        try {
            lockToken = this.jobLockService.getLock(LOCK_USAGE_USERS, LOCK_TTL);
            IdsEntity idsParam = new IdsEntity();
            idsParam.setIdOne((Long)this.qnameDAO.getOrCreateQName(ContentModel.ASPECT_PERSON_DISABLED).getFirst());
            idsParam.setIdTwo((Long)this.qnameDAO.getOrCreateQName(ContentModel.TYPE_PERSON).getFirst());
            Long userCount = this.cannedQueryDAO.executeCountQuery(QUERY_NS, QUERY_SELECT_COUNT_PERSONS_NOT_DISABLED, idsParam);
            userCount = userCount > 0L ? userCount - 1L : 0L;
            this.jobLockService.refreshLock(lockToken, LOCK_USAGE_USERS, LOCK_TTL);
            this.attributeService.setAttribute(new Long(System.currentTimeMillis()), new Serializable[]{".repoUsages", "current", "lastUpdateUsers"});
            this.attributeService.setAttribute(userCount, new Serializable[]{".repoUsages", "current", "users"});
            boolean bl = true;
            return bl;
        }
        catch (LockAcquisitionException e) {
            logger.debug((Object)("Failed to get lock for user counts: " + e.getMessage()));
            boolean bl = false;
            return bl;
        }
        finally {
            if (lockToken != null) {
                this.jobLockService.releaseLock(lockToken, LOCK_USAGE_USERS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateDocuments() {
        String lockToken = null;
        try {
            lockToken = this.jobLockService.getLock(LOCK_USAGE_DOCUMENTS, LOCK_TTL);
            HashSet<QName> searchTypeQNames = new HashSet<QName>(11);
            Collection qnames = this.dictionaryService.getSubTypes(ContentModel.TYPE_CONTENT, true);
            searchTypeQNames.addAll(qnames);
            searchTypeQNames.add(ContentModel.TYPE_CONTENT);
            qnames = this.dictionaryService.getSubTypes(ContentModel.TYPE_LINK, true);
            searchTypeQNames.addAll(qnames);
            searchTypeQNames.add(ContentModel.TYPE_LINK);
            Set<Long> searchTypeQNameIds = this.qnameDAO.convertQNamesToIds(searchTypeQNames, false);
            IdsEntity idsParam = new IdsEntity();
            idsParam.setIds(new ArrayList<Long>(searchTypeQNameIds));
            Long documentCount = this.cannedQueryDAO.executeCountQuery(QUERY_NS, QUERY_SELECT_COUNT_DOCUMENTS, idsParam);
            this.jobLockService.refreshLock(lockToken, LOCK_USAGE_DOCUMENTS, LOCK_TTL);
            this.attributeService.setAttribute(new Long(System.currentTimeMillis()), new Serializable[]{".repoUsages", "current", "lastUpdateDocuments"});
            this.attributeService.setAttribute(documentCount, new Serializable[]{".repoUsages", "current", "documents"});
            boolean bl = true;
            return bl;
        }
        catch (LockAcquisitionException e) {
            logger.debug((Object)("Failed to get lock for document counts: " + e.getMessage()));
            boolean bl = false;
            return bl;
        }
        finally {
            if (lockToken != null) {
                this.jobLockService.releaseLock(lockToken, LOCK_USAGE_DOCUMENTS);
            }
        }
    }

    private RepoUsage getUsageImpl() {
        Long lastUpdateUsers = (Long)this.attributeService.getAttribute(new Serializable[]{".repoUsages", "current", "lastUpdateUsers"});
        Long users = (Long)this.attributeService.getAttribute(new Serializable[]{".repoUsages", "current", "users"});
        Long lastUpdateDocuments = (Long)this.attributeService.getAttribute(new Serializable[]{".repoUsages", "current", "lastUpdateDocuments"});
        Long documents = (Long)this.attributeService.getAttribute(new Serializable[]{".repoUsages", "current", "documents"});
        Long lastUpdate = lastUpdateUsers == null ? lastUpdateDocuments : (lastUpdateDocuments == null ? lastUpdateUsers : (lastUpdateDocuments.compareTo(lastUpdateUsers) > 0 ? lastUpdateDocuments : lastUpdateUsers));
        RepoUsage usage = new RepoUsage(lastUpdate, users, documents, this.restrictions.getLicenseMode(), this.restrictions.getLicenseExpiryDate(), !this.transactionService.getAllowWrite());
        return usage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RepoUsage getUsage() {
        this.checkTxnState(AlfrescoTransactionSupport.TxnReadState.TXN_READ_ONLY);
        this.restrictionsReadLock.lock();
        try {
            RepoUsage usage = this.getUsageImpl();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Retrieved repo usage: " + usage));
            }
            RepoUsage repoUsage = usage;
            return repoUsage;
        }
        finally {
            this.restrictionsReadLock.unlock();
        }
    }

    @Override
    public RepoUsageStatus getUsageStatus() {
        long documentsMax;
        long usersMax;
        RepoUsage usage = this.getUsage();
        RepoUsage restrictions = this.getRestrictions();
        RepoUsageStatus.RepoUsageLevel level = RepoUsageStatus.RepoUsageLevel.OK;
        ArrayList<String> warnings = new ArrayList<String>(1);
        ArrayList<String> errors = new ArrayList<String>(1);
        long usersCurrent = usage.getUsers() == null ? 0L : usage.getUsers();
        long l = usersMax = restrictions.getUsers() == null ? Long.MAX_VALUE : restrictions.getUsers();
        if (usersCurrent > usersMax) {
            errors.add(I18NUtil.getMessage((String)"system.usage.err.limit_users_exceeded", (Object[])new Object[]{usersMax, usersCurrent}));
            level = RepoUsageStatus.RepoUsageLevel.LOCKED_DOWN;
        } else if (usersCurrent == usersMax) {
            warnings.add(I18NUtil.getMessage((String)"system.usage.warn.limit_users_reached", (Object[])new Object[]{usersMax, usersCurrent}));
            level = RepoUsageStatus.RepoUsageLevel.WARN_ALL;
        } else if ((double)usersCurrent >= 0.9 * (double)usersMax || usersCurrent >= usersMax - 1L) {
            warnings.add(I18NUtil.getMessage((String)"system.usage.warn.limit_users_approached", (Object[])new Object[]{usersMax, usersCurrent}));
            level = RepoUsageStatus.RepoUsageLevel.WARN_ADMIN;
        }
        long documentsCurrent = usage.getDocuments() == null ? 0L : usage.getDocuments();
        long l2 = documentsMax = restrictions.getDocuments() == null ? Long.MAX_VALUE : restrictions.getDocuments();
        if (documentsCurrent > documentsMax) {
            errors.add(I18NUtil.getMessage((String)"system.usage.err.limit_documents_exceeded", (Object[])new Object[]{documentsMax, documentsCurrent}));
            level = RepoUsageStatus.RepoUsageLevel.LOCKED_DOWN;
        } else if ((double)documentsCurrent > 0.99 * (double)documentsMax) {
            warnings.add(I18NUtil.getMessage((String)"system.usage.warn.limit_documents_reached", (Object[])new Object[]{documentsMax, documentsCurrent}));
            if (level.ordinal() < RepoUsageStatus.RepoUsageLevel.WARN_ALL.ordinal()) {
                level = RepoUsageStatus.RepoUsageLevel.WARN_ALL;
            }
        } else if ((double)documentsCurrent > 0.9 * (double)documentsMax) {
            warnings.add(I18NUtil.getMessage((String)"system.usage.warn.limit_documents_approached", (Object[])new Object[]{documentsMax, documentsCurrent}));
            if (level.ordinal() < RepoUsageStatus.RepoUsageLevel.WARN_ADMIN.ordinal()) {
                level = RepoUsageStatus.RepoUsageLevel.WARN_ADMIN;
            }
        }
        Long licenseExpiryDate = restrictions.getLicenseExpiryDate();
        if (licenseExpiryDate != null) {
            long remainingMs = licenseExpiryDate - System.currentTimeMillis();
            double remainingDays = (double)remainingMs / 8.64E7;
            if (remainingDays <= 0.0) {
                errors.add(I18NUtil.getMessage((String)"system.usage.err.limit_license_expired"));
                level = RepoUsageStatus.RepoUsageLevel.LOCKED_DOWN;
            } else if (remainingDays <= 7.0) {
                warnings.add(I18NUtil.getMessage((String)"system.usage.err.limit_license_expiring", (Object[])new Object[]{(int)remainingDays}));
                if (level.ordinal() < RepoUsageStatus.RepoUsageLevel.WARN_ADMIN.ordinal()) {
                    level = RepoUsageStatus.RepoUsageLevel.WARN_ALL;
                }
            } else if (remainingDays <= 21.0) {
                warnings.add(I18NUtil.getMessage((String)"system.usage.err.limit_license_expiring", (Object[])new Object[]{(int)remainingDays}));
                if (level.ordinal() < RepoUsageStatus.RepoUsageLevel.WARN_ALL.ordinal()) {
                    level = RepoUsageStatus.RepoUsageLevel.WARN_ADMIN;
                }
            }
        }
        RepoUsageStatus status = new RepoUsageStatus(restrictions, usage, level, warnings, errors);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Usage status generated: " + status));
        }
        return status;
    }
}

