/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.person.TestGroupManager;
import org.alfresco.repo.security.person.TestPersonManager;
import org.alfresco.repo.workflow.BPMEngineRegistry;
import org.alfresco.repo.workflow.WorkflowAdminServiceImpl;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.repo.workflow.WorkflowTestHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowDeployment;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskDefinition;
import org.alfresco.service.cmr.workflow.WorkflowTaskQuery;
import org.alfresco.service.cmr.workflow.WorkflowTaskState;
import org.alfresco.service.cmr.workflow.WorkflowTimer;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;
import org.alfresco.util.collections.CollectionUtils;
import org.alfresco.util.collections.Function;

public abstract class AbstractWorkflowServiceIntegrationTest
extends BaseSpringTest {
    private static final String XML = "text/xml";
    protected static final String USER1 = "WFUser1" + GUID.generate();
    protected static final String USER2 = "WFUser2" + GUID.generate();
    protected static final String USER3 = "WFUser3" + GUID.generate();
    protected static final String GROUP = "WFGroup" + GUID.generate();
    protected static final String SUB_GROUP = "WFSubGroup" + GUID.generate();
    protected static final QName customStringProp = QName.createQName((String)"http://www.alfresco.org/model/workflow/1.0", (String)"customStringProp");
    protected WorkflowService workflowService;
    protected AuthenticationComponent authenticationComponent;
    protected TestPersonManager personManager;
    protected TestGroupManager groupManager;
    protected NodeService nodeService;
    private NodeRef companyHome;
    protected WorkflowTestHelper wfTestHelper;

    public void testDeployWorkflowDefinition() {
        List<WorkflowDefinition> defs = this.workflowService.getDefinitions();
        WorkflowDefinition definition = this.deployDefinition(this.getTestDefinitionPath());
        String id = definition.getId();
        this.checkDefinitions(definition, false, defs.toArray(new WorkflowDefinition[0]));
        List<WorkflowDefinition> newDefs = this.workflowService.getDefinitions();
        this.checkDefinitions(definition, true, newDefs.toArray(new WorkflowDefinition[0]));
        AbstractWorkflowServiceIntegrationTest.assertEquals((int)(defs.size() + 1), (int)newDefs.size());
        WorkflowDefinition defById = this.workflowService.getDefinitionById(id);
        this.checkDefinition(definition, defById);
        WorkflowDefinition defByName = this.workflowService.getDefinitionByName(definition.getName());
        this.checkDefinition(definition, defByName);
        this.wfTestHelper.enableThisEngineOnly();
        AbstractWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.getDefinitions().isEmpty());
        AbstractWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.getAllDefinitions().isEmpty());
        this.wfTestHelper.setVisible(false);
        AbstractWorkflowServiceIntegrationTest.assertTrue((boolean)this.workflowService.getDefinitions().isEmpty());
        AbstractWorkflowServiceIntegrationTest.assertTrue((boolean)this.workflowService.getAllDefinitions().isEmpty());
    }

    public void testStartWorkflow() {
        WorkflowDefinition definition = this.deployDefinition(this.getTestDefinitionPath());
        WorkflowPath path = this.workflowService.startWorkflow(definition.getId(), null);
        AbstractWorkflowServiceIntegrationTest.assertNotNull((Object)path);
        AbstractWorkflowServiceIntegrationTest.assertTrue((boolean)path.isActive());
        AbstractWorkflowServiceIntegrationTest.assertNotNull((Object)path.getNode());
        WorkflowInstance instance = path.getInstance();
        AbstractWorkflowServiceIntegrationTest.assertNotNull((Object)instance);
        AbstractWorkflowServiceIntegrationTest.assertEquals((String)definition.getId(), (String)instance.getDefinition().getId());
    }

    public void testStartTask() {
        WorkflowDefinition workflowDef = this.deployDefinition(this.getAdhocDefinitionPath());
        WorkflowTaskDefinition startTaskDef = workflowDef.getStartTaskDefinition();
        AbstractWorkflowServiceIntegrationTest.assertNotNull((Object)startTaskDef);
        HashMap<QName, Serializable> params = new HashMap<QName, Serializable>();
        NodeRef wfPackage = this.workflowService.createPackage(null);
        params.put(WorkflowModel.ASSOC_PACKAGE, (Serializable)wfPackage);
        Date dueDate = new Date();
        params.put(WorkflowModel.PROP_DUE_DATE, dueDate);
        params.put(WorkflowModel.PROP_PRIORITY, Integer.valueOf(1));
        NodeRef assignee = this.personManager.get(USER2);
        params.put(WorkflowModel.ASSOC_ASSIGNEE, (Serializable)assignee);
        WorkflowPath path = this.workflowService.startWorkflow(workflowDef.getId(), params);
        AbstractWorkflowServiceIntegrationTest.assertNotNull((Object)path);
        AbstractWorkflowServiceIntegrationTest.assertTrue((boolean)path.isActive());
        String startTaskDefId = startTaskDef.getId();
        List<WorkflowTask> tasks = this.workflowService.getTasksForWorkflowPath(path.getId());
        AbstractWorkflowServiceIntegrationTest.assertEquals((int)1, (int)tasks.size());
        WorkflowTask startTask = tasks.get(0);
        AbstractWorkflowServiceIntegrationTest.assertEquals((String)startTaskDefId, (String)startTask.getDefinition().getId());
        startTask = this.workflowService.getStartTask(path.getInstance().getId());
        AbstractWorkflowServiceIntegrationTest.assertNotNull((Object)startTask);
        AbstractWorkflowServiceIntegrationTest.assertEquals((String)startTaskDefId, (String)startTask.getDefinition().getId());
        this.workflowService.endTask(startTask.getId(), null);
        WorkflowTask task = this.workflowService.getTaskById(startTask.getId());
        Map<QName, Serializable> props = task.getProperties();
        AbstractWorkflowServiceIntegrationTest.assertEquals((Object)dueDate, (Object)props.get(WorkflowModel.PROP_DUE_DATE));
        AbstractWorkflowServiceIntegrationTest.assertEquals((Object)1, (Object)props.get(WorkflowModel.PROP_PRIORITY));
        AbstractWorkflowServiceIntegrationTest.assertEquals((Object)assignee, (Object)props.get(WorkflowModel.ASSOC_ASSIGNEE));
    }

    public void testGetPathProperties() throws Exception {
        WorkflowDefinition workflowDef = this.deployDefinition(this.getAdhocDefinitionPath());
        HashMap<QName, Serializable> params = new HashMap<QName, Serializable>();
        NodeRef wfPackage = this.workflowService.createPackage(null);
        params.put(WorkflowModel.ASSOC_PACKAGE, (Serializable)wfPackage);
        Date dueDate = new Date();
        params.put(WorkflowModel.PROP_WORKFLOW_DUE_DATE, dueDate);
        params.put(WorkflowModel.PROP_WORKFLOW_PRIORITY, Integer.valueOf(1));
        String description = "Some Description";
        params.put(WorkflowModel.PROP_WORKFLOW_DESCRIPTION, (Serializable)((Object)description));
        NodeRef assignee = this.personManager.get(USER2);
        params.put(WorkflowModel.ASSOC_ASSIGNEE, (Serializable)assignee);
        this.personManager.setUser(USER1);
        WorkflowPath path = this.workflowService.startWorkflow(workflowDef.getId(), params);
        AbstractWorkflowServiceIntegrationTest.assertNotNull((Object)path);
        AbstractWorkflowServiceIntegrationTest.assertTrue((boolean)path.isActive());
        String instanceId = path.getInstance().getId();
        WorkflowTask startTask = this.workflowService.getStartTask(instanceId);
        this.workflowService.endTask(startTask.getId(), null);
        Map<QName, Serializable> properties = this.workflowService.getPathProperties(path.getId());
        AbstractWorkflowServiceIntegrationTest.assertNotNull(properties);
        AbstractWorkflowServiceIntegrationTest.assertEquals((Object)false, (Object)properties.get(QName.createQName((String)"{}cancelled")));
        AbstractWorkflowServiceIntegrationTest.assertEquals((Object)instanceId, (Object)properties.get(QName.createQName((String)"{}workflowinstanceid")));
        NodeRef initiator = (NodeRef)properties.get(QName.createQName((String)"{}initiator"));
        AbstractWorkflowServiceIntegrationTest.assertEquals((Object)this.personManager.get(USER1), (Object)initiator);
        NodeRef expInitiatorHome = (NodeRef)this.nodeService.getProperty(initiator, ContentModel.PROP_HOMEFOLDER);
        NodeRef initiatorHome = (NodeRef)properties.get(QName.createQName((String)"{}initiatorhome"));
        AbstractWorkflowServiceIntegrationTest.assertEquals((Object)expInitiatorHome, (Object)initiatorHome);
        NodeRef actualCompanyHome = (NodeRef)properties.get(QName.createQName((String)"{}companyhome"));
        AbstractWorkflowServiceIntegrationTest.assertEquals((Object)this.companyHome, (Object)actualCompanyHome);
        AbstractWorkflowServiceIntegrationTest.assertEquals((Object)wfPackage, (Object)properties.get(WorkflowModel.ASSOC_PACKAGE));
        AbstractWorkflowServiceIntegrationTest.assertEquals((Object)dueDate, (Object)properties.get(WorkflowModel.PROP_WORKFLOW_DUE_DATE));
        AbstractWorkflowServiceIntegrationTest.assertEquals((Object)1, (Object)properties.get(WorkflowModel.PROP_WORKFLOW_PRIORITY));
        AbstractWorkflowServiceIntegrationTest.assertEquals((Object)assignee, (Object)properties.get(WorkflowModel.ASSOC_ASSIGNEE));
        AbstractWorkflowServiceIntegrationTest.assertEquals((Object)description, (Object)properties.get(WorkflowModel.PROP_WORKFLOW_DESCRIPTION));
    }

    public void testAssociateWorkflowPackage() {
        this.authenticationComponent.setSystemUserAsCurrentUser();
        NodeRef rootNode = this.nodeService.getRootNode(new StoreRef("workspace", "SpacesStore"));
        ChildAssociationRef childAssoc = this.nodeService.createNode(rootNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"cm", (String)"test"), ContentModel.TYPE_CONTENT, null);
        NodeRef contentNode = childAssoc.getChildRef();
        NodeRef pckgNode = this.workflowService.createPackage(null);
        AbstractWorkflowServiceIntegrationTest.assertNotNull((Object)pckgNode);
        AbstractWorkflowServiceIntegrationTest.assertTrue((boolean)this.nodeService.hasAspect(pckgNode, WorkflowModel.ASPECT_WORKFLOW_PACKAGE));
        List<WorkflowInstance> existingInstances = this.workflowService.getWorkflowsForContent(contentNode, true);
        AbstractWorkflowServiceIntegrationTest.assertNotNull(existingInstances);
        AbstractWorkflowServiceIntegrationTest.assertEquals((int)0, (int)existingInstances.size());
        existingInstances = this.workflowService.getWorkflowsForContent(contentNode, false);
        AbstractWorkflowServiceIntegrationTest.assertNotNull(existingInstances);
        AbstractWorkflowServiceIntegrationTest.assertEquals((int)0, (int)existingInstances.size());
        this.nodeService.addChild(pckgNode, contentNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"cm", (String)"test123"));
        WorkflowDefinition workflowDef = this.deployDefinition(this.getAdhocDefinitionPath());
        HashMap<QName, Serializable> parameters = new HashMap<QName, Serializable>();
        parameters.put(WorkflowModel.ASSOC_PACKAGE, (Serializable)pckgNode);
        parameters.put(WorkflowModel.ASSOC_ASSIGNEE, (Serializable)this.personManager.get(USER2));
        WorkflowPath path = this.workflowService.startWorkflow(workflowDef.getId(), parameters);
        AbstractWorkflowServiceIntegrationTest.assertNotNull((Object)path);
        AbstractWorkflowServiceIntegrationTest.assertTrue((boolean)path.isActive());
        AbstractWorkflowServiceIntegrationTest.assertNotNull((Object)path.getNode());
        AbstractWorkflowServiceIntegrationTest.assertNotNull((Object)path.getInstance());
        AbstractWorkflowServiceIntegrationTest.assertEquals((String)workflowDef.getId(), (String)path.getInstance().getDefinition().getId());
        String workflowDefId = (String)((Object)this.nodeService.getProperty(pckgNode, WorkflowModel.PROP_WORKFLOW_DEFINITION_ID));
        AbstractWorkflowServiceIntegrationTest.assertEquals((String)workflowDefId, (String)workflowDef.getId());
        String workflowDefName = (String)((Object)this.nodeService.getProperty(pckgNode, WorkflowModel.PROP_WORKFLOW_DEFINITION_NAME));
        AbstractWorkflowServiceIntegrationTest.assertEquals((String)workflowDefName, (String)workflowDef.getName());
        String workflowInstanceId = (String)((Object)this.nodeService.getProperty(pckgNode, WorkflowModel.PROP_WORKFLOW_INSTANCE_ID));
        AbstractWorkflowServiceIntegrationTest.assertEquals((String)workflowInstanceId, (String)path.getInstance().getId());
        List<WorkflowInstance> instances = this.workflowService.getWorkflowsForContent(contentNode, true);
        AbstractWorkflowServiceIntegrationTest.assertNotNull(instances);
        AbstractWorkflowServiceIntegrationTest.assertEquals((int)1, (int)instances.size());
        WorkflowInstance newInstance = instances.get(0);
        AbstractWorkflowServiceIntegrationTest.assertNotNull((Object)newInstance);
        AbstractWorkflowServiceIntegrationTest.assertEquals((String)path.getInstance().getId(), (String)newInstance.getId());
        List<WorkflowInstance> completedInstances = this.workflowService.getWorkflowsForContent(contentNode, false);
        AbstractWorkflowServiceIntegrationTest.assertNotNull(completedInstances);
        AbstractWorkflowServiceIntegrationTest.assertEquals((int)0, (int)completedInstances.size());
    }

    public void testTaskCapabilities() {
        this.personManager.setUser(USER1);
        WorkflowDefinition workflowDef = this.deployDefinition(this.getAdhocDefinitionPath());
        AbstractWorkflowServiceIntegrationTest.assertNotNull((Object)workflowDef);
        HashMap<QName, Serializable> params = new HashMap<QName, Serializable>();
        NodeRef wfPackage = this.workflowService.createPackage(null);
        params.put(WorkflowModel.ASSOC_PACKAGE, (Serializable)wfPackage);
        Date dueDate = new Date();
        params.put(WorkflowModel.PROP_WORKFLOW_DUE_DATE, dueDate);
        params.put(WorkflowModel.PROP_WORKFLOW_PRIORITY, Integer.valueOf(1));
        NodeRef assignee = this.personManager.get(USER2);
        params.put(WorkflowModel.ASSOC_ASSIGNEE, (Serializable)assignee);
        WorkflowPath path = this.workflowService.startWorkflow(workflowDef.getId(), params);
        AbstractWorkflowServiceIntegrationTest.assertNotNull((Object)path);
        AbstractWorkflowServiceIntegrationTest.assertTrue((boolean)path.isActive());
        String workflowInstanceId = path.getInstance().getId();
        WorkflowTask startTask = this.workflowService.getStartTask(workflowInstanceId);
        String startTaskId = startTask.getId();
        this.workflowService.endTask(startTaskId, null);
        startTask = this.workflowService.getTaskById(startTaskId);
        AbstractWorkflowServiceIntegrationTest.assertNotNull((Object)startTask);
        AbstractWorkflowServiceIntegrationTest.assertEquals((Object)((Object)startTask.getState()), (Object)((Object)WorkflowTaskState.COMPLETED));
        AbstractWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.isTaskClaimable(startTask, USER1));
        AbstractWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.isTaskEditable(startTask, USER1));
        AbstractWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.isTaskReassignable(startTask, USER1));
        AbstractWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.isTaskReleasable(startTask, USER1));
        List<WorkflowPath> paths = this.workflowService.getWorkflowPaths(workflowInstanceId);
        AbstractWorkflowServiceIntegrationTest.assertNotNull(paths);
        AbstractWorkflowServiceIntegrationTest.assertEquals((int)1, (int)paths.size());
        List<WorkflowTask> tasks = this.workflowService.getTasksForWorkflowPath(path.getId());
        AbstractWorkflowServiceIntegrationTest.assertEquals((int)1, (int)tasks.size());
        WorkflowTask currentTask = tasks.get(0);
        AbstractWorkflowServiceIntegrationTest.assertEquals((Object)((Object)currentTask.getState()), (Object)((Object)WorkflowTaskState.IN_PROGRESS));
        AbstractWorkflowServiceIntegrationTest.assertEquals((Object)currentTask.getProperties().get(ContentModel.PROP_OWNER), (Object)USER2);
        AbstractWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.isTaskClaimable(currentTask, USER1));
        AbstractWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.isTaskClaimable(currentTask, USER2));
        AbstractWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.isTaskClaimable(currentTask, USER3));
        AbstractWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.isTaskReleasable(currentTask, USER1));
        AbstractWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.isTaskReleasable(currentTask, USER2));
        AbstractWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.isTaskReleasable(currentTask, USER3));
        AbstractWorkflowServiceIntegrationTest.assertTrue((boolean)this.workflowService.isTaskEditable(currentTask, USER1));
        AbstractWorkflowServiceIntegrationTest.assertTrue((boolean)this.workflowService.isTaskEditable(currentTask, USER2));
        AbstractWorkflowServiceIntegrationTest.assertTrue((boolean)this.workflowService.isTaskReassignable(currentTask, USER1));
        AbstractWorkflowServiceIntegrationTest.assertTrue((boolean)this.workflowService.isTaskReassignable(currentTask, USER2));
        AbstractWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.isTaskEditable(currentTask, USER3));
        AbstractWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.isTaskReassignable(currentTask, USER3));
        this.workflowService.cancelWorkflow(workflowInstanceId);
    }

    public void testPooledTaskCapabilities() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        WorkflowDefinition workflowDef = this.deployDefinition(this.getPooledReviewDefinitionPath());
        AbstractWorkflowServiceIntegrationTest.assertNotNull((Object)workflowDef);
        HashMap<QName, Serializable> params = new HashMap<QName, Serializable>();
        NodeRef wfPackage = this.workflowService.createPackage(null);
        params.put(WorkflowModel.ASSOC_PACKAGE, (Serializable)wfPackage);
        Date dueDate = new Date();
        params.put(WorkflowModel.PROP_WORKFLOW_DUE_DATE, dueDate);
        params.put(WorkflowModel.PROP_WORKFLOW_PRIORITY, Integer.valueOf(1));
        NodeRef group = this.groupManager.get(GROUP);
        AbstractWorkflowServiceIntegrationTest.assertNotNull((Object)group);
        params.put(WorkflowModel.ASSOC_GROUP_ASSIGNEE, (Serializable)group);
        WorkflowPath path = this.workflowService.startWorkflow(workflowDef.getId(), params);
        AbstractWorkflowServiceIntegrationTest.assertNotNull((Object)path);
        AbstractWorkflowServiceIntegrationTest.assertTrue((boolean)path.isActive());
        String workflowInstanceId = path.getInstance().getId();
        WorkflowTask startTask = this.workflowService.getStartTask(workflowInstanceId);
        String startTaskId = startTask.getId();
        this.workflowService.endTask(startTaskId, null);
        List<WorkflowPath> paths = this.workflowService.getWorkflowPaths(workflowInstanceId);
        AbstractWorkflowServiceIntegrationTest.assertNotNull(paths);
        AbstractWorkflowServiceIntegrationTest.assertEquals((int)1, (int)paths.size());
        List<WorkflowTask> tasks = this.workflowService.getTasksForWorkflowPath(path.getId());
        AbstractWorkflowServiceIntegrationTest.assertEquals((int)1, (int)tasks.size());
        WorkflowTask currentTask = tasks.get(0);
        AbstractWorkflowServiceIntegrationTest.assertEquals((Object)((Object)currentTask.getState()), (Object)((Object)WorkflowTaskState.IN_PROGRESS));
        Map<QName, Serializable> taskProperties = currentTask.getProperties();
        AbstractWorkflowServiceIntegrationTest.assertNull((Object)taskProperties.get(ContentModel.PROP_OWNER));
        Serializable pooledActors = taskProperties.get(WorkflowModel.ASSOC_POOLED_ACTORS);
        AbstractWorkflowServiceIntegrationTest.assertNotNull((Object)pooledActors);
        AbstractWorkflowServiceIntegrationTest.assertTrue((boolean)((Collection)((Object)pooledActors)).contains(group));
        AbstractWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.isTaskReassignable(currentTask, USER1));
        AbstractWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.isTaskReassignable(currentTask, USER2));
        AbstractWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.isTaskReassignable(currentTask, USER3));
        AbstractWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.isTaskReleasable(currentTask, USER1));
        AbstractWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.isTaskReleasable(currentTask, USER2));
        AbstractWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.isTaskReleasable(currentTask, USER3));
        AbstractWorkflowServiceIntegrationTest.assertTrue((boolean)this.workflowService.isTaskClaimable(currentTask, USER1));
        AbstractWorkflowServiceIntegrationTest.assertTrue((boolean)this.workflowService.isTaskClaimable(currentTask, USER2));
        AbstractWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.isTaskClaimable(currentTask, USER3));
        AbstractWorkflowServiceIntegrationTest.assertTrue((boolean)this.workflowService.isTaskEditable(currentTask, USER1));
        AbstractWorkflowServiceIntegrationTest.assertTrue((boolean)this.workflowService.isTaskEditable(currentTask, USER2));
        AbstractWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.isTaskEditable(currentTask, USER3));
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>(8);
        properties.put(ContentModel.PROP_OWNER, (Serializable)((Object)USER1));
        this.workflowService.updateTask(currentTask.getId(), properties, null, null);
        currentTask = this.workflowService.getTaskById(currentTask.getId());
        AbstractWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.isTaskClaimable(currentTask, USER1));
        AbstractWorkflowServiceIntegrationTest.assertTrue((boolean)this.workflowService.isTaskReleasable(currentTask, USER1));
        AbstractWorkflowServiceIntegrationTest.assertTrue((boolean)this.workflowService.isTaskEditable(currentTask, USER1));
        AbstractWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.isTaskReassignable(currentTask, USER1));
        AbstractWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.isTaskClaimable(currentTask, USER2));
        AbstractWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.isTaskEditable(currentTask, USER2));
        properties.clear();
        properties.put(ContentModel.PROP_OWNER, null);
        this.workflowService.updateTask(currentTask.getId(), properties, null, null);
        currentTask = this.workflowService.getTaskById(currentTask.getId());
        AbstractWorkflowServiceIntegrationTest.assertTrue((boolean)this.workflowService.isTaskClaimable(currentTask, USER1));
        properties.clear();
        NodeRef person2 = this.personManager.get(USER2);
        NodeRef person3 = this.personManager.get(USER3);
        List<NodeRef> actors = Arrays.asList(person2, person3);
        properties.put(WorkflowModel.ASSOC_POOLED_ACTORS, (Serializable)((Object)actors));
        currentTask = this.workflowService.updateTask(currentTask.getId(), properties, null, null);
        taskProperties = currentTask.getProperties();
        Collection newActors = (Collection)((Object)taskProperties.get(WorkflowModel.ASSOC_POOLED_ACTORS));
        AbstractWorkflowServiceIntegrationTest.assertEquals((int)2, (int)newActors.size());
        AbstractWorkflowServiceIntegrationTest.assertTrue((boolean)newActors.contains(person2));
        AbstractWorkflowServiceIntegrationTest.assertTrue((boolean)newActors.contains(person3));
        AbstractWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.isTaskReassignable(currentTask, USER1));
        AbstractWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.isTaskReassignable(currentTask, USER2));
        AbstractWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.isTaskReassignable(currentTask, USER3));
        AbstractWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.isTaskReleasable(currentTask, USER1));
        AbstractWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.isTaskReleasable(currentTask, USER2));
        AbstractWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.isTaskReleasable(currentTask, USER3));
        AbstractWorkflowServiceIntegrationTest.assertTrue((boolean)this.workflowService.isTaskClaimable(currentTask, USER2));
        AbstractWorkflowServiceIntegrationTest.assertTrue((boolean)this.workflowService.isTaskClaimable(currentTask, USER3));
        AbstractWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.isTaskClaimable(currentTask, USER1));
        AbstractWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.isTaskEditable(currentTask, USER1));
        AbstractWorkflowServiceIntegrationTest.assertTrue((boolean)this.workflowService.isTaskEditable(currentTask, USER2));
        AbstractWorkflowServiceIntegrationTest.assertTrue((boolean)this.workflowService.isTaskEditable(currentTask, USER3));
        properties.clear();
        properties.put(ContentModel.PROP_OWNER, (Serializable)((Object)USER3));
        currentTask = this.workflowService.updateTask(currentTask.getId(), properties, null, null);
        taskProperties = currentTask.getProperties();
        AbstractWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.isTaskClaimable(currentTask, USER1));
        AbstractWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.isTaskClaimable(currentTask, USER2));
        AbstractWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.isTaskClaimable(currentTask, USER3));
        AbstractWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.isTaskReleasable(currentTask, USER1));
        AbstractWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.isTaskReleasable(currentTask, USER2));
        AbstractWorkflowServiceIntegrationTest.assertTrue((boolean)this.workflowService.isTaskReleasable(currentTask, USER3));
        AbstractWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.isTaskEditable(currentTask, USER1));
        AbstractWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.isTaskEditable(currentTask, USER2));
        AbstractWorkflowServiceIntegrationTest.assertTrue((boolean)this.workflowService.isTaskEditable(currentTask, USER3));
        AbstractWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.isTaskReassignable(currentTask, USER1));
        AbstractWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.isTaskReassignable(currentTask, USER2));
        AbstractWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.isTaskReassignable(currentTask, USER3));
        this.workflowService.cancelWorkflow(workflowInstanceId);
    }

    public void testGetWorkflowTaskDefinitions() {
        WorkflowDefinition definition = this.deployDefinition(this.getAdhocDefinitionPath());
        String workflowDefId = definition.getId();
        List<WorkflowTaskDefinition> taskDefs = this.workflowService.getTaskDefinitions(workflowDefId);
        AbstractWorkflowServiceIntegrationTest.assertEquals((int)3, (int)taskDefs.size());
    }

    public void testGetTimers() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        WorkflowDefinition workflowDef = this.deployDefinition(this.getTestTimerDefinitionPath());
        AbstractWorkflowServiceIntegrationTest.assertNotNull((Object)workflowDef);
        HashMap<QName, Serializable> params = new HashMap<QName, Serializable>();
        NodeRef wfPackage = this.workflowService.createPackage(null);
        params.put(WorkflowModel.ASSOC_PACKAGE, (Serializable)wfPackage);
        Date dueDate = new Date();
        params.put(WorkflowModel.PROP_WORKFLOW_DUE_DATE, dueDate);
        params.put(WorkflowModel.PROP_WORKFLOW_PRIORITY, Integer.valueOf(1));
        NodeRef assignee = this.personManager.get(USER2);
        params.put(WorkflowModel.ASSOC_ASSIGNEE, (Serializable)assignee);
        WorkflowPath path = this.workflowService.startWorkflow(workflowDef.getId(), params);
        AbstractWorkflowServiceIntegrationTest.assertNotNull((Object)path);
        AbstractWorkflowServiceIntegrationTest.assertTrue((boolean)path.isActive());
        String workflowInstanceId = path.getInstance().getId();
        WorkflowTask startTask = this.workflowService.getStartTask(workflowInstanceId);
        String startTaskId = startTask.getId();
        this.workflowService.endTask(startTaskId, null);
        WorkflowTask task = this.getNextTaskForWorkflow(workflowInstanceId);
        List<WorkflowTimer> timers = this.workflowService.getTimers(workflowInstanceId);
        AbstractWorkflowServiceIntegrationTest.assertNotNull(timers);
        AbstractWorkflowServiceIntegrationTest.assertEquals((int)1, (int)timers.size());
        WorkflowTimer timer = timers.get(0);
        AbstractWorkflowServiceIntegrationTest.assertNotNull((Object)timer.getId());
        AbstractWorkflowServiceIntegrationTest.assertNotNull((Object)timer.getDueDate());
        AbstractWorkflowServiceIntegrationTest.assertNotNull((Object)timer.getName());
        AbstractWorkflowServiceIntegrationTest.assertNull((Object)timer.getError());
        AbstractWorkflowServiceIntegrationTest.assertNotNull((Object)timer.getPath());
        AbstractWorkflowServiceIntegrationTest.assertEquals((String)task.getPath().getId(), (String)timer.getPath().getId());
        AbstractWorkflowServiceIntegrationTest.assertEquals((String)workflowInstanceId, (String)timer.getPath().getInstance().getId());
        AbstractWorkflowServiceIntegrationTest.assertNotNull((Object)timer.getPath().getNode());
        AbstractWorkflowServiceIntegrationTest.assertTrue((boolean)timer.getPath().getNode().isTaskNode());
        AbstractWorkflowServiceIntegrationTest.assertNotNull((Object)timer.getTask());
        AbstractWorkflowServiceIntegrationTest.assertEquals((String)task.getId(), (String)timer.getTask().getId());
        this.workflowService.endTask(task.getId(), null);
        timers = this.workflowService.getTimers(workflowInstanceId);
        AbstractWorkflowServiceIntegrationTest.assertNotNull(timers);
        AbstractWorkflowServiceIntegrationTest.assertEquals((int)0, (int)timers.size());
    }

    public void testQueryTasks() {
        WorkflowDefinition workflowDef = this.deployDefinition(this.getAdhocDefinitionPath());
        AbstractWorkflowServiceIntegrationTest.assertNotNull((Object)workflowDef);
        String workflowInstanceId = this.startAdhocWorkflow(workflowDef, USER2);
        this.personManager.setUser(USER2);
        WorkflowTask startTask = this.workflowService.getStartTask(workflowInstanceId);
        String startTaskId = startTask.getId();
        this.workflowService.endTask(startTaskId, null);
        WorkflowTask theTask = this.getNextTaskForWorkflow(workflowInstanceId);
        HashMap<QName, Serializable> params = new HashMap<QName, Serializable>();
        params.put(customStringProp, (Serializable)((Object)"stringValue"));
        this.workflowService.updateTask(theTask.getId(), params, null, null);
        this.checkTaskQueryInProgress(workflowInstanceId, theTask, workflowInstanceId);
        this.checkTaskQueryStartTaskCompleted(workflowInstanceId, startTask);
        this.workflowService.endTask(theTask.getId(), null);
        this.checkTaskQueryTaskCompleted(workflowInstanceId, theTask, startTask);
        WorkflowTask lastTask = this.getNextTaskForWorkflow(workflowInstanceId);
        this.workflowService.endTask(lastTask.getId(), null);
        this.checkQueryTasksInactiveWorkflow(workflowInstanceId);
    }

    public void testQueryTaskLimit() throws Exception {
        WorkflowDefinition workflowDef = this.deployDefinition(this.getAdhocDefinitionPath());
        for (int x = 0; x < 5; ++x) {
            this.executeAdhocWorkflow(workflowDef);
        }
        WorkflowTaskQuery query = new WorkflowTaskQuery();
        query.setActive(false);
        query.setActorId(USER3);
        query.setTaskState(WorkflowTaskState.COMPLETED);
        List<WorkflowTask> tasks = this.workflowService.queryTasks(query);
        AbstractWorkflowServiceIntegrationTest.assertTrue((tasks.size() > 5 ? 1 : 0) != 0);
        query.setLimit(5);
        tasks = this.workflowService.queryTasks(query);
        AbstractWorkflowServiceIntegrationTest.assertEquals((int)5, (int)tasks.size());
    }

    protected void checkQueryTasksInactiveWorkflow(String workflowInstanceId) {
        WorkflowTaskQuery taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.COMPLETED);
        taskQuery.setActive(false);
        taskQuery.setProcessId(workflowInstanceId);
        List<WorkflowTask> tasks = this.workflowService.queryTasks(taskQuery);
        AbstractWorkflowServiceIntegrationTest.assertNotNull(tasks);
        AbstractWorkflowServiceIntegrationTest.assertEquals((int)3, (int)tasks.size());
        taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.COMPLETED);
        taskQuery.setActive(true);
        taskQuery.setProcessId(workflowInstanceId);
        this.checkNoTasksFoundUsingQuery(taskQuery);
    }

    protected void checkTaskQueryTaskCompleted(String workflowInstanceId, WorkflowTask theTask, WorkflowTask startTask) {
        List<String> expectedTasks = Arrays.asList(theTask.getId(), startTask.getId());
        this.checkProcessIdQuery(workflowInstanceId, expectedTasks, WorkflowTaskState.COMPLETED);
        QName taskName = QName.createQName((String)"http://www.alfresco.org/model/workflow/1.0", (String)"adhocTask");
        this.checkTaskNameQuery(taskName, Arrays.asList(theTask.getId()), WorkflowTaskState.COMPLETED, workflowInstanceId);
        this.checkActorIdQuery(USER2, Arrays.asList(theTask.getId()), WorkflowTaskState.COMPLETED, null);
        this.checkIsActiveQuery(expectedTasks, WorkflowTaskState.COMPLETED, workflowInstanceId);
        this.checkTaskPropsQuery(expectedTasks, WorkflowTaskState.COMPLETED, null);
    }

    protected void checkTaskQueryInProgress(String workflowInstanceId, WorkflowTask expectedTask, String workflowInstanceId2) {
        List<String> expectedTasks = Arrays.asList(expectedTask.getId());
        this.checkProcessIdQuery(workflowInstanceId, expectedTasks, WorkflowTaskState.IN_PROGRESS);
        this.checkTaskIdQuery(expectedTask.getId(), WorkflowTaskState.IN_PROGRESS);
        QName taskName = QName.createQName((String)"http://www.alfresco.org/model/workflow/1.0", (String)"adhocTask");
        this.checkTaskNameQuery(taskName, expectedTasks, WorkflowTaskState.IN_PROGRESS, null);
        this.checkActorIdQuery(USER2, expectedTasks, WorkflowTaskState.IN_PROGRESS, null);
        this.checkIsActiveQuery(expectedTasks, WorkflowTaskState.IN_PROGRESS, workflowInstanceId);
        this.checkTaskPropsQuery(expectedTasks, WorkflowTaskState.IN_PROGRESS, null);
        this.checkProcessPropsQuery(expectedTasks, WorkflowTaskState.IN_PROGRESS);
    }

    protected void checkTaskQueryStartTaskCompleted(String workflowInstanceId, WorkflowTask startTask) {
        List<String> expectedTasks = Arrays.asList(startTask.getId());
        this.checkProcessIdQuery(workflowInstanceId, expectedTasks, WorkflowTaskState.COMPLETED);
        this.checkTaskIdQuery(startTask.getId(), WorkflowTaskState.COMPLETED);
        QName startTaskName = QName.createQName((String)"http://www.alfresco.org/model/workflow/1.0", (String)"submitAdhocTask");
        this.checkTaskNameQuery(startTaskName, expectedTasks, WorkflowTaskState.COMPLETED, null);
        this.checkActorIdQuery(USER1, expectedTasks, WorkflowTaskState.COMPLETED, null);
        this.checkIsActiveQuery(expectedTasks, WorkflowTaskState.COMPLETED, workflowInstanceId);
        this.checkTaskPropsQuery(expectedTasks, WorkflowTaskState.COMPLETED, null);
    }

    public void testGetWorkflows() throws Exception {
        String fakeDefId = this.getEngine() + "$9999999999999";
        List<WorkflowInstance> workflows = this.workflowService.getActiveWorkflows(fakeDefId);
        AbstractWorkflowServiceIntegrationTest.assertTrue((boolean)workflows.isEmpty());
        workflows = this.workflowService.getCompletedWorkflows(fakeDefId);
        AbstractWorkflowServiceIntegrationTest.assertTrue((boolean)workflows.isEmpty());
        workflows = this.workflowService.getWorkflows(fakeDefId);
        AbstractWorkflowServiceIntegrationTest.assertTrue((boolean)workflows.isEmpty());
        WorkflowDefinition definition = this.deployDefinition(this.getTestDefinitionPath());
        String defId = definition.getId();
        workflows = this.workflowService.getActiveWorkflows(defId);
        AbstractWorkflowServiceIntegrationTest.assertTrue((boolean)workflows.isEmpty());
        workflows = this.workflowService.getCompletedWorkflows(defId);
        AbstractWorkflowServiceIntegrationTest.assertTrue((boolean)workflows.isEmpty());
        workflows = this.workflowService.getWorkflows(defId);
        AbstractWorkflowServiceIntegrationTest.assertTrue((boolean)workflows.isEmpty());
        Date dueDate = new Date();
        String description = "Some Description";
        NodeRef assignee = this.personManager.get(USER2);
        NodeRef wfPackage1 = this.workflowService.createPackage(null);
        HashMap<Object, Serializable> params = new HashMap<QName, Serializable>();
        params.put(WorkflowModel.ASSOC_PACKAGE, (Serializable)wfPackage1);
        params.put(WorkflowModel.PROP_WORKFLOW_DUE_DATE, dueDate);
        params.put(WorkflowModel.PROP_WORKFLOW_PRIORITY, Integer.valueOf(1));
        params.put(WorkflowModel.PROP_WORKFLOW_DESCRIPTION, (Serializable)((Object)description));
        params.put(WorkflowModel.ASSOC_ASSIGNEE, (Serializable)assignee);
        WorkflowPath path1 = this.workflowService.startWorkflow(defId, params);
        String instance1 = path1.getInstance().getId();
        this.checkActiveWorkflows(defId, instance1);
        this.checkCompletedWorkflows(defId, new String[0]);
        this.checkWorkflows(defId, instance1);
        NodeRef wfPackage2 = this.workflowService.createPackage(null);
        params = new HashMap();
        params.put(WorkflowModel.ASSOC_PACKAGE, (Serializable)wfPackage2);
        params.put(WorkflowModel.PROP_WORKFLOW_DUE_DATE, dueDate);
        params.put(WorkflowModel.PROP_WORKFLOW_PRIORITY, Integer.valueOf(1));
        params.put(WorkflowModel.PROP_WORKFLOW_DESCRIPTION, (Serializable)((Object)description));
        params.put(WorkflowModel.ASSOC_ASSIGNEE, (Serializable)assignee);
        WorkflowPath path2 = this.workflowService.startWorkflow(defId, params);
        String instance2 = path2.getInstance().getId();
        this.checkActiveWorkflows(defId, instance1, instance2);
        this.checkCompletedWorkflows(defId, new String[0]);
        this.checkWorkflows(defId, instance1, instance2);
        WorkflowTask startTask1 = this.workflowService.getStartTask(instance1);
        this.workflowService.endTask(startTask1.getId(), null);
        List<WorkflowTask> tasks = this.workflowService.getTasksForWorkflowPath(path1.getId());
        AbstractWorkflowServiceIntegrationTest.assertEquals((int)1, (int)tasks.size());
        WorkflowTask task1 = tasks.get(0);
        this.workflowService.endTask(task1.getId(), null);
        this.checkActiveWorkflows(defId, instance2);
        this.checkCompletedWorkflows(defId, instance1);
        this.checkWorkflows(defId, instance1, instance2);
        this.checkWorkflowsContains(this.workflowService.getActiveWorkflows(), instance2);
        this.checkWorkflowsDontContain(this.workflowService.getActiveWorkflows(), instance1);
        this.checkWorkflowsContains(this.workflowService.getCompletedWorkflows(), instance1);
        this.checkWorkflowsDontContain(this.workflowService.getCompletedWorkflows(), instance2);
        this.checkWorkflowsContains(this.workflowService.getWorkflows(), instance1, instance2);
        WorkflowTask startTask2 = this.workflowService.getStartTask(instance2);
        this.workflowService.endTask(startTask2.getId(), null);
        tasks = this.workflowService.getTasksForWorkflowPath(path2.getId());
        AbstractWorkflowServiceIntegrationTest.assertEquals((int)1, (int)tasks.size());
        WorkflowTask task2 = tasks.get(0);
        this.workflowService.endTask(task2.getId(), null);
        this.checkActiveWorkflows(defId, new String[0]);
        this.checkCompletedWorkflows(defId, instance1, instance2);
        this.checkWorkflows(defId, instance1, instance2);
    }

    public void testDeleteWorkflow() throws Exception {
    }

    public void checkWorkflows(String defId, String ... expectedIds) {
        List<WorkflowInstance> workflows = this.workflowService.getWorkflows(defId);
        this.checkWorkflows(workflows, expectedIds);
    }

    public void testParallelReview() throws Exception {
        WorkflowDefinition workflowDef = this.deployDefinition(this.getParallelReviewDefinitionPath());
        AbstractWorkflowServiceIntegrationTest.assertNotNull((Object)workflowDef);
        HashMap<QName, Serializable> params = new HashMap<QName, Serializable>();
        NodeRef wfPackage = this.workflowService.createPackage(null);
        params.put(WorkflowModel.ASSOC_PACKAGE, (Serializable)wfPackage);
        Date dueDate = new Date();
        params.put(WorkflowModel.PROP_WORKFLOW_DUE_DATE, dueDate);
        params.put(WorkflowModel.PROP_WORKFLOW_PRIORITY, Integer.valueOf(1));
        NodeRef group = this.groupManager.get(GROUP);
        AbstractWorkflowServiceIntegrationTest.assertNotNull((Object)group);
        List<NodeRef> assignees = Arrays.asList(this.personManager.get(USER2), this.personManager.get(USER3));
        params.put(WorkflowModel.ASSOC_ASSIGNEES, (Serializable)((Object)assignees));
        WorkflowPath path = this.workflowService.startWorkflow(workflowDef.getId(), params);
        AbstractWorkflowServiceIntegrationTest.assertNotNull((Object)path);
        AbstractWorkflowServiceIntegrationTest.assertTrue((boolean)path.isActive());
        String instnaceId = path.getInstance().getId();
        WorkflowTask startTask = this.workflowService.getStartTask(instnaceId);
        this.workflowService.endTask(startTask.getId(), null);
        this.personManager.setUser(USER2);
        List<WorkflowTask> tasks = this.workflowService.getAssignedTasks(USER2, WorkflowTaskState.IN_PROGRESS);
        AbstractWorkflowServiceIntegrationTest.assertEquals((int)1, (int)tasks.size());
        this.personManager.setUser(USER3);
        tasks = this.workflowService.getAssignedTasks(USER3, WorkflowTaskState.IN_PROGRESS);
        AbstractWorkflowServiceIntegrationTest.assertEquals((int)1, (int)tasks.size());
    }

    public void checkCompletedWorkflows(String defId, String ... expectedIds) {
        List<WorkflowInstance> workflows = this.workflowService.getCompletedWorkflows(defId);
        this.checkWorkflows(workflows, expectedIds);
    }

    private void checkActiveWorkflows(String defId, String ... expectedIds) {
        List<WorkflowInstance> workflows = this.workflowService.getActiveWorkflows(defId);
        this.checkWorkflows(workflows, expectedIds);
    }

    private void checkWorkflows(List<WorkflowInstance> workflows, String ... expectedIds) {
        AbstractWorkflowServiceIntegrationTest.assertEquals((int)expectedIds.length, (int)workflows.size());
        List<String> expIds = Arrays.asList(expectedIds);
        for (WorkflowInstance workflow : workflows) {
            String workflowId = workflow.getId();
            AbstractWorkflowServiceIntegrationTest.assertTrue((String)("The id: " + workflowId + " was not expected! Expected Ids: " + expIds), (boolean)expIds.contains(workflowId));
        }
    }

    private void checkWorkflowsContains(List<WorkflowInstance> workflows, String ... expectedIds) {
        List<String> expIds = Arrays.asList(expectedIds);
        List workflowIds = CollectionUtils.transform(workflows, (Function)new Function<WorkflowInstance, String>(){

            public String apply(WorkflowInstance workflow) {
                return workflow.getId();
            }
        });
        AbstractWorkflowServiceIntegrationTest.assertTrue((boolean)workflowIds.containsAll(expIds));
    }

    private void checkWorkflowsDontContain(List<WorkflowInstance> workflows, String ... expectedIds) {
        List<String> expIds = Arrays.asList(expectedIds);
        for (WorkflowInstance instance : workflows) {
            AbstractWorkflowServiceIntegrationTest.assertFalse((boolean)expIds.contains(instance.getId()));
        }
    }

    protected void checkTaskNameQuery(QName taskName, List<String> expectedTaskIds, WorkflowTaskState state, String optionalProcessId) {
        WorkflowTaskQuery taskQuery = this.createWorkflowTaskQuery(state);
        taskQuery.setTaskName(taskName);
        if (optionalProcessId != null) {
            taskQuery.setProcessId(optionalProcessId);
        }
        this.checkTasksFoundUsingQuery(expectedTaskIds, taskQuery);
        QName unexistingTaskName = QName.createQName((String)"http://www.alfresco.org/model/workflow/1.0", (String)"unexistingTask");
        taskQuery = this.createWorkflowTaskQuery(state);
        taskQuery.setTaskName(unexistingTaskName);
        if (optionalProcessId != null) {
            taskQuery.setProcessId(optionalProcessId);
        }
        this.checkNoTasksFoundUsingQuery(taskQuery);
    }

    protected void checkProcessIdQuery(String workflowInstanceId, List<String> expectedTaskIds, WorkflowTaskState state) {
        WorkflowTaskQuery taskQuery = this.createWorkflowTaskQuery(state);
        taskQuery.setProcessId(workflowInstanceId);
        this.checkTasksFoundUsingQuery(expectedTaskIds, taskQuery);
        taskQuery = this.createWorkflowTaskQuery(state);
        taskQuery.setProcessId(BPMEngineRegistry.createGlobalId(this.getEngine(), "99999999999"));
        this.checkNoTasksFoundUsingQuery(taskQuery);
    }

    protected void checkTaskIdQuery(String expectedTaskId, WorkflowTaskState state) {
        WorkflowTaskQuery taskQuery = this.createWorkflowTaskQuery(state);
        taskQuery.setTaskId(expectedTaskId);
        this.checkTasksFoundUsingQuery(Arrays.asList(expectedTaskId), taskQuery);
        taskQuery = this.createWorkflowTaskQuery(state);
        taskQuery.setTaskId(BPMEngineRegistry.createGlobalId(this.getEngine(), "99999999999"));
        this.checkNoTasksFoundUsingQuery(taskQuery);
    }

    protected void checkIsActiveQuery(List<String> expectedTaskIds, WorkflowTaskState state, String optionalProcessId) {
        WorkflowTaskQuery taskQuery = this.createWorkflowTaskQuery(state);
        taskQuery.setActive(true);
        if (optionalProcessId != null) {
            taskQuery.setProcessId(optionalProcessId);
        }
        this.checkTasksFoundUsingQuery(expectedTaskIds, taskQuery);
        taskQuery = this.createWorkflowTaskQuery(state);
        taskQuery.setActive(false);
        if (optionalProcessId != null) {
            taskQuery.setProcessId(optionalProcessId);
        }
        this.checkNoTasksFoundUsingQuery(taskQuery);
    }

    protected void checkActorIdQuery(String actorId, List<String> expectedTaskIds, WorkflowTaskState state, String optionalProcessId) {
        WorkflowTaskQuery taskQuery = this.createWorkflowTaskQuery(state);
        taskQuery.setActorId(actorId);
        if (optionalProcessId != null) {
            taskQuery.setProcessId(optionalProcessId);
        }
        this.checkTasksFoundUsingQuery(expectedTaskIds, taskQuery);
        taskQuery = this.createWorkflowTaskQuery(state);
        taskQuery.setActorId(USER3);
        if (optionalProcessId != null) {
            taskQuery.setProcessId(optionalProcessId);
        }
        this.checkNoTasksFoundUsingQuery(taskQuery);
    }

    protected void checkTaskPropsQuery(List<String> expectedTaskIds, WorkflowTaskState state, String optionalProcessId) {
        WorkflowTaskQuery taskQuery = this.createWorkflowTaskQuery(state);
        HashMap<Object, Object> taskProps = new HashMap<QName, Object>();
        taskProps.put(customStringProp, "stringValue");
        taskQuery.setTaskCustomProps(taskProps);
        if (optionalProcessId != null) {
            taskQuery.setProcessId(optionalProcessId);
        }
        this.checkTasksFoundUsingQuery(expectedTaskIds, taskQuery);
        taskProps = new HashMap();
        taskProps.put(customStringProp, "otherValue");
        taskQuery = this.createWorkflowTaskQuery(state);
        taskQuery.setTaskCustomProps(taskProps);
        if (optionalProcessId != null) {
            taskQuery.setProcessId(optionalProcessId);
        }
        this.checkNoTasksFoundUsingQuery(taskQuery);
    }

    protected void checkProcessNameQuery(List<String> expectedTaskIds, WorkflowTaskState state) {
        WorkflowTaskQuery taskQuery = this.createWorkflowTaskQuery(state);
        taskQuery.setProcessName(this.getAdhocProcessName());
        this.checkTasksFoundUsingQuery(expectedTaskIds, taskQuery);
        taskQuery = this.createWorkflowTaskQuery(state);
        taskQuery.setProcessName(QName.createQName((String)"dummyProcessName"));
        this.checkNoTasksFoundUsingQuery(taskQuery);
        taskQuery.setWorkflowDefinitionName(this.getAdhocProcessName().toPrefixString());
        this.checkTasksFoundUsingQuery(expectedTaskIds, taskQuery);
        taskQuery = this.createWorkflowTaskQuery(state);
        taskQuery.setWorkflowDefinitionName("dummyProcessName");
        this.checkNoTasksFoundUsingQuery(taskQuery);
    }

    protected void checkProcessPropsQuery(List<String> expectedTaskIds, WorkflowTaskState state) {
        WorkflowTaskQuery taskQuery = this.createWorkflowTaskQuery(state);
        HashMap<Object, Object> processProps = new HashMap<QName, Object>();
        processProps.put(WorkflowModel.PROP_WORKFLOW_DESCRIPTION, "Test workflow description");
        taskQuery.setProcessCustomProps(processProps);
        this.checkTasksFoundUsingQuery(expectedTaskIds, taskQuery);
        processProps = new HashMap();
        processProps.put(WorkflowModel.PROP_WORKFLOW_DESCRIPTION, "Wrong workflow description");
        taskQuery = this.createWorkflowTaskQuery(state);
        taskQuery.setTaskCustomProps(processProps);
        this.checkNoTasksFoundUsingQuery(taskQuery);
    }

    protected WorkflowTaskQuery createWorkflowTaskQuery(WorkflowTaskState state) {
        WorkflowTaskQuery taskQuery = new WorkflowTaskQuery();
        taskQuery.setTaskState(state);
        return taskQuery;
    }

    protected void checkTasksFoundUsingQuery(List<String> taskIds, WorkflowTaskQuery workflowTaskQuery) {
        List<WorkflowTask> tasks = this.workflowService.queryTasks(workflowTaskQuery);
        AbstractWorkflowServiceIntegrationTest.assertNotNull(tasks);
        AbstractWorkflowServiceIntegrationTest.assertEquals((int)taskIds.size(), (int)tasks.size());
        for (WorkflowTask task : tasks) {
            AbstractWorkflowServiceIntegrationTest.assertTrue((boolean)taskIds.contains(task.getId()));
        }
    }

    protected void checkNoTasksFoundUsingQuery(WorkflowTaskQuery workflowTaskQuery) {
        List<WorkflowTask> tasks = this.workflowService.queryTasks(workflowTaskQuery);
        AbstractWorkflowServiceIntegrationTest.assertNotNull(tasks);
        AbstractWorkflowServiceIntegrationTest.assertEquals((int)0, (int)tasks.size());
    }

    protected WorkflowTask getNextTaskForWorkflow(String workflowInstanceId) {
        WorkflowTaskQuery taskQuery = new WorkflowTaskQuery();
        taskQuery.setProcessId(workflowInstanceId);
        taskQuery.setTaskState(WorkflowTaskState.IN_PROGRESS);
        List<WorkflowTask> workflowTasks = this.workflowService.queryTasks(taskQuery);
        AbstractWorkflowServiceIntegrationTest.assertEquals((int)1, (int)workflowTasks.size());
        return workflowTasks.get(0);
    }

    protected WorkflowDefinition deployDefinition(String resource) {
        InputStream input = this.getInputStream(resource);
        WorkflowDeployment deployment = this.workflowService.deployDefinition(this.getEngine(), input, XML);
        WorkflowDefinition definition = deployment.getDefinition();
        return definition;
    }

    protected abstract QName getAdhocProcessName();

    private InputStream getInputStream(String resource) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader.getResourceAsStream(resource);
    }

    private void checkDefinitions(WorkflowDefinition expDefinition, boolean expContainsDef, WorkflowDefinition ... definitions) {
        String id = expDefinition.getId();
        for (WorkflowDefinition definition : definitions) {
            if (expContainsDef) {
                if (!definition.getId().equals(id)) continue;
                this.checkDefinition(expDefinition, definition);
                return;
            }
            if (!definition.getId().equals(id)) continue;
            AbstractWorkflowServiceIntegrationTest.fail((String)("The definitions unexpectedly contain id: " + id));
        }
        if (expContainsDef) {
            AbstractWorkflowServiceIntegrationTest.fail((String)("The definitions did not contain expected id: " + id));
        }
    }

    private void checkDefinition(WorkflowDefinition expDef, WorkflowDefinition actualDef) {
        AbstractWorkflowServiceIntegrationTest.assertEquals((String)expDef.getId(), (String)actualDef.getId());
        AbstractWorkflowServiceIntegrationTest.assertEquals((String)expDef.getName(), (String)actualDef.getName());
        AbstractWorkflowServiceIntegrationTest.assertEquals((String)expDef.getDescription(), (String)actualDef.getDescription());
        AbstractWorkflowServiceIntegrationTest.assertEquals((String)expDef.getTitle(), (String)actualDef.getTitle());
        AbstractWorkflowServiceIntegrationTest.assertEquals((String)expDef.getVersion(), (String)actualDef.getVersion());
    }

    private void executeAdhocWorkflow(WorkflowDefinition workflowDef) {
        this.personManager.setUser(USER3);
        String workflowId = this.startAdhocWorkflow(workflowDef, USER3);
        WorkflowTask startTask = this.workflowService.getStartTask(workflowId);
        String startTaskId = startTask.getId();
        this.workflowService.endTask(startTaskId, null);
        WorkflowTask adhocTask = this.getNextTaskForWorkflow(workflowId);
        this.workflowService.endTask(adhocTask.getId(), null);
        WorkflowTask lastTask = this.getNextTaskForWorkflow(workflowId);
        this.workflowService.endTask(lastTask.getId(), null);
        AbstractWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.getWorkflowById(workflowId).isActive());
    }

    private String startAdhocWorkflow(WorkflowDefinition workflowDef, String assigneeId) {
        HashMap<QName, Serializable> params = new HashMap<QName, Serializable>();
        NodeRef wfPackage = this.workflowService.createPackage(null);
        params.put(WorkflowModel.ASSOC_PACKAGE, (Serializable)wfPackage);
        Date dueDate = new Date();
        params.put(WorkflowModel.PROP_WORKFLOW_DUE_DATE, dueDate);
        params.put(WorkflowModel.PROP_WORKFLOW_PRIORITY, Integer.valueOf(1));
        params.put(WorkflowModel.PROP_WORKFLOW_DESCRIPTION, (Serializable)((Object)"Test workflow description"));
        params.put(customStringProp, (Serializable)((Object)"stringValue"));
        NodeRef assignee = this.personManager.get(assigneeId);
        params.put(WorkflowModel.ASSOC_ASSIGNEE, (Serializable)assignee);
        WorkflowPath path = this.workflowService.startWorkflow(workflowDef.getId(), params);
        AbstractWorkflowServiceIntegrationTest.assertNotNull((Object)path);
        AbstractWorkflowServiceIntegrationTest.assertTrue((boolean)path.isActive());
        return path.getInstance().getId();
    }

    protected void onSetUpInTransaction() throws Exception {
        super.onSetUpInTransaction();
        ServiceRegistry registry = (ServiceRegistry)this.applicationContext.getBean("ServiceRegistry");
        this.workflowService = registry.getWorkflowService();
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.nodeService = registry.getNodeService();
        Repository repositoryHelper = (Repository)this.applicationContext.getBean("repositoryHelper");
        this.companyHome = repositoryHelper.getCompanyHome();
        MutableAuthenticationService authenticationService = registry.getAuthenticationService();
        AuthorityService authorityService = registry.getAuthorityService();
        PersonService personService = registry.getPersonService();
        SearchService searchService = registry.getSearchService();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        WorkflowAdminServiceImpl workflowAdminService = (WorkflowAdminServiceImpl)this.applicationContext.getBean("workflowAdminService");
        this.wfTestHelper = new WorkflowTestHelper(workflowAdminService, this.getEngine(), true);
        this.personManager = new TestPersonManager(authenticationService, personService, this.nodeService);
        this.groupManager = new TestGroupManager(authorityService, searchService);
        this.personManager.createPerson(USER1);
        this.personManager.createPerson(USER2);
        this.personManager.createPerson(USER3);
        this.groupManager.addGroupToParent(GROUP, SUB_GROUP);
        this.groupManager.addUserToGroup(GROUP, USER1);
        this.groupManager.addUserToGroup(SUB_GROUP, USER2);
        this.personManager.setUser(USER1);
    }

    protected void onTearDownInTransaction() throws Exception {
        this.wfTestHelper.tearDown();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.groupManager.clearGroups();
        this.personManager.clearPeople();
        this.authenticationComponent.clearCurrentSecurityContext();
        super.onTearDownInTransaction();
    }

    protected abstract String getEngine();

    protected abstract String getTestDefinitionPath();

    protected abstract String getAdhocDefinitionPath();

    protected abstract String getPooledReviewDefinitionPath();

    protected abstract String getParallelReviewDefinitionPath();

    protected abstract String getTestTimerDefinitionPath();
}

