/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.activiti;

import java.io.InputStream;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.runtime.ProcessInstance;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

public class ActivitiSpringTransactionTest
extends TestCase {
    private static final QName PROP_CHECK_VALUE = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"check_value");
    private static final String PROC_DEF_KEY = "testTask";
    private static final QName ASPECT = ContentModel.ASPECT_ATTACHABLE;
    private RuntimeService runtime;
    private RepositoryService repo;
    private Deployment deployment;
    private AuthenticationComponent authenticationComponent;
    private NodeService nodeService;
    private RetryingTransactionHelper txnHelper;
    private NodeRef workingNodeRef;

    public void testSmoke() throws Exception {
        ActivitiSpringTransactionTest.assertNotNull((Object)this.runtime);
        ProcessInstance instance = this.runtime.startProcessInstanceByKey(PROC_DEF_KEY);
        ActivitiSpringTransactionTest.assertNotNull((Object)instance);
        String instanceId = instance.getId();
        ProcessInstance instanceInDb = this.findProcessInstance(instanceId);
        ActivitiSpringTransactionTest.assertNotNull((Object)instanceInDb);
        this.runtime.deleteProcessInstance(instance.getId(), "");
        ActivitiSpringTransactionTest.assertNotNull((Object)instance);
    }

    public void testRollbackFromAlfresco() {
        RetryingTransactionHelper.RetryingTransactionCallback<String> callback = new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

            @Override
            public String execute() throws Throwable {
                ProcessInstance instance = ActivitiSpringTransactionTest.this.runtime.startProcessInstanceByKey(ActivitiSpringTransactionTest.PROC_DEF_KEY);
                String id = instance.getId();
                try {
                    ActivitiSpringTransactionTest.this.blowUp();
                }
                catch (InvalidNodeRefException invalidNodeRefException) {
                    // empty catch block
                }
                return id;
            }
        };
        String id = this.txnHelper.doInTransaction(callback);
        ProcessInstance instance = this.findProcessInstance(id);
        if (instance != null) {
            this.runtime.deleteProcessInstance(id, "For test");
            ActivitiSpringTransactionTest.fail((String)"The process instance creation should have been rolled back!");
        }
    }

    public void testRollbackFromActiviti() {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ActivitiSpringTransactionTest.this.nodeService.addAspect(ActivitiSpringTransactionTest.this.workingNodeRef, ASPECT, null);
                Assert.assertTrue((String)"The node should have the aspect!", (boolean)ActivitiSpringTransactionTest.this.nodeService.hasAspect(ActivitiSpringTransactionTest.this.workingNodeRef, ASPECT));
                try {
                    ActivitiSpringTransactionTest.this.runtime.signal("Fake Id");
                    Assert.fail((String)"Should throw an Exception here!");
                }
                catch (ActivitiException activitiException) {
                    // empty catch block
                }
                return null;
            }
        };
        this.txnHelper.doInTransaction(callback);
        ActivitiSpringTransactionTest.assertFalse((String)"The node should not have the aspect!", (boolean)this.nodeService.hasAspect(this.workingNodeRef, ASPECT));
    }

    public void testNestedWithoutPropogation() {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void execute() throws Throwable {
                ProcessInstance instance = ActivitiSpringTransactionTest.this.runtime.startProcessInstanceByKey(ActivitiSpringTransactionTest.PROC_DEF_KEY);
                final String id = instance.getId();
                ProcessInstance instanceInDb = ActivitiSpringTransactionTest.this.findProcessInstance(id);
                Assert.assertNotNull((String)"Can't read process instance in same transaction!", (Object)instanceInDb);
                RetryingTransactionHelper.RetryingTransactionCallback<Void> callbackInner = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                    @Override
                    public Void execute() throws Throwable {
                        ProcessInstance instanceInDb2 = ActivitiSpringTransactionTest.this.findProcessInstance(id);
                        Assert.assertNull((String)"Should not be able to read process instance in inner transaction!", (Object)instanceInDb2);
                        return null;
                    }
                };
                try {
                    ActivitiSpringTransactionTest.this.txnHelper.doInTransaction(callbackInner, false, true);
                    Void void_ = null;
                    return void_;
                }
                finally {
                    ActivitiSpringTransactionTest.this.runtime.deleteProcessInstance(id, "FOr test");
                }
            }
        };
        this.txnHelper.doInTransaction(callback);
    }

    private Long blowUp() {
        NodeRef invalidNodeRef = new NodeRef(this.workingNodeRef.getStoreRef(), "BOGUS");
        this.nodeService.setProperty(invalidNodeRef, PROP_CHECK_VALUE, null);
        ActivitiSpringTransactionTest.fail((String)"Expected to generate an InvalidNodeRefException");
        return null;
    }

    private ProcessInstance findProcessInstance(String instanceId) {
        return (ProcessInstance)this.runtime.createProcessInstanceQuery().processInstanceId(instanceId).singleResult();
    }

    protected void setUp() throws Exception {
        ApplicationContext appContext = ApplicationContextHelper.getApplicationContext();
        this.repo = (RepositoryService)appContext.getBean("activitiRepositoryService");
        this.runtime = (RuntimeService)appContext.getBean("activitiRuntimeService");
        ServiceRegistry serviceRegistry = (ServiceRegistry)appContext.getBean("ServiceRegistry");
        this.authenticationComponent = (AuthenticationComponent)appContext.getBean("authenticationComponent");
        TransactionService transactionService = serviceRegistry.getTransactionService();
        this.nodeService = serviceRegistry.getNodeService();
        this.txnHelper = transactionService.getRetryingTransactionHelper();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        StoreRef storeRef = this.nodeService.createStore("workspace", "test-" + this.getName() + "-" + System.currentTimeMillis());
        NodeRef rootNodeRef = this.nodeService.getRootNode(storeRef);
        this.workingNodeRef = this.nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)this.getName()), ContentModel.TYPE_CMOBJECT).getChildRef();
        String resource = "activiti/testTransaction.bpmn20.xml";
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream input = classLoader.getResourceAsStream(resource);
        this.deployment = this.repo.createDeployment().addInputStream(resource, input).deploy();
    }

    protected void tearDown() throws Exception {
        try {
            this.repo.deleteDeployment(this.deployment.getId(), true);
            this.authenticationComponent.clearCurrentSecurityContext();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

