/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.activiti;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.history.HistoricDetail;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricVariableUpdate;
import org.activiti.engine.task.Task;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.workflow.BPMEngineRegistry;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.repo.workflow.activiti.AbstractActivitiComponentTest;
import org.alfresco.repo.workflow.activiti.ActivitiScriptNode;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowException;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskQuery;
import org.alfresco.service.cmr.workflow.WorkflowTaskState;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ActivitiTaskComponentTest
extends AbstractActivitiComponentTest {
    private WorkflowDefinition workflowDef;

    @Test
    public void testGetStartTask() {
        try {
            this.workflowEngine.getStartTask("Foo");
            Assert.fail((String)"Should blow up if Id is wrong format!");
        }
        catch (WorkflowException e) {
            // empty catch block
        }
        WorkflowTask result = this.workflowEngine.getStartTask("activiti$Foo");
        Assert.assertNull((String)"Should not find any result for fake (but valid) Id.", (Object)result);
        HashMap<QName, Serializable> params = new HashMap<QName, Serializable>();
        String comment = "Start task description";
        params.put(WorkflowModel.PROP_COMMENT, (Serializable)((Object)comment));
        params.put(WorkflowModel.PROP_PRIORITY, Integer.valueOf(1));
        Date dueDate = new Date();
        params.put(WorkflowModel.PROP_DUE_DATE, dueDate);
        WorkflowPath path = this.workflowEngine.startWorkflow(this.workflowDef.getId(), params);
        String instanceId = path.getInstance().getId();
        WorkflowTask task = this.workflowEngine.getStartTask(instanceId);
        Assert.assertNotNull((String)"Task shoudl exist!", (Object)task);
        String localId = "start" + BPMEngineRegistry.getLocalId(instanceId);
        String taskId = BPMEngineRegistry.createGlobalId("activiti", localId);
        Assert.assertEquals((String)"Start Task Id is wrong", (Object)taskId, (Object)task.getId());
        Assert.assertEquals((String)"The start task path is wrong!", (Object)path.getId(), (Object)task.getPath().getId());
        TypeDefinition definition = task.getDefinition().getMetadata();
        Assert.assertNotNull((Object)definition);
        String name = definition.getName().toPrefixString((NamespacePrefixResolver)this.namespaceService).replace(':', '_');
        Assert.assertEquals((Object)"bpm_foo", (Object)name);
        Assert.assertEquals((Object)name, (Object)task.getName());
        Assert.assertEquals((Object)name, (Object)task.getTitle());
        Assert.assertEquals((Object)name, (Object)task.getDescription());
        Assert.assertEquals((Object)((Object)WorkflowTaskState.IN_PROGRESS), (Object)((Object)task.getState()));
        Assert.assertEquals((Object)name, (Object)task.getDescription());
        Map<QName, Serializable> properties = task.getProperties();
        Assert.assertEquals((Object)comment, (Object)properties.get(WorkflowModel.PROP_COMMENT));
        Assert.assertEquals((Object)1, (Object)properties.get(WorkflowModel.PROP_PRIORITY));
        Assert.assertEquals((Object)dueDate, (Object)properties.get(WorkflowModel.PROP_DUE_DATE));
        task = this.workflowEngine.endTask(task.getId(), null);
        Assert.assertEquals((String)"Start Task Id is wrong", (Object)taskId, (Object)task.getId());
        Assert.assertEquals((String)"The start task path is wrong!", (Object)path.getId(), (Object)task.getPath().getId());
        definition = task.getDefinition().getMetadata();
        Assert.assertNotNull((Object)definition);
        name = definition.getName().toPrefixString((NamespacePrefixResolver)this.namespaceService).replace(':', '_');
        Assert.assertEquals((Object)"bpm_foo", (Object)name);
        Assert.assertEquals((Object)name, (Object)task.getName());
        Assert.assertEquals((Object)name, (Object)task.getTitle());
        Assert.assertEquals((Object)name, (Object)task.getDescription());
        Assert.assertEquals((Object)((Object)WorkflowTaskState.COMPLETED), (Object)((Object)task.getState()));
        Assert.assertEquals((Object)name, (Object)task.getDescription());
        properties = task.getProperties();
        Assert.assertEquals((Object)comment, (Object)properties.get(WorkflowModel.PROP_COMMENT));
        Assert.assertEquals((Object)1, (Object)properties.get(WorkflowModel.PROP_PRIORITY));
        Assert.assertEquals((Object)dueDate, (Object)properties.get(WorkflowModel.PROP_DUE_DATE));
        this.workflowEngine.cancelWorkflow(instanceId);
        task = this.workflowEngine.getStartTask(instanceId);
        Assert.assertNull((Object)task);
    }

    @Test
    public void testGetTaskById() throws Exception {
        try {
            this.workflowEngine.getTaskById("Foo");
            Assert.fail((String)"Should blow up if Id is wrong format!");
        }
        catch (WorkflowException e) {
            // empty catch block
        }
        WorkflowTask result = this.workflowEngine.getTaskById("activiti$Foo");
        Assert.assertNull((String)"Should not find any result for fake (but valid) Id.", (Object)result);
        WorkflowPath path = this.workflowEngine.startWorkflow(this.workflowDef.getId(), new HashMap<QName, Serializable>());
        Task task = (Task)this.taskService.createTaskQuery().executionId(BPMEngineRegistry.getLocalId(path.getId())).singleResult();
        Assert.assertNotNull((String)"Task shoudl exist!", (Object)task);
        String taskId = BPMEngineRegistry.createGlobalId("activiti", task.getId());
        WorkflowTask wfTask = this.workflowEngine.getTaskById(taskId);
        Assert.assertNotNull((Object)wfTask);
    }

    @Test
    public void testGetStartTaskById() throws Exception {
        WorkflowTask result = this.workflowEngine.getTaskById("activiti$Foo");
        Assert.assertNull((String)"Should not find any result for fake (but valid) Id.", (Object)result);
        WorkflowPath path = this.workflowEngine.startWorkflow(this.workflowDef.getId(), new HashMap<QName, Serializable>());
        Task task = (Task)this.taskService.createTaskQuery().executionId(BPMEngineRegistry.getLocalId(path.getId())).singleResult();
        String startTaskId = "start" + task.getProcessInstanceId();
        String taskId = this.createGlobalId(startTaskId);
        WorkflowTask wfTask = this.workflowEngine.getTaskById(taskId);
        Assert.assertNotNull((Object)wfTask);
        Assert.assertEquals((Object)this.createGlobalId(task.getProcessInstanceId()), (Object)wfTask.getPath().getId());
    }

    @Test
    public void testGetFinishedTaskById() throws Exception {
        WorkflowPath path = this.workflowEngine.startWorkflow(this.workflowDef.getId(), new HashMap<QName, Serializable>());
        WorkflowTask startTask = this.workflowEngine.getStartTask(path.getInstance().getId());
        this.workflowEngine.endTask(startTask.getId(), null);
        List<WorkflowTask> tasks = this.workflowEngine.getTasksForWorkflowPath(path.getId());
        String finishedTaskId = tasks.get(0).getId();
        HashMap<QName, Serializable> props = new HashMap<QName, Serializable>();
        props.put(WorkflowModel.PROP_DESCRIPTION, (Serializable)((Object)"Task description"));
        props.put(WorkflowModel.PROP_PRIORITY, Integer.valueOf(1234));
        props.put(QName.createQName((String)"myprop1"), (Serializable)((Object)"Property value"));
        props.put(QName.createQName((String)"myprop2"), Boolean.TRUE);
        props.put(QName.createQName((String)"myprop3"), Integer.valueOf(12345));
        props.put(QName.createQName((String)"myprop4"), Long.valueOf(45678L));
        this.workflowEngine.updateTask(finishedTaskId, props, null, null);
        this.workflowEngine.endTask(finishedTaskId, null);
        WorkflowTask finishedTask = this.workflowEngine.getTaskById(finishedTaskId);
        Assert.assertNotNull((Object)finishedTask);
        Assert.assertEquals((Object)"Task description", (Object)finishedTask.getDescription());
        Assert.assertEquals((Object)finishedTaskId, (Object)finishedTask.getId());
        Assert.assertEquals((Object)"bpm_foo_task", (Object)finishedTask.getName());
        Assert.assertEquals((Object)"Task", (Object)finishedTask.getTitle());
        Assert.assertEquals((Object)((Object)WorkflowTaskState.COMPLETED), (Object)((Object)finishedTask.getState()));
        Assert.assertEquals((String)"task name", (Object)finishedTask.getDefinition().getId(), (Object)"bpm_foo_task");
        Assert.assertEquals((Object)path.getId(), (Object)finishedTask.getPath().getId());
        Assert.assertEquals((Object)path.getInstance().getId(), (Object)finishedTask.getPath().getInstance().getId());
        Assert.assertEquals((Object)"Property value", (Object)finishedTask.getProperties().get(QName.createQName((String)"myprop1")));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)finishedTask.getProperties().get(QName.createQName((String)"myprop2")));
        Assert.assertEquals((Object)12345, (Object)finishedTask.getProperties().get(QName.createQName((String)"myprop3")));
        Assert.assertEquals((Object)45678L, (Object)finishedTask.getProperties().get(QName.createQName((String)"myprop4")));
        List pooledActors = (List)((Object)finishedTask.getProperties().get(WorkflowModel.ASSOC_POOLED_ACTORS));
        Assert.assertNotNull((Object)pooledActors);
        Assert.assertEquals((long)2L, (long)pooledActors.size());
        Assert.assertTrue((boolean)pooledActors.contains(testGroupNode));
        Assert.assertTrue((boolean)pooledActors.contains(testUserNode));
    }

    @Test
    public void testEndTask() throws Exception {
        WorkflowPath path = this.workflowEngine.startWorkflow(this.workflowDef.getId(), new HashMap<QName, Serializable>());
        Task task = (Task)this.taskService.createTaskQuery().executionId(BPMEngineRegistry.getLocalId(path.getId())).singleResult();
        Assert.assertNotNull((String)"Task should exist!", (Object)task);
        String globalTaskId = this.createGlobalId(task.getId());
        HashMap<QName, Serializable> props = new HashMap<QName, Serializable>();
        props.put(QName.createQName((String)"http://test", (String)"myVar"), (Serializable)((Object)"test123"));
        this.workflowEngine.updateTask(globalTaskId, props, null, null);
        this.workflowEngine.endTask(globalTaskId, null);
        List updates = this.historyService.createHistoricDetailQuery().variableUpdates().processInstanceId(task.getProcessInstanceId()).list();
        boolean found = false;
        for (HistoricDetail detail : updates) {
            HistoricVariableUpdate update = (HistoricVariableUpdate)detail;
            if (!update.getVariableName().equals("test_myVar")) continue;
            Assert.assertEquals((Object)"test123", (Object)update.getValue());
            found = true;
        }
        Assert.assertTrue((String)"Task variables are not flushed to process-instance", (boolean)found);
        HistoricTaskInstance hti = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().taskId(task.getId()).singleResult();
        Assert.assertNotNull((Object)hti);
        Assert.assertEquals((Object)"admin", (Object)hti.getAssignee());
    }

    @Test
    public void testGetPooledTasks() throws Exception {
        WorkflowPath path = this.workflowEngine.startWorkflow(this.workflowDef.getId(), new HashMap<QName, Serializable>());
        WorkflowTask startTask = this.workflowEngine.getStartTask(path.getInstance().getId());
        Assert.assertNotNull((Object)startTask);
        this.workflowEngine.endTask(startTask.getId(), null);
        List<WorkflowTask> tasks = this.workflowEngine.getTasksForWorkflowPath(path.getId());
        Assert.assertNotNull(tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        WorkflowTask theTask = tasks.get(0);
        Serializable pooledActors = theTask.getProperties().get(WorkflowModel.ASSOC_POOLED_ACTORS);
        Assert.assertNotNull((Object)pooledActors);
        List pooledActorNodes = (List)((Object)pooledActors);
        Assert.assertEquals((long)2L, (long)pooledActorNodes.size());
        Assert.assertTrue((boolean)pooledActorNodes.contains(testUserNode));
        Assert.assertTrue((boolean)pooledActorNodes.contains(testGroupNode));
        List<WorkflowTask> pooledUserTasks = this.workflowEngine.getPooledTasks(Arrays.asList("testUser"));
        Assert.assertNotNull(pooledUserTasks);
        Assert.assertEquals((long)1L, (long)pooledUserTasks.size());
        Assert.assertEquals((Object)theTask.getId(), (Object)pooledUserTasks.get(0).getId());
        List<WorkflowTask> pooledGroupTasks = this.workflowEngine.getPooledTasks(Arrays.asList("GROUP_testGroup"));
        Assert.assertNotNull(pooledGroupTasks);
        Assert.assertEquals((long)1L, (long)pooledGroupTasks.size());
        Assert.assertEquals((Object)theTask.getId(), (Object)pooledGroupTasks.get(0).getId());
        List<WorkflowTask> pooledTasks = this.workflowEngine.getPooledTasks(Arrays.asList("testUser", "GROUP_testGroup"));
        Assert.assertNotNull(pooledTasks);
        Assert.assertEquals((long)1L, (long)pooledTasks.size());
        Assert.assertEquals((Object)theTask.getId(), (Object)pooledTasks.get(0).getId());
        List<WorkflowTask> unexistingPooledTasks = this.workflowEngine.getPooledTasks(Arrays.asList("unexisting"));
        Assert.assertNotNull(unexistingPooledTasks);
        Assert.assertEquals((long)0L, (long)unexistingPooledTasks.size());
        pooledGroupTasks = this.workflowEngine.getPooledTasks(Arrays.asList("unexistinggroup", "GROUP_testGroup"));
        Assert.assertNotNull(pooledGroupTasks);
        Assert.assertEquals((long)1L, (long)pooledGroupTasks.size());
        Assert.assertEquals((Object)theTask.getId(), (Object)pooledGroupTasks.get(0).getId());
    }

    @Test
    public void testQueryTasksInProgress() throws Exception {
        WorkflowPath path = this.workflowEngine.startWorkflow(this.workflowDef.getId(), new HashMap<QName, Serializable>());
        Task task = (Task)this.taskService.createTaskQuery().executionId(BPMEngineRegistry.getLocalId(path.getId())).singleResult();
        Assert.assertNotNull((String)"Task should exist!", (Object)task);
        String globalTaskId = this.createGlobalId(task.getId());
        WorkflowTaskQuery taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.IN_PROGRESS);
        taskQuery.setTaskId(globalTaskId);
        List<WorkflowTask> tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull(tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)globalTaskId, (Object)tasks.get(0).getId());
        taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.IN_PROGRESS);
        taskQuery.setTaskId(this.createGlobalId("nonexistentTask"));
        tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull(tasks);
        Assert.assertEquals((long)0L, (long)tasks.size());
        taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.IN_PROGRESS);
        taskQuery.setProcessId(this.createGlobalId(task.getProcessInstanceId()));
        tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull(tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)globalTaskId, (Object)tasks.get(0).getId());
        taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.IN_PROGRESS);
        taskQuery.setProcessId(this.createGlobalId("nonexistentProcess"));
        tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull(tasks);
        Assert.assertEquals((long)0L, (long)tasks.size());
        taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.IN_PROGRESS);
        taskQuery.setActorId("testUser");
        tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull(tasks);
        Assert.assertEquals((long)0L, (long)tasks.size());
        this.taskService.setAssignee(task.getId(), "testUser");
        taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.IN_PROGRESS);
        taskQuery.setActorId("testUser");
        tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull(tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)globalTaskId, (Object)tasks.get(0).getId());
        taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.IN_PROGRESS);
        taskQuery.setActorId("nonexistentUser");
        tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull(tasks);
        Assert.assertEquals((long)0L, (long)tasks.size());
        taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.IN_PROGRESS);
        taskQuery.setWorkflowDefinitionName("testTask");
        tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull(tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        taskQuery.setWorkflowDefinitionName("unexistingTaskName");
        tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull(tasks);
        Assert.assertEquals((long)0L, (long)tasks.size());
        taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.IN_PROGRESS);
        taskQuery.setTaskName(QName.createQName((String)"bpm_foo_task"));
        tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull(tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        taskQuery.setTaskName(QName.createQName((String)"unexisting_task_name"));
        tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull(tasks);
        Assert.assertEquals((long)0L, (long)tasks.size());
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("longVar", 928374L);
        variables.put("shortVar", (short)123);
        variables.put("integerVar", 1234);
        variables.put("stringVar", "stringValue");
        variables.put("booleanVar", true);
        Date date = Calendar.getInstance().getTime();
        variables.put("dateVar", date);
        variables.put("nullVar", null);
        ActivitiScriptNode scriptNode = new ActivitiScriptNode(testGroupNode, this.serviceRegistry);
        variables.put("scriptNodeVar", scriptNode);
        this.taskService.setVariablesLocal(task.getId(), variables);
        this.checkTaskVariableTaskPresent(WorkflowTaskState.IN_PROGRESS, QName.createQName((String)"longVar"), 928374L, globalTaskId);
        this.checkTaskVariableNoMatch(WorkflowTaskState.IN_PROGRESS, QName.createQName((String)"longVar"), 444444L);
        this.checkTaskVariableTaskPresent(WorkflowTaskState.IN_PROGRESS, QName.createQName((String)"shortVar"), (short)123, globalTaskId);
        this.checkTaskVariableNoMatch(WorkflowTaskState.IN_PROGRESS, QName.createQName((String)"shortVar"), (short)456);
        this.checkTaskVariableTaskPresent(WorkflowTaskState.IN_PROGRESS, QName.createQName((String)"integerVar"), 1234, globalTaskId);
        this.checkTaskVariableNoMatch(WorkflowTaskState.IN_PROGRESS, QName.createQName((String)"integerVar"), 5678);
        this.checkTaskVariableTaskPresent(WorkflowTaskState.IN_PROGRESS, QName.createQName((String)"stringVar"), "stringValue", globalTaskId);
        this.checkTaskVariableNoMatch(WorkflowTaskState.IN_PROGRESS, QName.createQName((String)"stringVar"), "noMatchString");
        this.checkTaskVariableTaskPresent(WorkflowTaskState.IN_PROGRESS, QName.createQName((String)"booleanVar"), true, globalTaskId);
        this.checkTaskVariableNoMatch(WorkflowTaskState.IN_PROGRESS, QName.createQName((String)"booleanVar"), false);
        this.checkTaskVariableTaskPresent(WorkflowTaskState.IN_PROGRESS, QName.createQName((String)"dateVar"), date, globalTaskId);
        Calendar otherDate = Calendar.getInstance();
        otherDate.add(1, 1);
        this.checkTaskVariableNoMatch(WorkflowTaskState.IN_PROGRESS, QName.createQName((String)"dateVar"), otherDate.getTime());
        this.checkTaskVariableTaskPresent(WorkflowTaskState.IN_PROGRESS, QName.createQName((String)"nullVar"), null, globalTaskId);
        this.checkTaskVariableNoMatch(WorkflowTaskState.IN_PROGRESS, QName.createQName((String)"nullVar"), "notNull");
        this.checkTaskVariableTaskPresent(WorkflowTaskState.IN_PROGRESS, QName.createQName((String)"scriptNodeVar"), scriptNode, globalTaskId);
        ActivitiScriptNode otherNode = new ActivitiScriptNode(testUserNode, this.serviceRegistry);
        this.checkTaskVariableNoMatch(WorkflowTaskState.IN_PROGRESS, QName.createQName((String)"scriptNodeVar"), otherNode);
        this.runtime.setVariable(task.getExecutionId(), "processVar", (Object)"testing");
        taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.IN_PROGRESS);
        HashMap<QName, Object> props = new HashMap<QName, Object>();
        props.put(QName.createQName((String)"processVar"), "testing");
        taskQuery.setProcessCustomProps(props);
        tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull(tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        props.put(QName.createQName((String)"processVar"), "notmatching");
        tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull(tasks);
        Assert.assertEquals((long)0L, (long)tasks.size());
    }

    @Test
    public void testQueryTasksCompleted() throws Exception {
        WorkflowPath path = this.workflowEngine.startWorkflow(this.workflowDef.getId(), new HashMap<QName, Serializable>());
        Task task = (Task)this.taskService.createTaskQuery().executionId(BPMEngineRegistry.getLocalId(path.getId())).singleResult();
        this.taskService.setVariableLocal(task.getId(), "taskVar", (Object)"theValue");
        Assert.assertNotNull((String)"Task should exist!", (Object)task);
        String globalTaskId = this.createGlobalId(task.getId());
        this.taskService.setAssignee(task.getId(), "testUser");
        this.runtime.setVariable(task.getExecutionId(), "processVar", (Object)"testing");
        AuthenticationUtil.setFullyAuthenticatedUser((String)"testUser");
        this.workflowEngine.endTask(globalTaskId, null);
        AuthenticationUtil.setFullyAuthenticatedUser((String)"admin");
        WorkflowTaskQuery taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.COMPLETED);
        taskQuery.setActive(Boolean.FALSE);
        taskQuery.setTaskId(globalTaskId);
        List<WorkflowTask> tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull(tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)globalTaskId, (Object)tasks.get(0).getId());
        taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.COMPLETED);
        taskQuery.setTaskId(this.createGlobalId("nonexistantTask"));
        tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull(tasks);
        Assert.assertEquals((long)0L, (long)tasks.size());
        taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.COMPLETED);
        taskQuery.setProcessId(this.createGlobalId(task.getProcessInstanceId()));
        taskQuery.setActive(Boolean.FALSE);
        tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull(tasks);
        Assert.assertEquals((long)2L, (long)tasks.size());
        boolean taskFound = false;
        boolean startTaskFound = false;
        for (WorkflowTask wfTask : tasks) {
            if (wfTask.getId().equals(globalTaskId)) {
                taskFound = true;
            }
            if (!wfTask.getId().contains("start")) continue;
            startTaskFound = true;
        }
        Assert.assertTrue((String)"Task should have been returned", (boolean)taskFound);
        Assert.assertTrue((String)"Start-task should have been returned", (boolean)startTaskFound);
        taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.COMPLETED);
        taskQuery.setProcessId(this.createGlobalId("nonexistantProcess"));
        tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull(tasks);
        Assert.assertEquals((long)0L, (long)tasks.size());
        taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.COMPLETED);
        taskQuery.setActorId("testUser");
        taskQuery.setActive(Boolean.FALSE);
        tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull(tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.COMPLETED);
        taskQuery.setActorId("unexistingUser");
        tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull(tasks);
        Assert.assertEquals((long)0L, (long)tasks.size());
        taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.COMPLETED);
        taskQuery.setWorkflowDefinitionName("testTask");
        taskQuery.setActive(Boolean.FALSE);
        tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull(tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        taskQuery.setWorkflowDefinitionName("unexistingTaskName");
        tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull(tasks);
        Assert.assertEquals((long)0L, (long)tasks.size());
        taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.COMPLETED);
        HashMap<Object, Object> props = new HashMap<QName, Object>();
        props.put(QName.createQName((String)"taskVar"), "theValue");
        taskQuery.setActive(false);
        taskQuery.setTaskCustomProps(props);
        tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull(tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        props.put(QName.createQName((String)"processVar"), "notmatching");
        tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull(tasks);
        Assert.assertEquals((long)0L, (long)tasks.size());
        taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.COMPLETED);
        props = new HashMap();
        props.put(QName.createQName((String)"processVar"), "testing");
        taskQuery.setActive(false);
        taskQuery.setProcessCustomProps(props);
        tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull(tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        props.put(QName.createQName((String)"processVar"), "notmatching");
        tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull(tasks);
        Assert.assertEquals((long)0L, (long)tasks.size());
    }

    @Test
    public void testQueryUsingNodeRef() {
        NodeRef nodeRef = new NodeRef("workspace:///someRef");
        QName nodeRefPropQname = QName.createQName((String)"testProp");
        HashMap<QName, Serializable> props = new HashMap<QName, Serializable>();
        props.put(nodeRefPropQname, (Serializable)nodeRef);
        this.workflowEngine.startWorkflow(this.workflowDef.getId(), props);
        WorkflowTaskQuery taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.IN_PROGRESS);
        HashMap<QName, Object> queryParams = new HashMap<QName, Object>();
        queryParams.put(nodeRefPropQname, nodeRef);
        taskQuery.setProcessCustomProps(queryParams);
        List<WorkflowTask> tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull(tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
    }

    @Test
    public void testUpdateTask() {
        NodeRef nodeRef = new NodeRef("workspace:///someRef");
        NodeRef anotherRef = new NodeRef("workspace:///anotherRef");
        QName propQname = QName.createQName((String)"testProp");
        QName nodeRefPropQname = QName.createQName((String)"testAssoc");
        QName singleNodeRefPropQname = QName.createQName((String)"testAssocSingleValue");
        HashMap<Object, Serializable> props = new HashMap<QName, Serializable>();
        WorkflowPath path = this.workflowEngine.startWorkflow(this.workflowDef.getId(), props);
        WorkflowTask startTask = this.workflowEngine.getStartTask(path.getInstance().getId());
        this.workflowEngine.endTask(startTask.getId(), null);
        WorkflowTaskQuery taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.IN_PROGRESS);
        taskQuery.setProcessId(path.getInstance().getId());
        List<WorkflowTask> tasks = this.workflowEngine.queryTasks(taskQuery);
        WorkflowTask task = tasks.get(0);
        props = new HashMap();
        props.put(propQname, (Serializable)((Object)"54321"));
        props.put(singleNodeRefPropQname, (Serializable)nodeRef);
        this.workflowEngine.updateTask(task.getId(), props, null, null);
        tasks = this.workflowEngine.queryTasks(taskQuery);
        task = tasks.get(0);
        Assert.assertEquals((Object)"54321", (Object)task.getProperties().get(propQname));
        HashMap<Object, List<Object>> toAdd = new HashMap<QName, List<NodeRef>>();
        toAdd.put(nodeRefPropQname, Arrays.asList(anotherRef, nodeRef));
        this.workflowEngine.updateTask(task.getId(), null, toAdd, null);
        tasks = this.workflowEngine.queryTasks(taskQuery);
        task = tasks.get(0);
        Assert.assertEquals((long)2L, (long)((List)((Object)task.getProperties().get(nodeRefPropQname))).size());
        HashMap<Object, List<Object>> toRemove = new HashMap<QName, List<NodeRef>>();
        toRemove.put(nodeRefPropQname, Arrays.asList(nodeRef));
        this.workflowEngine.updateTask(task.getId(), null, null, toRemove);
        tasks = this.workflowEngine.queryTasks(taskQuery);
        task = tasks.get(0);
        Assert.assertEquals((long)1L, (long)((List)((Object)task.getProperties().get(nodeRefPropQname))).size());
        Assert.assertEquals((Object)anotherRef, ((List)((Object)task.getProperties().get(nodeRefPropQname))).get(0));
        toAdd = new HashMap();
        toRemove = new HashMap();
        toRemove.put(singleNodeRefPropQname, Arrays.asList(nodeRef));
        toAdd.put(singleNodeRefPropQname, Arrays.asList(anotherRef));
        this.workflowEngine.updateTask(task.getId(), null, toAdd, toRemove);
        tasks = this.workflowEngine.queryTasks(taskQuery);
        task = tasks.get(0);
        Assert.assertEquals((Object)anotherRef, (Object)task.getProperties().get(singleNodeRefPropQname));
        toRemove = new HashMap();
        toRemove.put(singleNodeRefPropQname, Arrays.asList(anotherRef));
        this.workflowEngine.updateTask(task.getId(), null, null, toRemove);
        tasks = this.workflowEngine.queryTasks(taskQuery);
        task = tasks.get(0);
        Assert.assertNull((Object)task.getProperties().get(singleNodeRefPropQname));
    }

    private void checkTaskVariableTaskPresent(WorkflowTaskState state, QName varName, Object varValue, String expectedTask) {
        WorkflowTaskQuery taskQuery = this.createWorkflowTaskQuery(state);
        HashMap<QName, Object> customProperties = new HashMap<QName, Object>();
        customProperties.put(varName, varValue);
        taskQuery.setTaskCustomProps(customProperties);
        this.assertTaskPresent(taskQuery, expectedTask);
    }

    private void checkTaskVariableNoMatch(WorkflowTaskState state, QName varName, Object varValue) {
        WorkflowTaskQuery taskQuery = this.createWorkflowTaskQuery(state);
        HashMap<QName, Object> customProperties = new HashMap<QName, Object>();
        customProperties.put(varName, varValue);
        taskQuery.setTaskCustomProps(customProperties);
        this.assertNoTaskPresent(taskQuery);
    }

    private WorkflowTaskQuery createWorkflowTaskQuery(WorkflowTaskState state) {
        WorkflowTaskQuery taskQuery = new WorkflowTaskQuery();
        taskQuery.setTaskState(state);
        return taskQuery;
    }

    private void assertTaskPresent(WorkflowTaskQuery taskQuery, String taskId) {
        List<WorkflowTask> tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull(tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)taskId, (Object)tasks.get(0).getId());
    }

    private void assertNoTaskPresent(WorkflowTaskQuery taskQuery) {
        List<WorkflowTask> tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull(tasks);
        Assert.assertEquals((long)0L, (long)tasks.size());
    }

    private String createGlobalId(String id) {
        return BPMEngineRegistry.createGlobalId("activiti", id);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.workflowDef = this.deployTestTaskDefinition();
    }
}

