/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.jbpm;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.alfresco.repo.workflow.jbpm.JBPMJpdlXmlReader;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.jpdl.JpdlException;
import org.jbpm.jpdl.par.ProcessArchive;
import org.jbpm.jpdl.par.ProcessArchiveParser;
import org.jbpm.jpdl.xml.ProblemListener;
import org.xml.sax.InputSource;

public class JBPMJpdlArchiveParser
implements ProcessArchiveParser {
    private static final long serialVersionUID = 1L;

    public ProcessDefinition readFromArchive(ProcessArchive processArchive, ProcessDefinition processDefinition) throws JpdlException {
        try {
            byte[] processBytes = processArchive.getEntry("processdefinition.xml");
            if (processBytes == null) {
                throw new JpdlException("no processdefinition.xml inside process archive");
            }
            ByteArrayInputStream processInputStream = new ByteArrayInputStream(processBytes);
            InputSource processInputSource = new InputSource(processInputStream);
            JBPMJpdlXmlReader jpdlXmlReader = new JBPMJpdlXmlReader(processInputSource, (ProblemListener)processArchive);
            processDefinition = jpdlXmlReader.readProcessDefinition();
            jpdlXmlReader.close();
            ((InputStream)processInputStream).close();
        }
        catch (IOException e) {
            throw new JpdlException("io problem while reading processdefinition.xml: " + e.getMessage(), (Throwable)e);
        }
        return processDefinition;
    }
}

