/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.tools;

import java.io.IOException;
import org.alfresco.tools.Tool;
import org.alfresco.tools.ToolArgumentException;
import org.alfresco.tools.ToolContext;
import org.alfresco.tools.ToolException;

public class Repository
extends Tool {
    @Override
    protected String getToolName() {
        return "Repository";
    }

    @Override
    protected ToolContext processArgs(String[] args) throws ToolException {
        ToolContext context = new ToolContext();
        context.setLogin(true);
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-h") || args[i].equals("-help")) {
                context.setHelp(true);
                break;
            }
            if (args[i].equals("-verbose")) {
                context.setVerbose(true);
                continue;
            }
            if (args[i].equals("-user")) {
                if (++i == args.length || args[i].length() == 0) {
                    throw new ToolArgumentException("The value <user> for the option -user must be specified");
                }
                context.setUsername(args[i]);
                continue;
            }
            if (args[i].equals("-pwd")) {
                if (++i == args.length || args[i].length() == 0) {
                    throw new ToolArgumentException("The value <password> for the option -pwd must be specified");
                }
                context.setPassword(args[i]);
                continue;
            }
            throw new ToolArgumentException("Unknown option " + args[i] + ".  Use -help for options.");
        }
        return context;
    }

    @Override
    protected void displayHelp() {
        this.logError("usage: repository [OPTIONS] \n\nInitialize the Alfresco application context, initiating any \nconfigured server beans (e.g. CIFS server, FTP server, etc). \n\nOptions: \n -h -help         Display this help \n -user USER       Login as USER \n -pwd PASSWORD    Use PASSWORD to login");
    }

    @Override
    protected synchronized int execute() throws ToolException {
        try {
            System.out.println("\nRepository initialized.\nPress ENTER to exit...");
            System.in.read();
            System.out.println("\nShutting down the repository.");
            new ShutdownNotifierThread().start();
            try {
                this.wait(3000L);
            }
            catch (InterruptedException e) {}
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 0;
    }

    public static void main(String[] args) {
        new Repository().start(args);
    }

    private static class ShutdownNotifierThread
    extends Thread {
        private ShutdownNotifierThread() {
            this.setDaemon(true);
        }

        @Override
        public synchronized void run() {
            while (true) {
                System.out.print('.');
                try {
                    this.wait(500L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

