/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import org.alfresco.util.ApplicationContextHelper;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.test.AbstractTransactionalDataSourceSpringContextTests;

public abstract class BaseSpringTest
extends AbstractTransactionalDataSourceSpringContextTests {
    protected SessionFactory sessionFactory;
    private boolean defaultContext;

    public BaseSpringTest() {
        this.setAutowireMode(1);
        this.defaultContext = false;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    protected Session getSession() {
        return SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)true);
    }

    protected void flushAndClear() {
        this.getSession().flush();
        this.getSession().clear();
    }

    protected String[] getConfigLocations() {
        this.defaultContext = true;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Getting config locations");
        }
        return ApplicationContextHelper.CONFIG_LOCATIONS;
    }

    protected ConfigurableApplicationContext loadContext(Object key) throws Exception {
        if (this.defaultContext) {
            return (ConfigurableApplicationContext)ApplicationContextHelper.getApplicationContext();
        }
        String[] configLocations = (String[])key;
        return new ClassPathXmlApplicationContext(configLocations);
    }
}

