/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.json;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.service.cmr.transfer.TransferException;
import org.alfresco.util.json.JsonSerializer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ExceptionJsonSerializer
implements JsonSerializer<Throwable, JSONObject> {
    private static final Log log = LogFactory.getLog(ExceptionJsonSerializer.class);

    @Override
    public Throwable deserialize(JSONObject errorJSON) {
        Object result;
        block18: {
            if (errorJSON == null) {
                return null;
            }
            result = null;
            Object createdObject = null;
            try {
                Class<Object> errorClass;
                String errorType = errorJSON.getString("errorType");
                String errorMessage = errorJSON.getString("errorMessage");
                if (errorType == null) {
                    errorType = Exception.class.getName();
                }
                if (errorMessage == null) {
                    errorMessage = "";
                }
                String errorId = errorJSON.optString("alfrescoMessageId", null);
                Object[] errorParams = new Object[]{};
                JSONArray errorParamArray = errorJSON.optJSONArray("alfrescoMessageParams");
                if (errorParamArray != null) {
                    int length = errorParamArray.length();
                    errorParams = new Object[length];
                    for (int i = 0; i < length; ++i) {
                        errorParams[i] = errorParamArray.getString(i);
                    }
                }
                try {
                    errorClass = Class.forName(errorType);
                }
                catch (ClassNotFoundException e) {
                    errorClass = Exception.class;
                }
                Constructor<Object> constructor = null;
                try {
                    try {
                        constructor = errorClass.getConstructor(String.class, Object[].class);
                        createdObject = constructor.newInstance(errorId, errorParams);
                    }
                    catch (NoSuchMethodException e) {
                        try {
                            constructor = errorClass.getConstructor(String.class);
                            createdObject = constructor.newInstance(errorId == null ? errorMessage : errorId);
                        }
                        catch (NoSuchMethodException e1) {
                            try {
                                constructor = errorClass.getConstructor(new Class[0]);
                                createdObject = constructor.newInstance(new Object[0]);
                            }
                            catch (NoSuchMethodException e2) {}
                        }
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                result = createdObject == null || !Throwable.class.isAssignableFrom(createdObject.getClass()) ? new TransferException(errorId == null ? errorMessage : errorId, errorParams) : (Throwable)createdObject;
            }
            catch (JSONException ex) {
                if (!log.isDebugEnabled()) break block18;
                log.debug((Object)"Failed to deserialize Throwable object from JSON object", (Throwable)ex);
            }
        }
        return result;
    }

    @Override
    public JSONObject serialize(Throwable object) {
        JSONObject errorObject;
        block3: {
            errorObject = new JSONObject();
            try {
                errorObject.put("errorType", (Object)object.getClass().getName());
                errorObject.put("errorMessage", (Object)object.getMessage());
                if (AlfrescoRuntimeException.class.isAssignableFrom(object.getClass())) {
                    AlfrescoRuntimeException alfEx = (AlfrescoRuntimeException)object;
                    errorObject.put("alfrescoMessageId", (Object)alfEx.getMsgId());
                    Object[] msgParams = alfEx.getMsgParams();
                    List<Object> params = msgParams == null ? Collections.emptyList() : Arrays.asList(msgParams);
                    errorObject.put("alfrescoMessageParams", params);
                }
            }
            catch (JSONException e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)"Failed to serialize Throwable object into JSON object", (Throwable)e);
            }
        }
        return errorObject;
    }
}

