/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.ibatis;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;

public class SerializableTypeHandler
implements TypeHandler {
    public static final int DEFAULT_SERIALIZABLE_TYPE = -4;
    private static volatile int serializableType = -4;

    public static void setSerializableType(int serializableType) {
        SerializableTypeHandler.serializableType = serializableType;
    }

    public static int getSerializableType() {
        return serializableType;
    }

    public Object getResult(ResultSet rs, String columnName) throws SQLException {
        Serializable ret;
        try {
            InputStream is = rs.getBinaryStream(columnName);
            if (is == null || rs.wasNull()) {
                return null;
            }
            ObjectInputStream ois = new ObjectInputStream(is);
            Object obj = ois.readObject();
            ret = (Serializable)obj;
        }
        catch (Throwable e) {
            throw new DeserializationException(e);
        }
        return ret;
    }

    public void setParameter(PreparedStatement ps, int i, Object parameter, JdbcType jdbcType) throws SQLException {
        if (parameter == null) {
            ps.setNull(i, serializableType);
        } else {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(parameter);
                byte[] bytes = baos.toByteArray();
                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                ps.setBinaryStream(i, (InputStream)bais, bytes.length);
            }
            catch (Throwable e) {
                throw new SerializationException(e);
            }
        }
    }

    public Object getResult(CallableStatement cs, int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Unsupported");
    }

    public Object valueOf(String s) {
        return s;
    }

    public static class SerializationException
    extends RuntimeException {
        private static final long serialVersionUID = 962957884262870228L;

        public SerializationException(Throwable cause) {
            super(cause);
        }
    }

    public static class DeserializationException
    extends RuntimeException {
        private static final long serialVersionUID = 4673487701048985340L;

        public DeserializationException(Throwable cause) {
            super(cause);
        }
    }
}

