/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PathMapper {
    private static final Log logger = LogFactory.getLog(PathMapper.class);
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private boolean locked;
    private final Map<String, Set<String>> pathMaps;
    private final Map<String, Set<String>> derivedPathMaps;
    private final Map<String, Set<String>> derivedPathMapsPartial;

    public PathMapper() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.pathMaps = new HashMap<String, Set<String>>(37);
        this.derivedPathMaps = new HashMap<String, Set<String>>(127);
        this.derivedPathMapsPartial = new HashMap<String, Set<String>>(127);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() {
        this.writeLock.lock();
        try {
            this.locked = true;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.writeLock.lock();
        try {
            if (this.locked) {
                throw new IllegalStateException("The PathMapper has been locked against further changes");
            }
            this.pathMaps.clear();
            this.derivedPathMaps.clear();
            this.derivedPathMapsPartial.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPathMap(String sourcePath, String targetPath) {
        this.writeLock.lock();
        try {
            if (this.locked) {
                throw new IllegalStateException("The PathMapper has been locked against further changes");
            }
            this.derivedPathMaps.clear();
            this.derivedPathMapsPartial.clear();
            Set<String> targetPaths = this.pathMaps.get(sourcePath);
            if (targetPaths == null) {
                targetPaths = new HashSet<String>(5);
                this.pathMaps.put(sourcePath, targetPaths);
            }
            targetPaths.add(targetPath);
        }
        finally {
            this.writeLock.unlock();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Added path map: " + sourcePath + " --> " + targetPath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getMappedPaths(String sourcePath) {
        this.readLock.lock();
        try {
            Set<String> targetPaths = this.derivedPathMaps.get(sourcePath);
            if (targetPaths != null) {
                Set<String> set = targetPaths;
                return set;
            }
        }
        finally {
            this.readLock.unlock();
        }
        this.writeLock.lock();
        try {
            Set<String> set = this.updateMappedPaths(sourcePath);
            return set;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getMappedPathsWithPartialMatch(String sourcePath) {
        this.readLock.lock();
        try {
            Set<String> targetPaths = this.derivedPathMapsPartial.get(sourcePath);
            if (targetPaths != null) {
                Set<String> set = targetPaths;
                return set;
            }
        }
        finally {
            this.readLock.unlock();
        }
        this.writeLock.lock();
        try {
            Set<String> set = this.updateMappedPathsPartial(sourcePath);
            return set;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        this.readLock.lock();
        try {
            boolean bl = this.pathMaps.isEmpty();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private Set<String> updateMappedPaths(String sourcePath) {
        Set<String> targetPaths = this.derivedPathMaps.get(sourcePath);
        if (targetPaths != null) {
            return targetPaths;
        }
        targetPaths = new HashSet<String>(17);
        this.derivedPathMaps.put(sourcePath, targetPaths);
        for (Map.Entry<String, Set<String>> entry : this.pathMaps.entrySet()) {
            String mapSourcePath = entry.getKey();
            Set<String> mapTargetPaths = entry.getValue();
            if (mapSourcePath.equals(sourcePath)) {
                targetPaths.addAll(mapTargetPaths);
                continue;
            }
            int index = sourcePath.indexOf(mapSourcePath);
            if (index != 0) continue;
            for (String mapTargetPath : mapTargetPaths) {
                if (mapTargetPath.equals(mapSourcePath)) {
                    targetPaths.add(sourcePath);
                    continue;
                }
                String newPath = mapTargetPath + sourcePath.substring(mapSourcePath.length());
                targetPaths.add(newPath);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cached path mapping: \n   Source:  " + sourcePath + "\n" + "   Targets: " + targetPaths));
        }
        return targetPaths;
    }

    private Set<String> updateMappedPathsPartial(String sourcePath) {
        Set<String> targetPaths = this.derivedPathMapsPartial.get(sourcePath);
        if (targetPaths != null) {
            return targetPaths;
        }
        targetPaths = new HashSet<String>(17);
        this.derivedPathMapsPartial.put(sourcePath, targetPaths);
        for (Map.Entry<String, Set<String>> entry : this.pathMaps.entrySet()) {
            String mapSourcePath = entry.getKey();
            Set<String> mapTargetPaths = entry.getValue();
            int index = mapSourcePath.indexOf(sourcePath);
            if (index != 0) continue;
            targetPaths.addAll(mapTargetPaths);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cached path mapping (partial): \n   Source:  " + sourcePath + "\n" + "   Targets: " + targetPaths));
        }
        return targetPaths;
    }

    public <V> Map<String, V> convertMap(Map<String, V> valueMap) {
        HashMap<String, V> resultMap = new HashMap<String, V>(valueMap.size() * 2 + 1);
        for (Map.Entry<String, V> entry : valueMap.entrySet()) {
            String path = entry.getKey();
            V value = entry.getValue();
            Set<String> mappedPaths = this.getMappedPaths(path);
            for (String mappedPath : mappedPaths) {
                resultMap.put(mappedPath, value);
            }
        }
        return resultMap;
    }
}

