/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.bean;

import org.alfresco.util.PropertyCheck;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class HierarchicalBeanLoader
implements InitializingBean,
FactoryBean,
ApplicationContextAware {
    public static final String DEFAULT_DIALECT_PLACEHOLDER = "#bean.dialect#";
    public static final String DEFAULT_DIALECT_REGEX = "\\#bean\\.dialect\\#";
    private ApplicationContext ctx;
    private String targetBeanName;
    private Class<?> targetClass;
    private String dialectBaseClass;
    private String dialectClass;

    public void setApplicationContext(ApplicationContext ctx) {
        this.ctx = ctx;
    }

    public void setTargetBeanName(String targetBeanName) {
        this.targetBeanName = targetBeanName;
    }

    public void setTargetClass(Class<?> targetClass) {
        this.targetClass = targetClass;
    }

    public void setDialectBaseClass(String className) {
        this.dialectBaseClass = className;
    }

    public void setDialectClass(String className) {
        this.dialectClass = className;
    }

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory(this, "targetBeanName", this.targetBeanName);
        PropertyCheck.mandatory(this, "targetClass", this.targetClass);
        PropertyCheck.mandatory(this, "dialectBaseClass", this.dialectBaseClass);
        PropertyCheck.mandatory(this, "dialectClass", this.dialectClass);
    }

    public Class<?> getObjectType() {
        return this.targetClass;
    }

    public boolean isSingleton() {
        return true;
    }

    public Object getObject() throws Exception {
        Class<?> dialectClazz;
        Class<?> dialectBaseClazz;
        if (this.dialectClass == null || this.dialectBaseClass == null) {
            this.ctx.getBean(this.targetBeanName);
        }
        String dialectBaseClassStr = this.dialectBaseClass;
        if (!PropertyCheck.isValidPropertyString(this.dialectBaseClass)) {
            String prop = PropertyCheck.getPropertyName(this.dialectBaseClass);
            dialectBaseClassStr = System.getProperty(prop, this.dialectBaseClass);
        }
        String dialectClassStr = this.dialectClass;
        if (!PropertyCheck.isValidPropertyString(this.dialectClass)) {
            String prop = PropertyCheck.getPropertyName(this.dialectClass);
            dialectClassStr = System.getProperty(prop, this.dialectClass);
        }
        try {
            dialectBaseClazz = Class.forName(dialectBaseClassStr);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Dialect base class not found: " + dialectBaseClassStr);
        }
        try {
            dialectClazz = Class.forName(dialectClassStr);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Dialect class not found: " + dialectClassStr);
        }
        if (!Object.class.isAssignableFrom(dialectBaseClazz)) {
            throw new RuntimeException("Dialect base class must be derived from java.lang.Object: " + dialectBaseClazz.getName());
        }
        if (!Object.class.isAssignableFrom(dialectClazz)) {
            throw new RuntimeException("Dialect class must be derived from java.lang.Object: " + dialectClazz.getName());
        }
        if (!dialectBaseClazz.isAssignableFrom(dialectClazz)) {
            throw new RuntimeException("Non-existent HierarchicalBeanLoader hierarchy: " + dialectBaseClazz.getName() + " is not a superclass of " + dialectClazz);
        }
        Class<?> clazz = dialectClazz;
        Object bean = null;
        while (bean == null) {
            String newBeanName = this.targetBeanName.replaceAll(DEFAULT_DIALECT_REGEX, clazz.getName());
            try {
                bean = this.ctx.getBean(newBeanName);
                break;
            }
            catch (NoSuchBeanDefinitionException e) {
                bean = null;
                if (clazz.equals(dialectBaseClazz)) break;
                if ((clazz = clazz.getSuperclass()) != null) continue;
                throw new RuntimeException("Non-existent HierarchicalBeanLoaderBean hierarchy: " + dialectBaseClazz.getName() + " is not a superclass of " + dialectClazz);
            }
        }
        return bean;
    }
}

