/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.exec;

import java.util.Arrays;
import java.util.List;
import org.alfresco.util.exec.ExecParameterTokenizer;
import org.junit.Assert;
import org.junit.Test;

public class ExecParameterTokenizerTest {
    @Test
    public void tokenizeEmptyString() {
        String str1 = "";
        String str2 = "   \t   ";
        List<String> expectedTokens = Arrays.asList(new String[0]);
        ExecParameterTokenizer t = new ExecParameterTokenizer("");
        Assert.assertEquals((String)"Wrong tokens", expectedTokens, t.getAllTokens());
        t = new ExecParameterTokenizer("   \t   ");
        Assert.assertEquals((String)"Wrong tokens", expectedTokens, t.getAllTokens());
    }

    @Test(expected=NullPointerException.class)
    public void tokenizeNullString() {
        String str1 = null;
        List<String> expectedTokens = Arrays.asList(new String[0]);
        ExecParameterTokenizer t = new ExecParameterTokenizer(str1);
        Assert.assertEquals((String)"Wrong tokens", expectedTokens, t.getAllTokens());
    }

    @Test
    public void tokenizeSimpleParameterString() {
        String str1 = "-font Helvetica -pointsize 50";
        String str2 = "   -font   Helvetica   -pointsize   50   ";
        List<String> expectedTokens = Arrays.asList("-font", "Helvetica", "-pointsize", "50");
        ExecParameterTokenizer t = new ExecParameterTokenizer("-font Helvetica -pointsize 50");
        Assert.assertEquals((String)"Wrong tokens", expectedTokens, t.getAllTokens());
        t = new ExecParameterTokenizer("   -font   Helvetica   -pointsize   50   ");
        Assert.assertEquals((String)"Wrong tokens", expectedTokens, t.getAllTokens());
    }

    @Test
    public void tokenizeParameterStringEntirelyQuoted() {
        String str1 = "\"circle 100,100 150,150\"";
        String str2 = "'circle 100,100 150,150'";
        List<String> expectedTokens = Arrays.asList("circle 100,100 150,150");
        ExecParameterTokenizer t = new ExecParameterTokenizer("\"circle 100,100 150,150\"");
        Assert.assertEquals((String)"Wrong tokens", expectedTokens, t.getAllTokens());
        t = new ExecParameterTokenizer("'circle 100,100 150,150'");
        Assert.assertEquals((String)"Wrong tokens", expectedTokens, t.getAllTokens());
    }

    @Test(expected=IllegalArgumentException.class)
    public void tokenizeParameterStringWithUnclosedSingleQuote() {
        String str = "-font Helvetica -pointsize 50 -draw 'circle";
        ExecParameterTokenizer t = new ExecParameterTokenizer("-font Helvetica -pointsize 50 -draw 'circle");
        t.getAllTokens();
    }

    @Test(expected=IllegalArgumentException.class)
    public void tokenizeParameterStringWithUnclosedDoubleQuote() {
        String str = "-font Helvetica -pointsize 50 -draw \"circle";
        ExecParameterTokenizer t = new ExecParameterTokenizer("-font Helvetica -pointsize 50 -draw \"circle");
        t.getAllTokens();
    }

    @Test(expected=IllegalArgumentException.class)
    public void tokenizeParameterStringWithMalformedQuoteNesting() {
        String str = "  \"foo 'bar baz\" hello'  ";
        ExecParameterTokenizer t = new ExecParameterTokenizer("  \"foo 'bar baz\" hello'  ");
        t.getAllTokens();
    }

    @Test
    public void tokenizeParameterStringWithQuotedParam() {
        String str1 = "-font Helvetica -pointsize 50 -draw \"circle 100,100 150,150\"";
        String str2 = "-font Helvetica -pointsize 50 -draw 'circle 100,100 150,150'";
        List<String> expectedTokens = Arrays.asList("-font", "Helvetica", "-pointsize", "50", "-draw", "circle 100,100 150,150");
        ExecParameterTokenizer t = new ExecParameterTokenizer("-font Helvetica -pointsize 50 -draw \"circle 100,100 150,150\"");
        Assert.assertEquals((String)"Wrong tokens", expectedTokens, t.getAllTokens());
        t = new ExecParameterTokenizer("-font Helvetica -pointsize 50 -draw 'circle 100,100 150,150'");
        Assert.assertEquals((String)"Wrong tokens", expectedTokens, t.getAllTokens());
    }

    @Test
    public void tokenizeParameterStringWithQuotedParam_MixedQuotes() {
        String str1 = "'Hello world' middle \"Goodbye world\"";
        String str2 = "\"Hello world\" middle 'Goodbye world'";
        List<String> expectedTokens = Arrays.asList("Hello world", "middle", "Goodbye world");
        ExecParameterTokenizer t = new ExecParameterTokenizer("'Hello world' middle \"Goodbye world\"");
        Assert.assertEquals((String)"Wrong tokens", expectedTokens, t.getAllTokens());
        t = new ExecParameterTokenizer("\"Hello world\" middle 'Goodbye world'");
        Assert.assertEquals((String)"Wrong tokens", expectedTokens, t.getAllTokens());
    }

    @Test
    public void tokenizeParameterStringWithQuotedParamContainingQuotes() {
        String str1 = "-font Helvetica -pointsize 50 -draw \"gravity south fill black text 0,12 'CopyRight'\"";
        String str2 = "-font Helvetica -pointsize 50 -draw 'gravity south fill black text 0,12 \"CopyRight\"'";
        List<String> expectedTokens1 = Arrays.asList("-font", "Helvetica", "-pointsize", "50", "-draw", "gravity south fill black text 0,12 'CopyRight'");
        List<String> expectedTokens2 = Arrays.asList("-font", "Helvetica", "-pointsize", "50", "-draw", "gravity south fill black text 0,12 \"CopyRight\"");
        ExecParameterTokenizer t = new ExecParameterTokenizer("-font Helvetica -pointsize 50 -draw \"gravity south fill black text 0,12 'CopyRight'\"");
        Assert.assertEquals((String)"Wrong tokens", expectedTokens1, t.getAllTokens());
        t = new ExecParameterTokenizer("-font Helvetica -pointsize 50 -draw 'gravity south fill black text 0,12 \"CopyRight\"'");
        Assert.assertEquals((String)"Wrong tokens", expectedTokens2, t.getAllTokens());
    }
}

