/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.transaction;

import javax.transaction.RollbackException;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.util.transaction.SpringAwareUserTransaction;
import org.springframework.transaction.NoTransactionException;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;

public class SpringAwareUserTransactionTest
extends TestCase {
    private DummyTransactionManager transactionManager;
    private UserTransaction txn;

    protected void setUp() throws Exception {
        this.transactionManager = new DummyTransactionManager();
        this.txn = this.getTxn();
    }

    private UserTransaction getTxn() {
        return new SpringAwareUserTransaction((PlatformTransactionManager)this.transactionManager, false, -1, 0, -1);
    }

    public void testSetUp() throws Exception {
        SpringAwareUserTransactionTest.assertNotNull((Object)((Object)this.transactionManager));
        SpringAwareUserTransactionTest.assertNotNull((Object)this.txn);
    }

    private void checkNoStatusOnThread() {
        try {
            TransactionAspectSupport.currentTransactionStatus();
            SpringAwareUserTransactionTest.fail((String)"Spring transaction info is present outside of transaction boundaries");
        }
        catch (NoTransactionException noTransactionException) {
            // empty catch block
        }
    }

    public void testNoTxnStatus() throws Exception {
        this.checkNoStatusOnThread();
        SpringAwareUserTransactionTest.assertEquals((String)"Transaction status is not correct", (int)6, (int)this.txn.getStatus());
        SpringAwareUserTransactionTest.assertEquals((String)"Transaction manager not set up correctly", (int)this.txn.getStatus(), (int)this.transactionManager.getStatus());
    }

    public void testSimpleTxnWithCommit() throws Throwable {
        this.testNoTxnStatus();
        try {
            this.txn.begin();
            SpringAwareUserTransactionTest.assertEquals((String)"Transaction status is not correct", (int)0, (int)this.txn.getStatus());
            SpringAwareUserTransactionTest.assertEquals((String)"Transaction manager not called correctly", (int)this.txn.getStatus(), (int)this.transactionManager.getStatus());
            this.txn.commit();
            SpringAwareUserTransactionTest.assertEquals((String)"Transaction status is not correct", (int)3, (int)this.txn.getStatus());
            SpringAwareUserTransactionTest.assertEquals((String)"Transaction manager not called correctly", (int)this.txn.getStatus(), (int)this.transactionManager.getStatus());
        }
        catch (Throwable e) {
            try {
                this.txn.rollback();
            }
            catch (Throwable ee) {
                e.printStackTrace();
            }
            throw e;
        }
        this.checkNoStatusOnThread();
    }

    public void testSimpleTxnWithRollback() throws Exception {
        this.testNoTxnStatus();
        try {
            this.txn.begin();
            throw new Exception("Blah");
        }
        catch (Throwable e) {
            this.txn.rollback();
            SpringAwareUserTransactionTest.assertEquals((String)"Transaction status is not correct", (int)4, (int)this.txn.getStatus());
            SpringAwareUserTransactionTest.assertEquals((String)"Transaction manager not called correctly", (int)this.txn.getStatus(), (int)this.transactionManager.getStatus());
            this.checkNoStatusOnThread();
            return;
        }
    }

    public void testNoBeginCommit() throws Exception {
        this.testNoTxnStatus();
        try {
            this.txn.commit();
            SpringAwareUserTransactionTest.fail((String)"Failed to detected no begin");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.checkNoStatusOnThread();
    }

    public void testPostRollbackCommitDetection() throws Exception {
        this.testNoTxnStatus();
        this.txn.begin();
        this.txn.rollback();
        try {
            this.txn.commit();
            SpringAwareUserTransactionTest.fail((String)"Failed to detect rolled back txn");
        }
        catch (RollbackException rollbackException) {
            // empty catch block
        }
        this.checkNoStatusOnThread();
    }

    public void testPostSetRollbackOnlyCommitDetection() throws Exception {
        this.testNoTxnStatus();
        this.txn.begin();
        this.txn.setRollbackOnly();
        try {
            this.txn.commit();
            SpringAwareUserTransactionTest.fail((String)"Failed to detect set rollback");
        }
        catch (RollbackException e) {
            this.txn.rollback();
        }
        this.checkNoStatusOnThread();
    }

    public void testMismatchedBeginCommit() throws Exception {
        UserTransaction txn1 = this.getTxn();
        UserTransaction txn2 = this.getTxn();
        this.testNoTxnStatus();
        txn1.begin();
        txn2.begin();
        txn2.commit();
        txn1.commit();
        this.checkNoStatusOnThread();
        txn1 = this.getTxn();
        txn2 = this.getTxn();
        txn1.begin();
        txn2.begin();
        try {
            txn1.commit();
            SpringAwareUserTransactionTest.fail((String)"Failure to detect mismatched transaction begin/commit");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        txn2.commit();
        txn1.commit();
        this.checkNoStatusOnThread();
    }

    public void xtestLeakedTransactionLogging() throws Exception {
        SpringAwareUserTransactionTest.assertFalse((boolean)SpringAwareUserTransaction.isCallStackTraced());
        TrxThread t1 = new TrxThread();
        t1.start();
        System.gc();
        Thread.sleep(1000L);
        TrxThread t2 = new TrxThread();
        t2.start();
        System.gc();
        Thread.sleep(1000L);
        SpringAwareUserTransactionTest.assertTrue((boolean)SpringAwareUserTransaction.isCallStackTraced());
        TrxThread t3 = new TrxThread();
        t3.start();
        System.gc();
        Thread.sleep(3000L);
        System.gc();
        Thread.sleep(3000L);
    }

    private static class DummyTransactionManager
    extends AbstractPlatformTransactionManager {
        private int status = 6;
        private Object txn = new Object();

        private DummyTransactionManager() {
        }

        public int getStatus() {
            return this.status;
        }

        protected void doBegin(Object arg0, TransactionDefinition arg1) {
            this.status = 0;
        }

        protected void doCommit(DefaultTransactionStatus arg0) {
            this.status = 3;
        }

        protected Object doGetTransaction() {
            return this.txn;
        }

        protected void doRollback(DefaultTransactionStatus arg0) {
            this.status = 4;
        }
    }

    private class TrxThread
    extends Thread {
        private TrxThread() {
        }

        @Override
        public void run() {
            try {
                this.getTrx();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void getTrx() throws Exception {
            UserTransaction txn = SpringAwareUserTransactionTest.this.getTxn();
            txn.begin();
            txn = null;
        }
    }
}

