/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.deployment.impl.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Pipe;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Set;

public class NonblockingReaderManagement {
    ReaderThread worker;
    public Selector selector = null;

    public NonblockingReaderManagement() {
        try {
            this.selector = Selector.open();
        }
        catch (IOException ie) {
            // empty catch block
        }
        ReaderThread worker = new ReaderThread();
        worker.start();
    }

    void addCopyThread(Pipe.SourceChannel sc, InputStream is, OutputStream os, String token) {
        ReadableByteChannel ic = Channels.newChannel(is);
        try {
            sc.configureBlocking(false);
            Tracker newKey = new Tracker();
            newKey.is = is;
            newKey.os = os;
            newKey.token = token;
            SelectionKey acceptKey = sc.register(this.selector, 16);
            acceptKey.attach(newKey);
        }
        catch (ClosedChannelException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void closeCopyThread(String token) throws IOException {
    }

    private class Tracker {
        public InputStream is;
        public OutputStream os;
        public String token;

        private Tracker() {
        }
    }

    private class ReaderThread
    extends Thread {
        public ReaderThread() {
            super.setName("Reader Thread ");
        }

        @Override
        public void run() {
            try {
                while (NonblockingReaderManagement.this.selector.select() > 0) {
                    Set<SelectionKey> readyKeys = NonblockingReaderManagement.this.selector.selectedKeys();
                    for (SelectionKey key : readyKeys) {
                        if (!key.isReadable()) continue;
                        Tracker t = (Tracker)key.attachment();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

