/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.config.source;

import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.source.BaseConfigSource;

public class JarConfigSource
extends BaseConfigSource {
    public static final String JAR_PROTOCOL = "jar";
    public static final String JAR_PATH_SEPARATOR = "!/";
    private static final Log logger = LogFactory.getLog(JarConfigSource.class);

    public JarConfigSource(String location) {
        super(Collections.singletonList(location));
    }

    protected InputStream getInputStream(String sourceString) {
        InputStream in;
        block5: {
            in = null;
            try {
                JarFile jar;
                ZipEntry entry;
                if (!sourceString.startsWith(JAR_PROTOCOL)) {
                    throw new IllegalArgumentException("sourceString must start with \"jar:\"");
                }
                int indexSep = sourceString.indexOf(JAR_PATH_SEPARATOR);
                if (indexSep == -1) {
                    throw new IllegalArgumentException("sourceString must contain an entry within the JAR file i.e. jar:file:/[file]!/[entry]");
                }
                String entryStr = sourceString.substring(indexSep + JAR_PATH_SEPARATOR.length());
                URL url = new URL(sourceString);
                URLConnection conn = url.openConnection();
                if (conn instanceof JarURLConnection && (entry = (jar = ((JarURLConnection)conn).getJarFile()).getEntry(entryStr)) != null) {
                    in = jar.getInputStream(entry);
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block5;
                logger.debug((Object)("Failed to obtain input stream to URL: " + sourceString), (Throwable)e);
            }
        }
        return in;
    }
}

