/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.ajp;

import java.io.IOException;
import java.net.SocketException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.ajp.AbstractAjpProtocol;
import org.apache.coyote.ajp.AjpAprProcessor;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.AprEndpoint;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class AjpAprProtocol
extends AbstractAjpProtocol {
    private static final Log log = LogFactory.getLog(AjpAprProtocol.class);
    private AjpConnectionHandler cHandler;

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected AbstractEndpoint.Handler getHandler() {
        return this.cHandler;
    }

    public AjpAprProtocol() {
        this.endpoint = new AprEndpoint();
        this.cHandler = new AjpConnectionHandler(this);
        ((AprEndpoint)this.endpoint).setHandler(this.cHandler);
        this.setSoLinger(-1);
        this.setSoTimeout(-1);
        this.setTcpNoDelay(true);
        ((AprEndpoint)this.endpoint).setUseSendfile(false);
    }

    public int getPollTime() {
        return ((AprEndpoint)this.endpoint).getPollTime();
    }

    public void setPollTime(int pollTime) {
        ((AprEndpoint)this.endpoint).setPollTime(pollTime);
    }

    public void setPollerSize(int pollerSize) {
        this.endpoint.setMaxConnections(pollerSize);
    }

    public int getPollerSize() {
        return this.endpoint.getMaxConnections();
    }

    @Override
    protected String getNamePrefix() {
        return "ajp-apr";
    }

    protected static class AjpConnectionHandler
    extends AbstractProtocol.AbstractConnectionHandler
    implements AprEndpoint.Handler {
        protected AjpAprProtocol proto;
        protected ConcurrentHashMap<SocketWrapper<Long>, AjpAprProcessor> connections = new ConcurrentHashMap();
        protected AbstractProtocol.RecycledProcessors<AjpAprProcessor> recycledProcessors = new AbstractProtocol.RecycledProcessors(this);

        public AjpConnectionHandler(AjpAprProtocol proto) {
            this.proto = proto;
        }

        @Override
        protected AbstractProtocol getProtocol() {
            return this.proto;
        }

        @Override
        protected Log getLog() {
            return log;
        }

        @Override
        public void recycle() {
            this.recycledProcessors.clear();
        }

        @Override
        public AbstractEndpoint.Handler.SocketState event(SocketWrapper<Long> socket, SocketStatus status) {
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }

        @Override
        public AbstractEndpoint.Handler.SocketState process(SocketWrapper<Long> socket) {
            AjpAprProcessor processor = (AjpAprProcessor)this.recycledProcessors.poll();
            try {
                AbstractEndpoint.Handler.SocketState state;
                if (processor == null) {
                    processor = this.createProcessor();
                }
                if ((state = processor.process(socket)) == AbstractEndpoint.Handler.SocketState.LONG) {
                    state = processor.asyncPostProcess();
                }
                if (state == AbstractEndpoint.Handler.SocketState.LONG || state == AbstractEndpoint.Handler.SocketState.ASYNC_END) {
                    this.connections.put(socket, processor);
                    socket.setAsync(true);
                } else {
                    processor.recycle();
                    this.recycledProcessors.offer(processor);
                }
                return state;
            }
            catch (SocketException e) {
                log.debug((Object)AbstractAjpProtocol.sm.getString("ajpprotocol.proto.socketexception.debug"), (Throwable)e);
            }
            catch (IOException e) {
                log.debug((Object)AbstractAjpProtocol.sm.getString("ajpprotocol.proto.ioexception.debug"), (Throwable)e);
            }
            catch (Throwable e) {
                ExceptionUtils.handleThrowable(e);
                log.error((Object)AbstractAjpProtocol.sm.getString("ajpprotocol.proto.error"), e);
            }
            processor.recycle();
            this.recycledProcessors.offer(processor);
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AbstractEndpoint.Handler.SocketState asyncDispatch(SocketWrapper<Long> socket, SocketStatus status) {
            AjpAprProcessor processor = this.connections.get(socket);
            AbstractEndpoint.Handler.SocketState state = AbstractEndpoint.Handler.SocketState.CLOSED;
            if (processor != null) {
                try {
                    state = processor.asyncDispatch(socket, status);
                }
                catch (Throwable e) {
                    ExceptionUtils.handleThrowable(e);
                    log.error((Object)AbstractAjpProtocol.sm.getString("ajpprotocol.proto.error"), e);
                }
                finally {
                    if (state == AbstractEndpoint.Handler.SocketState.LONG && processor.isAsync()) {
                        state = processor.asyncPostProcess();
                    }
                    if (state != AbstractEndpoint.Handler.SocketState.LONG && state != AbstractEndpoint.Handler.SocketState.ASYNC_END) {
                        this.connections.remove(socket);
                        processor.recycle();
                        this.recycledProcessors.offer(processor);
                        if (state == AbstractEndpoint.Handler.SocketState.OPEN) {
                            ((AprEndpoint)this.proto.endpoint).getPoller().add(socket.getSocket());
                        }
                    }
                }
            }
            return state;
        }

        protected AjpAprProcessor createProcessor() {
            AjpAprProcessor processor = new AjpAprProcessor(this.proto.packetSize, (AprEndpoint)this.proto.endpoint);
            processor.setAdapter(this.proto.adapter);
            processor.setTomcatAuthentication(this.proto.tomcatAuthentication);
            processor.setRequiredSecret(this.proto.requiredSecret);
            processor.setClientCertProvider(this.proto.getClientCertProvider());
            this.register(processor);
            return processor;
        }
    }
}

