/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.model;

import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.hslf.model.Picture;
import org.apache.poi.hslf.model.Shape;
import org.apache.poi.hslf.record.ExEmbed;
import org.apache.poi.hslf.record.ExObjList;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.usermodel.ObjectData;
import org.apache.poi.hslf.usermodel.SlideShow;
import org.apache.poi.util.POILogger;

public final class OLEShape
extends Picture {
    protected ExEmbed _exEmbed;

    public OLEShape(int idx) {
        super(idx);
    }

    public OLEShape(int idx, Shape parent) {
        super(idx, parent);
    }

    protected OLEShape(EscherContainerRecord escherRecord, Shape parent) {
        super(escherRecord, parent);
    }

    public int getObjectID() {
        return this.getEscherProperty((short)267);
    }

    public ObjectData getObjectData() {
        SlideShow ppt = this.getSheet().getSlideShow();
        ObjectData[] ole = ppt.getEmbeddedObjects();
        ExEmbed exEmbed = this.getExEmbed();
        ObjectData data = null;
        if (exEmbed != null) {
            int ref = exEmbed.getExOleObjAtom().getObjStgDataRef();
            for (int i = 0; i < ole.length; ++i) {
                if (ole[i].getExOleObjStg().getPersistId() != ref) continue;
                data = ole[i];
            }
        }
        if (data == null) {
            this.logger.log(POILogger.WARN, (Object)"OLE data not found");
        }
        return data;
    }

    public ExEmbed getExEmbed() {
        if (this._exEmbed == null) {
            SlideShow ppt = this.getSheet().getSlideShow();
            ExObjList lst = ppt.getDocumentRecord().getExObjList();
            if (lst == null) {
                this.logger.log(POILogger.WARN, (Object)"ExObjList not found");
                return null;
            }
            int id = this.getObjectID();
            Record[] ch = lst.getChildRecords();
            for (int i = 0; i < ch.length; ++i) {
                ExEmbed embd;
                if (!(ch[i] instanceof ExEmbed) || (embd = (ExEmbed)ch[i]).getExOleObjAtom().getObjID() != id) continue;
                this._exEmbed = embd;
            }
        }
        return this._exEmbed;
    }

    public String getInstanceName() {
        return this.getExEmbed().getMenuName();
    }

    public String getFullName() {
        return this.getExEmbed().getClipboardName();
    }

    public String getProgID() {
        return this.getExEmbed().getProgId();
    }
}

