/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hsmf.datatypes;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hsmf.datatypes.Chunk;
import org.apache.poi.hsmf.datatypes.MAPIProperty;
import org.apache.poi.hsmf.datatypes.PropertyValue;
import org.apache.poi.hsmf.datatypes.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertiesChunk
extends Chunk {
    public static final String NAME = "__properties_version1.0";
    private Map<MAPIProperty, List<PropertyValue>> properties = new HashMap<MAPIProperty, List<PropertyValue>>();

    protected PropertiesChunk() {
        super(NAME, -1, Types.UNKNOWN);
    }

    @Override
    public String getEntryName() {
        return NAME;
    }

    public Map<MAPIProperty, List<PropertyValue>> getProperties() {
        return this.properties;
    }

    public List<PropertyValue> getValues(MAPIProperty property) {
        return this.properties.get(property);
    }

    public PropertyValue getValue(MAPIProperty property) {
        List<PropertyValue> values = this.properties.get(property);
        if (values != null && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }

    protected void readProperties(InputStream value) throws IOException {
    }

    protected void writeProperties(OutputStream out) throws IOException {
    }
}

