/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hsmf.dev;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.hsmf.datatypes.Chunk;
import org.apache.poi.hsmf.datatypes.ChunkGroup;
import org.apache.poi.hsmf.datatypes.MAPIProperty;
import org.apache.poi.hsmf.datatypes.PropertiesChunk;
import org.apache.poi.hsmf.datatypes.PropertyValue;
import org.apache.poi.hsmf.parsers.POIFSChunkParser;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class HSMFDump {
    private POIFSFileSystem fs;

    public HSMFDump(POIFSFileSystem fs) {
        this.fs = fs;
    }

    public void dump() throws IOException {
        ChunkGroup[] chunkGroups;
        for (ChunkGroup chunks : chunkGroups = POIFSChunkParser.parse(this.fs)) {
            System.out.println(chunks.getClass().getSimpleName());
            for (Chunk chunk : chunks.getChunks()) {
                MAPIProperty attr = MAPIProperty.get(chunk.getChunkId());
                if (chunk instanceof PropertiesChunk) {
                    PropertiesChunk props = (PropertiesChunk)chunk;
                    System.out.println("   Properties - " + props.getProperties().size() + ":");
                    for (MAPIProperty prop : props.getProperties().keySet()) {
                        System.out.println("       * " + prop);
                        for (PropertyValue v : props.getValues(prop)) {
                            System.out.println("        = " + v.toString());
                        }
                    }
                    continue;
                }
                String idName = attr.id + " - " + attr.name;
                if (attr == MAPIProperty.UNKNOWN) {
                    idName = chunk.getChunkId() + " - (unknown)";
                }
                System.out.println("   " + idName + " - " + chunk.getType().getName());
                System.out.println("       " + chunk.toString());
            }
            System.out.println();
        }
    }

    public static void main(String[] args) throws Exception {
        for (String file : args) {
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)new FileInputStream(file));
            HSMFDump dump = new HSMFDump(fs);
            dump.dump();
        }
    }
}

