/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.db;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;
import org.hibernate.Session;
import org.jbpm.JbpmException;
import org.jbpm.db.JbpmSession;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.taskmgmt.exe.TaskInstance;

public class TaskMgmtSession
implements Serializable {
    private static final long serialVersionUID = 1L;
    JbpmSession jbpmSession = null;
    Session session = null;
    private static final Log log = LogFactory.getLog(TaskMgmtSession.class);

    public TaskMgmtSession(JbpmSession jbpmSession) {
        this.jbpmSession = jbpmSession;
        this.session = jbpmSession.getSession();
    }

    public TaskMgmtSession(Session session) {
        this.session = session;
        this.jbpmSession = new JbpmSession(session);
    }

    public List findTaskInstances(String actorId) {
        List result = null;
        try {
            Query query = this.session.getNamedQuery("TaskMgmtSession.findTaskInstancesByActorId");
            query.setString("actorId", actorId);
            result = query.list();
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't get task instances list for actor '" + actorId + "'", e);
        }
        return result;
    }

    public List findTaskInstances(List actorIds) {
        if (actorIds == null) {
            return new ArrayList(0);
        }
        return this.findTaskInstances(actorIds.toArray(new String[actorIds.size()]));
    }

    public List findTaskInstances(String[] actorIds) {
        List result = null;
        try {
            Query query = this.session.getNamedQuery("TaskMgmtSession.findTaskInstancesByActorIds");
            query.setParameterList("actorIds", (Object[])actorIds);
            result = query.list();
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't get task instances list for actors '" + actorIds + "'", e);
        }
        return result;
    }

    public List findPooledTaskInstances(String actorId) {
        ArrayList<Object> result = null;
        try {
            Query query = this.session.getNamedQuery("TaskMgmtSession.findPooledTaskInstancesByActorId");
            query.setString("swimlaneActorId", actorId);
            List identifiers = query.list();
            if (!identifiers.isEmpty()) {
                result = new ArrayList<Object>(identifiers.size());
                for (Long taskInstanceId : identifiers) {
                    result.add(this.session.load(TaskInstance.class, (Serializable)taskInstanceId));
                }
            } else {
                result = Collections.EMPTY_LIST;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't get pooled task instances list for actor '" + actorId + "'", e);
        }
        return result;
    }

    public List findPooledTaskInstances(List actorIds) {
        ArrayList<Object> result = null;
        try {
            Query query = this.session.getNamedQuery("TaskMgmtSession.findPooledTaskInstancesByActorIds");
            query.setParameterList("actorIds", (Collection)actorIds);
            List identifiers = query.list();
            if (!identifiers.isEmpty()) {
                result = new ArrayList<Object>(identifiers.size());
                for (Long taskInstanceId : identifiers) {
                    result.add(this.session.load(TaskInstance.class, (Serializable)taskInstanceId));
                }
            } else {
                result = Collections.EMPTY_LIST;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't get pooled task instances list for actors '" + actorIds + "'", e);
        }
        return result;
    }

    public List findTaskInstancesByToken(long tokenId) {
        List result = null;
        try {
            Query query = this.session.getNamedQuery("TaskMgmtSession.findTaskInstancesByTokenId");
            query.setLong("tokenId", tokenId);
            result = query.list();
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't get task instances by token '" + tokenId + "'", e);
        }
        return result;
    }

    public List findTaskInstancesByProcessInstance(ProcessInstance processInstance) {
        List result = null;
        try {
            Query query = this.session.getNamedQuery("TaskMgmtSession.findTaskInstancesByProcessInstance");
            query.setEntity("processInstance", (Object)processInstance);
            result = query.list();
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't get task instances by process instance '" + processInstance + "'", e);
        }
        return result;
    }

    public TaskInstance loadTaskInstance(long taskInstanceId) {
        TaskInstance taskInstance = null;
        try {
            taskInstance = (TaskInstance)this.session.load(TaskInstance.class, (Serializable)new Long(taskInstanceId));
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't get task instance '" + taskInstanceId + "'", e);
        }
        return taskInstance;
    }

    public TaskInstance getTaskInstance(long taskInstanceId) {
        TaskInstance taskInstance = null;
        try {
            taskInstance = (TaskInstance)this.session.get(TaskInstance.class, (Serializable)new Long(taskInstanceId));
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't get task instance '" + taskInstanceId + "'", e);
        }
        return taskInstance;
    }

    public List findTaskInstancesByIds(List taskInstanceIds) {
        List result = null;
        try {
            Query query = this.session.getNamedQuery("TaskMgmtSession.findTaskInstancesByIds");
            query.setParameterList("taskInstanceIds", (Collection)taskInstanceIds);
            result = query.list();
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't get task instances by ids '" + taskInstanceIds + "'", e);
        }
        return result;
    }
}

