/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config.forms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.alfresco.util.BaseTest;
import org.alfresco.web.config.forms.ControlParam;
import org.alfresco.web.config.forms.DefaultControlsConfigElement;
import org.alfresco.web.config.forms.FormConfigElement;
import org.alfresco.web.config.forms.FormsConfigElement;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.xml.XMLConfigService;

public class DefaultControlsConfigTest
extends BaseTest {
    protected XMLConfigService configService;
    protected Config globalConfig;
    protected ConfigElement globalDefaultControls;
    protected ConfigElement globalConstraintHandlers;
    protected FormsConfigElement formsConfigElement;
    protected FormConfigElement defaultFormConfigElement;
    protected DefaultControlsConfigElement defltCtrlsConfElement;

    protected String getConfigXmlFile() {
        return "test-config-forms-basic.xml";
    }

    public void testDefaultControls_MappingNameToTemplate() {
        HashMap<String, String> expectedDataMappings = new HashMap<String, String>();
        expectedDataMappings.put("d:long", "/form-controls/mytextfield.ftl");
        expectedDataMappings.put("d:text", "/form-controls/mytextfield.ftl");
        expectedDataMappings.put("d:test", "/form-controls/test.ftl");
        expectedDataMappings.put("d:boolean", "/form-controls/checkbox.ftl");
        expectedDataMappings.put("association", "/form-controls/association-picker.ftl");
        expectedDataMappings.put("abc", "/form-controls/abc.ftl");
        List<String> actualNames = this.defltCtrlsConfElement.getItemNamesAsList();
        DefaultControlsConfigTest.assertEquals((String)("Incorrect name count, expected " + expectedDataMappings.size()), (int)expectedDataMappings.size(), (int)actualNames.size());
        DefaultControlsConfigTest.assertEquals(expectedDataMappings.keySet(), new HashSet<String>(actualNames));
        for (String nextKey : expectedDataMappings.keySet()) {
            String nextExpectedValue = (String)expectedDataMappings.get(nextKey);
            String nextActualValue = this.defltCtrlsConfElement.getTemplateFor(nextKey);
            DefaultControlsConfigTest.assertTrue((String)("Incorrect template for " + nextKey + ": " + nextActualValue), (boolean)nextExpectedValue.equals(nextActualValue));
        }
    }

    public void testControlParams() {
        HashMap<String, List> expectedControlParams = new HashMap<String, List>();
        ArrayList<ControlParam> textParams = new ArrayList<ControlParam>();
        textParams.add(new ControlParam("size", "50"));
        ArrayList<ControlParam> abcParams = new ArrayList<ControlParam>();
        abcParams.add(new ControlParam("a", "1"));
        abcParams.add(new ControlParam("b", "Hello"));
        abcParams.add(new ControlParam("c", "For ever and ever."));
        abcParams.add(new ControlParam("d", ""));
        expectedControlParams.put("d:text", textParams);
        expectedControlParams.put("d:boolean", Collections.EMPTY_LIST);
        expectedControlParams.put("association", Collections.EMPTY_LIST);
        expectedControlParams.put("abc", abcParams);
        for (String name : expectedControlParams.keySet()) {
            List<ControlParam> actualControlParams = this.defltCtrlsConfElement.getControlParamsAsListFor(name);
            DefaultControlsConfigTest.assertEquals((String)("Incorrect params for " + name), expectedControlParams.get(name), actualControlParams);
        }
    }

    public void testDefaultControlsConfigElementShouldHaveNoChildren() {
        try {
            this.defltCtrlsConfElement.getChildren();
            DefaultControlsConfigTest.fail((String)"getChildren() did not throw an exception");
        }
        catch (ConfigException configException) {
            // empty catch block
        }
    }

    public void testCombineDefaultControlsWithAddedParam() {
        DefaultControlsConfigElement basicElement = new DefaultControlsConfigElement();
        basicElement.addDataMapping("text", "path/textbox.ftl", null);
        DefaultControlsConfigElement parameterisedElement = new DefaultControlsConfigElement();
        ArrayList<ControlParam> testParams = new ArrayList<ControlParam>();
        testParams.add(new ControlParam("A", "1"));
        parameterisedElement.addDataMapping("text", "path/textbox.ftl", testParams);
        DefaultControlsConfigElement combinedElem = (DefaultControlsConfigElement)basicElement.combine((ConfigElement)parameterisedElement);
        DefaultControlsConfigTest.assertEquals((String)"path/textbox.ftl", (String)combinedElem.getItems().get("text").getTemplate());
        List<ControlParam> actualControlParams = combinedElem.getItems().get("text").getParamsAsList();
        DefaultControlsConfigTest.assertEquals((String)"Wrong count of control-params", (int)1, (int)actualControlParams.size());
        DefaultControlsConfigTest.assertEquals((String)"A", (String)actualControlParams.get(0).getName());
        DefaultControlsConfigTest.assertEquals((String)"1", (String)actualControlParams.get(0).getValue());
    }

    public void testCombineDefaultControlsWithModifiedParam() {
        DefaultControlsConfigElement initialElement = new DefaultControlsConfigElement();
        ArrayList<ControlParam> testParams = new ArrayList<ControlParam>();
        testParams.add(new ControlParam("A", "1"));
        initialElement.addDataMapping("text", "path/textbox.ftl", testParams);
        DefaultControlsConfigElement modifiedElement = new DefaultControlsConfigElement();
        ArrayList<ControlParam> modifiedTestParams = new ArrayList<ControlParam>();
        modifiedTestParams.add(new ControlParam("A", "5"));
        modifiedElement.addDataMapping("text", "path/textbox.ftl", modifiedTestParams);
        DefaultControlsConfigElement combinedElem = (DefaultControlsConfigElement)initialElement.combine((ConfigElement)modifiedElement);
        DefaultControlsConfigTest.assertEquals((String)"path/textbox.ftl", (String)combinedElem.getItems().get("text").getTemplate());
        List<ControlParam> actualControlParams = combinedElem.getItems().get("text").getParamsAsList();
        DefaultControlsConfigTest.assertEquals((String)"Wrong count of control-params", (int)1, (int)actualControlParams.size());
        DefaultControlsConfigTest.assertEquals((String)"A", (String)actualControlParams.get(0).getName());
        DefaultControlsConfigTest.assertEquals((String)"5", (String)actualControlParams.get(0).getValue());
    }

    public void testCombineDefaultControlsWithDeletedParam() {
        DefaultControlsConfigElement initialElement = new DefaultControlsConfigElement();
        ArrayList<ControlParam> testParams = new ArrayList<ControlParam>();
        testParams.add(new ControlParam("A", "1"));
        initialElement.addDataMapping("text", "path/textbox.ftl", testParams);
        DefaultControlsConfigElement modifiedElement = new DefaultControlsConfigElement();
        modifiedElement.addDataMapping("text", "path/textbox.ftl", null);
        DefaultControlsConfigElement combinedElem = (DefaultControlsConfigElement)initialElement.combine((ConfigElement)modifiedElement);
        DefaultControlsConfigTest.assertEquals((String)"path/textbox.ftl", (String)combinedElem.getItems().get("text").getTemplate());
        List<ControlParam> actualControlParams = combinedElem.getItems().get("text").getParamsAsList();
        DefaultControlsConfigTest.assertEquals((String)"Wrong count of control-params", (int)0, (int)actualControlParams.size());
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.configService = this.initXMLConfigService(this.getConfigXmlFile());
        DefaultControlsConfigTest.assertNotNull((String)"configService was null.", (Object)this.configService);
        Config myExampleConfig = this.configService.getConfig((Object)"my:example");
        DefaultControlsConfigTest.assertNotNull((String)"myExampleConfig was null.", (Object)myExampleConfig);
        ConfigElement confElement = myExampleConfig.getConfigElement("forms");
        DefaultControlsConfigTest.assertNotNull((String)"confElement was null.", (Object)confElement);
        DefaultControlsConfigTest.assertTrue((String)"confElement should be instanceof FormsConfigElement.", (boolean)(confElement instanceof FormsConfigElement));
        this.formsConfigElement = (FormsConfigElement)confElement;
        this.defaultFormConfigElement = this.formsConfigElement.getDefaultForm();
        this.globalConfig = this.configService.getGlobalConfig();
        ConfigElement globalFormsCE = this.globalConfig.getConfigElement("forms");
        FormsConfigElement globalForms = (FormsConfigElement)globalFormsCE;
        this.defltCtrlsConfElement = globalForms.getDefaultControls();
        DefaultControlsConfigTest.assertNotNull((String)"global default-controls element should not be null", (Object)((Object)this.defltCtrlsConfElement));
        DefaultControlsConfigTest.assertNotNull((String)"global constraint-handlers element should not be null", (Object)((Object)globalForms.getConstraintHandlers()));
    }
}

